/*!
 *   a2B̃OǂݏNX
 * 
 * 
 */
#include <QDir>
#include <QFileInfo>
#include <QMessageBox>
#include "a2BcConstants.h"
#include "a2BbrowserParser.h"
#include "bbsTableParser.h"
#include "datFileUtil.h"

/*!
 *  RXgN^
 * 
 */
a2BbrowserParser::a2BbrowserParser()
 : mpBbsTableParser(0), mCount(0), mUnmanagedCount(0)
{
    // ȂɂȂ...
}

/*!
 *  fXgN^
 * 
 */
a2BbrowserParser::~a2BbrowserParser()
{
    // ȂɂȂ...
}

/*!
 *   uEÛ̖
 * 
 */
QString a2BbrowserParser::getBrowserName(void)
{
    QString name = "a2B";
    return (name);
}

/*!
 *   ǗpX̎w...
 *   (Ot@Ci[郋[gfBNg)
 */
void a2BbrowserParser::setPath(QString &arPath)
{
    mBaseDirectory = arPath;
    return;
}

/*!
 *   bbstable̓NXibbstable.htmlj̎w...
 * 
 */
void a2BbrowserParser::setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable)
{
    mpBbsTableParser = apBbsTable;
    return;
}

/*!
 *   ͂̏...
 * 
 */    
bool a2BbrowserParser::prepare(void)
{
    /// f[^NA...
    mUnmanagedDatFilePath.clear();
    mUnmanagedDatFileName.clear();
    mFavoriteParser.clear();
    mIndexParser.clearIndexFile();
    mCount = 0;

    /// Cɓf[^ǂݍ...
    mFavoriteParser.parseIndexFile(mBaseDirectory + "/favorite.idx");

    /// fBNgāAOt@C𒊏o
    bool ret = checkDirectory(mBaseDirectory);
    return (ret);
}

/*!
 *   ͂̏(fBNg...)
 * 
 */    
bool a2BbrowserParser::checkDirectory(QString &arPath)
{
    QDir targetDir(arPath);
    QFileInfoList fileList = targetDir.entryInfoList();
    for (QFileInfoList::const_iterator ite = fileList.constBegin(); ite != fileList.constEnd(); ite++)
    {
        QFileInfo fileInfo = (*ite);
        if (fileInfo.isDir() == true)
        {
            QString filePath = fileInfo.absoluteFilePath();
            if (filePath.endsWith(".") != true)
            {
                checkDirectory(filePath);
            }
        }

        // t@Cǂ`FbN
        if (fileInfo.isFile() == true)
        {
            // a2B̃OǗf[^t@C...
            if ( fileInfo.fileName() == "a2b.idx")
            {
                QString idxFile = fileInfo.absolutePath() + "/a2b.idx";
                parseIndexFile(idxFile);
            }
        }
    }
    return (true);
}

/*!
 *   ǗOdatt@C`FbN
 * 
 */
int  a2BbrowserParser::checkUnmanagedDatFile(void)
{
//    QMessageBox::information(0, "checkUnmanagedDatFile()", mBaseDirectory, QMessageBox::Ok);

    /// fBNgāAOt@C𒊏o
    mUnmanagedCount = 0;
    checkUnmanagedFiles(mBaseDirectory);

    return (mUnmanagedCount);
}

/*!
 *  ǗĂȂdatt@Co(C̏)
 * 
 */
void  a2BbrowserParser::checkUnmanagedFiles(QString &arPath)
{
    QDir targetDir(arPath);
    QFileInfoList fileList = targetDir.entryInfoList();
    for (QFileInfoList::const_iterator ite = fileList.constBegin(); ite != fileList.constEnd(); ite++)
    {
        QFileInfo fileInfo = (*ite);
        if (fileInfo.isDir() == true)
        {
            QString filePath = fileInfo.absoluteFilePath();
            if (filePath.endsWith(".") != true)
            {
                checkUnmanagedFiles(filePath);
            }
        }
        if (fileInfo.isFile() == true)
        {
            QString filePath = fileInfo.absolutePath();
            QString fileName = fileInfo.fileName();
            QString suffix   = fileInfo.suffix();
            if (suffix == "dat")
            {
                bool unmanaged = false;
                int index = mIndexParser.exists(fileName);
                if (index == -1)
                {
                    unmanaged = true;
                }
                else
                {
                    int nofMsg = mIndexParser.getNofMessage(index);
                    if (nofMsg > 1000)
                    {
                        unmanaged = true;
                    }
                }
                if (index == -1)
                {
                    // OǗĂȂ...
                    mUnmanagedDatFilePath.append(filePath);
                    mUnmanagedDatFileName.append(fileName);
                    mUnmanagedCount++;
                }
            }
        }
    }
    return;    
}

/*!
 *  f[^Ǘt@C̓ǂݏo...
 * 
 * 
 */
void a2BbrowserParser::parseIndexFile(QString &arFileName)
{
//    QMessageBox::information(0, "Info(index File)", arFileName, QMessageBox::Ok);
    mCount = mCount + mIndexParser.parseIndexFile(arFileName);
    return;   
}

/*!
 *   f[^t@C̐
 * 
 */
int a2BbrowserParser::datFileCount(void)
{
    return (mCount);
}

/*!
 *    ǗOdatt@C擾
 * 
 */
QString a2BbrowserParser::getUnmanagedDatFileName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mUnmanagedCount))
    {
        return ("");
    }
    return (mUnmanagedDatFileName[aIndex]);
}


/*
 *     ǗOdatjbNl[擾
 * 
 */
QString a2BbrowserParser::getUnmanagedDatNickName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mUnmanagedCount))
    {
        return ("");
    }
    QString nick = mUnmanagedDatFilePath[aIndex];
    nick.replace((mBaseDirectory), "");
    return (nick + "/");
}

/*!
 *  datt@Cfull-path擾
 * 
 */
QString a2BbrowserParser::getFullPathDatFileName(QString &arNick, QString &arFileName)
{
    return (mBaseDirectory + arNick + arFileName);
}


/*!
 *   datt@C(full path)̎Mpt@C𐶐
 * 
 */
QString a2BbrowserParser::getReceiveDatFileName(QString &arNick, QString &arFileName)
{
    QString fileName = arFileName;
    int pos = arFileName.indexOf(".");
    fileName = arFileName.left(pos);

    QDir path(mBaseDirectory);
    path.mkpath(mBaseDirectory + arNick);

    QString fullPath = mBaseDirectory + arNick + fileName + ".dat";
    return (fullPath);
}

/*!
 *  datt@C擾
 * 
 */
QString a2BbrowserParser::getDatFileName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mCount))
    {
        return ("");
    } 

    QString fileName = mIndexParser.getFileName(aIndex);
    return (fileName);
}

/*!
 *  Nick擾
 * 
 */
QString a2BbrowserParser::getBoardNick(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mCount))
    {
        return ("");
    } 

    QString nick = mIndexParser.getNickName(aIndex);
    return (nick + "/");
}

/*!
 *  ǈʒu̎擾
 * 
 */
int  a2BbrowserParser::getReadPoint(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mCount))
    {
        return (1);
    } 

    int curMsg = mIndexParser.getCurrentMessage(aIndex);
    return (curMsg);
}

/*!
 *  ŏIXVԂ̎擾
 * 
 */
qint64 a2BbrowserParser::getLastUpdate(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mCount))
    {
        return (0);
    } 

    qint64 lastUpdate = mIndexParser.getLastUpdate(aIndex);
    return (lastUpdate);
}

/*
 *   subject.txt̃t@C(full path)擾
 * 
 */
QString a2BbrowserParser::getSubjectTxtFilePath(QString &arNick)
{
    QString fullPath = mBaseDirectory + arNick + "subject.txt";
    return (fullPath);
}

/*!
 *   datt@CM
 * 
 */
bool a2BbrowserParser::receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
    // fBNg@
    QDir path(mBaseDirectory);
    path.mkpath(mBaseDirectory + arNick);

    // datt@Cړ
    datFileUtil util;
    util.moveDatFile(arSrc, isSame, arDst, true);

    // datt@CǗĂ邩ǂmF
    int index = mIndexParser.exists(arFile);
    if (index >= 0)
    {
        // ǗĂdatt@C...
        if (aReadPoint > 0)
        {
            mIndexParser.setCurrentMessage(index, aReadPoint);
            mIndexParser.setFileStatus(index, A2BCSTATUS_UPDATE);
        }
    }
    else
    {
        // ǗĂȂdatt@C...o^
        insertData(arNick, arFile, aReadPoint, aLastUpdate);
    }
    
    return (true);
}

/*!
 *   datt@CRs[
 * 
 */
bool a2BbrowserParser::copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
    // fBNg@
    QDir path(mBaseDirectory);
    path.mkpath(mBaseDirectory + arNick);

    // datt@CRs[
    datFileUtil util;
    util.copyDatFile(arSrc, isSame, arDst, true);

    // datt@CǗĂ邩ǂmF
    int index = mIndexParser.exists(arFile);
    if (index >= 0)
    {
        // ǗĂdatt@C...
        if (aReadPoint > 0)
        {
            mIndexParser.setCurrentMessage(index, aReadPoint);
            mIndexParser.setFileStatus(index, A2BCSTATUS_UPDATE);
        }
    }
    else
    {
        // ǗĂȂdatt@C...o^
        insertData(arNick, arFile, aReadPoint, aLastUpdate);
    }

    return (true);
}

/*!
 *   Ǘt@C֓o^
 * 
 */
bool a2BbrowserParser::insertData(QString &arNick, QString &arFile, int aReadPoint, qint64 aLastUpdate)
{
    //  QMessageBox::information(0, "insertData()", arNick + " | " + arFile, QMessageBox::Ok);

    datFileUtil util;
    QString target = mBaseDirectory + arNick;
    int pos = target.lastIndexOf("/");
    QString path = target.left(pos);
    int nofMsg = util.checkResCount(path, arFile);
    int curMsg = aReadPoint;
    if (curMsg < 1)
    {
        curMsg = 1;
    }
    QString title   = util.pickupDatFileTitle(path, arFile);
    QString idxFile = mBaseDirectory + arNick + "a2b.idx";
    QString option  = "0";
    mIndexParser.insertData(idxFile, arFile, option, title, curMsg, nofMsg, aLastUpdate);
    return (false);
}

/*!
 *   Ƃ܂s
 * 
 */
bool a2BbrowserParser::finalize(void)
{
    // "a2b.idx" o͂BBB
    mIndexParser.outputIndexFile(false, false, 0);
    return (true);    
}
/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
