/*============================================================================*
 *  FILE: 
 *     bbsmng.c
 *
 *  Description: 
 *     BBS list manage form functions for NNsh.
 *
 *===========================================================================*/
#define BBSMNG_C
#include "local.h"

// BBS擾֐Q
static UInt16  getBoardURL    (Char *url, Char *nick, Char *top, Char *bottom);
static void    parseBoard     (DmOpenRef dbRef, Char *top, UInt32 *readSize);
static void    updateBoardList(void);

// gpBBSI֐Q
static void    closeForm_SelectBBS  (void);
static void    setBBSListItem       (void);
static void    setAllBBS_Selection  (UInt16     value);
static Boolean ctlSelEvt_SelectBBS  (EventType *event);
static Int16   ctlRepEvt_SelectBBS  (EventType *event);
static Int16   keyDownEvt_SelectBBS (EventType *event);
static void    set_Selection_Info   (UInt16     pageNum);
static void    display_BBS_Selection(UInt16     pageNum, Int16 selection);

///////////////////////////////////////////////////////////////////////////////
//////////   BBS擾p֐Q
///////////////////////////////////////////////////////////////////////////////

/*-------------------------------------------------------------------------*/
/*   Function :   getBoardURL                                              */
/*                                                                         */
/*                                              ̂ǂ̔fƎ擾 */
/*-------------------------------------------------------------------------*/
static UInt16 getBoardURL(Char *url, Char *nick, Char *top, Char *bottom)
{
    Char   *ptr, *ptr2, *ptr3, *chk;
    
    ptr  = StrStr(top, "http://");
    ptr2 = ptr + 7; // 7 == StrLen("http://");

#ifdef USE_STRSTR
    ptr2 = StrStr(ptr2, "/");
#else
    while ((*ptr2 != '/')&&(*ptr2 != '\0'))
    {
        ptr2++;
    }
#endif
    ptr2 = ptr2 + 1; // 1 == StrLen("/");
#ifdef USE_STRSTR
    ptr3 = StrStr(ptr2, "/");
#else
    ptr3 = ptr2;
    while ((*ptr3 != '/')&&(*ptr3 != '\0'))
    {
        ptr3++;
    }
#endif
    ptr3 = ptr3 + 1; // 1 == StrLen("/");
#ifdef USE_STRSTR
    if ((ptr3 == NULL)||(bottom < ptr3))
#else
    if ((bottom < ptr3)||(ptr3 == '\0'))
#endif
    {
        // "http://قɂ/قւق/" `ł͂Ȃ̂ŁAł͂ȂƔf
        return (NNSH_BBSTYPE_ERROR);
    }

    // 2˂̃{[hABBSPINK̃{[hȊO͔Ƃ݂͂ȂȂ
    chk = StrStr(top, "2ch.net");
    if ((chk != NULL)&&(chk < bottom))
    {
#if 0   // ܂ɂ͂ɎԂ肷̂ł͂
        chk = StrStr(top, "www.2ch.net");
        if ((chk != NULL)&&(chk < bottom))
        {
            // A"www.2ch.net" ƁAƂ݂͂ȂȂ悤ɂ
            return (NNSH_BBSTYPE_ERROR);
        }
#endif
        StrNCopy(url,  ptr,  (ptr3 - ptr));
        StrNCopy(nick, ptr2, (ptr3 - ptr2));
        return (NNSH_BBSTYPE_2ch);
    }
    chk = StrStr(top, "bbspink.com");
    if ((chk != NULL)&&(chk < bottom))
    {
        StrNCopy(url,  ptr,  (ptr3 - ptr));
        StrNCopy(nick, ptr2, (ptr3 - ptr2));
        return (NNSH_BBSTYPE_2ch);
    }

    // ܂BBS̃{[hvɂĂ݂BBB
    chk = StrStr(top, "machibbs.com");
    if ((chk != NULL)&&(chk < bottom))
    {
        // ܂BBSURĹA"http://(zXg)/" ɂB
        StrNCopy(url,  ptr,  (ptr2 - ptr));
        StrNCopy(nick, ptr2, (ptr3 - ptr2));
        return (NNSH_BBSTYPE_MACHIBBS);
    }

    if (NNshParam->notCheckBBSURL != 0)
    {
        // URL̗L`FbNȂꍇ(Ƃ肠)
        StrNCopy(url,  ptr,  (ptr3 - ptr));
        StrNCopy(nick, ptr2, (ptr3 - ptr2));
        return (NNSH_BBSTYPE_2ch);
#if 0
        {
            // ܂BBSURĹA"http://(zXg)/" ɂB
            StrNCopy(url,  ptr,  (ptr2 - ptr));
            StrNCopy(nick, ptr2, (ptr3 - ptr2));
            return (NNSH_BBSTYPE_MACHIBBS);
        }
#endif
    }

    return (~errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   parseBoard                                               */
/*                                  Mf[^̍\߂єꗗ̍XV */
/*-------------------------------------------------------------------------*/
static void parseBoard(DmOpenRef dbRef, Char *top, UInt32 *readSize)
{
    Err               err;
    Char             *data, *ptr, *chkToken;
    UInt32            parseSize;
    UInt16            state, index, ret;
    NNshBoardDatabase bbsData, bbsData2;

    // f[^̏
    index     = 0;
    ret       = NNSH_BBSTYPE_ERROR;
    state     = HTTP_ANCHORSTATE_NORMAL;
    chkToken  = "<A";
    MemSet(&bbsData, sizeof(NNshBoardDatabase), 0x00);

    parseSize = 0;
    ptr       = top;
    while (parseSize < *readSize)
    {
        data = StrStr(ptr, chkToken);
        if (data == NULL)
        {
            // g[NȂ(r܂Ńp[X)
            if (state != HTTP_ANCHORSTATE_NORMAL)
            {
                // Op[X擪
                *readSize = parseSize;
            }
            return;
        }
        // g[NI ݂̃Xe[gɂA𕪊򂷂
        switch (state)
        {
          case HTTP_ANCHORSTATE_ANCHOR:
            // URLRs[
            ret      = getBoardURL(bbsData.boardURL, bbsData.boardNick, 
                                   ptr, data);
            chkToken = "</A>";
            ptr      = data + 1;  // 1 == StrLen(">");
            state    = HTTP_ANCHORSTATE_LABEL;
            break;

          case HTTP_ANCHORSTATE_LABEL:
            StrNCopy(bbsData.boardName, ptr, (data - ptr));
            switch (ret)
            {
              case NNSH_BBSTYPE_SHITARABA:
                // ΂ꍇ
                StrCat(bbsData.boardName, NNSH_SHITARABA_SUFFIX);
                break;

              case NNSH_BBSTYPE_SHITARABAJBBS:
                // @JBBSꍇ
                StrCat(bbsData.boardName, NNSH_SHITARABAJBBS_SUFFIX);
                break;

              case NNSH_BBSTYPE_MACHIBBS:
                // ܂BBSꍇ
                StrCat(bbsData.boardName, NNSH_MACHINAME_SUFFIX);
                break;

              case NNSH_BBSTYPE_2ch:
              case NNSH_BBSTYPE_OTHERBBS:
                // 2chꍇ
                break;

              default:
                // BBSƂ͉Ȃ
                goto NEXT_BBS;
                break;
            }

            // BBSf[^DBɓo^
            bbsData.state     = (UInt8) NNSH_BBSSTATE_INVISIBLE;
            bbsData.bbsType   = (UInt8) ret;

            if (NNshParam->bbsOverwrite == 0)
            {
                // {[hf[^caɓo^B
                (void) EntryRecord_NNsh(dbRef, sizeof(NNshBoardDatabase),
                                        &bbsData);
            }
            else
            {
                // {[hf[^łɓo^ς݂`FbN
                err = SearchRecord_NNsh(dbRef, bbsData.boardNick,
                                        NNSH_KEYTYPE_CHAR, 0,
                                        sizeof(NNshBoardDatabase),
                                        &bbsData2, &index);
                if (err != errNone)
                {
                    // f[^炸AVKo^
                    (void) EntryRecord_NNsh(dbRef, 
                                            sizeof(NNshBoardDatabase),
                                            &bbsData);
                }
                else
                {
                    // f[^Af[^㏑
                    bbsData.state   = bbsData2.state;
                    bbsData.bbsType = bbsData2.bbsType;
                    (void) UpdateRecord_NNsh(dbRef, index,
                                             sizeof(NNshBoardDatabase),
                                             &bbsData);
                }
            }
            ret = NNSH_BBSTYPE_ERROR;

NEXT_BBS:
            // ̔T
            state     = HTTP_ANCHORSTATE_NORMAL;
            chkToken  = "<A";
            MemSet(&bbsData, sizeof(NNshBoardDatabase), 0x00);
            ptr       = data + 4; // 4 == StrLen("</A>");
            parseSize = ptr - top;
            break;

          case HTTP_ANCHORSTATE_NORMAL:
          default:
            state     = HTTP_ANCHORSTATE_ANCHOR;
            chkToken  = ">";
            ptr       = data + 2; // 2 == StrLen("<A");
            break;
        }
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   updateBoardList                                          */
/*                                                        {[hꗗ̍XV */
/*-------------------------------------------------------------------------*/
static void updateBoardList(void)
{
    Err                   ret;
    Char                 *ptr, boardNick[MAX_NICKNAME], *saveBBSInfo, *bufPtr;
    UInt16                bufSize, cnt, index, useBBSCnt, lp;
    UInt32                fileSize, offset, readSize;
    DmOpenRef             dbRef;
    NNshFileRef           fileRef;
    NNshBoardDatabase     tmpBd;

    // ꎞ̈̊m
    bufSize = NNshParam->bufferSize + MARGIN;
    bufPtr     = NULL;
    while (bufPtr == NULL)
    {
        bufPtr  = (Char *) MemPtrNew(bufSize);
        bufSize = bufSize - 12;
    }
    MemSet(bufPtr, bufSize, 0x00);

    // gpBBS𐔂āA݂̐ݒޔB
    Show_BusyForm(MSG_BBSBACKUP_INFO);
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);
    GetDBCount_NNsh(dbRef, &cnt);

    useBBSCnt   = 0;
    saveBBSInfo = NULL;

    if (NNshParam->bbsOverwrite == 0)
    { 
        // gpɐݒ肳ꂽBBS𐔂
        for (index = cnt; index != 0; index--)
        {
            MemSet(&tmpBd, sizeof(tmpBd), 0x00);
            GetRecord_NNsh(dbRef, (index - 1), sizeof(tmpBd), &tmpBd);
            if ((tmpBd.state & NNSH_BBSSTATE_VISIBLE) == NNSH_BBSSTATE_VISIBLE)
            {
                useBBSCnt++;
            }
        }

        // ݒ肳ĂBBSL
        saveBBSInfo = 
                    MemPtrNew((sizeof(Char) * MAX_NICKNAME) * (useBBSCnt + 1));
        if (saveBBSInfo == NULL)
        {
            // As(BBSgp͋L^Ȃ)
            useBBSCnt = 0;
        }
        else
        {
            // ̈揉
            MemSet(saveBBSInfo,
                   (sizeof(Char) * MAX_NICKNAME) * (useBBSCnt + 1),0x00);
        }

        // aarꗗS폜B
        SetMsg_BusyForm(MSG_BBSDELETE_INFO);
        ptr = saveBBSInfo;
        lp  = 0;
        for (index = cnt; index != 0; index--)
        {
            GetRecord_NNsh(dbRef, (index - 1), sizeof(tmpBd), &tmpBd);
            if ((tmpBd.state & NNSH_BBSSTATE_VISIBLE)== NNSH_BBSSTATE_VISIBLE)
            {
                // BBSgp񂪂΁ȀoĂ
                if (lp < useBBSCnt)
                {
                    StrCopy(ptr, tmpBd.boardNick);
                    lp++;
                    ptr = ptr + MAX_NICKNAME;
                }
            }
            DeleteRecordIDX_NNsh(dbRef, (index - 1));
        }
        useBBSCnt = lp;

        // ܂AItCpBBS(擪)o^Ă
        MemSet (&tmpBd, sizeof(NNshBoardDatabase), 0x00);
        StrCopy(tmpBd.boardNick, OFFLINE_THREAD_NICK);
        StrCopy(tmpBd.boardURL,  OFFLINE_THREAD_URL);
        StrCopy(tmpBd.boardName, OFFLINE_THREAD_NAME);
        tmpBd.state     = NNSH_BBSSTATE_VISIBLE;
        (void) EntryRecord_NNsh(dbRef, sizeof(NNshBoardDatabase), &tmpBd);
    }

    // t@CMf[^ǂݏoȂ{[hꗗXV
    SetMsg_BusyForm(MSG_BBSPARSE_INFO);
    OpenFile_NNsh(FILE_RECVMSG, 
                  (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                  &fileRef);
    GetFileSize_NNsh(&fileRef, &fileSize);

    // (fobObZ[W\)
    NNsh_DebugMessage(ALTID_INFO, FILE_RECVMSG, " fileSize:", fileSize);
    
    // Mf[^ׂēǂݏoA̒BBS̕𒊏oAo^
    offset = 0;
    while (offset < fileSize)
    {
        readSize = 0;
        ret = ReadFile_NNsh(&fileRef, offset, bufSize, bufPtr, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            NNsh_DebugMessage(ALTID_ERROR, 
                              "ReadFile_NNsh() ", FILE_RECVMSG, ret);
            break;
        }

        // BBS̒oDBɓo^郁C
        parseBoard(dbRef, bufPtr, &readSize);
        offset = offset + readSize;
    }
    if (bufPtr != NULL)
    {
        MemPtrFree(bufPtr);
    }
    CloseFile_NNsh(&fileRef);
    SetMsg_BusyForm(MSG_BBSSORT_INFO);

    // o^BBS𐮗񂷂(Quick Sortgp)
    QsortRecord_NNsh(dbRef, NNSH_KEYTYPE_CHAR, 0);

    // _uBBS(boardNick)폜
    //  (BBS͐񂵂Ă邽߁A_uBBS͘AĂ͂)
    SetMsg_BusyForm(MSG_BBSDUPCHK_INFO);
    GetDBCount_NNsh(dbRef, &cnt);
    if (cnt != 0)
    {
        MemSet(&tmpBd, sizeof(tmpBd), 0x00);
        GetRecord_NNsh(dbRef, (cnt - 1), sizeof(tmpBd), &tmpBd);
        MemSet (boardNick, sizeof(boardNick), 0x00);
        StrCopy(boardNick, tmpBd.boardNick);
        for (index = (cnt - 1) ; index != 0; index--)
        {
            MemSet(&tmpBd, sizeof(tmpBd), 0x00);
            GetRecord_NNsh(dbRef, (index - 1), sizeof(tmpBd), &tmpBd);
            if (StrCompare(boardNick, tmpBd.boardNick) == 0)
            {
                // INDEX̑傫ق폜
                DeleteRecordIDX_NNsh(dbRef, index);
            }
            else
            {
                MemSet (boardNick, sizeof(boardNick), 0x00);
                StrCopy(boardNick, tmpBd.boardNick);
            }
        }
    }

    //    BBSꗗ㏑Ȃꍇɂ́AꎞIɋLĂ
    //  BBSgpݒ𔽉f(\Ԃ邩H)
    if (NNshParam->bbsOverwrite == 0)
    {
        SetMsg_BusyForm(MSG_BBSRESTORE_INFO);
        GetDBCount_NNsh(dbRef, &cnt);
        for (index = cnt; index != 0; index--)
        {
            GetRecord_NNsh(dbRef, (index - 1), sizeof(tmpBd), &tmpBd);
            for (ptr = saveBBSInfo, lp = 0;
                 lp < useBBSCnt;
                 lp++, ptr = ptr + MAX_NICKNAME)
            {
                if (StrCompare(tmpBd.boardNick, ptr) == 0)
                {
                    tmpBd.state = NNSH_BBSSTATE_VISIBLE;
                    break;
                }
            }
            // BBSԂ(K)XV
            UpdateRecord_NNsh(dbRef, (index - 1), sizeof(tmpBd), &tmpBd);
        }
    }

    // Ƃ܂
    if (saveBBSInfo != NULL)
    {
        MemPtrFree(saveBBSInfo);
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(true);
    return;
}

/*=========================================================================*/
/*   Function :   GetBBSList                                               */
/*                                            Internetꗗ擾 */
/*=========================================================================*/
Boolean GetBBSList(Char *url)
{
    Err                ret;
    UInt16             buttonID, cnt;
    DmOpenRef          dbRef;
    NNshBoardDatabase  tmpBd;

    // aar擾JnmF
    buttonID = NNsh_ConfirmMessage(ALTID_CONFIRM, url, MSG_BBSURL_INFO, 0);
    if (buttonID != 0)
    {
        // LZ{^ĂꍇABBSꗗ擾ɏI
        //   Ã^C~OBBSꗗOꍇɂ́AOFFLINE
        // p̃XǉB
        goto SET_DUMMY_BBS;
    }

    // zXg{[hꗗf[^擾
    ret = NNshHttp_comm(HTTP_SENDTYPE_GET, url, NULL, NULL,
                        HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    if (ret != errNone)
    {
        // ʐMG[
        if (ret == netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "", ret);
        }
        else
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_ERROR_HTTP_COMM, "", ret);
        }
        // G[I
        goto SET_DUMMY_BBS;
    }

    // M{[hꗗf[^ϊA݋L^Ă̂ƒuB
    updateBoardList();
    return (true);

SET_DUMMY_BBS:
    // BBSꗗOꍇɂ́AOFFLINEp̃Xǉ鏈
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);
    GetDBCount_NNsh(dbRef, &cnt);
    if (cnt == 0)
    {
        // ItCOpBBSo^
        MemSet (&tmpBd, sizeof(NNshBoardDatabase), 0x00);
        StrCopy(tmpBd.boardNick, OFFLINE_THREAD_NICK);
        StrCopy(tmpBd.boardURL,  OFFLINE_THREAD_URL);
        StrCopy(tmpBd.boardName, OFFLINE_THREAD_NAME);
        tmpBd.bbsType   = NNSH_BBSTYPE_2ch;
        tmpBd.state     = NNSH_BBSSTATE_VISIBLE;
        (void) EntryRecord_NNsh(dbRef, sizeof(NNshBoardDatabase), &tmpBd);

        // BBSꗗʂ
        if (NNshGlobal->boardIdxH != 0)
        {
            MemHandleFree(NNshGlobal->boardIdxH);
            NNshGlobal->boardIdxH = 0;
        }
        if ((NNshGlobal->bbsTitles) != NULL)
        {
            MemPtrFree((NNshGlobal->bbsTitles));
            (NNshGlobal->bbsTitles) = NULL;
        }
        CloseDatabase_NNsh(dbRef);
        return (true);
    }
    CloseDatabase_NNsh(dbRef);
    return (false);
}

///////////////////////////////////////////////////////////////////////////////
//////////   gpBBSI֘A
///////////////////////////////////////////////////////////////////////////////
/*-------------------------------------------------------------------------*/
/*   Function :   searchBBSTitle                                           */
/*                                                 BBS^Cgs */
/*-------------------------------------------------------------------------*/
static Err searchBBSTitle(Char *title, UInt16 direction, UInt16 *recNum)
{
    Err                ret;
    Int16              step;
    UInt16             end, loop;
    Char               string[BUFSIZE];
    Char               match1[MAX_BOARDNAME], match2[MAX_BOARDNAME];
    DmOpenRef          dbRef;
    MemHandle          bdH;
    NNshBoardDatabase *tmpBd;

    // ""̕\
    MemSet (string, 0x00, sizeof(string));
    StrCopy(string, MSG_SEARCHING_TITLE);
    StrCat (string, title);
    Show_BusyForm(string);

    // 啶ʂȂꍇɂ́Aɕϊ
    MemSet(match1, sizeof(match1), 0x00);
    if (NNshParam->searchCaseless != 0)
    {
        (void) StrToLower(match1, title);
    }
    else
    {
        (void) StrCopy(match1, title);
    }

    // BBSf[^x[X擾
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);

    switch (direction)
    {
      case NNSH_SEARCH_ALL:
        // 擪S
        *recNum = 0;
        GetDBCount_NNsh(dbRef, &end);
        end--;
        step = 1;
        break;

      case NNSH_SEARCH_FORWARD:
        // tH[hw
        GetDBCount_NNsh(dbRef, &end);
        end--;
        step = 1;
        break;

      case NNSH_SEARCH_BACKWARD: 
      default:
        // obN[hw
        end  = 0;
        step = -1;
        break;
    }
    loop = *recNum;

    // ̎
    do {
        // GetRecord_NNsh()Ń[NAĂ邽ߕsv
        // MemSet(&tmpBd, sizeof(NNshBoardDatabase), 0x00);
        GetRecordReadOnly_NNsh(dbRef,(loop + step), &bdH, (void **)  &tmpBd);

        //  w肳ꂽƃ}b`邩mF
        MemSet(match2, sizeof(match2), 0x00);
        if (NNshParam->searchCaseless != 0)
        {
            // X^Cɕϊ
            (void) StrToLower(match2, tmpBd->boardName);
        }
        else
        {
            (void) StrCopy(match2, tmpBd->boardName);
        }
        ReleaseRecordReadOnly_NNsh(dbRef, bdH);

        loop = loop + step;
        if (StrStr(match2, match1) != NULL)
        {
            // I
            ret = errNone;
            goto FUNC_END;
        }
    } while (loop != end);

    // ɎsAȂ
    ret = ~errNone;

FUNC_END:
    *recNum = loop;
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   entryBBSRecord                                           */
/*                                                           BBŠʓo^ */
/*-------------------------------------------------------------------------*/
static void entryBBSRecord(UInt16 recNum)
{
    Err                err;
    Boolean            ret = false;
    FormType          *prevFrm, *diagFrm;
    UInt16             btnId, item;
    ListType          *lstP;
    NNshBoardDatabase  bbsData;
    Char               msg[BIGBUF], nickBak[MAX_NICKNAME + MARGIN];
    DmOpenRef          bbsRef;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // _CAOtH[ANeBuɂ
    diagFrm  = FrmInitForm(FRMID_BOARDINPUT);
    if (diagFrm == NULL)
    {
        return;
    }
    FrmSetActiveForm(diagFrm);

    // VN\ő剻
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaFormModify(diagFrm, vgaFormModify160To240);
        SilkMaximizeWindow();
    }
    else
#endif // #ifdef USE_HANDERA
    {
        NNshSilkMaximize(diagFrm);
    }
    HandEraMoveDialog(diagFrm);

    if (recNum != NNSH_NOTENTRY_BBS)
    {
        // R[hf[^擾
        MemSet(&bbsData, sizeof(bbsData), 0x00);
        OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &bbsRef);
        err = 
           GetRecord_NNsh(bbsRef, recNum, sizeof(NNshBoardDatabase), &bbsData);
        CloseDatabase_NNsh(bbsRef);
        if (err == errNone)
        {
            // f[^擾łƂ́A̎擾eʂɔf

            // BBS^Cv
            switch (bbsData.bbsType)
            {
              case NNSH_BBSTYPE_OTHERBBS:
                // 2ch݊
                item = 4;
                break;
              
              case NNSH_BBSTYPE_SHITARABAJBBS:
                // ΁JBBS
                item = 3;
                break;

              case NNSH_BBSTYPE_SHITARABA:
                // 
                item = 2;
                break;

              case NNSH_BBSTYPE_MACHIBBS:
                // ܂BBS
                item = 1;
                break;

              case NNSH_BBSTYPE_2ch:
              default:
                // Q˂
                item = 0;
                break;
            }
            NNshWinSetPopItems(diagFrm,POPTRID_BBSINPUT, LSTID_BBSINPUT, item);

            // BBS
            NNshWinSetFieldText(diagFrm, FLDID_BBSINPUT_NAME, false,
                                bbsData.boardName, (MAX_BOARDNAME));
            // URL
            NNshWinSetFieldText(diagFrm, FLDID_BBSINPUT_URL, false,
                                bbsData.boardURL, (MAX_URL));
            // BBS Nick
            NNshWinSetFieldText(diagFrm, FLDID_BBSINPUT_NICK, true,
                                bbsData.boardNick, (MAX_NICKNAME));
            MemSet (nickBak, sizeof(nickBak), 0x00);
            StrCopy(nickBak, bbsData.boardNick);

            // WXx̐ݒ
            item = 1;
            switch((bbsData.state) & NNSH_BBSSTATE_LEVELMASK)
            {
              case NNSH_BBSSTATE_FAVOR_L1:
                // Cɓ背x()
                SetControlValue(diagFrm, PBTNID_FAVOR_L1, &item);
                break;

              case NNSH_BBSSTATE_FAVOR_L2:
                // Cɓ背x()
                SetControlValue(diagFrm, PBTNID_FAVOR_L2, &item);
                break;

              case NNSH_BBSSTATE_FAVOR_L3:
                // Cɓ背x()
                SetControlValue(diagFrm, PBTNID_FAVOR_L3, &item);
                break;

              case NNSH_BBSSTATE_FAVOR_L4:
                // Cɓ背x()
                SetControlValue(diagFrm, PBTNID_FAVOR_L4, &item);
                break;

              case NNSH_BBSSTATE_FAVOR:
                // Cɓ背x()
                SetControlValue(diagFrm, PBTNID_FAVOR_L5, &item);
                break;

              default:
                // Cɓł͂Ȃ
                SetControlValue(diagFrm, PBTNID_FAVOR_L0, &item);
                break;
            }
        }
    }

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_EditAction);

    // ̓EBhEJ
    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_DIALOG_OK)
    {
        // OK{^ꂽƂAo^쐬
        MemSet(&bbsData, sizeof(bbsData), 0x00);

        // BBS擾
        NNshWinGetFieldText(diagFrm, FLDID_BBSINPUT_NAME, bbsData.boardName,
                            (MAX_BOARDNAME - 1));
        // URL擾
        NNshWinGetFieldText(diagFrm, FLDID_BBSINPUT_URL, bbsData.boardURL,
                            (MAX_URL - 1));
        // Nick擾
        NNshWinGetFieldText(diagFrm, FLDID_BBSINPUT_NICK, bbsData.boardNick,
                            (MAX_NICKNAME - 1));

        // XxBBSgpݒXV
        item = 0;
        UpdateParameter(diagFrm, PBTNID_FAVOR_L0, &item);
        if (item != 0)
        {
            // Cɓݒ肳ĂȂ
            bbsData.state = NNSH_BBSSTATE_VISIBLE;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L1, &item);
        if (item != 0)
        {
            // Cɓݒ()
            bbsData.state = (NNSH_BBSSTATE_VISIBLE)|(NNSH_BBSSTATE_FAVOR_L1);
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L2, &item);
        if (item != 0)
        {
            // Cɓݒ()
            bbsData.state = (NNSH_BBSSTATE_VISIBLE)|(NNSH_BBSSTATE_FAVOR_L2);
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L3, &item);
        if (item != 0)
        {
            // Cɓݒ()
            bbsData.state = (NNSH_BBSSTATE_VISIBLE)|(NNSH_BBSSTATE_FAVOR_L3);
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L4, &item);
        if (item != 0)
        {
            // Cɓݒ()
            bbsData.state = (NNSH_BBSSTATE_VISIBLE)|(NNSH_BBSSTATE_FAVOR_L4);
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L5, &item);
        if (item != 0)
        {
            // Cɓݒ()
            bbsData.state = (NNSH_BBSSTATE_VISIBLE)|(NNSH_BBSSTATE_FAVOR);
            goto DELETE_DIALOG;
        }

DELETE_DIALOG:
        // BBS^Cv̐ݒ
        lstP = FrmGetObjectPtr(diagFrm,
                               FrmGetObjectIndex(diagFrm, LSTID_BBSINPUT));
        item = LstGetSelection(lstP);
        switch (item)
        {
          case 4:
            // 2ch݊^Cv
            bbsData.bbsType = NNSH_BBSTYPE_OTHERBBS;
            break;
            
          case 3:
            // @JBBS^Cv
            bbsData.bbsType = NNSH_BBSTYPE_SHITARABAJBBS;
            break;

          case 2:
            // ΃^Cv
            bbsData.bbsType = NNSH_BBSTYPE_SHITARABA;
            break;

          case 1:
            // ܂aar^Cv
            bbsData.bbsType = NNSH_BBSTYPE_MACHIBBS;
            break;

          case 0:
          default:
            // 2ch^Cv
            bbsData.bbsType = NNSH_BBSTYPE_2ch;
            break;
        }
        MemSet (msg, sizeof(msg), 0x00);
        StrCopy(msg, bbsData.boardName);
        StrCat (msg, "(");
        StrCat (msg, bbsData.boardURL);
        StrCat (msg, ", Nick:");
        StrCat (msg, bbsData.boardNick);
        StrCat (msg, ") type:");
        NUMCATI(msg, (UInt16) bbsData.bbsType);
        btnId = NNsh_ConfirmMessage(ALTID_CONFIRM, 
                                    NNSH_CONFIRMMSG_ENTRYBBS, msg, 0);
        if (btnId == 0)
        {
            /////////////////////////////////////////////////////
            // BBSf[^x[Xɓo^/XV
            ////////////////////////////////////////////////////
            if (recNum == NNSH_NOTENTRY_BBS)
            {
                OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &bbsRef);

                EntryRecord_NNsh(bbsRef,sizeof(NNshBoardDatabase),&bbsData);

                // o^BBS𐮗񂷂(Quick Sortgp)
                QsortRecord_NNsh(bbsRef, NNSH_KEYTYPE_CHAR, 0);

                CloseDatabase_NNsh(bbsRef);

                // o^ƂʒmAċNv
                NNsh_InformMessage(ALTID_WARN, 
                                   bbsData.boardName, NNSH_MSGINFO_DBENTRY, 0);
            }
            else
            {

                // BBSXV
                err = Update_BBS_Database(recNum, &bbsData);

                // {[hjbNl[ύXǂmF
                if (StrCompare(nickBak, bbsData.boardNick) != 0)
                {
                    // {[hjbNl[ύXꍇɂ́A\[g
                    OpenDatabase_NNsh(DBNAME_BBSLIST, 
                                      DBVERSION_BBSLIST, &bbsRef);
                    // o^BBS𐮗񂷂(Quick Sortgp)
                    QsortRecord_NNsh(bbsRef, NNSH_KEYTYPE_CHAR, 0);

                    CloseDatabase_NNsh(bbsRef);
                }

                // XVƂʒm
                NNsh_InformMessage(ALTID_WARN, bbsData.boardName, 
                                   NNSH_MSGINFO_DBUPDATE, err);
            }
        }
    }
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        FrmEraseForm(prevFrm);

        // VN\ŏ
        NNshSilkMinimize(prevFrm);

        FrmDrawForm(prevFrm);
    }
    else
#endif
    {
        // VN\ŏ
        NNshSilkMinimize(prevFrm);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   CloseForm_SelectBBS                                      */
/*                                        ʕ\Ŏgpꎞ̈̊J */
/*-------------------------------------------------------------------------*/
static void closeForm_SelectBBS(void)
{
    // gf[^̂Ƃ܂
    MEMFREE_PTR((NNshGlobal->tempInfo)->checkBoxState);
    MEMFREE_PTR((NNshGlobal->tempInfo)->BBSName_Temp);
    MEMFREE_PTR((NNshGlobal->tempInfo));

    // BBSꗗʂ
    if (NNshGlobal->boardIdxH != 0)
    {
        MemHandleFree(NNshGlobal->boardIdxH);
        NNshGlobal->boardIdxH = 0;
    }
    if ((NNshGlobal->bbsTitles) != NULL)
    {
        MemPtrFree((NNshGlobal->bbsTitles));
        (NNshGlobal->bbsTitles) = NULL;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   setBBSListItem                                           */
/*                                   IBBSgpݒɔf */
/*-------------------------------------------------------------------------*/
static void setBBSListItem(void)
{
    Err                   ret;
    UInt16                index, cnt, useCnt;
    DmOpenRef             dbRef;
    NNshBoardDatabase     bbsData;

    // aarꗗJA݂̓o^BBS擾
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);
    GetDBCount_NNsh(dbRef, &cnt);

    // BBSXV
    useCnt = 0;
    for (index = 0; index < cnt; index++)
    {
        // BBS擾
        ret =  GetRecord_NNsh(dbRef, index, sizeof(bbsData), &bbsData);
        if (ret != errNone)
        {
            // ŃG[͂肦Ȃ͂Ȃ񂾂...
            NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh()", "", ret);
            continue;
        }
        if (((NNshGlobal->tempInfo)->checkBoxState[index] == 
                                          NNSH_BBSSTATE_VISIBLE)||(index == 0))
        {
            bbsData.state = ((NNSH_BBSSTATE_LEVELMASK)&(bbsData.state))|(NNSH_BBSSTATE_VISIBLE);
            useCnt++;
        } 
        else
        {
            bbsData.state = ((NNSH_BBSSTATE_LEVELMASK)&(bbsData.state))|(NNSH_BBSSTATE_INVISIBLE);
        } 
        UpdateRecord_NNsh(dbRef, index, sizeof(bbsData), &bbsData);
    }

    // f[^x[X̃N[Y
    CloseDatabase_NNsh(dbRef);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   setAllBBS_Selection                                      */
/*                                            {[hꗗIꊇXV */
/*-------------------------------------------------------------------------*/
static void setAllBBS_Selection(UInt16 value)
{
    FormType  *frm;
    TableType *tableP;
    UInt16     row, nofRow;

    // ׂđI  
    for (row = 0; row < (NNshGlobal->tempInfo)->nofRecords; row++)
    {
        (NNshGlobal->tempInfo)->checkBoxState[row] = value;
    }

    // ʏ̃IuWFNgɐݒ𔽉f
    frm    = FrmGetActiveForm();
    tableP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));
    nofRow = TblGetNumberOfRows(tableP);
    for (row = 0; row < nofRow; row++)
    {
        TblSetItemInt(tableP, row, 1, value);
    }

    //e[u̕\ԂXV
    TblEraseTable(tableP);
    TblDrawTable (tableP);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : detail_SelectBBS                                           */
/*                                                       BBSڍׂ̕\ */
/*-------------------------------------------------------------------------*/
static Boolean detail_SelectBBS(void)
{
    FormType    *frm;
    TableType   *tableP;
    UInt16       row, col, nofRow, recNum;

    frm    = FrmGetActiveForm();
    tableP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,TBLID_BBS_SELECTION));
                                 
    nofRow = TblGetNumberOfRows(tableP);
    if (TblGetSelection(tableP, &row, &col) == true)
    {
        // 擾郌R[hԍ肷
        recNum = ((NNshGlobal->tempInfo)->currentPage * 
                  ((NNshGlobal->tempInfo)->nofRow - 1)) + row;
        entryBBSRecord(recNum);

        //////////  XIʂXV  /////////
        display_BBS_Selection((NNshGlobal->tempInfo)->currentPage,
                              NNSH_ITEM_LASTITEM);
        return (true);
    }
    // e[uIĂȂ(x\)
    NNsh_WarningMessage(ALTID_WARN, NNSH_MSGINFO_NOTSELECTBBS, "", 0);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function : ctlSelEvt_SelectBBS                                        */
/*                                                {^ꂽ̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlSelEvt_SelectBBS(EventType *event)
{
    Boolean ret = true;
    Err     err;

    switch (event->data.ctlSelect.controlID)
    {
      // uׂđIv{^
      case BTNID_SELECT_ALLBBS:
        setAllBBS_Selection(NNSH_BBSSTATE_VISIBLE);
        break;

      // uׂĉv{^
      case BTNID_DESELECT_ALLBBS:
        setAllBBS_Selection(NNSH_BBSSTATE_INVISIBLE);
        break;

      // uڍׁv{^
      case BTNID_DETAIL_BBS:
        return (detail_SelectBBS());
        break;

      // uݒv{^
      case BTNID_SELECT_BBS:
        // ݂̐ݒugpԊi[[N̈vɔf
        set_Selection_Info((NNshGlobal->tempInfo)->currentPage);
        // gpBBSݒDBɔf
        Show_BusyForm(MSG_BBSLISTSETTING_INFO);
        setBBSListItem();

        // gpBBSݒDBVFSɃobNAbv
        if ((NNshParam->useVFS & (NNSH_VFS_DBBACKUP)) != 0)
        {
            err = BackupDatabaseToVFS_NNsh(DBNAME_BBSLIST);
            if (err != errNone)
            {
                // G[\
                NNsh_DebugMessage(ALTID_ERROR, "BackupDatabaseToVFS()",
                                  DBNAME_BBSLIST, err);
            }
        }
        Hide_BusyForm(true);

        // tH[Ŏgpꎞ̈̊J
        closeForm_SelectBBS();

        // Xꗗʂɖ߂
        FrmGotoForm(FRMID_THREAD);
        break;

      // ȊÕ{^(肦Ȃ)
      default:
        ret = false;
        break;
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : ctlRepEvt_SelectBBS                                        */
/*                                        s[g{^ꂽ̏ */
/*-------------------------------------------------------------------------*/
static Int16 ctlRepEvt_SelectBBS(EventType *event)
{
    Int16 command = 0;

    switch (event->data.ctlRepeat.controlID)
    {
      case RPTID_MANAGEBBS_UP:
        // ナs[g{^ : Õy[W\
        command = -1;
        break;

      case RPTID_MANAGEBBS_DOWN:
        // s[g{^ : ̃y[W\
        command = 1;
        break;

      default:
        // ȊÕ{^
        break;
    }
    return (command);
}

/*-------------------------------------------------------------------------*/
/*   Function : keyDownEvt_SelectBBS                                       */
/*                                                  L[͂ꂽ̏ */
/*-------------------------------------------------------------------------*/
static Int16 keyDownEvt_SelectBBS(EventType *event)
{
    Int16  command = 0;
    UInt16 keyCode;

    //tungsten T 5way navigator (281AӁI)
    keyCode = KeyConvertFiveWayToJogChara(event);
    switch (keyCode)
    {
        // BL[
      case chrCapital_B:
      case chrSmall_B:
        // 
        command = (NNshGlobal->tempInfo)->maxPage
                                  - ((NNshGlobal->tempInfo)->currentPage + 1);
        break;

        // TL[
      case chrCapital_T:
      case chrSmall_T:
        // 擪
        command = (NNshGlobal->tempInfo)->currentPage * (-1);
        break;


      // uv̏(WO_C) : Õy[W\
      case vchrPageUp:
      case vchrJogUp:
      case vchrThumbWheelUp:
      case vchrTrgJogUp:
      case chrUpArrow:
      case chrCapital_P:  // PL[̓
      case chrSmall_P:
        command = -1;
        break;

      // uv̏(WO_C) : ̃y[W\
      case vchrPageDown:
      case vchrJogDown:
      case vchrThumbWheelDown:
      case vchrTrgJogDown:
      case chrDownArrow:
      case chrCapital_N:  // NL[̓
      case chrSmall_N:
        command = 1;
        break;

      // WO_C()̏
      // J[\L[Ei5way Ej̏
      // J[\L[()̏
      case vchrJogPushedDown:
      case chrRightArrow:
        if (((NNshGlobal->tempInfo)->maxPage - 
                                     (NNshGlobal->tempInfo)->currentPage) < 5)
        {
            command = (NNshGlobal->tempInfo)->maxPage
                                  - ((NNshGlobal->tempInfo)->currentPage + 1);
        }
        else
        {
            command = 5;
        }
        break;

      // WO_C()̏
      // J[\L[ijE5way̏ 
      // J[\L[()̏
      case vchrJogPushedUp:
      case chrLeftArrow:
        if ((NNshGlobal->tempInfo)->currentPage < 5)
        {
            command = (NNshGlobal->tempInfo)->currentPage * (-1);
        }
        else
        {
            command = -5;
        }
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf
        NNshNet_LineHangup();
        break;

      // ㉺ȊȌ(Ȃ)
      case vchrJogRelease:
      case vchrJogBack:
      default:
        break;
    }
    return (command);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Set_BBS_Selection                                        */
/*                                        \̃{[hꗗI擾 */
/*-------------------------------------------------------------------------*/
static void set_Selection_Info(UInt16 pageNum)
{
    FormType  *frm;
    TableType *tableP;
    UInt16     nofRow, lp, startItem;

    // tH[̏擾
    frm    = FrmGetActiveForm();
    tableP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));

    // 擾擪INDEXԍ肷
    nofRow    = (NNshGlobal->tempInfo)->nofRow;
    startItem = pageNum * (nofRow - 1);

    // \Ăf[^ugpԊi[[N̈vɔf
    for (lp = 0; lp < nofRow; lp++)
    {
        // f[^̍ő吔𒴂ǂ̃`FbN
        if ((startItem + lp) >= (NNshGlobal->tempInfo)->nofRecords)
        {
            return;
        }
        (NNshGlobal->tempInfo)->checkBoxState[startItem + lp]
                                               = TblGetItemInt(tableP, lp, 1);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   display_BBS_Selection                                    */
/*                                  {[hꗗI(y[WPʂ)\ */
/*-------------------------------------------------------------------------*/
static void display_BBS_Selection(UInt16 pageNum, Int16 selection)
{
    FormType          *frm;
    TableType         *tableP;
    Char              *namePtr;
    UInt16            *chkPtr, nofRow, lp, startItem;
    DmOpenRef          dbRef;
    MemHandle          bdH;
    NNshBoardDatabase *tmpBd;

    // tH[̏擾
    frm    = FrmGetActiveForm();
    tableP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));
    nofRow = TblGetNumberOfRows(tableP);

    // ݕ\̃y[W(ʉE)\
    MemSet ((NNshGlobal->tempInfo)->PageLabel, BBSSEL_PAGEINFO, 0x00);
    NUMCATI((NNshGlobal->tempInfo)->PageLabel, (pageNum + 1));
    StrCat ((NNshGlobal->tempInfo)->PageLabel, " / ");
    NUMCATI((NNshGlobal->tempInfo)->PageLabel, 
            (NNshGlobal->tempInfo)->maxPage);
    NNshWinSetFieldText(frm, FLDID_PAGENUM, true,
                        (NNshGlobal->tempInfo)->PageLabel,
                        StrLen((NNshGlobal->tempInfo)->PageLabel));

    // 擾擪INDEXԍ肷
    startItem = pageNum * (nofRow - 1);

    // ʂɕ\x쐬ȂAʂݒ肷
    MemSet((NNshGlobal->tempInfo)->BBSName_Temp, 
           (NNshGlobal->tempInfo)->BBSName_size, 0x00);
    namePtr = (NNshGlobal->tempInfo)->BBSName_Temp;
    chkPtr  = (NNshGlobal->tempInfo)->checkBoxState;
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);
    for (lp = 0; lp < nofRow; lp++)
    {
        // f[^̍ő吔𒴂ǂ̃`FbN
        if ((startItem + lp) < (NNshGlobal->tempInfo)->nofRecords)
        {
            // xnamePtrɃRs[( + boardNick\)
            (void) GetRecordReadOnly_NNsh(dbRef, (lp + startItem), &bdH, 
                                          (void **) &tmpBd);
            StrCopy(namePtr, tmpBd->boardName);
            StrCat (namePtr, "(");
            StrCat (namePtr, tmpBd->boardNick);
            ReleaseRecordReadOnly_NNsh(dbRef, bdH);
            namePtr[StrLen(namePtr) - 1] = ')';

            // ̍쐬
            TblSetRowData(tableP, lp, (UInt32) (lp + 1));

            // f[^Zbg (̂̐ݒ)
            TblSetItemStyle(tableP, lp, 0, labelTableItem);
            TblSetItemPtr  (tableP, lp, 0, namePtr);

            // f[^Zbg (`FbN{bNX)
            TblSetItemStyle(tableP, lp, 1, checkboxTableItem);
            TblSetItemInt (tableP, lp, 1, (UInt16) chkPtr[lp + startItem]);

            // xi[̈ւ߂
            namePtr = namePtr + StrLen(namePtr) + 1;

            TblSetRowUsable(tableP, lp, true);
        }
        else
        {
            TblSetRowUsable(tableP, lp, false);
        }
    }
    CloseDatabase_NNsh(dbRef);
    
    // e[ũf[^\ł悤ɂ
    TblSetColumnUsable(tableP, 0, true);
    TblSetColumnUsable(tableP, 1, true);

    // ʂ̍ĕ\
    TblEraseTable(tableP);
    TblDrawTable (tableP);

    // e[uI
    if (selection < nofRow)
    {
        TblSelectItem(tableP, selection, 0);
    }
    return;
}

/*=========================================================================*/
/*   Function : Handler_SelectBBS                                          */
/*                                           aarǗ̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_SelectBBS(EventType *event)
{
    Int16        addPage = 0;
    UInt16       nofRow, recNum  = 0;
    Char        *ttl;
#ifdef USE_HANDERA
    FormType    *frm;
#endif

    switch (event->eType)
    {
      case ctlSelectEvent:
        // {^ꂽƂ̏
        ctlSelEvt_SelectBBS(event);
        break;

      case ctlRepeatEvent:
        // s[g{^ꂽƂ̏
        addPage = ctlRepEvt_SelectBBS(event);
        break;

      case keyDownEvent:
        // L[͂ꂽƂ̏
        addPage = keyDownEvt_SelectBBS(event);
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent :
        // HandErapʃTCYύXCxg
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            FrmEraseForm(frm);
            HandEraResizeForm(frm);
            FrmDrawForm(frm);

            //////////  XIʂXV  /////////
            display_BBS_Selection((NNshGlobal->tempInfo)->currentPage, 
                                  NNSH_ITEM_LASTITEM);
        } 
       break;
#endif  // #ifdef USE_HANDERA

      case menuEvent:
        switch (event->data.menu.itemID)
        {
          case MNUID_NET_DISCONN:
            // ؒf
            NNshNet_LineHangup();
            break;

          case MNUID_SEARCH_TITLE:
            ttl = ((NNshGlobal->tempInfo)->searchName);
            MemSet(ttl, MAX_BOARDNAME, 0x00);
            // ^Cg
            // (̓EBhEJAf[^l)
            if (DataInputDialog(NNSH_INPUTWIN_SEARCH, ttl, MAX_BOARDNAME,
                                NNSH_DIALOG_USE_SEARCH, NULL) != true)
            {
                break;
            }
            addPage = -1;
            recNum = 0;
            // not break;  Č...

          case MNUID_SEARCH_NEXT:
            // s()
            if (addPage == 0)
            {
                // \Ăy[Ẅԉ猟
                recNum =  (((NNshGlobal->tempInfo)->currentPage + 1) * 
                           (NNshGlobal->tempInfo)->nofRow) + 1;
                if (recNum >= (NNshGlobal->tempInfo)->nofRecords)
                {
                    // R[hI[ot[ꍇ͐擪
                    recNum = 0;
                }
            }
            ttl = ((NNshGlobal->tempInfo)->searchName);
            if (searchBBSTitle(ttl, NNSH_SEARCH_FORWARD, &recNum) == errNone)
            {
                // (^Cg)
                // ݂̐ݒugpԊi[[N̈vɔf
                set_Selection_Info((NNshGlobal->tempInfo)->currentPage);

                // \y[WԍXV
                (NNshGlobal->tempInfo)->currentPage =
                               recNum / (((NNshGlobal->tempInfo)->nofRow) - 1);
                nofRow =   recNum % (((NNshGlobal->tempInfo)->nofRow) - 1);

                //////////  XIʂXV(\y[Ẅړ) /////
                display_BBS_Selection((NNshGlobal->tempInfo)->currentPage, 
                                      nofRow);
                return (true);
            }
            NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, ttl, 0);
            break;

          case MNUID_ENTRY_BBS:
            // BBŠʓo^Aʂ
            entryBBSRecord(NNSH_NOTENTRY_BBS);
            closeForm_SelectBBS();
            FrmGotoForm(FRMID_THREAD);
            break;

          case MNUID_UPDATE_BBS:
            // BBSڍ
            return (detail_SelectBBS());
            break;

          default:
            // LȊO 
            break;
        }
        return (false);
        break;

      default:
        // LȊÕCxg
        break;
    }

    // y[Ẅړ
    if ((addPage != 0)&&
        (((NNshGlobal->tempInfo)->currentPage + addPage) >= 0)&&
        (((NNshGlobal->tempInfo)->currentPage +addPage) <
                                              (NNshGlobal->tempInfo)->maxPage))
    {
        // ݂̐ݒugpԊi[[N̈vɔf
        set_Selection_Info((NNshGlobal->tempInfo)->currentPage);

        // \y[WԍXV
        (NNshGlobal->tempInfo)->currentPage =
                                  (NNshGlobal->tempInfo)->currentPage +addPage;

        //////////  XIʂXV  /////////
        display_BBS_Selection((NNshGlobal->tempInfo)->currentPage, 
                              NNSH_ITEM_LASTITEM);
        return (true);
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   OpenForm_SelectBBS                                       */
/*                                       gpBBSIʂJ */
/*=========================================================================*/
void OpenForm_SelectBBS(FormType *frm)
{
    Err                    ret;
    DmOpenRef              dbBBSRef;
    UInt16                 bbsCnt,lp, nofRow;
    UInt32                 bufSize;
    NNshBoardDatabase      tmpBd;
    TableType             *tableP;

    // gpBBSIʗpobt@̈̊m
    if ((NNshGlobal->tempInfo) != NULL)
    {
        // gpԊi[[N̈̊m(mۍς݂ꍇɂ͉Ăo^)
        if ((NNshGlobal->tempInfo)->checkBoxState != NULL)
        {
            MemPtrFree((NNshGlobal->tempInfo)->checkBoxState);
        }
        MemPtrFree((NNshGlobal->tempInfo));
    }
    (NNshGlobal->tempInfo) = MemPtrNew(sizeof(NNshBBS_Temp_Info));
    if ((NNshGlobal->tempInfo) == NULL)
    {
        // ̈mۃG[Äꗗʂɖ߂
        FrmGotoForm(FRMID_THREAD);
        return;
    }
    MemSet((NNshGlobal->tempInfo), sizeof(NNshBBS_Temp_Info), 0x00);

    // 񐔂擾
    tableP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));
    nofRow = TblGetNumberOfRows(tableP);

    // BUSYEBhE\
    Show_BusyForm(MSG_READ_BBSLIST_WAIT);

    // o^Ă擾
    OpenDatabase_NNsh (DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbBBSRef);
    GetDBCount_NNsh   (dbBBSRef, &bbsCnt);

    bufSize = (bbsCnt + 1) * sizeof(UInt16) + 8;
    (NNshGlobal->tempInfo)->checkBoxState = (UInt16 *) MemPtrNew(bufSize);
    if ((NNshGlobal->tempInfo)->checkBoxState == NULL)
    {
        //  obt@̈mۃG[
        NNsh_DebugMessage(ALTID_ERROR,MSG_MEMORY_ALLOC_FAIL,"size:",bufSize);
        goto ERROR_END;
    }
    MemSet((NNshGlobal->tempInfo)->checkBoxState, bufSize, 0x00);

    // BBS̎gpԂꎞ̈ɔf
    for (lp = 0; lp < bbsCnt; lp++)
    {
        ret = GetRecord_NNsh(dbBBSRef, lp, sizeof(tmpBd), &tmpBd);
        if (ret == errNone)
        {
            (NNshGlobal->tempInfo)->checkBoxState[lp] = ((tmpBd.state)&(NNSH_BBSSTATE_VISIBLE));
        }
    }

    // \̈̊m(mۍς݂ꍇɂ͉Ăēxmۂ)
    if ((NNshGlobal->tempInfo)->BBSName_Temp != NULL)
    {
        MemPtrFree((NNshGlobal->tempInfo)->BBSName_Temp);
        (NNshGlobal->tempInfo)->BBSName_Temp = NULL;
    }
    bufSize = (nofRow + 1) * 
                    (MAX_BOARDNAME + MAX_NICKNAME + 3 + 1) * sizeof(Char) + 8;
    (NNshGlobal->tempInfo)->BBSName_Temp = (Char *) MemPtrNew(bufSize);
    if ((NNshGlobal->tempInfo)->BBSName_Temp == NULL)
    {
        //  obt@̈mۃG[
        NNsh_DebugMessage(ALTID_ERROR,MSG_MEMORY_ALLOC_FAIL,"Size:",bufSize);

        // `FbNԂ̗̈J
        MemPtrFree((NNshGlobal->tempInfo)->checkBoxState);
        (NNshGlobal->tempInfo)->checkBoxState = NULL;

        goto ERROR_END;
    }
    (NNshGlobal->tempInfo)->BBSName_size = bufSize;
    MemSet((NNshGlobal->tempInfo)->BBSName_Temp, bufSize, 0x00);

    // BBSIʍőy[W߂
    (NNshGlobal->tempInfo)->maxPage     = (bbsCnt / (nofRow - 1));
    if ((bbsCnt % (nofRow - 1)) > 1)
    {
        //  XN[lƁA1y[WɎ(nofRow - 1)BBS
        // \ł邪Aŏ̃y[W nofRow\ł邽߁A
        // lĂ܂y[W߂B
        (NNshGlobal->tempInfo)->maxPage++;
    }
    (NNshGlobal->tempInfo)->currentPage = 0;
    (NNshGlobal->tempInfo)->nofRecords  = bbsCnt;
    (NNshGlobal->tempInfo)->nofRow      = nofRow;

    // f[^x[X̃N[Y
    CloseDatabase_NNsh(dbBBSRef);

    // BUSYEBhE
    Hide_BusyForm(true);

    //////////  XIʂ\  /////////
    display_BBS_Selection((NNshGlobal->tempInfo)->currentPage,
                           NNSH_ITEM_LASTITEM);

    // BBS^Cg̓NA
    if (NNshGlobal->boardIdxH != 0)
    {
        MemHandleFree(NNshGlobal->boardIdxH);
        NNshGlobal->boardIdxH = 0;
    }
    if ((NNshGlobal->bbsTitles) != NULL)
    {
        MemPtrFree((NNshGlobal->bbsTitles));
        (NNshGlobal->bbsTitles) = NULL;
    }
    return;

ERROR_END:
    // f[^x[X̃N[Y
    CloseDatabase_NNsh(dbBBSRef);

    // BUSYEBhE
    Hide_BusyForm(true);

    // f[^NA
    closeForm_SelectBBS();

    // Xꗗʂɖ߂
    FrmGotoForm(FRMID_THREAD);
    return;
}

/*=========================================================================*/
/*   Function :   Get_BBS_Info                                             */
/*                                     XgIԍBBS擾 */
/*=========================================================================*/
Err Get_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)
{
    Err              ret;
    DmOpenRef        bbsRef;
    UInt16          *bbsIdx, index;
    NNshBBSRelation *relPtr;

#if 0    // ̊֐ĂяoOɂ̃G[͔ς݁AAÂ͂B

    // BBSꗗuCɓvu擾ς݃XSāvuǂv̎̓G[
    if ((selBBS == NNSH_SELBBS_FAVORITE)||
        (selBBS == NNSH_SELBBS_GETALL)||
        (selBBS == NNSH_SELBBS_NOTREAD)||
        (selBBS == NNSH_SELBBS_CUSTOM1)||
        (selBBS == NNSH_SELBBS_CUSTOM2)||
        (selBBS == NNSH_SELBBS_CUSTOM3)||
        (selBBS == NNSH_SELBBS_CUSTOM4)||
        (selBBS == NNSH_SELBBS_CUSTOM5))
    {    
        return (~errNone - 3);
    }

#endif

    // BBS̃CfbNX擾
    if (NNshGlobal->boardIdxH == 0)
    {
        // CfbNX擾s
        return (~errNone);
    }
    relPtr = MemHandleLock(NNshGlobal->boardIdxH);
    if (relPtr == NULL)
    {
        // CfbNX擾s
        return (~errNone);
    }
    bbsIdx = &(relPtr->bbsIndex);
    index  = bbsIdx[selBBS];
    MemHandleUnlock(NNshGlobal->boardIdxH);

    // f[^x[XI[vABBS擾
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &bbsRef);
    ret = GetRecord_NNsh(bbsRef, index, sizeof(NNshBoardDatabase), bbsInfo);
    CloseDatabase_NNsh(bbsRef);
    if (ret != errNone)
    {
        // R[h̎擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_BBS_Info()", "", ret);
        MemSet(bbsInfo, sizeof(NNshBoardDatabase),   0x00);
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   Update_BBS_Info                                          */
/*                                     XgIԍBBSXV */
/*=========================================================================*/
Err Update_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)
{
    UInt16          *bbsIdx, index;
    NNshBBSRelation *relPtr;
    
    // BBSꗗ{[h̎̓G[
    if (selBBS <= NNSH_SELBBS_CUSTOM2)
    {    
        return (~errNone - 3);
    }

    // BBS̃CfbNX擾
    if (NNshGlobal->boardIdxH == 0)
    {
        // CfbNX擾s
        return (~errNone);
    }
    relPtr = MemHandleLock(NNshGlobal->boardIdxH);
    if (relPtr == NULL)
    {
        // CfbNX擾s
        return (~errNone);
    }
    bbsIdx = &(relPtr->bbsIndex);
    index  = bbsIdx[selBBS];
    MemHandleUnlock(NNshGlobal->boardIdxH);

    // BBS̃f[^x[XɃf[^o^
    return (Update_BBS_Database(index, bbsInfo));
}

/*=========================================================================*/
/*   Function : Get_BBS_Database                                           */
/*                                      (boardNickBBS擾)   */
/*=========================================================================*/
Err Get_BBS_Database(Char *boardNick, NNshBoardDatabase *bbs, UInt16 *index)
{
    Err       ret;
    DmOpenRef dbRef;

    *index = 0;

    // BBSf[^x[X擾
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &dbRef);

    ret = SearchRecord_NNsh(dbRef, boardNick, NNSH_KEYTYPE_CHAR, 0,
                            sizeof(NNshBoardDatabase), bbs, index);

    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function : Update_BBS_Database                                        */
/*                                          (indexBBSL^)   */
/*=========================================================================*/
Err Update_BBS_Database(UInt16 index, NNshBoardDatabase *bbs)
{
    Err       ret;
    DmOpenRef bbsRef;

    // f[^x[XI[vABBSXV
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &bbsRef);
    ret = UpdateRecord_NNsh(bbsRef, index, sizeof(NNshBoardDatabase), bbs);
    CloseDatabase_NNsh(bbsRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :   Create_BBS_INDEX                                         */
/*                                                      BBSꗗ̍쐬  */
/*=========================================================================*/
Err Create_BBS_INDEX(Char **bdLst, UInt16 *cnt)
{
    Err                   ret = errNone;
    DmOpenRef             bbsRef;
    UInt16                nofBBS, tempSize, lp, useCnt, *idxP;
    Char                 *ptr;
    MemHandle             bdH;
    NNshBoardDatabase    *tmpBd;
    NNshBBSRelation      *relPtr;

    // ^ꂽ *bdLst  NULLłȂ΁A(BBSꗗ\zς݂ƍl)Ȃ
    if (*bdLst != NULL)
    {
        *cnt = NNshGlobal->useBBS;
        NNsh_DebugMessage(ALTID_INFO,"Already created BBS-name-LIST","",*cnt);
        return (errNone);
    }

    // "BBSꗗ쐬"̕\
    Show_BusyForm(MSG_READ_BBS_WAIT);

    // BBSf[^x[X̃I[v
    OpenDatabase_NNsh(DBNAME_BBSLIST, DBVERSION_BBSLIST, &bbsRef);
    GetDBCount_NNsh(bbsRef, &nofBBS);
    if (nofBBS == 0)
    {
        // "쐬"\̍폜
        Hide_BusyForm(false);
        CloseDatabase_NNsh(bbsRef);

        // VFScaXgA(\Ȃ)
        ret = RestoreDBtoVFS(true);
        if (ret != errNone)
        {
            // BBSf[^x[X݂ȂꍇAx\
            NNsh_WarningMessage(ALTID_WARN,
                                MSG_BOARDDB_NONE1, MSG_BOARDDB_NONE2, 0);
        }
        return (~errNone);
    }

    // gpBBSJEg
    useCnt = 0;
    for (lp = 0; lp < nofBBS; lp++)
    {
        (void) GetRecordReadOnly_NNsh(bbsRef, lp, &bdH, (void **) &tmpBd);
        if ((tmpBd->state & NNSH_BBSSTATE_VISIBLE) == NNSH_BBSSTATE_VISIBLE)
        {
            useCnt++;
        } 
        ReleaseRecordReadOnly_NNsh(bbsRef, bdH);
    }
    if (useCnt == 0)
    {
        // "쐬"\̍폜
        Hide_BusyForm(false);
        CloseDatabase_NNsh(bbsRef);

        // gpf[^x[Xݒ肳ĂȂꍇAx\
        NNsh_WarningMessage(ALTID_WARN,
                            MSG_USEBOARD_WARN1, MSG_USEBOARD_WARN2, 0);
        return (~errNone);
    }

    // BBS^CgCfbNXp̗̈mۂ
    if (NNshGlobal->boardIdxH != 0)
    {
        MemHandleFree(NNshGlobal->boardIdxH);
        NNshGlobal->boardIdxH = 0;
    }
    tempSize      = sizeof(NNshBBSRelation) +
                       sizeof(UInt16) * (useCnt + NNSH_NOF_SPECIAL_BBS);
    NNshGlobal->boardIdxH = MemHandleNew(tempSize);
    if (tempSize == 0)
    {
       // "쐬"\̍폜
       Hide_BusyForm(false);

       // ̈mۃG[
       ret = ~errNone;
       NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL,
                         " size:", tempSize);

       // f[^x[X̃N[Y
       CloseDatabase_NNsh(bbsRef);
       return (~errNone);
    }
    relPtr = MemHandleLock(NNshGlobal->boardIdxH);
    idxP   = &(relPtr->bbsIndex);

    // BBS^Cgꗗp̗̈mۂ
    tempSize = sizeof(Char) *
                     (useCnt + NNSH_NOF_SPECIAL_BBS) * (LIMIT_BOARDNAME + 1);
    *bdLst   = (Char *) MemPtrNew(tempSize);
    if (*bdLst == NULL)
    {
        MemHandleUnlock(NNshGlobal->boardIdxH);
        MemHandleFree(NNshGlobal->boardIdxH);
        NNshGlobal->boardIdxH = 0;

        // "쐬"\̍폜
        Hide_BusyForm(false);

        // ̈mۃG[
        ret = ~errNone;
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL,
                          " size:", tempSize);

        // f[^x[X̃N[Y
        CloseDatabase_NNsh(bbsRef);
        return (~errNone);
    }
    MemSet(*bdLst, tempSize, 0x00);
    ptr = *bdLst;
    *cnt  = 0;

    // BBSꗗ̐擪Ɂuǂvu擾ςݑSāvuCɓvǉ
    StrCopy(ptr, NOTREAD_THREAD_NAME);
    ptr   = ptr + sizeof(NOTREAD_THREAD_NAME); // Terminator܂߂člĂ
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, GETALL_THREAD_NAME);
    ptr   = ptr + sizeof(GETALL_THREAD_NAME); // Terminator܂߂člĂ
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, FAVORITE_THREAD_NAME);
    ptr   = ptr + sizeof(FAVORITE_THREAD_NAME); // Terminator܂߂člĂ
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, CUSTOM1_THREAD_HEAD);
    StrCat (ptr, NNshParam->custom1.tabName);
    ptr   = ptr + StrLen(ptr) + 1;
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, CUSTOM2_THREAD_HEAD);
    StrCat (ptr, NNshParam->custom2.tabName);
    ptr   = ptr + StrLen(ptr) + 1;
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, CUSTOM3_THREAD_HEAD);
    StrCat (ptr, NNshParam->custom3.tabName);
    ptr   = ptr + StrLen(ptr) + 1;
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, CUSTOM4_THREAD_HEAD);
    StrCat (ptr, NNshParam->custom4.tabName);
    ptr   = ptr + StrLen(ptr) + 1;
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    StrCopy(ptr, CUSTOM5_THREAD_HEAD);
    StrCat (ptr, NNshParam->custom5.tabName);
    ptr   = ptr + StrLen(ptr) + 1;
    (*cnt)++;
    *idxP = 0;                       // _~[f[^(̒lɂ͉lȂ)
    idxP++;

    // (gp)BBS^CgꗗƃCfbNX쐬
    for (lp = 0; lp < nofBBS; lp++)
    {
        (void) GetRecordReadOnly_NNsh(bbsRef, lp, &bdH, (void **) &tmpBd);
        if ((tmpBd->state & NNSH_BBSSTATE_VISIBLE) == NNSH_BBSSTATE_VISIBLE)
        {
            // ̂Rs[
            StrNCopy(ptr, tmpBd->boardName, LIMIT_BOARDNAME);
            ptr = ptr + StrLen(ptr) + 1;   // 1 '\0'̈ӖA(XgŎgp)
            (*cnt)++;
            *idxP = lp;
            idxP++;
        }
        ReleaseRecordReadOnly_NNsh(bbsRef, bdH);
    }
    NNshGlobal->useBBS = *cnt;
    MemHandleUnlock(NNshGlobal->boardIdxH);

    // "쐬"\̍폜
    Hide_BusyForm(false);

    // f[^x[X̃N[Y
    CloseDatabase_NNsh(bbsRef);
    return (ret);
}
