
////////////////////////////////////////////////
///// 電子カルテと接続するための API 
///// 　以下２つのメソッドを電子カルテにインプリすれば
///// 　電子カルテから電子処方箋を使えるようになる
////////////////////////////////////////////////

function getPrescription(value){
	// ### 標準 API：電子処方箋から受け取ったデータを表示 ###
	// JSON 形式の value を、電子カルテ固有の処方箋表示形式に変換して表示
	var obj = eval('(' + value + ')');
	document.getElementById("prsc").value = jsonToEMR(obj);
	
	function jsonToEMR(obj){
		// object をこの電子カルテの処方表示フォーマットへ変換
		var buff = "";
		for (key in obj){
			var val = obj[key];
			if (isSame(val.toString(), "[object Object]") > 0){
				// グループの中を処理
				buff +=  jsonToEMR(val);
			}
			else {
				// レコードの処理
				if (obj.code > 100) buff += "----- "; // 用法行の場合
				buff += obj.name + "(" + obj.dose + " " + obj.unit + ")\n";
				return buff;
			}
		}
		return buff;
	}
}

function putPrescription(){
	// ### 標準 API：電子処方箋を開き、処方データを渡す ###
	// 電子カルテからも以下と同様の呼び出しをすれば電子処方箋を使える
	// 電子カルテ固有の表示形式を以下の JSON 形式に変換して渡す
	var href = "./prescription.php?value='" + parameters() + "'";
	
	alert("--- 処方箋へ送付する URL ---\n"+href);//==
	
	// tools エリアに「電子処方箋」を開く
	window.open(href, "tools", "");
	
	function parameters(){
		// ### 標準 API：URL に付加するパラメータ（処方箋データ形式）###
		// ### 以下のような JSON 形式で出力する
		// 　頭につく "0.0": などは、それぞれのオブジェクトを識別するための
		// 　階層化された ID で、これを元に挿入・削除などの操作を行える。
		// 　約束処方も、このような形式で DB に記憶される。
		// 　　しかし ID は電子処方箋側の都合によるものなので、「電子カルテとの交換規格」
		// 　から、はずす予定。
		// "prescription":{
		//	"0":{
		//		"0.0":{"code":"0","name":"トランサミンカプセル 250mg","dose":"6","unit":"Cap"},
		//		"0.1":{"code":"121","name":"分3内服 ８時間毎","dose":"5","unit":"日分"}},
		//	"1":{
		//		"1.0":{"code":"0","name":"アデスタンクリーム 500mg","dose":"1","unit":"回分"},
		//		"1.1":{"code":"123","name":"外用","dose":"1","unit":"回分"}},
		//	"2":{
		//		"2.0":{"code":"0","name":"ニューロタン錠 50mg","dose":"1","unit":"Tab"},
		//		"2.1":{"code":"122","name":"屯用 就寝前","dose":"5","unit":"日分"}}
		// }
		
		var currentDate = document.getElementById("currentDate").innerHTML;
		var prescriptionObj = prescriptionObject();
		var buff = '{';
		buff += '"currentDate":"'+ currentDate +'",';
		buff += '"patientId":"'+document.getElementById("patientId").value+'",';
		buff += '"hospitalAddress":"'+document.getElementById("hospitalAddress").value+'",';
		buff += '"hospitalPhone":"'+document.getElementById("hospitalPhone").value+'",';
		buff += '"hospitalName":"'+document.getElementById("hospitalName").value+'",';
		buff += '"loginName":"'+document.getElementById("loginName").value+'",';
		buff += '"name":"'+document.getElementById("name").value+'",';
		buff += '"furigana":"'+document.getElementById("furigana").value+'",';
		buff += '"sex":"'+document.getElementById("sex").value+'",';
		buff += '"birthDay":"'+birthday()+'",';
		buff += '"shubetsu":"'+document.getElementById("shubetsu").value+'",';
		buff += '"family":"'+document.getElementById("family").value+'",';
		buff += '"paymentRatio":"'+document.getElementById("paymentRatio").value+'",';
		buff += '"hokenshaBangou":"'+document.getElementById("insNumber").value+'",';
		buff += '"kigou":"'+document.getElementById("mark").value+'",';
		buff += '"bangou":"'+document.getElementById("number").value+'",';
		buff += '"kouhiFutanBangou":"'+document.getElementById("publicNumber").value+'",';
		buff += '"jyukyuuBangou":"'+document.getElementById("recipientNumber").value+'",';
		buff += '"prescription":'+ json2string(prescriptionObj);
		buff += '}';
		
		return buff;
		
		function birthday(){
			var koyomi = document.getElementById("wareki").value;
			var yy = document.getElementById("year").value;
			var seirekiYear = seirekiWithWareki(koyomi, yy);
			var mm = document.getElementById("month").value;
			var dd = document.getElementById("day").value;
			return seirekiYear+"-"+mm+"-"+dd;
		}
	}
	
	function json2string(obj){
		// JSON オブジェクトを文字列にして返す
		var buff = '{';
		for (recNum in obj){
			var groupObj = obj[recNum];
			buff += '"'+recNum+'":{';
			var num = 0;
			for (code in groupObj){
				var po = groupObj[code];
				var recId = recNum+"."+num++;
				buff += '"'+recId+'":{';
				buff += '"code":"'+code+'",';
				buff += '"name":"'+po.name+'",';
				buff += '"dose":"'+po.dose+'",';
				buff += '"unit":"'+po.unit+'"},';
			}
			buff = buff.substr(0, buff.length - 1); // 末尾の余計な ',' を削除
			buff += '},';
		}
		buff = buff.substr(0, buff.length - 1); // 末尾の余計な ',' を削除
		buff += '}';
		return buff;
	}
	
	function prescriptionObject(){
		// 平文形式の処方を JSON 形式に encode して返す
		var buff = document.getElementById("prsc").value;
		var records = buff.split("\n");
		var gId, num, i, count = records.length;
		var prscObj = new Object();
		var groupObj = new Object();
		var code = "0"; // 用法種別を示すコード
		for (i=gId=num=0; i < count; i++){
			var ln = records[i];
			if (isSame(ln.substr(0,6),"----- ")){
				// ln: "----- 分3内服 ８時間毎(5 日分)" のような形式
				// これにより用法行であることを検知
				ln = ln.substr(6); // 文頭の "----- " を削除
				code = codeWithString(ln); // "121","122","123" いずれかを返す
			}
			else {
				// ln: "トランサミンカプセル 250mg(6 Cap)" のような形式 あるいは
				code = "" + num++; // (code < 100) で用法行ではない
			}
			
			// ln を解析して、名前、投与量、単位、を記憶したオブジェクト:obj を生成
			var array1 = ln.split("(");
			if (array1.length > 1){
				var obj = new Object();
				obj.name = array1[0];
				var ln2 = array1[1];
				var array2 = ln2.split(")");
				var ln3 = array2[0];
				var array3 = ln3.split(" ");
				obj.dose = array3[0];
				obj.unit = (array3.length > 1) ? array3[1] : "";
				groupObj[code] = obj;
			
				if (code * 1 > 100){
					var _gid = ""+gId++;
					prscObj[_gid] = groupObj;
					num = 0; // group 内のレコード id を初期化
					groupObj = new Object(); // 新しい groupObj を生成
				}
			}
		}
		return prscObj;
	}
}

///// 電子カルテと接続するための API ///////////////
////////////////////////////////////////////////


function codeWithString(ln){
	// ln: "----- 分3内服 ８時間毎(5 日分)" のような形式からコードを判別して返す
	if (ln.indexOf("内服", 0) >= 0)
		return "121";
	else if (ln.indexOf("内用", 0) >= 0)
		return "121";
	else if (ln.indexOf("頓", 0) >= 0)
		return "122";
	else if (ln.indexOf("屯", 0) >= 0)
		return "122";
	else if (ln.indexOf("外用", 0) >= 0)
		return "123";
	else
		return "0";
}

function timeStamp(){
	var date = new Date();
	var yy = date.getYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	var hr = date.getHours();
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	return yy + "-" + mm + "-" + dd;
}

function setDefaultValue(){
	// debug が楽になるよう dummy の default 値をセット
	document.getElementById("patientId").value = "03234200";
	document.getElementById("loginName").value = "薮井 竹庵";
	document.getElementById("hospitalName").value = "ほっとクリニック";
	document.getElementById("hospitalAddress").value = "東京都千代田区神田駿河台2-5";
	document.getElementById("hospitalPhone").value = "03-1111-2222";
	document.getElementById("name").value = "三船 敏郎";
	document.getElementById("furigana").value = "みふね としろう";
	document.getElementById("wareki").value = "大正";
	document.getElementById("year").value = "10";
	document.getElementById("month").value = "4";
	document.getElementById("day").value = "1";
	
	document.getElementById("insNumber").value = "01-23";
	document.getElementById("mark").value = "45";
	document.getElementById("number").value = "67";
	document.getElementById("publicNumber").value = "012345";
	document.getElementById("recipientNumber").value = "67890";
	document.getElementById("prsc").value = prescriptionData();
	
	function prescriptionData(){
		var array = new Array();
		array[0] = "アドナ 30mg(3 Tab)";
		array[1] = "トランサミンカプセル 250mg(6 Cap)";
		array[2] = "----- 分3内服 ８時間毎(5 日分)";
		array[3] = "ザジテン点眼薬(5 ml)";
		array[4] = "----- 外用(1 回分)";
		array[5] = "ロキソニン錠 60mg(1 Tab)";
		array[6] = "----- 屯用 疼痛時(5 日分)";
		return array.join("\n");
	}
}

function init(){
	var base = document.getElementById("base");
	
	var tbl = newTABLE(base, "rootTable");
	var tr = newTR(tbl, "bar", "");
	var td = newTD(tr, "", "「電子処方箋」起動用簡易インタフェース (input.php)");
	td.setAttribute("colspan", "2");

	var tr = newTR(tbl, "public", "処方年月日");
	var td = newTD(tr, "currentDate", timeStamp());
	
	var tr = newTR(tbl, "public", "カルテ番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "patientId", "", 30, "");
	
	var tr = newTR(tbl, "public", "医療機関住所");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalAddress", "", 30, "");
	
	var tr = newTR(tbl, "public", "医療機関電話番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalPhone", "", 30, "");
	
	var tr = newTR(tbl, "public", "医療機関名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "hospitalName", "", 30, "");
	
	var tr = newTR(tbl, "public", "処方医師名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "loginName", "", 30, "");
	
	var tr = newTR(tbl, "", "氏名");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "name", "", 30, "");

	var tr = newTR(tbl, "", "ふりがな");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "furigana", "", 30, "");
	var array = new Array("女","男");
	var pp = makePopupMenu(td, "sex", array, "男");
	
	var tr = newTR(tbl, "", "生年月日");
	var td = newTD(tr, "", "");
	var array = new Array("明治","大正","昭和","平成");
	var pp = makePopupMenu(td, "wareki", array, "昭和");
	var fd = newFIELD(td, "year", "", 4, "");
	var tx = newTEXT(td, "年");
	var fd = newFIELD(td, "month", "", 4, "");
	var tx = newTEXT(td, "月");
	var fd = newFIELD(td, "day", "", 4, "");
	var tx = newTEXT(td, "日");
	
	var tr = newTR(tbl, "", "保険種別");
	var td = newTD(tr, "", "");
	var array = new Array("国保","政府","組合","共済");
	var pp = makePopupMenu(td, "shubetsu", array, "国保");
	var array = new Array("本人","家族");
	var pp = makePopupMenu(td, "family", array, "家族");
	var array = new Array("0","1","2","3");
	var pp = makePopupMenu(td, "paymentRatio", array, "3");
	var tx = newTEXT(td, "割負担");

	var tr = newTR(tbl, "", "保険者番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "insNumber", "", 30, "");
	
	var tr = newTR(tbl, "", "記号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "mark", "", 30, "");
	
	var tr = newTR(tbl, "", "番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "number", "", 30, "");
	
	var tr = newTR(tbl, "public", "公費負担番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "publicNumber", "", 30, "");
	
	var tr = newTR(tbl, "public", "受給者番号");
	var td = newTD(tr, "", "");
	var fd = newFIELD(td, "recipientNumber", "", 30, "");
	
	var tr = newTR(tbl, "", "処方");
	var td = newTD(tr, "", "");
	var td = newTEXTAREA(td, "prsc", "50", "10", "");
	
	var tr = newTR(tbl, "footer", "Author: Katsuhiro OHASHI");
	var td = newTD(tr, "footerRight", "");
	var bt = newBUTTON(td, "", "debug 用 default 値をセット");
	bt.setAttribute("onclick", "setDefaultValue()");
	var bt = newBUTTON(td, "", "処方箋を開く");
	bt.setAttribute("onclick", "putPrescription()");
	
	var bk = newBR(base);
	
	var tbl = newTABLE(base, "messageTable");
	var tr = newTR(tbl, "", "prescription.php は、電子カルテから呼ばれることを想定しています");
	var tr = newTR(tbl, "", "そのため prescription.php は右側の小さなスペースで機能します");
	var tr = newTR(tbl, "", "決められた２つの API を使うだけで電子カルテから利用できます");
	var tr = newTR(tbl, "", "電子カルテの代わりに簡単なインタフェース input.php を作りました");
}
