
// ### 注意 ###
// ### prescription.js, usageEditor.jp, groupEditor.js でメソッド名が重複しないこと
// ###########

var _youhouType = 0; // Global 変数

///////////////////////////
/// Ajax による処理

function createXMLHttpRequest(func){
	var xmlHttpObject = null;
	
	if (window.XMLHttpRequest){ // Safari, Firefox
		xmlHttpObject = new XMLHttpRequest();
	} else if (window.ActieXObject){ // IE
		try{
			xmlHttpObject = new ActiveXObject("Msxml2.XMLHTTP"); // IE6
		} catch(e){
			try{
				xmlHttpObject = new ActiveXObject("Microsoft.XMLHTTP"); // IE5
			} catch(e){
				return null;
			}
		}
	}
	
	// xmlHttpObject が生成できたら、状態が変わった時に func が実行される
	if (xmlHttpObject) xmlHttpObject.onreadystatechange = func;
	return xmlHttpObject;
}

function clickedItem(item){
	document.getElementById("usageItem").value = item;
}

function loaded(){
	// HTTP 通信の状態が変化したら呼び出される関数
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert(value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			document.getElementById("usageList").innerHTML = usageList(ary[1]);
		}
	}
	else 
		document.getElementById("usageList").innerHTML = "Loading usageList ...";
	
	function usageList(buff){
		// 用法リストを HTML 形式にして返す
		var array = eval('(' + buff + ')');
		var results = new Array();
		var i, j, count = array.length;
		for (i=j=0; i < count; i++){
			var obj = array[i];
			if (obj.type == selectedType()){
				var item = obj.value;
				results[j++] = "<A HREF=# onclick=\"clickedItem('"+item+"')\">"+item+"</A>";
			}
		}
		return results.join("<BR/>");
	}
}
function load(){
	// 用法データすべてをリクエスト
	xmlHttpObject = createXMLHttpRequest(loaded);
	
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		//var type = selectedType();
		var st = "./priceListServer.php?command=GET_USAGE_LIST";
		xmlHttpObject.open("GET", st);
		xmlHttpObject.send(null);
	}
}

function saved(){
	// 用法の登録依頼に対するサーバからのレスポンスを処理
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			document.getElementById("message").innerHTML = ary[1];
			load();
		}
	}
	else 
		document.getElementById("message").innerHTML = "Saving usage...";
}
function save(item, freq){
	// 用法の登録依頼
	xmlHttpObject = createXMLHttpRequest(saved);
	if (xmlHttpObject){
		var st = "./priceListServer.php?command=PUT_USAGE"
		+ "&item="+item+"&freq="+freq+"&type="+selectedType();
		//alert(st);//==
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function removed(){
	// 用法の登録依頼に対するサーバからのレスポンスを処理
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			document.getElementById("message").innerHTML = ary[1];
			load();
		}
	}
	else 
		document.getElementById("message").innerHTML = "Removing usage ...";
}
function remove(){
	// 用法の削除依頼
	if (selectedType() == 0){
		alert("用法が選択されていません");
		return;
	}
	xmlHttpObject = createXMLHttpRequest(removed);
	if (xmlHttpObject){
		var type = selectedType();
		var item = document.getElementById("usageItem").value;
		if (item.length == 0)
			alert("削除対象が入力されていません");
		else {
			var st = "./priceListServer.php?command=REMOVE_USAGE"
			+ "&item="+item+"&type="+type;
			xmlHttpObject.open("GET", encodeURI(st), true);
			xmlHttpObject.send(null);
		}
	}
}

/// Ajax による処理
///////////////////////////


function setUsageSelectedType(type){
	// 用法 radio button の選択により popupMenu を作成表示
	_youhouType = type;
	load(); // type に該当するレコードを DB から読み込む
	document.getElementById("message").innerHTML = "";
}
function selectedType(){
	return _youhouType; // function名と定数名は異なること
}

function setSelector(){
	var td = document.getElementById("usageSelector");
	var pu = newPopupItem(td, "radio", "2", "内用");
	pu.setAttribute("onclick","setUsageSelectedType(21)");
	var pu = newPopupItem(td, "radio", "3", "屯用");
	pu.setAttribute("onclick","setUsageSelectedType(22)");
	var pu = newPopupItem(td, "radio", "4", "外用");
	pu.setAttribute("onclick","setUsageSelectedType(23)");
}

function closeUsageEditor(){
	document.getElementById("editorArea").innerHTML = "";
}

function ok(){
	// 確定ボタンのクリックで呼ばれる
	if (selectedType() == 0){
		alert("用法が選択されていません");
		return;
	}
	
	var item = document.getElementById("usageItem").value;
	if (item.length == 0){
		alert("用法が入力されていません");
		return;
	}
	
	var freq = 1;
	save(item, freq);
}

function showUsageEditor(){
	var elm = document.getElementById("editorArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "editorTable");
	
	// header
	var tr = newTR(tbl, "usageHeader", "");
	var td = newTD(tr, "editorIcon", "");
	var im = newIMAGE(td,"icon","./close.png","close");
	im.setAttribute("onclick", "closeUsageEditor()");
	var td = newTD(tr, "editorLabel", "用法編集");

	// ラジオボタン表示エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "usageSelector", "");
	td.setAttribute("colspan", "2");

	// ラベル編集エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "inputArea", "");
	td.setAttribute("colspan", "2");
	var fd = newFIELD(td, "usageItem", "", 20, "");
	fd.setAttribute("onchange","ok()");
	var bt = newBUTTON(td, "", "削除");
	bt.setAttribute("onclick", "remove()");
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "ok()");

	// 用法表示エリア
	var tr = newTR(tbl, "usageListArea", "");
	var td = newTD(tr, "usageList", "");
	td.setAttribute("colspan", "2");
	
	document.getElementById("message").innerHTML = "";
	setSelector();
}



