
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** chartFinder.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

///// カルテからの継承値 ///
/////////////////////////


/////////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////////

var _patientId;
var _currentY;
function gotLimittedVisitor(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
        _debug(value); //##
        //document.getElementById("_debug").innerHTML = value; // for debug
        
        var obj;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            obj = JSON.parse(array[1]);
        }
        showResults(obj);
        
        hideMessage("_message");
	} else
		showMessage("_message", "Loading records ...");
}
function getConditionalPatient(from, to){
    // yyyy/mm/dd 以後受診していないカルテを検索
	xmlHttpObject = createXMLHttpRequest(gotLimittedVisitor);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["fromDate"] = from;
		array["toDate"] = to;
		
        document.getElementById("dataArea").innerHTML = "　検索中：しばらくお待ちください";
        
		var st = "./server.php?command=GET_CONDITIONAL_PATIENT"
		+ "&value=" + encodeObject(array);
		
        _initDebug(false); //##
        _debug(st); //##
        //document.getElementById("_debug").innerHTML = st; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///// Ajax //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////


function showResults(obj){
    // 検索結果を表示
    if (obj == null){
        document.getElementById("dataArea").innerHTML = "　該当するものはありません";
    } else {
        var elm = document.getElementById("dataArea");
        elm.innerHTML = "";
        
        //alert(encodeObject(obj)); //##
        
        var tbl = newTABLE(elm, "base-table");
        tbl.style.fontSize = "9pt";
        
        var tr = newTR(tbl, "", "");
        tr.style.background = "#eee";
        var td = newTD(tr, "", "カルテID 氏名");
        td.style.paddingLeft = "5px";
        td.style.width = "100px";
        var td = newTD(tr, "", "最終受診日");
        
        var count = 0;
        for (patientId in obj){
            var rec = obj[patientId];
            var tr = newTR(tbl, "", "");
            var action = "noa().openChart('"+patientId+"','"+rec.name+"')";
            tr.setAttribute("onclick", action);
            setChangeColor(tr, '#000', '#fff');
            var td = newTD(tr, "", patientId + " " + rec.name);
            td.style.paddingLeft = "5px";
            var td = newTD(tr, "", rec.lvd);
            count++;
        }
        
        var tr = newTR(tbl, "", "");
        tr.style.background = "#eee";
        var td = newTD(tr, "", "該当件数");
        td.style.paddingLeft = "5px";
        var td = newTD(tr, "", count + " 件");
    }
}

function search(){
    // 指定された年月日以後受診していないカルテを検索
    var from = "";
    var val = document.getElementById("fromPop").value;
    var array = val.split("-");
    if (array.length == 3){
        from = val + " 00:00:00";
    }

    var to = "";
    var val = document.getElementById("toPop").value;
    var array = val.split("-");
    if (array.length == 3){
        to = val + " 23:59:59";
    }
    
    if (!from && !to){
        alert("年月日が指定されていません");
    } else {
        if (from == "")
            from = "0000-00-00 00:00:00";
        if (to == "")
            to = todayAndTime();
        getConditionalPatient(from, to);
    }
}

function initLvdSearcher(){
	var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
	
	// === HEADER =======================
    var div = newDIV(elm, "");
    var dv = newDIV(div, "tool-header");
    dv.innerHTML = "最終受診日検索";
    dv.style.fontSize = "12px";
    dv.style.paddingLeft = "10px";

    // === CONTENTS ======================
    var div = newDIV(elm, "");
    div.style.padding = "5px 10px";
    // from popup
    makeTodayPop(div, "fromPop", "から");
    
    // to popup
    makeTodayPop(div, "toPop", "まで");

    // button
    var dv = newDIV(div, "");
    dv.style.fontSize = "10pt";
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "の期間が最終受診日のカルテを";
    var bt = newBUTTON(sp, "", "リストアップ");
    bt.setAttribute("onclick", "search()");

    // === FWORK AREA ===================
    var div = newDIV(elm, "dataArea");

	// === FOOTER ===================
    var div = newDIV(elm, "");
	var tbl = newTABLE(div, "base-table");
	var tr = newTR(tbl, "tool-footer", "");
	var td = newTD(tr, "left-side", version());
	var td = newTD(tr, "", "");
    
    function makeTodayPop(elm, id, label){
        // 年月日ポップアップを生成
        var div = newDIV(elm, "");
        div.style.paddingBottom = "2px";
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
        var array = today().split("-");
        var yyyy = array[0] * 1;
        var mm = array[1] * 1;
        var dd = array[2] * 1;
        var pm = newDatePopUp(sp, id, "平成", yyyy, mm, dd, false, null);
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
        sp.innerHTML = label;
    }
}

function version(){
	return "Ver.120820";
}
