
<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function timestamp(){
        // 現在のタイムスタンプを返す updateTime に使う
        return date("Y-m-d H:i:s",time());
    }
	
	
    ///////////////////////////////////////
    ///// レコードの文字列化はここで管理     ///
    ///// vin.php 側では newItem() で管理 ///
    
    function decodeItem($st){
        $array = explode("_|_", $st);
        $array['isOwn'] = $array[0];
        $array['code'] = $array[1];
        $array['alias'] = $array[2];
        $array['name'] = $array[3];
        $array['standard'] = $array[4];
        $array['unitName'] = $array[5];
        $array['freq'] = $array[6];
        $array['point'] = $array[7];
        $array['isMix'] = $array[8];
        return $array;
    }
    
    function encodeItem($isOwn, $code, $alias, $name, 
                        $standard, $unitName, $freq, $point, $isMix){
        $array[0] = $isOwn;
        $array[1] = $code;
        $array[2] = $alias;
        $array[3] = $name;
        $array[4] = $standard;
        $array[5] = $unitName;
        $array[6] = $freq;
        $array[7] = $point;
        $array[8] = $isMix;
        return join("_|_", $array);
    }
	
    function decdeArgs($args){
        $array = explode("_|_", $args);
        $array['owner'] = $array[0];
        $array['patientId'] = $array[1];
        $array['currentDate'] = $array[2];
        $array['ageOfTheMoon'] = $array[3];
        $array['timeZone'] = $array[4];
        return $array;
    }
    
    ///// レコードの文字列化はここで管理 ///
    ///////////////////////////////////
    
    
    /////////////////////////
    ///// header 関連 ////////
    
    function getHospitalInfo($hospitalId, $key){
        // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
        $query = "SELECT `key`,`value` FROM `HospitalTable` WHERE `hospitalId`='$hospitalId' AND `key`='$key'";
        $result=mysql_query($query);
        
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            return $row['value'];
        }
        return "";
    }
    
    function hospitalId($owner){
        // $owner の所属する医療機関の hospitalId を返す
        $query = "SELECT `hospitalId` FROM `UserTable`
		WHERE `loginName`='$owner'";
        $result=mysql_query($query);
        
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            return $row['hospitalId'];
        }
        return "";
    }
    
    function hospitalInfo($owner){
        $hid = hospitalId($owner);
        $array['round'] = getHospitalInfo($hid, "まるめ係数");
        $array['ownRate'] = getHospitalInfo($hid, "自費係数");
        return join("_|_", $array);
    }
	
    function codeName($code){
        switch ($code){
            case 11: return "初診";
            case 12: return "再診";
            case 13: return "診他";
            case 21: return "内服";
            case 22: return "屯服";
            case 23: return "外用";
            case 29: return "薬加";
            case 31: return "皮注";
            case 32: return "静注";
            case 33: return "点滴";
            case 41: return "処置";
            case 48: return "処薬";
            case 51: return "手術";
            case 52: return "麻酔";
            case 58: return "手薬";
            case 60: return "検査";
            case 69: return "判断";
            case 70: return "画像";
            case 80: return "其他";
            case 90: return "入院";
            case 91: return "入他";
            default: return "";
        }
    }
    function codeName2code($codeName){
        if ($codeName == "初診") return 11;
        else if ($codeName == "再診") return 12;
        else if ($codeName == "診他") return 13;
        else if ($codeName == "内服") return 21;
        else if ($codeName == "屯服") return 22;
        else if ($codeName == "外用") return 23;
        else if ($codeName == "薬加") return 29;
        else if ($codeName == "皮注") return 31;
        else if ($codeName == "静注") return 32;
        else if ($codeName == "点滴") return 33;
        else if ($codeName == "処置") return 41;
        else if ($codeName == "処薬") return 48;
        else if ($codeName == "手術") return 51;
        else if ($codeName == "麻酔") return 52;
        else if ($codeName == "手薬") return 58;
        else if ($codeName == "検査") return 60;
        else if ($codeName == "判断") return 69;
        else if ($codeName == "画像") return 70;
        else if ($codeName == "其他") return 80;
        else if ($codeName == "入院") return 90;
        else if ($codeName == "入他") return 91;
        else if ($codeName == "合計") return 99;
        else return 0;
    }
	
    function encodeRecords($records){
        // 1_|_12_|_alias_|_name_|_dose_|_unitName_|_freq_|_point
        // を "codeName[name(dose unitName)] point*freq 自費" に変換して返す
        $count = count($records);
        $results = array();
        for ($i=0; $i < $count; $i++){
            $rec = trim($records[$i]);
            if (strlen($rec) == 0) continue;
            $array = decodeItem($rec);
            $codename = codeName($array['code']);
            
            $name = $array['name'];
            $dose = ($array['standard'] * 1 > 0) ? $array['standard'] : 1;
            $unitName = $array['unitName'];
            $freq = $array['freq'] * 1;
            $isOwn = ($array['isOwn'] * 1 > 0) ? " 自費" : "";
            $unit = (($array['code'] != "60") && (strlen($unitName) > 0))
			? "($dose $unitName)" : "";
            if ($array['code'] == "99")
                $results[] = $name;
            else {
                $point = $array['point'];
                $mix = ($array['isMix'] * 1 > 0) ? " 混注" : "";
                if ($freq > 1)
                    $results[] = "$codename\[$name$unit$mix\] $point x $freq $isOwn";
                else
                    $results[] = "$codename\[$name$unit$mix\] $point $isOwn";
            }
        }
        return $results;
    }
	
    function sortRecords($records){
        // $rocords をソートする
        sort($records, SORT_STRING);
        return $records;
    }
    
    function decodeRecords($buff){
        // codeName[name(dose unitName)] point x freq isOwnFee 形式を
        // 1_|_12_|_alias_|_産科健診料_|_dose_|_unitName_|_freq_|_point_|_isMix 形式へ変換し返す
        
        $results = array();
        $records = explode("\n", $buff);
        $count = count($records);
        for ($i=0; $i < $count; $i++){
            $rec = trim($records[$i]);
            if (strlen($rec) == 0) continue;
            
            // get CODE
            $ary = explode("[", $rec, 2);
            $code = codeName2code($ary[0]);
            
            // コードが13 または コード末尾が９ の自動付加項目はスキップ
            if (($code % 10) == 9) continue;
            if (($code * 1) == 13) continue;
            if (($code * 1) == 0) continue;
            
            // get NAME, DOSE, UNITNAME
            $st = $ary[1];
            $ary = explode("]", $st, 2);
            $name_unit_mix = $ary[0]; // "ピドキサール注１０ｍｇ(1 管) 混注"
            $pointAndOwnFee = trim($ary[1]);
            $ary = explode("(", $name_unit_mix, 2);
            $isMix = "";
            if (count($ary) > 1){
                $name = $ary[0]; // "ピドキサール注１０ｍｇ"
                $dose_unit_mix = $ary[1]; // "1 管) 混注"
                $ary = explode(" ", $dose_unit_mix, 2);
                if (count($ary) > 1){
                    $dose = $ary[0]; // "1"
                    $ary = explode(")", $ary[1], 2);
                    $unitName = $ary[0]; // "管"
                    $mixSt = trim($ary[1]); // "混注"
                    $isMix = (strcmp($mixSt, "混注") == 0) ? "1" : "0";
                }
            }
            else {
                $name = $name_unit_mix;
                $dose = "";
                $unitName = "";
            }
            
            // get ISOWNFEE from "210 x 7 自費"
            $pos = strpos($pointAndOwnFee, "自費");
            if ((strcmp($pointAndOwnFee, "自費") == 0) || ($pos > 0)){
                $isOwnFee = "1";
                $pointAndFreq = trim(substr($pointAndOwnFee, 0, $pos));
            } else {
                $isOwnFee = "0";
                $pointAndFreq = $pointAndOwnFee;
            }
            
            // get POINT, FREQ from "210 x 7"
            $array = explode("x", $pointAndFreq);
            if (count($array) > 1){
                $pont = trim($array[0]);
                $freq = trim($array[1]);
            } else {
                $pont = trim($array[0]);
                $freq = "1";
            }
            
            // 1_|_12_|_alias_|_産科健診料_|_dose_|_unitName_|_freq_|_point_|_isMix 形式にする
            $array = array();
            if ($code == 99){
                $array[] = "";
                $array[] = $code;
                $array[] = "";
                $array[] = $rec;
                $array[] = "";
                $array[] = "";
                $array[] = "";
                $array[] = "";
                $array[] = "";
            } else {
                $array[] = $isOwnFee;
                $array[] = $code;
                $array[] = "";
                $array[] = $name;
                $array[] = $dose;
                $array[] = $unitName;
                $array[] = $freq;
                $array[] = $pont;
                $array[] = $isMix;
            }
            
            $results[] = join("_|_", $array);
        }
        
        // 混注以外のものをソート
        $results = sortRecords($results);
        return join("\n", $results);
    }
	
    function putTimeStamp(){
        // データ更新のタイムスタンプを記憶
        $timestamp = date("Y-m-d H:i:s",time());
        $sql = "SELECT `rowid` FROM `FrontTable` WHERE `patientId`='STAMP'";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){	// STAMP が存在した
            $row=mysql_fetch_array($result);
            $sql = "UPDATE `FrontTable` SET 
			`updateTime`='$timestamp'
			WHERE `patientId`='STAMP'";
        } else {							// STAMP が存在しなかった
            $sql = "INSERT INTO `FrontTable` (`patientId`, `updateTime` )
			VALUES ('STAMP', '$timestamp')";
        }
        mysql_query($sql);
    }
    
    function save($patientId, $currentDate, $records){
        // records をサーバへ書き戻す
        if ($records){
            $records = encodeRecords($records); // ここを削除すると "_|_" 形式のまま保存
            $st = (count($records) > 0) ? join("\n", $records) : " ";
        } else {
            $st = "";
        }
        
        // カルテへの書き込み
        $sql = "UPDATE `ProgressSection` 
		SET `treatment`='$st', `updateTime`='".date("Y-m-d H:i:s",time()).
		"' WHERE `patientId`='$patientId' AND `entryDate`='$currentDate'";
        mysql_query($sql);
        putTimeStamp();
    }
	
    function getGroupCode($patientId, $max){
        // 当日の保険種別を調べて返す
        $sql = "SELECT * FROM `HealthInsurance`
        WHERE `patientId`='$patientId' AND `entryDate`<='$max'
        ORDER BY `entryDate` DESC";
        $result=mysql_query($sql);
        while ($row = mysql_fetch_array($result)){
            //echo "--- ".$row['shubetsu'].":".$row['kubun']."\n"; //###
            
            if (strcmp($row['shubetsu'], "ko") == 0)
                return 2;
            else if (strcmp($row['shubetsu'], "国保") == 0)
                return 2;
            else if (strcmp($row['kubun'], "S") == 0)
                return 0;
            else if (strcmp($row['kubun'], "本人") == 0)
                return 0;
            else if (strcmp($row['kubun'], "F") == 0)
                return 1;
            else if (strcmp($row['kubun'], "家族") == 0)
                return 1;
        }
        return 0;
    }
	
    function updateFront($patientId, $date, $owner, $isNew, $isIn, 
                         $point, $insFee, $ownFee){
        // 会計レコードを更新
        // 新患(初診料の有無)・健保料金・自費料金・診療終了時刻・updateTime・計画 を記録
        $min = substr($date, 0, 10)." 00:00:00";
        $max = substr($date, 0, 10)." 23:59:59";
        // 当日の保険種別を調べる
        $groupCode = getGroupCode($patientId, $max);
        
        $sql = "SELECT `rowid` FROM `FrontTable`
        WHERE `entryDate`<='$max' AND `entryDate`>='$min'";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){	// 同じ受診者が当日複数回存在した：同日再診
            $sql = "UPDATE `FrontTable` SET 
            `groupCode`='$groupCode',
            `inOut`='$isIn',
            `newPatient`='$isNew',
            `point`='$point',
            `insFee`='$insFee',
            `ownFee`='$ownFee',
            `owner`='$owner',
            `endTime`='".date("Y-m-d H:i:s",time())."',
            `updateTime`='".date("Y-m-d H:i:s",time())."'
            WHERE `patientId`='$patientId' AND
            `entryDate`<='$max' AND `entryDate`>='$min' ";
            echo "\n$sql\n";//##
            mysql_query($sql);
        }
    }
	
    function load($patientId, $currentDate){
        // カルテの treatment フィールドのデータを読み出す
        // # freq が 1 のレコードは削除されたレコード
        $query = "SELECT `treatment` FROM `ProgressSection` 
        WHERE `patientId`='$patientId' AND `entryDate`<='$currentDate'
        AND (`freq` IS NULL OR `freq`<1)
        ORDER BY `entryDate` DESC"; 
        $result=mysql_query($query);
        //	echo "\nload($query)===========\n";//####
        
        while ($row=mysql_fetch_array($result)){
            $buff = $row['treatment'];
            if (strlen($buff) > 0){
                // 直近の ProgressSection.treatment データを読み出して返す
                // コード末尾が９の自動加算項目は省略される
                echo "\nload($buff)===========\n";//####
                return decodeRecords($buff);
            }
        }
        return "";
    }
	
    function countCheck($patientId, $currentDate, $codeName){
        // $codeName:"特定疾患療養指導料" の存在する回数を返す
        $monthBegin = substr($currentDate, 0, 8)."01 00:00:00";
        $query = "SELECT `treatment` FROM `ProgressSection` "
        ."WHERE `patientId`='$patientId' "
        ."AND `entryDate`>'$monthBegin' AND `entryDate`<'$currentDate' "
        ."ORDER BY `entryDate` DESC"; 
        $result=mysql_query($query);
        echo "\n countCheck($query)===========\n";//####
        $count = 0;
        while ($row=mysql_fetch_array($result)){
            // treatment 中に $codeName が存在すればカウントをインクリメント
            if (strpos($row['treatment'], $codeName) > 0)
                $count++;
        }
        echo "\n countCheck($count)===========\n";//####
        return $count;
    }
	
    function isTokuteiShikkan($treatments){
        // 特定疾患指導料を算定できる傷病名であれば TRUE を返す
        // ## 決め打ち ## 
        $diseases = array("高血圧","胃炎","糖尿病","不整脈","喘息");
        for ($i=0,$ct=count($diseases); $i < $ct; $i++){
            if (strpos($treatments, $diseases[$i]) > 0){
                echo "\n isTokuteiShikkan(".$diseases[$i].")===========\n";//####
                return TRUE;
            }
        }	
        return FALSE;
    }
    
    function hasGeneric($patientId, $currentDate){
        // 処方箋に一般名（一般名は薬剤行頭に' '）が存在すれば TRUE を返す
        // カルテの prescription フィールドに一般名の薬剤があれば TRUE を返す
        // # freq が 1 のレコードは削除されたレコード
        $query = "SELECT `prescription` FROM `ProgressSection` 
        WHERE `patientId`='$patientId' AND `entryDate`<='$currentDate'
        AND (`freq` IS NULL OR `freq`<1)
        ORDER BY `entryDate` DESC"; 
        $result=mysql_query($query);
        //	echo "\nload($query)===========\n";//####
        
        while ($row=mysql_fetch_array($result)){
            $buff = $row['prescription'];
            if (strlen($buff) > 0){
                // 直近の ProgressSection.prescription データを読み出し
                // 各行先頭の * の有無をチェック
                $ary = explode("\n", $buff);
                $ct = count($ary);
                for ($i=0; $i < $ct; $i++){
                    $ch = substr($ary[$i], 0, 1);
                    // 行頭に ' ' があれば一般名薬剤と判定
                    if (strcmp($ch, " ") == 0) return TRUE;
                }
                return fALSE;
            }
        }
        return fALSE;
    }
    
    function tokuteiByoumeiList($patientId, $currentDate){
        // 特定疾患名が存在すれば、$currentDate における傷病名配列を返す
        $diseases = array();
        $monthEnd = substr($currentDate, 0, 10)." 23:59:59";
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='$patientId' 
        AND `entryDate`<'$monthEnd'
        ORDER BY `entryDate` DESC"; 
        $result = mysql_query($sql);
        while ($row = mysql_fetch_array($result)){
            if (! $row['disease'] || (strlen($row['disease']) == 0)) continue;
            $array = explode("\n", $row['disease']);
            for ($i=0,$ct=count($array); $i < $ct; $i++){
                $st = $array[$i];
                if (isTokuteiShikkan($st)) // 傷病名に特定疾患名が含まれる
                    $diseases[] = $st;
            }
            return $diseases;
        }
        return $diseases;
    }
    function monthsBetween($date1, $date2){
        // $date1 から $date2 までの経過月数を返す
        // $date1:"081201" 形式
        $yy1 = substr($date1, 0, 2);
        $mm1 = substr($date1, 2, 2);
        $dd1 = substr($date1, 4, 2);
        // $date2:"2009-01-12 11:19:37" 形式
        $yy2 = substr($date2, 2, 2);
        $mm2 = substr($date2, 5, 2);
        $dd2 = substr($date2, 8, 2);
        
        $diffMonth = (($yy2 - $yy1) * 12) + $mm2 - $mm1;
        if ($dd1 > $dd2) // 前月の日付より小さい日付
            $diffMonth -= 1;
        
        return $diffMonth;
    }
    function hasShohou($records){
        // 処方の有無を返す
        for ($i=0,$ct=count($records); $i < $ct; $i++){
            $array = explode("_|_", $records[$i]);
            $cd = $array[1];
            $name = $array[3];
            if (($cd * 1 == 80) && (strpos($name, "処方") > 0)){
                return TRUE;
            }
        }
        return FALSE;
    }
    function tokuteiShikanCheck($hasIns, $records, $pid, $cdate, $owner){
        // 特定疾患指導料・特定疾患処方管理加算 を加算
        $results = array();
        if ($hasIns == 0)
            return $results; // 健保項目がなかったので抜ける
        
        // $cdate の傷病名に含まれる特定疾患名リストを取得
        $diseases = tokuteiByoumeiList($pid, $cdate);
        if (count($diseases) > 0){
            // ## 決め打ち ## 特定疾患療養指導料は月２回まで算定できる
            if (countCheck($pid, $cdate, "特定疾患療養指導料") < 2){
                for ($i=0,$ct=count($diseases); $i < $ct; $i++){
                    $st = $diseases[$i]; // $st:"080811 高血圧"
                    $ary = explode(" ", $st);
                    if (count($ary) > 1){
                        // 日付が限定された月数を越えているかどうかチェック
                        $date = $ary[0];
                        if (monthsBetween($date, $cdate) >= 1){
                            // ## 決め打ち ## 初診日から１ヶ月経過していれば算定できる
                            $alias = "tokuteishikkanryouyoushidouryou";
                            $results[] = getRecord(0, "13", $alias, $owner);
                            break;
                        }
                    }
                }
            } 
            if (hasShohou($records)){
                // ## 決め打ち ##
                if (countCheck($pid, $cdate, "特定疾患処方管理加算28日以上") <= 2){
                    //if (countCheck($pid, $cdate, "特定疾患処方管理加算") <= 2){
                    //$alias = "tokutei-shohou-kanri";
                    $alias = "tokutei-shohou-kanri-28";
                    $results[] = getRecord(0, "13", $alias, $owner);
                }
            }
        }
        return $results;
    }
    
    ///// header 関連 /////
    /////////////////////////
    
    /////////////////////////
    ///// childSelector /////
    
    function showItemSelector($selectorNum){
        // 診療行為のリストを返す（薬剤、処置名、など）
        echo "<SEPARATOR>";
        $array = array();
        if ($selectorNum * 1 == 0){ // 一括入力メニュー
            $query = "SELECT * FROM `ProgressSection` WHERE `patientId`='GroupMenu' ORDER BY `freq`";
            $result=mysql_query($query);
            
            while ($row=mysql_fetch_array($result)){
                $subject = $row['subject'];
                $array["$subject"] = $subject;
            }
        } else {
            $query = "SELECT `code`,`alias`,`name` FROM `PriceList` WHERE `code`like'%$selectorNum%' and `code` < 100 ORDER BY `alias";
            $result=mysql_query($query);
            
            while ($row=mysql_fetch_array($result)){
                $name = $row['name'];
                $alias = $row['alias'];
                $array["$name"] = $alias;
            }
        }
        echo json_encode($array);
    }
    
    ///// childSelector /////
    /////////////////////////
    
    /////////////////////////
    ///// データベースから個々のアイテムをピックアップ
    
    function getPoint($code, $alias){
        // code, alias に相当するレコードの点数を返す
        $query = "SELECT `point` FROM `PriceList` 
		WHERE `code`='$code' and `alias`='$alias'";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            $point = $row['point'];
        }
        
        return $point;
    }
    
    function ownRate($owner){
        $hid = hospitalId($owner);
        return getHospitalInfo($hid, "自費係数");
    }
	
    function handanRecord($isOwn, $handan, $ownRate){
        // 判断料のレコードを返す
        if (strcmp($handan, "病") == 0)
            $alias = "byouri-handan";
        else if (strcmp($handan, "尿") == 0)
            $alias = "nyou-handan";
        else if (strcmp($handan, "血") == 0)
            $alias = "ketsueki-handan";
        else if (strcmp($handan, "生1") == 0)
            $alias = "seika1-handan";
        else if (strcmp($handan, "生2") == 0)
            $alias = "seika2-handan";
        else if (strcmp($handan, "免") == 0)
            $alias = "menneki-handan";
        else if (strcmp($handan, "微") == 0)
            $alias = "biseibutsu-handan";
        else if (strcmp($handan, "外") == 0) // 超音波
            $alias = "";
		
        $query = "SELECT `name`, `point` FROM `PriceList` 
		WHERE `code`='**69' and `alias`='$alias'";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            $point = ($isOwn * 1 > 0) ?  $row['point'] * $ownRate : $row['point'];
            return encodeItem($isOwn, "69", $alias, $row['name'], "", "", "", $point,"");
        }
        return "";
    }
    
    function getRecord($isOwn, $code, $alias, $owner){
        // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
        $query = "SELECT `code`,`alias`,`name`,`standard`,`unitName`,`point` 
		FROM `PriceList`
		WHERE `code`like'%$code%' and `alias`='$alias'
		ORDER BY `alias`";
        $result=mysql_query($query);
        
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            
            // $row['code'] は "21,23" のような複合形式なので $code を使う
            return encodeItem($isOwn, $code, $row['alias'], $row['name']
                              , $row['standard'], $row['unitName'], "1", $row['point'],"");
        }
        return "";
    }
	
    function getTeigenRecord($isOwn, $point, $code, $alias){
        // 該当する診療行為の点数に低減率を掛けたものを作成して返す
        $query = "SELECT * FROM `PriceList`
        WHERE `code` LIKE '%$code%' AND `alias`='$alias'";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            $row = mysql_fetch_array($result);
            $point = (-1 * $point / 100) * $row['point'];
            
            // isMix を使う可能性はないと思われるので isMix は ""
            return encodeItem($isOwn,$code,$alias,$row['name']
                              ,"","","1",$point,"");
        }
        return "";
    }
	
    function echoCountOfThisMonth($patientId, $currentDate){
        // 今月実施した超音波検査の回数を返す（本日を含まず）
        $yyyymm = substr($currentDate,0,7);
        $begin = date($yyyymm."-01 00:00:00");
        $yyyymmdd = substr($currentDate,0,10);
        $end = date($yyyymmdd." 00:00:00"); // 本日を含まず
        
        // freq が 0 以外のレコードは編集前のレコードなので無視
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='$patientId' 
        AND (`freq` IS NULL OR `freq`<1)
        AND `entryDate`>='$begin' 
        AND `entryDate`<='$end'";
        echo "$sql ---\n\n"; //##
        $result = mysql_query($sql);
        
        $count = 0;
        while ($row = mysql_fetch_array($result)){
            $date = $row['entryDate'];
            $update = $row['updateTime'];
            $treatment = $row['treatment'];
            $ary = explode("\n", $treatment);
            for ($i=0,$ct=count($ary); $i < $ct; $i++){
                $st = $ary[$i];
                if (strpos($st, "超音波") !== FALSE){
                    if (strpos($st, "自費") > 0) continue; // 自費は除く
                    echo "$date($update) $treatment ---\n\n"; //##
                    $count++;
                }
            }
        }
        return $count;
    }
	
    function getPointWithCodeAndName($code, $name){
        // 該当する診療行為（薬剤、処置名、など）の点数を DB から取り出して返す
        $sql = "SELECT `point` FROM `PriceList`
        WHERE `code`like'%$code%' and `name`='$name'
        ORDER BY `alias`";
        echo "getPointWithCodeAndName --\n $sql \n"; //##
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            
            // $row['code'] は "21,23" のような複合形式なので $code を使う
            return $row['point'];
        }
        return "";
    }
    
    function paymentRatio($patientId){
        // 保険の負担割合
        $query = "SELECT `paymentRatio` FROM `HealthInsurance`
		WHERE `patientId`='$patientId'
		ORDER BY `entryDate` DESC";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            while ($row=mysql_fetch_array($result)){
                if ($row['paymentRatio'] <> null) return  $row['paymentRatio'];
            }
        }
        return 10;
    }
    
    function discountRatio($patientId){
        // 割引率を返す
        $query = "SELECT `discountRatio` FROM `HealthInsurance`
        WHERE `patientId`='$patientId'
        ORDER BY `entryDate` DESC";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            while ($row=mysql_fetch_array($result)){
                if ($row['discountRatio'] <> null) return  $row['discountRatio'];
            }
        }
        return 0;
    }
    
    ///// データベースから個々のアイテムをピックアップ
    /////////////////////////
    
    /////////////////////////
    ///// 集計機能 ///////////
    
    function changeCode($isOwn, $st, $newCode){
        // code を $newCode に付け替える
        $array = decodeItem($st);
        return encodeItem($isOwn, $newCode, $array['alias'], $array['name']
						  , $array['standard'], $array['unitName']
						  , $array['freq'], $array['point'], $array['isMix']);
    }
	
    function hasShosin($records){
        // $records に初診があれば 1 なければ 0 を返す
        $count = count($records);
        for ($i=0; $i < $count; $i++){
            $st = trim($records[$i]);
            $array = decodeItem($st);
            if ($array['code'] != "11") continue;
            //echo "-- ".$array['name']."\n"; //###
            if (strpos($array['name'], "初診") >= 0) return 1;
        }
        return 0;
    }
    
    function hasNyuuin($records){
        // $records に入院があれば 1 なければ 0 を返す
        $count = count($records);
        for ($i=0; $i < $count; $i++){
            $st = trim($records[$i]);
            $array = decodeItem($st);
            if ($array['code'] != "90") continue;
            //echo "-- ".$array['name']."\n"; //###
            if (strpos($array['name'], "入院") >= 0) return "on";
        }
        return "";
    }
    
    function saishinCheck($hasIns, $records, $currentDate, $timeZone, $owner){
        // 健保の場合のみ機能する
        // 健保項目がなかったので抜ける
        if ($hasIns == 0) return null;
        
        // 初診または入院がなければ再診を自動付加
        // 初診も処置もなければ外来管理加算を自動付加
        $count = count($records);
        $hasShochi = 0;
        $hasOpe = 0;
        $hasSaishin = 0;
        for ($i=0; $i < $count; $i++){
            $st = trim($records[$i]);
            $array = decodeItem($st);
            if ($array['code'] == "41") $hasShochi = 1;
            if ($array['code'] == "51") $hasOpe = 1;
            if ($array['code'] == "11"){
                if (strpos($array['name'], "初診") >= 0){
                    // 診療時間外なら所定加算を追加する
                    if (strcmp($timeZone, "時間外") == 0)
                        $items[] = getRecord($isOwn, "13", "shoshin-jikangai", $owner);
                    else if (strcmp($timeZone, "深夜") == 0)
                        $items[] = getRecord($isOwn, "13", "shoshin-shinya", $owner);
                    else if (strcmp($timeZone, "休日") == 0)
                        $items[] = getRecord($isOwn, "13", "shoshin-kyuujitsu", $owner);
                    return $items; // 初診があったので抜ける
                }
            } else if ($array['code'] == "12"){
                if (strpos($array['name'], "電話等再診") !== FALSE){
                    $hasSaishin = 1;
                    $hasShochi = 1; // 外来管理加算を抑止するため
                } else if (strpos($array['name'], "再診") !== FALSE){
                    $hasSaishin = 1;
                }
            } else if ($array['code'] == "90"){
                return null; // 入院があったので抜ける
            }
        }
        
        $isOwn = ($hasiIns > 0) ? "1" : "0";
        
        // 再診がなかったので再診を追加する
        if ($hasSaishin == 0){
            $items[] = getRecord($isOwn, "12", "saishin", $owner);
        }
        
        // 診療時間外なら所定加算を追加する
        if (strcmp($timeZone, "時間外") == 0)
            $items[] = getRecord($isOwn, "13", "jikangai-kasan", $owner);
        else if (strcmp($timeZone, "深夜") == 0)
            $items[] = getRecord($isOwn, "13", "shinnya-kasan", $owner);
        else if (strcmp($timeZone, "休日") == 0)
            $items[] = getRecord($isOwn, "13", "kyuujitsu-kasan", $owner);
        
        if (($hasShochi == 0) && ($hasOpe == 0)){
            // 処置も手術も存在しなかったので外来管理加算を追加する
            $items[] = getRecord($isOwn, "13", "gairai-kanri-kasan", $owner);
        }
        
        // 明細書発行加算が届出されていれば加算
        $hid = hospitalId($owner);
        $hasMeisaisho = getHospitalInfo($hid, "明細書発行体制等加算");
        if ($hasMeisaisho && (strcmp($hasMeisaisho,"yes") == 0 ))
            $items[] = getRecord($isOwn, "13", "meisaisho", $owner);
        
        return $items;
    }
    
    function getHandanArray($isOwn, $code, $name, $ownRate){
        // 判断料のレコードの入った配列を返す
        $records = array();
        $query = "SELECT `handan` FROM `PriceList` 
		WHERE `code`='$code' and `name`='$name'";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            // $row['handan'] は "生1 生2 免" のように複数値が入っている可能性あり
            $st = $row['handan'];
            $array = explode(" ", $st);
            for ($i=0, $count=count($array); $i < $count; $i++){
                $handan = $array[$i];
                $records[] = handanRecord($isOwn, $handan, $ownRate);
            }
        }
        return $records;
    }
	
    function chouzai($isOwn, $code, $alias, $ownRate){
        // alias に対応するレコードを返す
        $query = "SELECT `name`, `point` FROM `PriceList` 
        WHERE `code`='$code' and `alias`='$alias'";
        $result=mysql_query($query);
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            $point = ($isOwn * 1 > 0) ?  $row['point'] * $ownRate : $row['point'];
            return encodeItem($isOwn, "29", $alias, $row['name'], "", "", "", $point,"");
        }
        return "";
    }
    
    function getChouzaiKasan($isOwn, $code, $name, $ownRate){
        // 調剤料のレコードを返す
        switch ($code){
            case "21":
                return chouzai($isOwn, "**29", "naifuku-chouzairyou", $ownRate);
            case "22":
                return chouzai($isOwn, "**29", "tonpuku-chouzairyou", $ownRate);
            case "23":
                return chouzai($isOwn, "**29", "gaiyou-chouzairyou", $ownRate);
            default:
                return "";
        }
    }
    
    function marume($round, $val){
        $val = floor(($val + $round) / 10);
        return $val * 10;
    }
    
    function sumFormat($insFee, $paymentRatio, 
                       $insRoundSum, $ownRoundSum, $discount)
    {
        // 合計行の表示文字列を作成して返す
        $kenpoSt = ($insFee > 0) ? "健保($insFee x $paymentRatio = $insRoundSum)" : "";
        $jihiSt = ($ownRoundSum * 1 != 0) ? "自費($ownRoundSum)" : "";
        $discountSt = ($discount * 1 > 0) ? "- 割引($discount)" : "";
        $total = $insRoundSum * 1 + $ownRoundSum * 1 - $discount * 1;
        
        return "合計[$kenpoSt $jihiSt $discountSt] $total";
    }
    
    function ownFee($rec, $freq){
        $_ary = decodeItem($rec);
        return ($_ary['isOwn'] * 1 > 0) ? $_ary['point'] * $freq : 0;
    }
    
    function insFee($rec, $freq){
        $_ary = decodeItem($rec);
        return ($_ary['isOwn'] * 1 > 0) ? 0 : $_ary['point'] * $freq;
    }
	
    function pointWithCode($isOwn, $code, $alias, $point, $dose, $owner, $isMix){
        // code ごとに点数計算の根拠が異なる
        // 薬価の場合：
        //  1) 薬価 * 数量		53.0(円) * 28(Tab) = 1484.0(円)
        //  2) 薬価のまるめ計算	(1484.0 - 15.0) / 10.0 + 1.99 = 148.89 = 148(点)
        //  3) 自費掛率をかける	148(小数点以下切り捨て) * 20(自費掛率) = 2960
        $point = ($dose > 1) ? $point * $dose : $point;
        switch ($code * 1){
            case 21: case 22: case 23: // 内服・頓服・外用
            case 33: case 48: case 58: // 点滴・処置薬・麻酔薬
                $point = ($point > 15.0) ? ($point - 15.0) / 10.0 + 1.99 : 1;
                break;
            case 31: // 筋注
                $point =  ($point + 6) / 10 + getPoint('**39','kinchuu-shugiryou');
                break;
            case 32: // 静注
            case 33: // 点滴 500cc 以下
                $point =  ($point + 6) / 10;
                if ($isMix * 1 == 0)
                    $point += getPoint('**39','jyouchuu-shugiryou');
                break;
        }
        if ($isOwn * 1 > 0){
            // 自費の場合は $point を自費料金に換算
            $ownRate = ownRate($owner);
            $point = floor($point) * $ownRate;
        }
        return floor($point);
    }
	
    function modifyWith($ary, $owner){
        // 点数を code,dose,freq を元に処理する
        // ##### ここが診療費計算のキモ #####
        $code = $ary['code'];
        $alias = $ary['alias'];
        $name = $ary['name'];
        $isOwn = $ary['isOwn'];
        $dose = ($ary['standard'] * 1 > 0) ? $ary['standard'] : 1;
        $freq = $ary['freq'];
        $standard = $ary['standard'];
        $unitName = $ary['unitName'];
        $point = $ary['point'];
        $isMix = $ary['isMix'];
        
        // $point が "" の場合は以下の pointWIthCode() 処理を行う
        // $point が "0" の場合は以下の処理は行わず "0" を尊重する
        if (strlen($point) == 0){
            // $point が "" の場合は getRecord() で priceList の点数で補完
            // * 元データがカルテの場合 alias がないので $name で検索
            $point = getPointWithCodeAndName($code, $name);
            echo "getPointWithCodeAndName:$code($name)-->$point \n"; //##
            // point x dose に code 毎固有の処理を行う
            $point = pointWithCode($isOwn,$code,$alias,$point,$dose,$owner,$isMix);
            echo "pointWithCode-->$point \n"; //##
        }
        
        return encodeItem($isOwn, $code, $alias, $name, 
                          $standard, $unitName, $freq, $point, $isMix);
    }
	
    function getHandanOfThisMonnth($patientId, $currentDate){
        // 今月請求した判断料を入れた配列を返す
        // NOA ページ作成時刻 $currentDate 以前直近のデータを探す（同日再診へ対応）
        // ## currentDate より前のレコードについて判断料の存在を検証
        $monthBegin = substr($currentDate, 0, 8)."01 00:00:00";
        // # freq が 1 のレコードは削除されたレコード
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='$patientId' 
        AND (`freq` IS NULL OR `freq`<1)
        AND `entryDate`<'$currentDate'
        AND `entryDate`>='$monthBegin' ORDER BY `entryDate` DESC";
        
        echo "getHandanOfThisMonnth == $sql\n"; //###
        
        $result = mysql_query($sql);
        $records = array();
        while ($row = mysql_fetch_array($result)){
            // ProgressSection.treatment データを読み出す
            $rec = $row['treatment'];
            $array = explode("\n", $rec);
            for ($i=0,$count=count($array); $i < $count; $i++){
                $ln = $array[$i]; // "判断[病理学的検査等判断料] 146" 形式
                // multi byte 文字の場合、１文字は 3 char になる
                if (strcmp(mb_substr($ln, 0, 6), "判断") == 0){
                    // $ln = "判断[病理学的検査等判断料] 146"
                    $ary1 = explode("[", $ln);
                    if (count($ary1) > 1){
                        $ary2 = explode("]", $ary1[1]);
                        $records[] = $ary2[0];
                    }
                }
            }
        }
        return $records;
    }
	
    function calc($value, $args){
        // アイテム・リストを集計し結果を表示
        // value = "1_|_21_|_adona30mg_|_アドナ30mg_|_3_|_Tab_|_5_|_12.9 \n
        // 1_|_12_|_saishin_|_再診料_|_1_|__|_1_|_71"
        // args = "ohashi_|_03234202_|_2008-05-18 10:53:32_|_793_|_時間内"
        $array = decdeArgs($args);
        $owner = $array['owner'];
        $patientId = $array['patientId'];
        $currentDate = $array['currentDate'];
        $timeZone = $array['timeZone'];
        $ownRate = ownRate($owner);
        
        if (strlen($value) == 0){ // 過去の履歴が透けて見えるようになる
            $newrecords = null;
            //save($patientId, $currentDate, $newrecords);
            return;
        }
        else if ($value == " "){ // 過去の履歴を空白で上書き
            $newrecords[] = " ";
            //save($patientId, $currentDate, $newrecords);
            return;
        } else
            $newrecords = array();
        
        // FRONT の画面表示を更新する
        putTimeStamp(); // ### save() が生きていればその中で行われる ###
        
        // 今月請求した判断料の配列 ("病理学的検査等判断料","微生物学的検査判断料",,)
        $handans = getHandanOfThisMonnth($patientId, $currentDate);
        echo "=== 判断履歴 ===\n".join("\n", $handans)."\n=== $patientId $currentDate ===\n"; //##
        
        $records = explode("\n", $value);
        $count = count($records);
        $insSum = 0; $ownSum = 0; $hasIns = 0; $echoFullName="";
        for ($i=0; $i < $count; $i++){
            $ln = $records[$i];
            $ary = decodeItem($ln);
            $code = $ary['code'];
            $name = $ary['name'];
            $isOwn = $ary['isOwn'];
            $dose = ($ary['standard'] * 1 > 0) ? $ary['standard'] : 1;
            $freq = $ary['freq'];
            $point = $ary['point']; // 単剤の点数
            
            // 既存の自動付加項目は、次行の健保チェック前にスキップし後で自動付加
            if ($code % 10 == 9) continue;
            if ($code * 1 == 13) continue;
            
            // 再診をスキップする前にチェック
            // でないと健保再診のみの場合、健保有無が未チェックになってしまう
            if ($isOwn < 1) $hasIns = 1;
            
            // 再診は後で自動追加（これにより常に再診は１回のみとなる）するためスキップ
            if (!$isOwn && ($code == "12") && ($name == "再診料")) continue;
            
            // 投薬に伴う付加項目を $records[] へ付加
            if (substr($code, 0, 1) == "2"){
                $rec = getChouzaiKasan($isOwn, $code, $name, $ownRate);
                // 重複した調剤料を防止
                if (strlen($rec) && (! in_array($rec, $newrecords))){
                    $newrecords[] = $rec;
                    $ownSum += ownFee($rec, 1);
                    $insSum += insFee($rec, 1);
                }
                $rec = chouzai($isOwn, "**29", "shohouryou", $ownRate);
                // 重複した調剤料を防止
                if (strlen($rec) && (! in_array($rec, $newrecords))){
                    $newrecords[] = $rec;
                    $ownSum += ownFee($rec, 1);
                    $insSum += insFee($rec, 1);
                }
            }
            
            // 判断料を $records[] へ付加
            if ($code * 1 == 60){
                // 判断料には "生1 生2 免" のように複数が入っている可能性あり
                $hArray = getHandanArray($isOwn, $code, $name, $ownRate);
                for ($n=0, $ct=count($hArray); $n < $ct; $n++){
                    // $_rec = "0_|_69_|_nyou-handan_|_尿糞便検査判断料_|__|__|__|_34"
                    $_rec = $hArray[$n];
                    // 当日の重複した判断料を防止
                    if (strlen($_rec) && (! in_array($_rec, $newrecords))){
                        // 今月の重複した判断料を防止 (既に $handans に存在すれば無視)
                        $ary1 = decodeItem($_rec);
                        $_name = $ary1['name'];
                        if (! in_array($_name, $handans)){
                            $newrecords[] = $_rec;
                            $ownSum += ownFee($_rec, 1);
                            $insSum += insFee($_rec, 1);
                        }
                    }
                }
                if (strpos($name, "超音波") !== FALSE)
                    $echoFullName = $name; // 超音波検査があった
            }
            
            if ($code * 1 == 80){
                if (hasGeneric($patientId, $currentDate)){
                    // 処方箋に一般名処方がある時のみ「一般名処方加算」を実行
                    $rec = chouzai($isOwn, "80", "yakuzai-ippannmei-shohousen", $ownRate);
                    if (strlen($rec) && (! in_array($rec, $newrecords))){
                        $newrecords[] = $rec;
                        $ownSum += ownFee($rec, 1);
                        $insSum += insFee($rec, 1);
                    }
                }
            }
            
            // 点数を code,dose,freq を元に処理する
            // ##### ここが診療費計算のキモ #####
            $ln = modifyWith($ary, $owner);
            echo "=== records:$ln \n\n"; //##
            
            // $records[] の値を $newrecords[] にコピー
            $newrecords[] = $ln;
            if ($isOwn * 1 > 0)
                $ownSum += ownFee($ln, $freq);
            else
                $insSum += insFee($ln, $freq);
        }
        
        // 初診または入院がなければ再診を自動付加
        // 初診も処置もなければ外来管理加算を自動付加
        $items = saishinCheck($hasIns, $newrecords, $currentDate, $timeZone, $owner);
        if ($items && (count($items) > 0)){
            for ($i=0; $i < count($items); $i++){
                $st = $items[$i];
                $newrecords[] = $st;
                $ownSum += ownFee($st, 1);
                $insSum += insFee($st, 1);
            }
        }
        
        // 超音波検査があった場合の処理
        if (strlen($echoFullName) > 0){
            // 今月の超音波使用回数を検出しておく
            $echoCount = echoCountOfThisMonth($patientId, $currentDate);
            echo "--- echoCount:$echoCount \n"; //##
            if ($echoCount == 0){
                // 超音波が過去に使用されていないので何もせず
            } else if ($echoCount == 1){
                // 超音波が今月１回しか使われていなければ２回目の逓減点数を追加
                $pt = getPointWithCodeAndName("60",$echoFullName);
                $st = getTeigenRecord($isOwn,$pt,"69","kensa-teigen");
                if (strlen($st) > 0){
                    $newrecords[] = $st;
                    $ownSum += ownFee($st, 1);
                    $insSum += insFee($st, 1);
                }
            } else {
                // すでに２回以上使われているので超音波レコードを削除
                $recs = array();
                for ($i=0,$ct=count($newrecords); $i < $ct; $i++){
                    $st = $newrecords[$i];
                    $ary = explode("_|_", $st);
                    $code = $ary[1];
                    $name = $ary[3];
                    // 超音波レコードを削除し、その点数を算定しない
                    if (($code=="60") && (strpos($name,"超音波")!==TRUE)){
                        $recs[] = "0_|_69_|__|_超音波検査（２回以上なので算定不可）_|_0_|__|_0_|_0";
                        $ownSum -= ownFee($st, 1);
                        $insSum -= insFee($st, 1);
                    } else
                        $recs[] = $st;
                }
                $newrecords = $recs;
            }
        }
        
        // 特定疾患指導料・特定疾患処方管理加算 を自動付加
        /*
         $ary = tokuteiShikanCheck($hasIns, $newrecords, $patientId, $currentDate, $owner);
         for ($i=0,$ct=count($ary); $i < $ct; $i++){
         $st = $ary[$i];
         $newrecords[] = $st;
         $ownSum += ownFee($st, 1);
         $insSum += insFee($st, 1);
         }
         */
        
        // 集計を付加
        
        // ## まるめ係数は ORCA では 0（小数点以下切り捨て） に設定
        $hid = hospitalId($owner);
        $round = getHospitalInfo($hid, "まるめ係数");
        $paymentRatio = paymentRatio($patientId);
        $insRoundSum = marume($round, $insSum * $paymentRatio);
        
        $discountRatio = discountRatio($patientId);
        // 自費最終料金 = 自費 - ((保険窓口 + 自費）* 割引 / 100)
        // すなわち割引がある場合、自費料金は保険窓口も含めたものから計算されるので
        $discount = ($insSum * $paymentRatio + $ownSum) * $discountRatio / 100;
        $discount = marume($round, $discount);
        $ownRoundSum = marume($round, $ownSum);
        
        // 診療費 EDITOR への集計表示
        $name = sumFormat($insSum, $paymentRatio, 
                          $insRoundSum, $ownRoundSum, $discount);
        $st = encodeItem("", "99", "", $name, "", "", "", "", "");
        $newrecords[] = $st;
        
        // 混注以外のものをソート
        $newrecords = sortRecords($newrecords);
        
        echo "<SEPARATOR>";
        echo join("\n", $newrecords);
        
        // records を NOA へ書き戻す
        //save($patientId, $currentDate, $newrecords);
        
        // FrontTable の窓口会計レコードを更新
        $isNew = hasShosin($newrecords);
        $isIn = hasNyuuin($newrecords);
        
        // 会計に現れる自費料金 = (自費 - 割引額) なので
        // 保険診療だけの場合に割引があると、保険窓口は変わらないがマイナスの自費が発生する
        updateFront($patientId,$currentDate,$owner,$isNew,$isIn,
                    $insSum, $insRoundSum,$ownRoundSum - $discount);
    }
	
    ///// 集計機能 ///////////
    /////////////////////////
    
    ///////////////////////////////
    ///// テンプレート登録 ///////////
    
    function putTemplate($menuItem, $treatment, $owner){
        // テンプレートを登録または更新する
        $patientId = "GroupMenu"; // テンプレートの場合の決め打ち
        // # freq が 1 のレコードは削除されたレコード
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='$patientId' 
        AND (`freq` IS NULL OR `freq`<1)
        AND `subject`='$menuItem'";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){	// 同じ menuItem が存在した
            $row=mysql_fetch_array($result);
            $rowid = $row['rowid'];
            $sql = "UPDATE `ProgressSection` SET 
            `treatment`='$treatment',
            `owner`='$owner', 
            `updateTime`='".date("Y-m-d H:i:s",time())."'
            WHERE `rowid`=$rowid";
        } else {							// 同じ menuItem が存在しなかった
            $sql = "INSERT INTO `ProgressSection` 
            ( `patientId`, `subject`, `treatment`, `entryDate`, `updateTime`, `freq`, `owner` )
            VALUES ( '$patientId','$menuItem','$treatment','".date("Y-m-d H:i:s",time())."','".date("Y-m-d H:i:s",time())."','0','$owner')";
        }
        echo "\n".$sql."----------\n"; //####
        mysql_query($sql);
    }
    
    ///// テンプレート登録 ///////////
    ///////////////////////////////
	
	
    $command=$_GET['command']; $command=htmlspecialchars($command);
    $args=$_GET['args']; $args=htmlspecialchars($args);
    $isOwn=$_GET['isOwn']; $isOwn=htmlspecialchars($isOwn);
    $code=$_GET['code']; $code=htmlspecialchars($code);
    $alias=$_GET['alias']; $alias=htmlspecialchars($alias);
    $alias = decodeSTRING($alias);
    $alias = stripslashes($alias);
    $value=$_GET['value']; $value=htmlspecialchars($value);
    $value = stripslashes($value);
    $value = urldecode($value);
    $value = decodeSTRING($value); // lib.php
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない 
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('cfg.php');
    
    $dbc = mysql_connect($db['host'], $db['user'], $db['pwd']);
    $db_select=mysql_select_db($db['dbname']);
    mysql_query("set names utf8");
    
    
    if (strcmp($command,"GET_HEADER") == 0){
        // VIN panel が開き初期化する時のデータを返す
        $args = decodeObject($value);
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        $entryDate = $args['entryDate'];
        
        // 診療行為マトリックス内容を返す
        // 診療行為種別のリストを JSON 形式で返す（再診、内服、など）
        $query = "SELECT `code`,`alias`,`name` FROM `PriceList` WHERE `alias`like'/%' ORDER BY `alias";
        $result=mysql_query($query);
        $array = array();
        while ($row=mysql_fetch_array($result)){
            $name = substr($row['name'], 2);
            $code = substr($row['name'], 0, 2);
            $ch = substr($row['name'], 0, 1);
            if (($ch < '0') || ('9' < $ch)) continue; // code は数値
            $array["$name"] = $code;
        }
        echo "<SEPARATOR>";
        echo json_encode($array);
        
        // 診療時間帯ポップアップ内容を返す
        echo "<SEPARATOR>";
        // 診療時間 = ",,0000,0600,深夜\n,,0900,1200,時間内" 形式
        $hid = hospitalId($owner);
        echo getHospitalInfo($hid, "診療時間");
       
        // 施設固有値を HospitalTable などから読み出す
        echo "<SEPARATOR>";
        echo hospitalInfo($owner);
        
        // 記憶されたアイテム・リストを ProgressSection.treatment から読み出す
        echo "<SEPARATOR>";
        $buff = load($patientId, $entryDate);
        if (strlen($buff) > 0) echo $buff;
    } else if (strcmp($command,"GET_CHILD_SELECTOR") == 0){
        // コードに一致する診療行為レコードの配列を返す
        showItemSelector($value);
    } else if (strcmp($command,"GET_ITEM") == 0){
        // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
        // isOwn, code, alias, args
        $array = decdeArgs($args);
        echo "<SEPARATOR>";
        if ($code * 1 == 0){
            // 一括メニュー
            // ProgressSection から patientId='GroupMenu' AND subject='$alias' を抽出
            // $alias の末尾に改行が入っている場合は改行の前迄を subject として扱う
            $sql = "SELECT * FROM `ProgressSection`
			WHERE `patientId`='GroupMenu' AND `subject`='$alias'";
            $result=mysql_query($sql);
            $row = mysql_fetch_array($result);
            
            // codeName[name(dose unitName)] point isOwnFee 形式を
            // 1_|_12_|_alias_|_産科健診料_|_dose_|_unitName_|_freq_|_point 形式へ変換
            if ($row) echo decodeRecords($row['treatment']);
        }
        else {
            // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
            $st = getRecord($isOwn, $code, $alias, $array['owner']);
            if (strlen($st) > 0) echo $st;
        }
    } else if (strcmp($command,"CALC") == 0){
        // 診療行為を計算して返す
        calc($value, $args);
    } else if (strcmp($command,"PUT_TREATMENT_GROUP") == 0){
        // 診療行為をテンプレートとして登録
        // alias, value, args
        echo "<SEPARATOR>";
        $array = decdeArgs($args);
        $owner = $array[0];
        $records = explode("\n", $value);
        $archives = encodeRecords($records);
        $treatment = join("\n", $archives);
        $menuItem = $alias;
        putTemplate($menuItem, $treatment, $owner);
    } else if (strcmp($command,"GET_GLOBAL_LIST") == 0){
        // グローバル・レコードを返す
        $args = decodeObject($value);
        // client 側との約束ごと
        $code = $args['code'];
        $name = $args['name'];
        
        $sql = "SELECT * FROM `PriceListGlobal` 
        WHERE `name` LIKE '%$name%' AND `code` LIKE '$code%'
        ORDER BY `name`";
        echo "$sql ------\n";
        $result=mysql_query($sql);
        
        echo "<SEPARATOR>[";
        while ($row=mysql_fetch_array($result)){
            $array = array();
            $array['code'] = $row['code'];
            $array['classCode'] = $row['classCode'];
            $array['requestCode'] = $row['requestCode'];
            $array['name'] = $row['name'];
            $array['point'] = $row['point'];
            $array['unitCode'] = $row['unitCode'];
            $array['unitName'] = $row['unitName'];
            $array['handanCode'] = $row['handanCode'];
            $array['effectCode'] = $row['effectCode'];
            $array['enforceDate'] = $row['enforceDate'];
            // 全体を json_encode() 使用とすると巨大データでコケるので
            // レコードを一行ずつ encode する
            echo json_encode($array).",";
        }
        echo "{}]";
    } else if (strcmp($command,"PUT_PRICE_LIST") == 0){
        // PriceList にグローバル・レコードをマージ
        $args = decodeObject($value);
        // client 側との約束ごと
        $code = $args['groupCode']; // VIN で指定された code
        $requestCode = $args['requestCode'];
        $name = $args['name'];
        $point = $args['point'];
        $unitName = $args['unitName'];
        $handan = $args['handan'];
        $effectCode = $args['effectCode'];
        $enforceDate = $args['enforceDate'];
        $updateTime = timestamp();
        
        $sql = "SELECT * FROM `PriceList` 
        WHERE `code`='$code' AND `name`='$name'";
        echo "$sql ------\n";
        $result=mysql_query($sql);
        
        $_unit = ($unitName) ? ",`unitName`='$unitName'" : "";
        $_handan = ($handan) ? ",`handan`='$handan'" : "";
        $_effect = (strlen($effectCode)) 
		? ",`effectCode`='$effectCode'" : "";
        
        if (mysql_num_rows ($result)){
            $sql = "UPDATE `PriceList` SET
            `requestCode`='$requestCode'
            ,`point`='$point'
            ,`unitName`='$unitName' 
            $_unit 
            $_handan 
            $_effect
            ,`updateTime`='$updateTime'
            WHERE `code`='$code' AND `name`='$name'";
        } else {
            $sql = "INSERT INTO `PriceList` 
            (`code`,`requestCode`,`name`,`point`,`unitName`,`handan`
             ,`effectCode`,`enforceDate`,`updateTime`) 
            VALUES 
            ('$code',$requestCode,'$name','$point','$unitName','$handan'
             ,'$effectCode','$enforceDate','$updateTime')";
        }
        mysql_query($sql);
        echo "$sql ------\n";
        echo "<SEPARATOR>";
        echo $value;
    } else {
        echo "*** unknown command: $command";
    }
    
?>
