
function mode(){
	return document.getElementById("_mode").value;
}

var _records;
function setPriceRecords(objct){
    _records = objct;
}
function priceRecords(){
	return _records;
}

/////////////////////////////////////////////////////////////
/// Ajax による処理 ///////////////////////////////////////////

function NR_debug(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert("=== NR_debug ===\n"+value); //## 返されたメッセージを debug 用に表示
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			_receiver(array[1]); // JSON
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}

function gotTable(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        //alert(value); //##

		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var obj = JSON.parse(array[1]);
			obj = pureRecords(obj); // $row の数値添字を取り除く
            
            _initDebug(false); //##
            _debug("gotTable:"+encodeObject(obj)); //##
            
			hideMessage("_message");
            setPriceRecords(obj);
			showRecords();
		} else
			showMessage("_message", value);
	} else 
		showMessage("_message", "Loading PriceList ...");
	
	function pureRecords(objects){
		// $row の数値添字を取り除く
		var recs = new Array();
		for (var i=0,ct=objects.length; i < ct; i++){
			var obj = objects[i];
			var array = new Array();
			for (key in obj){
				if (! isDigit(key)) array[key] = obj[key];
			}
			recs.push(array);
		}
		return recs;
	}
}
function getTable(dummyOwner, table, order){
	// table の内容をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(gotTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['table'] = table;
		array['order'] = order;
		var val = encodeObject(array);
		
		var st = "sysServer.php?command=GET_TABLE_SOURCE"
		+ "&value=" + encodeSTRING(val);
        
        //alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gotArchive(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        _initDebug(false); //##
		_debug("gotArchive->"+value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			// ### JSON に含まれる改行を encode してから eval する
			var val = transferCR(array[1]);
            _debug(val); //##
            
			var obj = eval('(' + val + ')');
            _debug("<p>obj->"+encodeObject(obj)+"</p>"); //##
            
			// ### object 中の encode された改行を decode する
			obj = decodeEncodedCR(obj);
            _debug("<p>obj->"+encodeObject(obj)+"</p>"); //##
			
            setPriceRecords(obj);
            
            showRecords();
		} 
	} 
	
	function decodeEncodedCR(array){
		// obj 中の encode された改行を decode する
		for (var i=0,ct=array.length; i < ct; i++){
			var newObj = new Object();
			var obj = array[i];
			for (key in obj){
				var val = obj[key];
				newObj[key] = transferToCR(val);
			}
			array[i] = newObj;
		}
		return array;
	}
}
function getArchive(path){
	// 選択されたユーザのバックアップ・データをサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(gotArchive);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['tableType'] = "PRICE";
		array['filename'] = path;
		var val = encodeObject(array);
        
		var st = "sysServer.php?command=GET_ARCHICE"
		+ "&value=" + encodeSTRING(val);
        
        //alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function loadedBackupedArchive(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("loadedBackupedArchive ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            
            // バックアップファイルのポップアップを表示
            showBackupSelector(obj);
		}
	} 
}
function loadBackupedArchive(){
    // バックアップ・ファイル名リストをリクエスト
	xmlHttpObject = createXMLHttpRequest(loadedBackupedArchive);
	if (xmlHttpObject){
		var array = new Array();
		array['folder'] = "PRICE_SOURCE";
		var args = encodeObject(array);
		
		var st = "./sysServer.php?command=GET_ARCHIVED_LIST"
		+ "&value=" + encodeSTRING(args);
		
        //alert(st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gotUserAgent(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert("gotUserAgent ===\n"+value);//##
	}
}
function getUserAgent(){
    // user agent をリクエスト
	xmlHttpObject = createXMLHttpRequest(gotUserAgent);
	if (xmlHttpObject){
		var st = "./sysServer.php?command=GET_LOGIN_USER";
        
        //alert(st); //##
		
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function removedPriceTable(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
//		if (debugMode()) alert("<p>"+value+"</p>");//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			showRecords();
		} 
	} 
}
function removePriceTable(obj){
	// obj を PriceList から削除
	xmlHttpObject = createXMLHttpRequest(removedPriceTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['code'] = obj.code;
		array['alias'] = obj.alias;
		array['name'] = obj.name;
        
		var st = "./noaSystemServer.php?command=REMOVE_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(array));
//		if (debugMode()) alert("<p>"+value+"</p>");//##

		xmlHttpObject.open("GET", encodeURI(st), false);
		xmlHttpObject.send(null);
	}
}

function puttedPriceTable(obj){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
        //alert("puttedPriceTable:\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // DB 内容をサーバへリクエストして再表示
            var tableName = "PriceList";
            var order = "`code`,`alias`";
            getTable("", tableName, order);
		}
	} 
}
function putPriceTable(obj){
	// obj を FieldTable に追加
	// FieldTable に同じ tag, id があれば上書き
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(puttedPriceTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./sysServer.php?command=PUT_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(obj));

        //alert(st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), false);
		xmlHttpObject.send(null);
	}
}

function replacedPriceTable(){
	// DB の FieldTable が空になった
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//if (debugMode()) alert(value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			mergeCycle();
		} 
	} 
}
function replacePriceTable(){
	// DB の FieldTable を空にしてからデータソースを書込む
	xmlHttpObject = createXMLHttpRequest(replacedPriceTable);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array['table'] = "PriceList";
		var val = encodeObject(array);
		
		var st = "./noaSystemServer.php?command=CLEAR_TABLE"
		+ "&value=" + encodeSTRING(val);
//		if (debugMode()) _debug("<p>replacePriceTable ===<br>"+st+"</p>"); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 ///////////////////////////////////////////
/////////////////////////////////////////////////////////////


function getGlobal(answer){
	// global.js からのメッセージを受ける
	//alert("getGlobal:"+answer); //===
	var obj = decodeObject(answer);
	if (obj.requestCode && obj.requestCode.length)
		document.getElementById('requestCode').value = obj.requestCode;
	if (obj.name && obj.name.length)
		document.getElementById('name').value = obj.name;
	if (obj.point && obj.point.length)
		document.getElementById('point').value = obj.point;
	if (obj.unitName && obj.unitName.length)
		document.getElementById('unitName').value = obj.unitName;
	if (obj.handan && obj.handan.length)
		document.getElementById('handan').value = obj.handan;
    
    // Editor が見えないことがあるのでエディター位置へスクロール
    var elm = document.getElementById("editor_title");
    var pos = getPosition(elm);
	window.scroll(0, pos.y); 
}
function showGlobal(){
	// グローバル辞書を開く
	var code = document.getElementById('code').value;
	var name = document.getElementById('name').value;
	
	// ### global.js からのメッセージは getGlobal() で受ける
	var url = "./global.php?code='" + code 
	+ "'&name='" + name + "'";
	window.open(url, "グローバル辞書"
				, "scrollbars=yes,width=800,height=500");
}

function suserPrice(){
    if (window.event.shiftKey){
        var elm = document.getElementById("markArea");
        
        if (elm.innerHTML.length > 0){
            elm.innerHTML = "";
            var array = ["バックアップ","データベース"];
        } else {
            elm.innerHTML = "* ";
            var array = ["テンプレート","バックアップ","データベース"];
        }
        
        // テンプレートを表示・非表示
        var elm = document.getElementById("sourcePopup2menuArea");
        if (elm){
            elm.innerHTML = "";
            var pu = makePopupMenu(elm, "sourcePopup2", array, "");
            pu.setAttribute("onchange", "sourceSelected2(this)");
        }
    }
}

function showBackupSelector(filenames){
    // バックアップ・ファイルのリストを選択してファイルをロード
    var items = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.charAt(0) == '.') continue;
        items.push(name);
    }
    var elm = document.getElementById("fileNamesArea");
    elm.innerHTML = "";
    var pu = makePopupMenu(elm, "filePop", items, "");
    
    // removeButtonArea の操作：バックアップファイルの削除ボタン
    var elm = document.getElementById("removeButtonArea");
    elm.innerHTML = " ";
    var bt = newBUTTON(elm, "", "サーバから削除");
    bt.setAttribute("onclick", "removeBackupFile('PRICE')");
}

function load(){
	// ユーザポップアップとソースポップアップに応じたデータを読込む
	var src = document.getElementById("sourcePopup").value;

    if (src == "テンプレート"){
        // バックアップデータを表示
        var filename = "./PRICE.txt";
        showController("テンプレート ( " + filename + " ) ");
        
        getArchive(filename);
    } else if (src == "バックアップ"){
        // 過去ログからピックアップ
        var filename = document.getElementById("filePop").value;
        showController("バックアップ ( " + filename + " ) ");
        
        getArchive(filename);
    } else if (src == "データベース"){
        showController( "データベース ");
        
		var tableName = "PriceList";
		var order = "`code`,`alias`";
        getTable("", tableName, order);
    }
}

var _archive;
var _archiveName;
function putArchive(filename){
	// データ・ソースを文字列ファイルとして保存	
//	if (debugMode()){
//        _initDebug(true); //##
//        _debug("archive->"+filename); //return; //##
//    } else
        _initDebug(false); //##
    
	var recs = priceRecords();
	if (! recs){
		alert("データ・ソースが読み込まれていません");
		return;
	}
    
	//alert(filename+" archive->"+encodeObject(recs)); //return; //##
	var array = new Array();
    for (i in recs){
		var obj = recs[i];
		array.push(object2json(obj));
	}
    
	//alert("array->"+encodeObject(array)); return; //##
	
	// [{"owner":"","tag":"","menu":"",,},{"owner":"",,},,] 形式
	var val = "[" + array.join(",") + "]";
	
	_archive = val;
	_archiveName = filename;
    
	_debug(filename+"->"+val); //return; //##
    
    archiveTableSource("C_L_E_A_T_E__F_I_L_E"); // サーバを新規ファイル受入れ状態にする
}

function mergedWithPrice(){
	// 各テーブルの存在がチェックされた
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
//		if (debugMode()) _debug("<p>"+value+"</p>");//## メニュー項目１つずつの返事
        
		var array = value.split("<SEPARATOR>");
		if ((array.length > 1) && (array[1].length)){
			showMessage("_message", value);
//            if (debugMode()) _debug("<p>"+value+"</p>"); //##
		} 
		mergeCycle();
	} 
}
function mergeWithPrice(obj){
	// データ・ソースを DB とマージ
	xmlHttpObject = createXMLHttpRequest(mergedWithPrice);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// ## obj に含まれた owner は操作者のものなので別途指定する
		var st = "./noaSystemServer.php?command=MERGE_PRICE"
		+ "&owner=" + owner()
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//alert(st); return;//## かなり頻繁
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

var _num;
function mergeCycle(){
	// Ajax で DB との間でリカーシブルに merge を行う
	var array = priceRecords();
	if (_num < array.length){
		var obj = array[_num++];
        mergeWithPrice(obj);
	} else {
        hideMessage("_message");
        
        // DB 内容を再表示
		var tableName = "PriceList";
		var order = "`code`,`alias`";
        getTable("", tableName, order);
        
		alert("データへの書込み終了しました");
    }
}
function save(){
	// ユーザポップアップとソースポップアップに応じたデータを書込む
//    if (debugMode()) _initDebug(true); else _initDebug(false); //##
    
	var src = document.getElementById("sourcePopup2").value;
	if (src == "バックアップ"){
		putArchive("PRICE");
	} else if (src == "テンプレート"){
		putArchive("./PRICE.txt");
	} else if (src == "データベース"){
		var elm = document.getElementById("isOverWrite");
        var st = (elm.checked)
        ? "ここに表示されたデータによって完全に置換されます"
        : "ここに表示されたデータとマージされます。すでに同じ tag, menu を持つレコードは置換されません。差分のみが追加されます。";
		
		if (confirm("データベースは、" + st)){
			// データ・ソースを DB とマージ
			//showMergeLog(); // マージのログを表示するエリアを用意
			_num = 0; // _num を 0 にセットしてから mergeCycle() を廻す
			if (elm && elm.checked)
				replacePriceTable();
			else
				mergeCycle();
		}
	}
}

function showSaveButtons(){
	// 保存ボタンを表示
	var elm = document.getElementById("saveButtonArea");
	elm.innerHTML = "";
	
    var sp = newSPAN(elm, "sourcePopup2Area");
    var tx = newTEXT(elm, " ");
    var sp = newSPAN(elm, "saveCheckArea");
    
	var td = document.getElementById("sourcePopup2Area");
	td.innerHTML = "";
    var sp = newSPAN(td, "sourcePopup2menuArea"); // priceList.js で必要
    var array = ["バックアップ","データベース"];
    var pu = makePopupMenu(sp, "sourcePopup2", array, "");
    pu.setAttribute("onchange","sourceSelected2(this)");
    var tx = newTEXT(td, " へ ");
    var bt = newBUTTON(td, "", "書込む");
    bt.setAttribute("onclick","save()");
    document.getElementById("saveCheckArea").innerHTML = "";
}

function removeCheckedRecords(){
	// チェックされたレコードをすべて削除
	var array = new Array();
	var recs = priceRecords();
    for (i in recs){
		var elm = document.getElementById("cb."+i);
		if (! elm.checked)
			array.push(recs[i]); // チェックの入らないものだけをピックアップ
	}
	setPriceRecords(array);
    showRecords();
}

function removeRecord(row){
	// row 行レコードを削除
	var array = priceRecords();
	var obj = array[row];
	if (confirm(obj.name + " を削除していいですか")){
		array.splice(row, 1);
		
		setEditorId("");
		var elm = document.getElementById("directEdit");
		if (elm && elm.checked){
			// 直接データベースの obj を削除
			removePriceTable(obj);
		} else
			showRecords();
	}
}

function changeRecord(row){
	// row 行レコードを変更
	var obj = new Object();
	obj.code = document.getElementById("code").value;
	obj.requestCode = document.getElementById("requestCode").value;
	obj.alias = document.getElementById("alias").value;
	obj.name = document.getElementById("name").value;
	obj.generic = document.getElementById("generic").value;
	obj.point = document.getElementById("point").value;
	obj.unitName = document.getElementById("unitName").value;
	obj.handan = document.getElementById("handan").value;
	obj.min = document.getElementById("min").value;
	obj.standard = document.getElementById("standard").value;
	obj.max = document.getElementById("max").value;
	obj.width = document.getElementById("width").value;
	obj.effectCode = document.getElementById("effectCode").value;
	obj.effect = document.getElementById("effect").value;
	obj.memo = document.getElementById("memo").value;
	obj.enforceDate = document.getElementById("enforceDate").value;
	if (obj.alias.length == 0){
		// alias が空ならアラート
		alert("alias にユニークな値を入れてください");
		document.getElementById("alias").focus();
		return;
	} else if (_addMode && isExist(obj.alias)){
		// 同一 alias が重複する場合はアラート
		alert(obj.alias + " はすでに存在します。ユニークな値を入れてください");
		document.getElementById("alias").focus();
		return;
	}
    
    // 新規レコードの場合もあるので obj は新たに起こしたものを使う
    priceRecords()[row] = obj;
	
	setEditorId("");
	var elm = document.getElementById("directEdit");
	if (elm && elm.checked){
		// 直接データベースの obj を更新
		putPriceTable(obj);
	} else {
		showRecords();
        
        // 新規登録モードなら続けて新規登録するか尋ねる
        if (_addMode && confirm("続けて新規登録しますか"))
            showNewEditor();
	}
	
    
    function isExist(alias){
        // alias が重複して存在するなら TRUE を返す
        var array = priceRecords();
        var count = 0;
        for (num in array){
            var obj = array[num];
            if (obj.alias == alias) count++;
        }
        return (count > 1) ? true : false;
    }
}

var _addMode;
function showNewEditor(){
	// 新規レコード作成エディターを開く
	// ## 新規レコードボタンに showEditor(row) を action として設定しても
	// ## その時点では row が決まっていない可能性があるため、この機能を独立させる
	_addMode = true;
	var row = priceRecords().length;
    openEditor(row);
}

function editorPanelHelp(){
	window.open("./editorPanelHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openEditor(row){
	// row 行レコードの編集パネルを開く
	var obj = priceRecords()[row];
//    if (debugMode()) alert("openEditor:"+row+"->"+obj); //##
    
	if (!obj){
        obj = new Object();
        obj.code = "00";
        obj.alias = "new-record";
        obj.name = "新規レコード";
        // obj は「変更」ボタンが押されてから fieldRecords に追加される
	}
    
//    if (debugMode()) alert("openEditor->"+encodeObject(obj)); //##
	
	// 以前開いていたエディターあれば閉じる
	var old_eid = editorId();
	var isClosed = closeEditor();
	
	// 目的エディターが今閉じたエディターなら、閉じただけで終了
	var eid = editorIdForRow(row);
	
	if (isClosed && (eid == old_eid)) return;
	
	// エディターを開く領域を記憶
	setEditorId(eid);
	
	// レコード編集ペーンを表示
	var elm = document.getElementById(eid);
	elm.innerHTML = "";
	
	var tbl = newTABLE(elm, "base-table");
	tbl.style.border = "solid #fc0 5px";
	tbl.style.textAlign = "left-side";
	tbl.style.fontSize = "10pt";
	tbl.style.backgroundColor = "yellow";
    
	// title
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "5");
	var img = newIMAGE(td, "icon", "./close.png", "close");
	img.setAttribute("onclick", "closeEditor()");
	var tx = newTEXT(td, "　" + obj.name + " を編集"); // tag
    
	// contents
	makeField(tbl, "code", obj, true);
	makeField(tbl, "requestCode", obj, true);
	makeField(tbl, "alias", obj, true);
	makeField(tbl, "name", obj, true);
	makeField(tbl, "generic", obj, true);
	makeField(tbl, "point", obj, true);
	makeField(tbl, "unitName", obj, true);
	makeField(tbl, "handan", obj, true);
	makeField(tbl, "min", obj, true);
	makeField(tbl, "standard", obj, true);
	makeField(tbl, "max", obj, true);
	makeField(tbl, "width", obj, true);
	makeField(tbl, "effectCode", obj, true);
	makeField(tbl, "effect", obj, true);
	makeField(tbl, "memo", obj, true);
	makeField(tbl, "enforceDate", obj, true);
	makeField(tbl, "updateTime", obj, false);
    
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var td = newTD(tr, "comment", "編集内容はバックアップやデータベースに書込まない限り保存されません ");
	td.setAttribute("colspan", "4");
	
	// footer
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "controller", "");
	td.setAttribute("colspan", "5");
	td.style.textAlign = "right-side";
	td.style.fontSize = "10pt";
    
	var a = newA(td, "グローバル辞書を開く", "#", "");
	a.setAttribute("onclick", "showGlobal()");
	var tx = newTEXT(td, " ");
	
	var dataSource = document.getElementById("sourcePopup").value;
	if (dataSource == "データベース"){
		var cb=newCHECKBOX(td,"directEdit","データベースを直接編集 ",false);
	}
	
    var bt = newBUTTON(td, "", "削除");
    var action = "removeRecord('" + row + "')";
    bt.setAttribute("onclick", action);

	var bt = newBUTTON(td, "", "確定");
	var action = "changeRecord('" + row + "')";
	bt.setAttribute("onclick", action);
    
	// HELP icon
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "editorPanelHelp()");
	im.style.height = "21px";
	im.style.verticalAlign = "bottom";
    
    // Editor が見えないことがあるので該当位置へスクロールしておく
    // 新規の場合は 以下の row がないので row-1 を使う
    var elm = document.getElementById("row" + row);
    if (!elm){
        elm = document.getElementById("debugbox");
    }
    var pos = getPosition(elm);
	window.scroll(0, pos.y); 
    
	function makeField(tbl, key, obj, status){
		var tr = newTR(tbl, "", key);
		var val = (obj && obj[key]) ? obj[key] : "";
		if (status){
			var td = newTD(tr, "", "");
			var fd = newFIELD(td, key, "", "100", val);
		} else {
			var td = newTD(tr, "", val);
		}
		td.setAttribute("colspan", "4");
	}
}

function checkAll(elm){
	// checkBox の全てにチェックを入れる
	var status = elm.checked;
	var recs = priceRecords();
    for (i in recs){
		var elm = document.getElementById("checkArea."+i);
		elm.innerHTML = "";
		var cb = newCHECKBOX(elm, "cb."+i, "", status);
	}
}

var _keyArray;
var _keyPos;
function jumpToKey(keyPos){
    // テキスト中の次のキーへカーソル・ジャンプ
    if (_keyPos * 1 > (keyPos * 1 + 1)){
        var row = _keyArray[(keyPos * 1 + 1)]; // 次のフィールド
        var elm = document.getElementById("row" + row);
        
        // 次のヒット・ページの先頭にジャンプ
        var pos = getPosition(elm);
        window.scroll(0, pos.y - 30);
    } else {
        window.scroll(0, 0);
    }
}
function find(){
	// 検索を実行
    _keyPos = 0;
    _keyArray = new Array();
	var key = document.getElementById("keyF").value;
	var array = priceRecords();
	var count = 0;
    for (i in array){
		var tr = document.getElementById("row"+i);
		var obj = array[i];
		var found = false;
		if (key.length){
			if (isDigit(key) || (key.indexOf("*")>=0) || (key=="@")){
				if (obj.code.indexOf(key) >= 0) found = true;
			} else {
				var st = obj.alias + obj.name;
				if (st.indexOf(key) >= 0) found = true;
			}
		}
		
        var nameTD = tr.childNodes[4];
		if (found){ // key が含まれていた行の色を変える
            nameTD.setAttribute("class", "nameTag");
            nameTD.setAttribute("onclick", "jumpToKey('" + _keyPos + "')");
            
            // key にマッチした element の行数を記憶
            _keyArray[_keyPos++] = i;
            
            // key に一致した回数をカウント
			count++;
		} else {
            nameTD.setAttribute("class", "");
        }
	}
	
	if (count){
        // キーが最初にみつかったページを画面上端に表示
        jumpToKey(-1);
        
		alert(count + " 個の該当レコードを見つけました。黄色い該当レコードをクリックすると次の該当行へジャンプします。");
	} else if (key.length > 0){
		alert(key + " を含むレコードは見つかりませんでした");
    }
}

function showRecords(){
	// レコードを表示する
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "10pt";
	
	// title
	var tr = newTR(tbl, "", "");
	tr.style.backgroundColor = "#8db";
	var td = newTD(tr, "", "");
	td.style.width = "10 px";
	var cb = newCHECKBOX(td, "", "", false);
	cb.setAttribute("onclick", "checkAll(this)");
	var td = newTD(tr, "", "code");
	var td = newTD(tr, "", "requestCode");
	var td = newTD(tr, "", "alias");
	var td = newTD(tr, "", "name");
	var td = newTD(tr, "", "point");
	var td = newTD(tr, "", "unit");
	var td = newTD(tr, "", "generic");
	var td = newTD(tr, "", "effect");
	var td = newTD(tr, "", "memo");
	
	// records
	array = priceRecords();
	array.sort(compare);　// 新規レコードが追加された場合にそなえ obj.code でソート
    for (i in array){
		var obj = array[i];
		var tr = newTR(tbl, "row"+i, "");
		
		// check box
		var td = newTD(tr, "checkArea."+i, "");
		td.style.width = "10 px";
		var cb = newCHECKBOX(td, "cb."+i, "", false);
		
		var td = newTD(tr, "", obj.code);
		var td = newTD(tr, "", obj.requestCode);
		var td = newTD(tr, "", obj.alias);
		td.setAttribute("onmouseout", "resetColor(this,'black','white')");
		td.setAttribute("onmouseover", "setColor(this, 'yellow', 'blue')");
		td.setAttribute("onclick", "openEditor('"+i+"')");
		
		var td = newTD(tr, "", obj.name);
		var td = newTD(tr, "", obj.point);
		var td = newTD(tr, "", obj.unitName);
		var td = newTD(tr, "", obj.generic);
		var td = newTD(tr, "", obj.effect);
		var memo = (obj.memo) ? obj.memo.substr(0,5)+"..." : "";
		var td = newTD(tr, "", memo);
		
		// 編集エリアを生成しておく
		var eid = editorIdForRow(i);
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, eid, "");
		td.setAttribute("colspan", "6");
	}
    
	// 編集エリアを生成しておく
	var eid = editorIdForRow(array.length);
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, eid, "");
	td.setAttribute("colspan", "6");
	
	// save ボタンを表示
	showSaveButtons();
    
	// confirmKey が指定されていればそれを実行して更新されたレコードを指し示す
	if (confirmKey() && (confirmKey().length > 0)){
		findRecordWith(confirmKey(), "no comment");
	}
	
	function compare(obj1, obj2){
		// obj.code + obj.alias でソート
		var key1 = obj1.code + " " + obj1.alias;
		var key2 = obj2.code + " " + obj2.alias;
		
		if (key1 == key2)
			return 0;
		else if (key1 > key2)
			return 1;
		else
			return -1;
	}
}

function initPriceList(){
	var fromNOA = (mode() == "NOA") ? true : false;
	
	var elm = document.getElementById("base");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
	
    // HEADER
    var div = newDIV(elm, "tool-header");
	var tbl = newTABLE(div, "base-table");
    tbl.style.fontSize = "10pt";
	var tr = newTR(tbl, "", "");
    // TITLE
	var td = newTD(tr, "left-side", "");
    td.setAttribute("onclick", "suserPrice()");
    var sp = newSPAN(td, "markArea");
    var tx = newTEXT(td, "PriceList ( 点数テーブル ) 編集");
	// HELP icon
	var td = newTD(tr, "right-side", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "priceListHelp()");
	im.style.height = "20px";
	im.style.verticalAlign = "bottom";
    
	// ロード・エリア
	if (! fromNOA){
        var div = newDIV(elm, "loadButtonArea");
        div.style.fontSize = "10pt";
        var sp = newSPAN(div, "sourceListArea"); // データソースを表示
        var sp = newSPAN(div, "fileNamesArea"); // テンプレートのリストを表示
        var tx = newTEXT(div, " を ");
        var bt = newBUTTON(div, "", "読込む");
        bt.setAttribute("onclick", "load()");
        var sp = newSPAN(div, "removeButtonArea"); // テンプレートのリスト削除ボタン
    }
    
	// セーブ・エリア
    var div = newDIV(elm, "saveButtonArea");
    
    // データ表示エリア
    var div = newDIV(elm, "controlArea");
   
	// FOOTER
    var div = newDIV(elm, "tool-footer");
	var tbl = newTABLE(div, "base-table");
    tbl.style.fontSize = "10pt";
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "left-side", version());
	
	// メッセージ・エリア
	var div = newDIV(elm, "message");
	
	_addMode = false;
	if (fromNOA){
		var fd = newHIDDEN(elm, "sourcePopup", "データベース");
		load(showRecords,'PRICE');
	} else {
		// ソースデータ・ポップアップを読込む
		showSourceSelector(["テンプレート","バックアップ","データベース"]);
	}
}

function version(){
	return "Ver.1201206";
}
