
<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        $array = explode("%xa;", $val); // DocMaker の Image 用
        $val = implode("\\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function rootDir(){
        // $rootDir = "../../" のような指定方法では認識されず "" になってしまう
        // return "./"; // infoSack 単体で動かす場合
        
        return "../NOA_ARCHIVE/";
    }
    
    function infoSack(){
        // ファイルを保存する directory を返す
        $dir = rootDir()."infoSack";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    
    function listBox(){
        // データファイルを保存する directory を返す
        $dir = infoSack()."/list";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    
    function fileBox(){
        // 画像ファイルを保存する directory を返す
        $dir = infoSack()."/file";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    

    
    $command = $_POST['command'];
    $id = $_POST['id'];
    $value = $_POST['value'];
    $value = decodeSTRING($value);

    if (strcmp($command,"PUT_GROUP") == 0){
        $dir = infoSack();
        $filename = "$dir/group.txt";
        
        echo "<SEPARATOR>";
        if (!$handle = fopen($filename, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "ERROR: Cannot open file ($filename)";
        } else {
            if (fwrite($handle, $value) === FALSE) {
                // オープンしたファイルに$buffを書き込む
                echo "ERROR: Cannot write to file ($filename)";
            } else {
                echo "group を ($filename) に保存しました";
                fclose($handle);
            }
        }
    } else if (strcmp($command,"GET_GROUP") == 0){
        $dir = infoSack();
        $filename = "$dir/group.txt";
        
        echo "<SEPARATOR>";
        $handle = @fopen($filename, "r");
        if ($handle) {
            while (!feof($handle)) {
                $buffer = fgets($handle, 4096);
                // ## ブラウザーの設定により好みのコードに変更可
                //$buffer = mb_convert_encoding($buffer, "SJIS", "UTF-8");
                echo "$buffer";
            }
            fclose($handle);
        } else {
            echo "ERROR: *** $patientId のデータはみつかりません";
        }
    } else if (strcmp($command,"PUT_INFO") == 0){
        // infoSack のデータ・オブジェクトをサーバへ格納
        $path = listBox()."/$id";
        
        echo "<SEPARATOR>";
        if (!$handle = fopen($path, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "ERROR: Cannot open file ($path)";
        } else {
            if (fwrite($handle, $value) === FALSE) {
                // オープンしたファイルに$buffを書き込む
                echo "ERROR: Cannot write to file ($path)";
            } else {
                echo "group を ($path) に保存しました";
                fclose($handle);
            }
        }
    } else if (strcmp($command,"GET_INFO_LIST") == 0){
        // listBox 内のファイルをリストアップ
        $array = array();
        $dir = listBox();
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // folder は除外する
            $path = "$dir/$filename";
            if (scandir($path)) continue;
            
            // ファイル内容を読み出す
            $handle = @fopen($path, "r");
            if ($handle) {
                $buffer = "";
                while (!feof($handle)) {
                    $st = fgets($handle, 4096);
                    $buffer = "$buffer$st";
                }
                fclose($handle);
                $array[] = $buffer;
            }
        }
        $results = array();
        $results['fileBox'] = infoSack()."/file";
        $results['list'] = $array;

        // groupMenu を取得
        $buffer = "";
        $dir = infoSack();
        $filename = "$dir/group.txt";
        $handle = @fopen($filename, "r");
        if ($handle) {
            while (!feof($handle)) {
                $st = fgets($handle, 4096);
                $buffer = "$buffer$st";
            }
            fclose($handle);
        }
        $results['group'] = $buffer;

        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if ($command == "REMOVE_INFO"){
        $ary = explode('.', $value); // $value = "filename.pdf" 型式
        $fileId = $ary[0];
        $suffix = $ary[1];
        
        echo "fileId($fileId) suffix($suffix) <br>";

        // データオブジェクトを削除
        $path = listBox()."/$fileId";
        unlink($path);
        
        // 画像を削除
        $path = fileBox()."/$value";
        unlink($path);
        
		echo "<SEPARATOR>";
		echo "$path を削除しました";
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }

?>
