

function setLayout(){
	// レイアウトを DB から読み出し FRONT 内容を表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        //_initDebug(true); //##
		//alert("showLayout->"+value);//###

        // サーバからのデータのあるものは上書き
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            if (array[1].length){
                var obj1 = eval('(' + array[1] + ')');
                //alert("== obj1->"+encodeObject(obj1));//##
                var timezones = ["全日"];
                if (obj1.timezones){
                    // obj1.timezones: ",,0000,0600,深夜^,,2200,2400,深夜^,日,0000,2400,休日^,,0845,1215,時間内^,,1445,1715,時間内^" 形式
                    //alert("timezones->"+obj1.timezones);//##
                    var array = obj1.timezones.split("^");
                    for (num in array){
                        var st = array[num];
                        var ary = st.split(",");
                        if (ary.length < 5) continue;
                        
                        var from = ary[2];
                        var to = ary[3];
                        var zone = ary[4];
                        if (zone == "時間内"){
                            timezones.push(from + ".." + to);
                        }
                    }
                }
                //alert("timezones->"+encodeObject(timezones));//##
                
                // 年月ポップアップ・メニューを表示
                // このポップアップ表示とともにサーバへデータを取りにゆくので ここに置く
                showDatePop(timezones);
            }
		}

        document.getElementById("message").innerHTML = "";
	} else
		document.getElementById("message").innerHTML = "Loading Layout...";
}
function getTimeZone(){
	// レイアウトをサーバへリクエスト
    
	xmlHttpObject = createXMLHttpRequest(setLayout);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var args = new Array();
        args['owner'] = parent().owner(); // NOA から引き継いだもの
        args['hospitalId'] = parent().hospitalId(); // NOA から引き継いだもの
        
		var st = "./frontServer.php?command=GET_LAYOUT_PARTS"
        + "&value=" + encodeObject(args);
		//alert("getTimeZone->"+st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

var _entryDate;
function gotMonthlyList(){
	// 再来患者が登録されたことを確認
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			var buff = ary[1];
            //_debug("gotMonthlyList-> "+buff); //##
            // var records = JSON.parse(buff);
            var records = eval('(' + buff + ')');
            //_initDebug(true); //##
            //_debug("records-> "+encodeObject(records)); //##
            
            // 日毎のレコードを表示
            var elm = document.getElementById("contentsArea");
            elm.innerHTML = "";
            var tbl = newTABLE(elm, "/base-table");
            tbl.style.fontSize = "9pt";
            tbl.style.margin = "10px 0";
            
            // TITLE =======================================
            var tr = newTR(tbl, "", "");
            tr.style.borderBottom = "thin solid #aaa";
            var td = newTD(tr, "", "日付");
            var td = newTD(tr, "/valueCol", "人数");
            var td = newTD(tr, "/valueCol", "本人");
            var td = newTD(tr, "/valueCol", "家族");
            var td = newTD(tr, "/valueCol", "国保");
            var td = newTD(tr, "/valueCol", "自費");
            var td = newTD(tr, "/valueCol", "合計");
            
            // TABLE ========================================
            var rows = 0;
            var membTotal = 0;
            var jihiTotal = 0;
            var insTotal = 0;
            var sumTotal = 0;
            
            for (num in records){
                var cols = records[num];
                if (cols.length > 0){
                    var sum = 0;
                    var date = cols[1].substr(8);
                    var week = weekOfDate(cols[1], true);
                    var members = "" + cols[0];
                    var honin = "" + cols[2]; sum += honin * 1;
                    var kazoku = "" + cols[3]; sum += kazoku * 1;
                    var kokuho = "" + cols[4]; sum += kokuho * 1;
                    var jihi = "" + cols[5]; sum += jihi * 1;
                    membTotal += members * 1;
                    jihiTotal += jihi * 1;
                    insTotal += honin * 1 + kazoku * 1 + kokuho * 1;
                    sumTotal += sum * 1;
                    // 6:未収 7:受取額 8:入院/外来 9:新患数 10:点数 は表示省略
                    
                    var tr = newTR(tbl, "/even-color", "");
                    var td = newTD(tr, "", date + " " + week);
                    var td = newTD(tr, "/valueCol", members);
                    var td = newTD(tr, "/valueCol", honin);
                    var td = newTD(tr, "/valueCol", kazoku);
                    var td = newTD(tr, "/valueCol", kokuho);
                    var td = newTD(tr, "/valueCol", jihi);
                    var td = newTD(tr, "/valueCol", "" + sum);
                    
                    rows++;
                }
            }
            
            // TOTAL =========================================
            var tr = newTR(tbl, "", "");
            tr.style.borderTop = "thin solid #aaa";
            var td = newTD(tr, "", "合計");
            var td = newTD(tr, "/valueCol", "" + membTotal);
            var td = newTD(tr, "/valueCol", "(" + rows + "日)");
            var td = newTD(tr, "/valueCol", "" + insTotal);
            td.setAttribute("colspan", "2");
            var td = newTD(tr, "/valueCol", "" + jihiTotal);
            var td = newTD(tr, "/valueCol", "" + sumTotal);
            // AVERAGE =======================================
            var tr = newTR(tbl, "", "");
            var td = newTD(tr, "", "平均");
            var td = newTD(tr, "/valueCol", "" + Math.round(membTotal / rows));
            var td = newTD(tr, "/valueCol", "");
            var td = newTD(tr, "/valueCol", "" + Math.round(insTotal / rows));
            td.setAttribute("colspan", "2");
            var td = newTD(tr, "/valueCol", "" + Math.round(jihiTotal / rows));
            var td = newTD(tr, "/valueCol", "" + Math.round(sumTotal / rows));
		} else
			document.getElementById("contentsArea").innerHTML = value;
	} else {
		var elm = document.getElementById("contentsArea");
        elm.innerHTML = "";
        var sp = newSPAN(elm, "");
        sp.innerHTML = "Loading monthlyList ...";
        sp.style.color = "#f88";
        sp.style.fontSize = "10pt";
        sp.style.padding = "20px";
    }
}
function getMonthlyList(entryDate){
	// 指定月の受診者リストをリクエスト
    _entryDate = entryDate;
    
	xmlHttpObject = createXMLHttpRequest(gotMonthlyList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        // まだ zonePop が生成されていないタイミングでは "0000-2400" を使用
        var zone = "0000-2400";
        var elm = elmFor("zonePop");
        if (elm){
            var st = elm.value;
            var from = "0000";
            var to = "2400";
            var ary = st.split("..");
            if (ary.length > 1){
                from = ary[0];
                to = ary[1];
            }
            zone = from + "-" + to;
        }
		var inStatus = 0; // 入院は無視
		var outStatus = 1; // 外来のみ表示

        var args = new Array();
        args['timeZone'] = zone;
		args['entryDate'] = encodeSTRING(entryDate);
		args['in'] = inStatus;
		args['out'] = outStatus;
        
        var st = "./frontServer.php"
        + "?command=GET_MONTHLY_LIST"
        + "&value=" + encodeObject(args);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function changeZone(elm){
    // 変更された診療時間帯に合致したレコードのみを処理・表示
    getMonthlyList(_entryDate);
}

function showDatePop(timezones){
    // 年月ポップアップ・メニューを表示
    //_initDebug(true); //##
    
	var date = new Date();
	var yy = date.getYear();
	if (yy < 2000) { yy += 1900; }
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
    
    _debug("showDatePop->"+timezones); //##
    var dv = elmFor("monthPopArea");
    dv.innerHTML = "";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "月計表";
    sp.style.paddingRight = "5px";
    
    // 年月ポップアップ・メニュー
    var sp = newSPAN(dv, "");
    var dp = newDatePopUp(sp, "datePop", "", yy, mm, dd, true, getMonthlyList);
    
    // 診療時間帯ポップアップ・メニュー
    var sp = newSPAN(dv, "");
    var dp = newPopupMenu(sp, "zonePop", timezones, "");
    dp.setAttribute("onchange", "changeZone(this)");
}

function initMonthlyTable(){
    // 月計表を初期化：NOA の周辺ツールとして利用される
	// テンプレートで FRONT のヘッダー部分を生成
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // HEADER ===============================================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "monthPopArea/left-side");
    dv.style.width = "90%";
	
	// CONTENTS ==============================================
    var div = newDIV(elm, "contentsArea");
	
	// FOOTER ================================================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "50%";
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "");
    sp.innerHTML = version();
    
    // DB へデータリクエスト・表示は newDatePopUp() がトリガーとなって実行される
    getTimeZone();
}

function version(){
    // since: 131022
    return "Ver.131106";
}