<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

<?php
	
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        return $val;
    }
    
    function decodeArgs($value){
        return explode("_|_", $value);
    }
    
    function decodeRecords($value){
        return explode("_||_", $value);
    }
    
    function decodeArguments($value){
        $records = array();
        $array = decodeRecords($value);
        for ($i=0,$ct=count($array); $i < $ct; $i++){
            $st = $array[$i];
            $ary = decodeArgs($st);
            $records[$ary[0]] = $ary[1];
        }
        return $records;
    }
	
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function arrayForLabels($buff, $separator, $args){
        // $buff 中から $args に含まれるラベルに一致する値を取り出す
        $values = array();
        $ary = explode($separator, $buff);
        if (count($ary) > 1){ // レコードに $separator が含まれれば値を取得
            foreach ($args as $key=>$val){
                // $buff 中から $key に一致する値を取り出し $values へ入れる
                if (strcmp($key, "patientId") == 0) continue; // ここでは使わない
                if (strcmp($key, "separator") == 0) continue; // ここでは使わない
                
                $values[$key] = valueForLabel($buff, $key);
            }
        }
        return $values;
    }
	
    function valueForLabel($buff, $label){
        // $buff 中から $label に一致する値を取り出す
        $pos = strpos($buff, "$label(");
        if ($pos != FALSE){
            $ln = substr($buff, $pos + strlen($label)+1);
            for ($i=0,$nest=0,$len=strlen($ln); $i < $len; $i++){
                if ($ln[$i] == ")")
                    return substr($ln, 0, $i);
            }
        }
        return "";
    }

    function lastFileOf($dir){
        // $dir 内の最後のファイル名を返す
        // ##### $dir は HTTP ではなく FILE-SYSTEM の PATH を示す #####
        $files = scandir($dir, 1); // 逆順にソート
        $count=count($files);
        echo "dir($dir) count($count)\n";
        
        for ($i=0; $i < $count; $i++){
            $filename = $files[$i];
            echo "$i -- ($filename)\n"; //###
            if (strlen($filename) == 0) continue;
            if (substr($filename, 0, 1) == ".") continue;
            echo "== ($filename)\n"; //###
            
            return $filename;
        }
        return NULL;
    }
    
	
    
    $command = $_GET['command']; $command=htmlspecialchars($command);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value); // lib.php
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('../NOA/cfg.php');
    
    $dbc = mysql_connect($db['host'], $db['user'], $db['pwd']);
    $db_select=mysql_select_db($db['dbname']);
    mysql_query("set names utf8");
    
    if (strcmp($command,"GET_PERINATAL_HISTORY") == 0){
        // PerinatalManager で使う
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        
        $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' ORDER BY `entryDate` DESC";
        echo "$sql ----\n"; //##
        $result=mysql_query($sql);
        
        $records = array();
        while ($row=mysql_fetch_array($result)){
            if ($row['freq'] && ($row['freq'] > 0))
                continue; // 削除されたレコードはスキップ
            
            $date = $row['entryDate'];
            $records[$date] = $row['examination'];
        }
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"GET_FORM") == 0){
        // "/USers/*user*/FORM/label/" の最新ファイルを読む
        $args = decodeObject($value);
        $owner = $args['owner'];
        $label= $args['label'];
        //$dir = "../../Users/$owner/FORM/$label"; // /X/NOA
        $dir = "../Users/$owner/FORM/$label";
        
        echo "value: $value \n"; //##
        echo "DIR: $dir \n"; //##
        
        // $dir の下の最新のファイルを読み込む："_" で始まるファイル名は無視
        $filename = lastFileOf($dir);
        echo "filename: $filename \n"; //##
        
        echo "<SEPARATOR>";
        $json = file_get_contents("$dir/$filename");
        echo $json;
    } else
	echo "*** unknown command: $command ***";
    
?>