
var gsArray = {"4":[7,17],"5":[10,25],"6":[14,30],"7":[20,37],"8":[24,45],"9":[30,59],"10":[35,65],"11":[40,80],"12":[48,94]};

var crlArray = {"8":[10,16],"9":[17,24],"10":[25,34],"11":[35,44],"12":[45,55],"13":[56,65]};

var bpdArray = {"11":[12,18],"12":[16,23],"13":[20,27],"14":[24,30],"15":[26,34],"16":[30,37],"17":[32,40],"18":[36,45],"19":[39,48],"20":[42,51],"21":[45,54],"22":[47,57],"23":[52,61],"24":[55,64],"25":[57,67],"26":[59,70],"27":[61,72],"28":[65,75],"29":[67,79],"30":[70,80],"31":[71,82],"32":[74,85],"33":[77,87],"34":[79,89],"35":[80,90],"36":[82,91],"37":[83,92],"38":[84,94],"39":[85,95],"40":[85,95],"41":[85,95],"42":[85,95]};

var efwArray = {"18":[141,232],"19":[186,308],"20":[236,390],"21":[293,481],"22":[357,580],"23":[430,690],"24":[511,809],"25":[602,940],"26":[702,1081],"27":[812,1233],"28":[930,1396],"29":[1057,1568],"30":[1191,1749],"31":[1332,1938],"32":[1477,2133],"33":[1626,2333],"34":[1776,2536],"35":[1926,2740],"36":[2072,2942],"37":[2213,3139],"38":[2345,3330],"39":[2466,3511],"40":[2572,3678],"41":[2660,3828]};

function kickPlotter(answer){
	// メニューの頻度がインクリメントされたレスポンスを得る
    var obj = JSON.parse(answer);
    //alert("kickPlotter->"+encodeObject(obj)); //##
    
    showPlot(obj, plotKey());
    document.getElementById("message").innerHTML = "";
}

function showPlot(records, key){
	// 測定値を標準曲線上にプロットする
	var tbl = document.getElementById("baseTable");
	tbl.innerHTML = "";
	
	// args() 中に最終月経がある場合は、その処理
	var lmpSec = null;
	var lmpSt = lmp();
	if (lmpSt.length >= 10){
		var st = lmpSt.substr(-10);
		var ary = st.split("-");
		var lmpDate = new Date(ary[0], ary[1] - 1, ary[2], 0, 0, 0);
		lmpSec = lmpDate.getTime();
	} else {
		alert("最終月経がわかりません");
		return;
	}
    
	// タイトル
	var tr = newTR(tbl, "header", "");
	var td = newTD(tr, "", "受診日");
	var td = newTD(tr, "", "週数");
	if (showValue()){
		var td = newTD(tr, "", "min");
		var td = newTD(tr, "", "mm");
		var td = newTD(tr, "", "max");
	}
	var td = newTD(tr, "", key + " 測定値を基準曲線へプロット");
    
	// obj から週数と計測値とのテーブルを生成しておく
	// 週数は日数を加味し四捨五入したものとする
	var values = new Array();
	var dates = new Array();
	var gdates = new Array();
	var oldRec;
	for (timeStamp in records){ // 受診日ごとのデータを解析
        var ln = trim(records[timeStamp]);
        if (!ln || (ln.length == 0)) continue;
        
        var obj = decodeObject(ln); // "妊婦健診(BPD(..)体重(..),,, )"
        var rec = obj[formLabel]; // "BPD(..)体重(..),,, "
        if (!rec) continue;
        
		var date = shortDate(timeStamp);
		var day = gestateDay(lmpSec, date);
		var gw = Math.floor(day / 7);
		var gd = day - gw * 7;
        
		// gd が 4日以上ならひとつ上の週の値として記憶しておく
		if (gd >= 4)
			values[gw+1] = measureOf(key, rec);
		else
			values[gw] = measureOf(key, rec);
		dates[gw] = date;
		gdates[gw] = gd;
		oldRec = rec;
	}
	
	// obj = {"2009-02-09 18:57:18":["val","val",,,],,,} 形式
	for (var w=41; w > 4; w--){
        var val = values[w];
		var bar = plotBar(key, w, val);
		var date = dates[w];
		var gd = (gdates[w]) ? gdates[w] : 0;
		
		var tr = newTR(tbl, "", "");
		tr.style.textAlign = "right";
		var td = newTD(tr, "", date);
		var td = newTD(tr, "", w + "w" + gd + "d");
		if (showValue()){
			var td = newTD(tr, "", minVal(key, w));
            var td = newTD(tr, "", (val) ? val + "" : "");
			var td = newTD(tr, "", maxVal(key, w));
		}
		var td = newTD(tr, "", bar);
		td.style.textAlign = "left";
		if (w <= 0) break; // w が０ 以下は表示不要
	}
	
    
	function minVal(key, week){
		if (key == "GS"){
			var obj = gsArray[week];
			return (obj) ? obj[0]+"" : "";
		} else if (key == "BPD"){
			var obj = bpdArray[week];
			return (obj) ? obj[0]+"" : "";
		} else if (key == "CRL"){
			var obj = crlArray[week];
			return (obj) ? obj[0]+"" : "";
		} else if (key == "EFW"){
			var obj = efwArray[week];
			return (obj) ? obj[0]+"" : "";
		}
		return "?";
	}
	
	function maxVal(key, week){
		if (key == "GS"){
			var obj = gsArray[week];
			return (obj) ? obj[1]+"" : "";
		} else if (key == "BPD"){
			var obj = bpdArray[week];
			return (obj) ? obj[1]+"" : "";
		} else if (key == "CRL"){
			var obj = crlArray[week];
			return (obj) ? obj[1]+"" : "";
		} else if (key == "EFW"){
			var obj = efwArray[week];
			return (obj) ? obj[1]+"" : "";
		}
		return "?";
	}
	
	function measureOf(key, rec){
		// key に対応する値を rec から取り出して返す
		// key は "GS","BPD" など
		var st = rec[key];
		if (st){
			var array = st.split(" ");
			return trim(array[0]) * 1;
		} else
			return null;
	}
	
	function plotBar(key, week, val){
		// week に相当した基準範囲に val をプロットしたバーを返す
		var array = new Array();
		var obj;
		if (key == "GS"){
			obj = gsArray[week];
		} else if (key == "BPD"){
			obj = bpdArray[week];
		} else if (key == "CRL"){
			obj = crlArray[week];
		} else if (key == "EFW"){
			obj = efwArray[week];
		}
		if (obj){
			var min = obj[0];
			var max = obj[1];
			if (key == "EFW"){
				min = Math.floor(min/39);
				max = Math.floor(max/39);
			}
			for (var i=0; i < 100; i++) array[i] = "_";
			for (var i=min; i < max; i++) array[i] = "=";
			if (val){
                // val は整数値でないとプロットできないので、小数点以下切捨て
				if (key == "EFW") 
					val = Math.floor(val/39);
                else
                    val = Math.floor(val);
				array[val] = "#";
			}
		}
		return array.join("");
	}
	
	function gestateDay(lmpSec, visitDate){
		// lmpSec, date から "8w0d" 形式で妊娠週数を返す
		var yy = 2000 + visitDate.substr(0, 2) * 1;
		var mm = visitDate.substr(2, 2) * 1;
		var dd = visitDate.substr(4, 2) * 1;
		var date = new Date(yy, mm - 1, dd, 0, 0, 0);
		var visitSec = date.getTime();
		var diffDay = (visitSec - lmpSec) / (1000*60*60*24);
		return diffDay;
	}
}
