/////////////////////////////////////
///// ACCESSS LOG ///////////////////

function opneLogChart(mode, patientId, patientName){
    // waitingList accessLog から呼ばれる
    if ((mode == 0) && isShiftDown()){ // mode -- 0:履歴 1:待受
        var st = patientId+ " " + patientName + " の行を削除していいですか";
        if (confirm(st)){
            var args = new Object();
            args["owner"] = cp_owner();
            args["patientId"] = patientId;
            NRCall("REMOVE_ACCESS_LOG", args, gotAccessLog);
        }
    } else {
        closeFloatPanel();
        if (openEachNOA2()) // localStorage.js
            window.open("top.php?patientId=" + patientId, "_blank");
        else
            openChart(patientId);
    }
}

var _accessLog;
function sortAccessLog(){
    // 受付日時で逆ソートする
    var status = (accessLogReverse()) ? "" : "1";
    setAccessLogReverse(status);
    
    var args = new Object();
    args["owner"] = owner();
    args["reverse"] = status;
    NRCall("GET_ACCESS_LOG", args, gotAccessLog);
}

function dateCompare(a, b){
    // a, b を日付で逆順に比較
    
    var dateA = dateWithString(a.date);
    var dateB = dateWithString(b.date);
    
    return (dateA > dateB) ? 0 : 1;
}
function gotAccessLog(answer){
    var x = 10;
    var y = 80;
    var w = 400;
    var title = "受診履歴";
    var action = "openHelp('./accessLogHelp.html')";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, action);
    var div = newDIV(elm, "");
    
    // TITLE
	var tbl = newTABLE(div, "/base-table");
    tbl.style.fontSize = "9pt";
    var tr = newTR(tbl, "", "");
    tr.parentNode.style.borderBottom = "thin solid #888";
    var td = newTD(tr, "bookingSortTab", "参照年月日");
    td.style.width = "140px";
    var td = newTD(tr, "", "カルテID");
    td.style.width = "70px";
    var td = newTD(tr, "", "氏名");
    td.style.width = "150px";
    
    var dv = newDIV(div, "");
	dv.style.height = "200px";
	dv.style.overflow = "auto";
    var tbl = newTABLE(dv, "/base-table");
    tbl.style.fontSize = "9pt";
    
    // RECORDS
    var array = JSON.parse(answer);
    var log = new Array();
    for (num in array){
        var rec = array[num];
        var tr = newTR(tbl, "/logRow", "");
        var action = "opneLogChart(0,'" + rec.pid + "','" + rec.name + "')"
        tr.setAttribute("onclick", action);
        var td = newTD(tr, "", rec.date);
        td.style.width = "140px";
        var td = newTD(tr, "", rec.pid + ""); // 数値だと表示されない
        td.style.width = "70px";
        var td = newTD(tr, "", rec.name);
        td.style.width = "150px";
    }
    
    // FOOOTER
    var dv = newDIV(elm, "");
    dv.style.fontSize = "9pt";
    dv.style.paddingLeft = "5px";
    dv.style.borderTop = "thin solid #888";
    var sp = newSPAN(dv, "/listMember");
    sp.innerHTML = "逆順に表示";
    sp.setAttribute("onclick", "sortAccessLog()");
    sp.style.marginRight = "10px";
    var cb = newCHECKBOX(dv, "", "カルテを別ウインドーで開く", openEachNOA2());
    cb.setAttribute("onchange", "setOpenEachNOA2(this)");
}

function showAccessLog(){
    // カルテのアクセス・ログを表示：TOOL MENU から使う
    // status が "1" なら逆順にソート
    var status = (accessLogReverse()) ? "1" : "";
    
    var args = new Object();
    args["owner"] = owner();
    args["reverse"] = status;
    NRCall("GET_ACCESS_LOG", args, gotAccessLog);
}

