

var _records;
function setRecords(array){
	// 読込まれたレコードを記憶
	_records = array;
}
function records(){
	return _records;
}
function recordAtIndex(ix){
	return _records[ix];
}

///////////////////////////
/// Ajax による処理 /////////

function searched(answer){
    //alert("searched ===\n"+answer);//##
    var objects = eval('(' + answer + ')');
    setRecords(objects);
    showResult();
}
function glm_search(){
	// 検索キーによりデータを検索
	var code = document.getElementById("codeF").value;
	var key = document.getElementById("keyF").value;
	
	if (code.length + key.length == 0){
		alert("検索キーが指定されていません");
		return;
	}
	
    var args = new Object();
    args["code"] = code;
    args["name"] = key;

    _callServer("GET_GLOBAL_PRICE", "sysServer.php", args, searched);
}

function closeDebug(){
    document.getElementById("_debug").innerHTML = "";
}
function puttedGlobalToPrice(answer){
    //alert("puttedPriceList ===\n"+answer);//##
    var elm = document.getElementById("_debug");
    var div = newDIV(elm, "");
    div.style.borderBottom = "thin solid #aaa";
    div.style.marginBottom = "5px";
    var img = newIMAGE(div, "", "./close.png", "close");
    img.setAttribute("onclick", "closeDebug()");
    var sp = newSPAN(div, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "以下のレコードが PriceList へ上書きされました";
    if (answer.length > 1){
        var div = newDIV(elm, "");
        div.innerHTML = answer;
    }
    div.innerHTML += "PriceList の該当レコードがグローバル辞書で更新されました";
}
function putGlobalToPrice(){
	// グローバル辞書から PriceList へ同じ requestCode のレコードを書き込む
    _callServer("PUT_GLOBAL_TO_PRICE", "sysServer.php", null, puttedGlobalToPrice);
}

function checkedPriceListGlobal(answer){
    //alert("checkedPriceListGlobal ===\n"+answer);//##
    if (answer.length){
        // テーブルの新規生成メッセージがあった場合、表示
        st = answer + "<br/>*** データベースを調整しました";
        showMessage("_message", st);
    }
}
function checkPriceListGlobal(){
	// グローバル辞書の有無をチェック
    _callServer("CREATE_TABLE_IF_NEEDED","sysServer.php",null,checkedPriceListGlobal);
}

/// Ajax による処理 /////////
///////////////////////////

function showResult(){
    // グローバル辞書での検索結果をリストアップ    
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
    tbl.style.width = "100%";
    tbl.style.fontSize = "10pt";
	
	// title
	var tr = newTR(tbl, "", "");
	tr.style.backgroundColor = "#8db";
	var td = newTD(tr, "/list-label", "code");
	var td = newTD(tr, "/list-label", "requestCode");
	var td = newTD(tr, "/list-label", "name");
	var td = newTD(tr, "/list-label", "point");
	var td = newTD(tr, "/list-label", "unitName");
	var td = newTD(tr, "/list-label", "handanCode");
	var td = newTD(tr, "/list-label", "effectCode");
	var td = newTD(tr, "/list-label", "enforceDate");
	
	// records
	array = records();
    for (num in array){
		var obj = array[num];
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "/underLine", obj.code);
		var td = newTD(tr, "/underLine", obj.requestCode);
		var td = newTD(tr, "/underLine", obj.name);
		var td = newTD(tr, "/underLine", obj.point);
		var td = newTD(tr, "/underLine", obj.unitName);
		var td = newTD(tr, "/underLine", obj.handanCode);
		var td = newTD(tr, "/underLine", obj.effectCode);
		var td = newTD(tr, "/underLine", obj.enforceDate);
	}
}

function viewLoadPane(){
	// CSV を閲覧するためのペーンを表示
	var elm = document.getElementById("controlArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "rootTable");
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "");
	td.innerHTML = "厚労省「診療行為マスター」「医薬品マスター」などの CSV データを直接閲覧するツールです。「厚労省マスター」の CSV ファイルは <a HREF='http://www.iryohoken.go.jp/shinryohoshu/downloadMenu/' target='_blank'>厚労省の Web サイト</a> から download できます。当面は「医科診療行為マスター」「医薬品マスター」の２つに対応しています。";
	
	// ファイル選択ボタン
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var fm = newFORM(td, "filename", "閲覧", "viewCSV.php");
	fm.setAttribute("target","_blank");
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "");
	td.innerHTML = "グローバル辞書への組込みは上のメニュー「CSV をグローバル辞書へ」で行います。";

	function newFORM(elm, name, label, action){
		// FORM を生成
		var fm = document.createElement('FORM');
		fm.setAttribute("METHOD", "POST");
		fm.setAttribute("enctype", "multipart/form-data");
		fm.setAttribute("ACTION", action);
		elm.appendChild(fm); 
		var tbl = newTABLE(fm, "controlTable");
		
		// ファイル・アップロード・ボタン
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "fm_col", "");
		var ip1 = document.createElement('INPUT');
		ip1.setAttribute("TYPE", "file");
		ip1.setAttribute("NAME", name);
		td.appendChild(ip1); 
		
		// submit(送信)ボタン
		var ip2 = document.createElement('INPUT');
		ip2.setAttribute("TYPE", "submit");
		ip2.setAttribute("VALUE", label);
		ip2.setAttribute("onclick", "closeUploadPane()");
		td.appendChild(ip2); 
		
		return fm;
	}
}

function showLoadPane(){
	// CSV から読込むためのペーンを表示
	var elm = document.getElementById("controlArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "rootTable");
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "厚労省「診療行為マスター」「医薬品マスター」などの CSV データをグローバル辞書へ読込む。");
	
	// ファイル選択ボタン
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var fm = newFORM(td, "filename", "読込", "uploadCSV.php");
	fm.setAttribute("target","_blank");
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "");
	td.innerHTML = "　CSV ファイルは /NOA_DB　の下にまずコピーされ、さらにグローバル辞書へ読込まれます。CSV は巨大で読込みにはちょっと時間がかかります。読込み終了しないうちにウインドーを閉じると不成功に終わる場合があります。<br/>　読込み状況を表示する画面の最下段に「..行のレコードが更新されました」というメッセージが表示されるまでウインドーを閉じないでください。";
	
	function newFORM(elm, name, label, action){
		// FORM を生成
		var fm = document.createElement('FORM');
		fm.setAttribute("METHOD", "POST");
		fm.setAttribute("enctype", "multipart/form-data");
		fm.setAttribute("ACTION", action);
		elm.appendChild(fm); 
		var tbl = newTABLE(fm, "controlTable");
		
		// ファイル・アップロード・ボタン
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "fm_col", "");
		var ip1 = document.createElement('INPUT');
		ip1.setAttribute("TYPE", "file");
		ip1.setAttribute("NAME", name);
		td.appendChild(ip1); 
		
		// submit(送信)ボタン
		var ip2 = document.createElement('INPUT');
		ip2.setAttribute("TYPE", "submit");
		ip2.setAttribute("VALUE", label);
		ip2.setAttribute("onclick", "closeUploadPane()");
		td.appendChild(ip2); 
		
		return fm;
	}
}

function showGlobalPane(){
	// グローバル辞書を閲覧するペーンを開く
	var elm = document.getElementById("controlArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "subTable");
    tbl.style.fontSize = "11pt";
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "グローバル辞書は「厚労省マスター」などから作成された辞書、PriceList は個人用辞書です。");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "NOA は PriceList しか使いませんが、そこにない処置・検査・薬剤などを使いたい場合、NOA のメニューから「...その他」を選択すればグローバル辞書のデータを PriceList へコピーして使える仕組みになっています。PriceList 編集ツールで読込むこともできます。");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "ここではグローバル辞書にどんなレコードがあるかを検索できます。");
	
	// controls
	var tr = newTR(tbl, "", "");
	
	var td = newTD(tr, "", "code ");
	td.style.backgroundColor = "#8db";
	td.style.padding = "0px 5px";
	var fd = newFIELD(td, "codeF", "", 3, "");
	fd.focus();
	
	var fd = newFIELD(td, "keyF", " name ", 20, "");
	fd.setAttribute("onchange","glm_search()");
	
	var bt = newBUTTON(td, "", "検索");
	bt.setAttribute("onclick","glm_search()");
	
	// results
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "resultArea", "");
}

function showRenewPane(){
	// PriceListGlobal のデータを PriceList へ書き込む
	var elm = document.getElementById("controlArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "rootTable");
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "PriceList の requestCode（請求コード）を元にグローバル辞書から同じレコードを探し PriceList へ上書きします。");
	// control
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "グローバル・レコードを PriceList へ ");
	var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "書き込む";
	bt.setAttribute("onclick","putGlobalToPrice()");

	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "comment", "投与量の default 値やメモなど、ユーザが設定する部分は上書きされません。");
}

var _oldTab;
function tabSelected(elm, num){
	// タブが選択された
	if (_oldTab){
		_oldTab.style.color = "#000";
		_oldTab.style.backgroundColor = "#8db";
	}
	_oldTab = elm;
	elm.style.color = "#000";
	elm.style.backgroundColor = "#fff";
    //setChangeColor(elm, '#000', '#fff');
	
	switch (num * 1){
		case 0: viewLoadPane(); break;
		case 1: showLoadPane(); break;
		case 2: showGlobalPane(); break;
		case 3: showRenewPane(); break;
	}
	document.getElementById("message").innerHTML = "";
}

function initGlobalMaster(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // HEADER
    var div = newDIV(elm, "");
    div.innerHTML = "グローバル辞書";
    div.style.textAlign = "left";
    div.style.paddingLeft = "10px";
    div.style.fontSize = "10pt";

    // TAB
    var div = newDIV(elm, "");
    div.style.marginTop = "8px";
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "tab");
    sp.style.borderRadius = "10px 10px 0px 0px";
    sp.innerHTML = "CSV を閲覧";
	sp.setAttribute("onclick","tabSelected(this,'0')");
    var sp = newSPAN(div, "tab");
    sp.style.borderRadius = "10px 10px 0px 0px";
    sp.innerHTML = "CSV をグローバル辞書へ";
	sp.setAttribute("onclick","tabSelected(this,'1')");
    var sp1 = newSPAN(div, "tab");
    sp1.style.borderRadius = "10px 10px 0px 0px";
    sp1.innerHTML = "グローバル辞書";
	sp1.setAttribute("onclick","tabSelected(this,'2')");
    var sp = newSPAN(div, "tab");
    sp.style.borderRadius = "10px 10px 0px 0px";
    sp.innerHTML = "グローバル辞書で PriceList を更新";
	sp.setAttribute("onclick","tabSelected(this,'3')");

    // CONTROLS
    var div = newDIV(elm, "controlArea");

    // FOOTER
    var div = newDIV(elm, "/tool-footer");
    div.style.marginTop = "5px";
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
    
	// 2番目の tab を選択
	tabSelected(sp1, 2);
	
	// グローバル辞書の有無をチェック
	checkPriceListGlobal();
}

function version(){
	return "Ver.140628";
}
