
function setGroupMenu(menus){
    // カテゴリーの配列を menus で置換
    var newObj = new Object();
    var obj = infoList();
    for (num in menus){
        var category = menus[num];
        if (category == "...その他") continue;

        newObj[category] = menusForCategory(category);
    }
    
    // infoList を newObj で置換
    setInfoList(newObj);
    showGroupMenu(_checkedGroups);
}
function groupMenu(){
    // グループメニューを返す
    var obj = infoList();
    var menus = [];
    for (category in obj){
        menus.push(category);
    }
    menus.push("...その他");
    return menus;
}
function removeGroupMenu(category){
    // category をグループメニューから削除
    var newObj = new Object();
    var obj = infoList();
    for (ctg in obj){
        if (ctg == category) continue;
        newObj[ctg] = obj[ctg];
    }
    setInfoList(newObj);
    showGroupMenu(_checkedGroups);
}

////////////////////////////////////////////////////////////////
///// Ajax /////////////////////////////////////////////////////

function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_id) return; // 自分自身は無視
    
    // drop_id の位置と target_id の位置をスワップ
    var menus = [];
    var array = groupMenu();
    for (num in array){
        var id = array[num] + ".lid";
        
        // target_node.id の位置に drop_id node を挿入
        if (id == target_node.id){
            var ary = drop_id.split('.');
            drop_menu = ary[0];
            
            menus.push(drop_menu);
        }
        if (id != drop_id)
            menus.push(array[num]);
    }
    // カテゴリーの配列を menus で置換
    setGroupMenu(menus);
}

function uploadFileName(){
    // ファイル・セレクターで選択されたファイル名を返す
    var fileSelector = elmFor("imageFile");
    var st = fileSelector.value; // "C:\fakepath\filename.pdf" 型式
    var ary = st.split('\\');
    
    return ary[ary.length - 1];
}

function save(){
    // ファイル情報をサーバへ保存
    var obj = new Object();

    // ファイル ID
    var nodes = document.getElementsByName("fileId"); // NAME では配列が返される
    obj.id = nodes[0].value;
    
    // URL
    obj.url = (elmFor("urlF")) ? elmFor("urlF").value : "";
    
    // ファイルの接尾語
    obj.suffix = elmFor("suffixF").value;
    
    // ラベル
    obj.label = elmFor("labelF").value;
    
    // カテゴリー
    var array = [];
    var menus = groupMenu();
    for (num in menus){
        var menu = menus[num];
        var cbox = elmFor(menu + ".id");
        if (cbox && cbox.checked) array.push(menu);
    }
    obj.group = array.join('^');
    if (array.length == 0) // ひとつもチェック入っていなければ未分類とする
        obj.group = "未分類";
    
    // サーバへ保存
    changeInfoList(obj);
    saveInfoList();
    closeFloatPanel();
}

///// Ajax /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
///// カテゴリーの DRAG and DROP /////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var categoryName = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(categoryName);
    
    if (event.currentTarget.id == "garbageArea"){
        var array = categoryName.split('.'); // categoryName = "labelName.lid" 形式
        var menu = array[0];
        if (confirm(menu + " を削除していいですか")){
            removeGroupMenu(menu);
        }
    } else {
        //ドロップ先にドラッグされた要素を追加
        moveTo(categoryName, event.currentTarget);
    }
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}

var _checkedGroups;
function showGroupMenu(checkedGroups){
    // カテゴリーを生成
    var area = elmFor("groupPopArea");
    area.innerHTML = "";
    
    var checkArray = [];
    if (checkedGroups){
        checkArray = checkedGroups.split('^');
    }
    
    var menus = groupMenu();
    for (num in menus){
        var div = newDIV(area, "");
        var menu = menus[num];
        if (menu == "...その他"){
            var dv = newDIV(div, "/clearfix");
            var label = newDIV(dv, "/listMember");
            label.innerHTML = menu;
            label.setAttribute("onclick", "newGroupName()");
            label.style.paddingRight = "10px";
        } else {
            var sp = newSPAN(div, "/group-menu");
            var status = (arrayHasItem(checkArray, menu)) ? 1 : 0;
            var cb = newCHECKBOX(sp, menu + ".id", "", status);
            var label = newSPAN(sp, menu + ".lid");
            label.innerHTML = menu;
            label.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
            label.setAttribute("ondragstart", "f_dragstart(event)");
            label.setAttribute("ondragover", "f_dragover(event)");
            label.setAttribute("ondrop", "f_drop(event)");
        }
    }
    var div = newDIV(area, "garbageArea");
    div.style.backgroundColor = "#ffd";
    div.style.color = "#888";
    div.style.fontSize = "9pt";
    div.style.padding = "5px 8px";
    div.style.border = "thin solid #ccc";
    div.style.borderRadius = "10px";
    div.setAttribute("ondragover", "f_dragover(event)");
    div.setAttribute("ondrop", "f_drop(event)");
    var img = newIMAGE(div, "", "garbage-can.png", "garabage can");
    img.style.height = "15px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "カテゴリーをここに drop し削除できます";
    sp.style.paddingLeft = "5px";
}

///// カテゴリーの DRAG and DROP /////////////////////////////////
////////////////////////////////////////////////////////////////



function newGroupName(){
    // 新規カテゴリーを追加
    var name = prompt("新規カテゴリーを入力してください");
    if (name.length > 0){
        // category をグループメニューに追加
        if (arrayHasItem(groupMenu(), name)){
            alert(name + " はすでに存在します");
        } else {
            replaceInfoList(name, []);
            showGroupMenu(_checkedGroups);
        }
    }
}

function upload(){
    // form を submit し画像をアップロード
    // 画像ファイル名を default 値としてラベル欄に表示
    var st = uploadFileName();
    
    var pos = st.lastIndexOf('.');
    var title = (pos > 0) ? st.substr(0, pos) : st; // suffix を除去した文字列
    elmFor("labelF").value = title;
    
    // suffix が save() で必要になるので記憶しておく
    elmFor("suffixF").value = suffix(st);

    console.log("uploadFileName", uploadFileName()); //##
    console.log("title", title); //##
    console.log("suffix", suffix(st)); //##

    // 画像ファイルを読み込んだ場合 URL は空にする
    elmFor("urlF").value = "";
    
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    // 以下の画面書き換えを行うとアップロードが中断され失敗するようだ
    // window.location.reload(true);
}

function infoEditHelp(){
	// ヘルプパネルを表示
    window.open("./infoEditHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openEditor(fileId){
    // 編集パネルを開く
    var addMode = (fileId) ? false : true;
    var panel = new FloatPanel("_floatPanel", 10, 40, 350, "編集パネル");
    var elm = panel.contents;
    
    if (addMode){ // 新規データ 
        fileId = todayAndTimeId();
        var label = "";
        var sfx = "";
        var url = "";
    } else { // 既存データの編集
        var rec = recordForId(fileId);
        var label = rec.label;
        var groups = rec.group;
        var sfx = rec.suffix;
        var url = rec.url;
    }
    
    // === FORM を生成 =============================
    var fm = newFORM(elm, "pictServer.php"); // submit で起動される URL
    fm.setAttribute("id", "uploadForm");
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("target", "iframeElement"); // iframe を指定
    fm.style.backgroundColor = "#ffe";
    fm.style.padding = "10px";
    fm.style.borderRadius = "10px";
    
    // === FIELD ID
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    dv.innerHTML = "ID";
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = fileId;
    dv.style.fontSize = "10pt";
    dv.style.color = "#555";
    // サーバへ ID を送るには newFIELD() タイプの必要あり
    // ### fd.setAttribute("disabled","disabled") だと FORM で送られないので表示は上記型式
    var fd = newFIELD(dv, "", "", 30, fileId);
    fd.setAttribute("NAME", "fileId"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    // === URL
    if (addMode || (url && url.length)){
        var div = newDIV(fm, "/clearfix");
        var dv = newDIV(div, "/label");
        dv.innerHTML = "URL";
        var dv = newDIV(div, "/left-side");
        var fd = newFIELD(dv, "urlF", "", 40, (url) ? url : "");
    }

    if (addMode){ // 新規データ
        // === ファイル選択ボタン ========================
        var dv = newDIV(fm, "file");
        var bt = newUploadBUTTON(dv, "imageFile", "files[]");
        // アップロード・ボタン 
        // ### iframe を使うにはここがキモ ###
        // form を見せない形で処理するため submit-button 機能を別に作成
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "転送";
        bt.setAttribute("onclick", "upload()");
        
        // === データ戻り先として iframe を作成 ===========
        // ### iframe を使うにはここがキモ ###
        var dv = newDIV(fm, "");
        //    dv.style.display = "none"; // 表示しない
        var fr = newIFRAME(dv, "iframeElement");
        fr.style.height = "70px";
        fr.style.width = "280px";
        fr.style.fontSize = "8pt";
        fr.style.color = "#aaa";
        fr.style.border = "thin solid #fff";
    }
    
    // === ラベル名
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    dv.innerHTML = "ラベル";
    var dv = newDIV(div, "/left-side");
    var fd = newFIELD(dv, "labelF", "", 40, label);
    
    // === 接尾語
    var fd = newFIELD(fm, "suffixF", "", "", sfx);
    fd.setAttribute("NAME", "suffix"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    // === owner
    var fd = newFIELD(fm, "owner", "", "", _owner());
    fd.setAttribute("NAME", "owner"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    
    // === カテゴリー
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "groupLabel/label");
    dv.innerHTML = "カテゴリー";
    var dv = newDIV(div, "/left-side");
    var sp = newSPAN(dv, "groupPopArea");
    showGroupMenu(groups);
    
    // === key：pictServer への COMMAND を設定
    var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
    fd.setAttribute("NAME", "key"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    var dv = newDIV(div, "/right-side");
    dv.style.fontSize = "9pt";

    // FOOTER =====================================
    var div = newDIV(elm, "");
    div.style.textAlign = "right"
    // 保存ボタン
    var bt = newDIV(div, "uploadButton/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "save()");
}
