<?php
    
    $imageArray;
    
    function pickupImages($buff){
        // $buff 中の "<IMG:..url..>" 部分を "IMAG(num)" に置換し
        // url のリストを文末に並べる
        $array = explode("<IMG:", $buff);
        $images = count($array);
        global $imageArray; // $buff 用に予約
        if ($images < 2) return $buff;
        
        // テキスト src 中の "<IMG:url>" の部分を "IMAGE(num)" に置換し
        // url のリスト images を生成
        $buff = $array[0]; // left side
        for ($i=0; $images > $i; $i++){
            $st = $array[$i];
            if ($i == 0) continue; // left side
            $array2 = explode(">", $st);
            if (count($array2) > 1){
                $imageArray[] = $array2[0]; // URL
                $buff = "$buff *IMAGE( $i ) ".$array2[1]; // pertial right side
            } else
                $buff = "$buff$st";
        }
        return $buff;
    }
    
    function getChartContens($link, $pid, $edate, $tags, $printImage, $owner){
        // 表示するデータを作成
        $rec = array();
        
        // ヘッダー部分：常に印刷
        $dt = substr($edate, 0, 10)." 23:59:59"; // 当日の最終時刻
        $dateTime = getValue($link, $pid, $dt, "ProgressSection.entryDate", null); // $dt 直近の受診日
        $status = getValue($link, $pid, $dt, "ProgressSection.status", null); // $dt 直近の入院ステータス
        $inOut = ($status && $status > 0) ? TRUE : FALSE;
        $date = showDayTitle($dateTime); // 受診日に曜日などを加える
        $userName = getUserInfo($link, $owner, "UserTable.kanjiName");
        $rec[] = array("HEADER", "$date  Doctor: $userName ");
        
        $isFirst = isFirstVisit($link, $pid, $edate);
        $age = ageOf($link, $pid, $edate);
        $st = get($link, $pid, $edate, "", "NameSection.patientKanjiName","",$isFirst)." ( ".get($link, $pid, $edate, "", "NameSection.patientKanaName", "", $isFirst)." )  $age 才";
        if ($inOut) $st = "$st 　入院"; // $st 直後に半角スペースが必要
        $_pid = substr($pid,0,4)."-".substr($pid,4);
        $rec[] = array($_pid, $st);
        
        // 当月最初の受診であればすべて印刷
        $array = explode(",", $tags);
        for ($i=0,$ct=count($array); $i < $ct; $i++){
            $st = $array[$i];
            $ary = explode(":", $st);
            $tag = $ary[0];
            $label = $ary[1];
            $val = get($link, $pid, $edate, "", $tag, "", $isFirst);
            
            if ($printImage * 1 > 0)
                $val = pickupImages($val); // <IMG:...> があれば抜き出す
            else
                $val = strip_tags($val); // HTML タグを削除した $val とする
            $rec[] = array($label, $val);
        }
        
        $rec[] = array("FOOTER", "FOOTER");
        
        return $rec;
    }
	
	function getArrayOfPatientId($link, $currentDate){
		// $currentDate の全受診者の patientId を array に入れて返す
		$min = substr($currentDate, 0, 10)." 00:00:00";
		$max = substr($currentDate, 0, 10)." 23:59:59";
        
		$sql = "SELECT * FROM `FrontTable` WHERE `entryDate`<='$max' AND `entryDate`>='$min'";
		$result=mysqli_query($link, $sql);
		$array = array();
		while ($row=mysqli_fetch_array($result))
			$array[] = $row['patientId'];
		return $array;
	}
	
	/////////////////////////////
	// print FOLDER with FPDF  //
	/////////////////////////////
    
    require_once '../TCPDF/tcpdf.php';
    require_once 'printLib.php';
	
	$patientId = $_GET['patientId']; $patientId = htmlspecialchars($patientId);
	$owner = $_GET['owner']; $owner = htmlspecialchars($owner);
	$entryDate = $_GET['entryDate']; $entryDate = htmlspecialchars($entryDate);
	$printImage = $_GET['printImage'];
	$isSmallFont = $_GET['isSmallFont']; 
	$isHalfPage = $_GET['isHalfPage'];
    $isSafari = $_GET['isSafari'] * 1;
	$tags = $_GET['tags']; 
    $slipCount = $_GET['slipCount'] * 1;
    $slip = $_GET['slip'];
    $slip = decodeSTRING($slip);
    $array = explode("<br>", $slip); // <br> を改行に変換
    $slip = implode("\n", $array);
	
	// DB を開く
    $link = mysqli_connect("localhost","root","root","NOA");
    $db_select = mysqli_select_db($link, "NOA");
    mysqli_query($link, "set names utf8");

	// サイズの定数
	$pageWidth = 160;			// 左右カラム合わせた外枠全体の幅
	if ($isHalfPage * 1 > 0) $pageWidth = 75;		
	$separatorWidth = 15;		// 左右カラムの間の間隔
	$colWidth = ($pageWidth-$separatorWidth) / 2;	// カラムの幅
	$labelWidth = 15;			// ラベル表示幅 18
	$colHeight = 230;			// 外枠の高さ 230
	$topMargin = 1;				// 画面上端からのマージン
	$leftMargin = 8;			// 画面左端から左カラムまでのマージン
	$leftMargin2 = $leftMargin+$colWidth+$separatorWidth;	// 画面左端からの右カラムまでのマージン
	$colMargin = 0;				// カラムとテキストとの間隔
	$blockSeparator = 5;		// 異なるカルテ同士の間隔に置くスペース
	
	openDB();
	
    $pdf=new TCPDF('P', 'mm', array(180, 256)); // B5
	
	if ($isSmallFont * 1 > 0){
		$cellHeight = 3;			// 行間隔
		$lineMax = 70;				// １ページの最大行番号
        $pdf->SetFont('kozminproregular', '', 6);
	} else {
		$cellHeight = 4;			// 行間隔
		$lineMax = 40;				// １ページの最大行番号
        $pdf->SetFont('kozminproregular', '', 8);
	}
    
    $imageArray = array();
    
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
	$pdf->Open();
	$pdf->AddPage();
    
    if ($isSafari == 0) $topMargin += 2; // FireFox では上端マージンを増やす
	$pdf->SetXY($leftMargin, $topMargin);
	$pdf->Cell($colWidth, $colHeight, '', 0, 0, 'L');
	
	// 右カラムを描く
	$pdf->SetXY($leftMargin2, $topMargin);
	$pdf->Cell($colWidth, $colHeight, '', 0, 0, 'L');
    
	if (strlen($patientId) == 0){
		// $patientId が "" の場合は当日のカルテ全てを印刷する
		$rec = array();
		$pidArray = getArrayOfPatientId($link, $entryDate);
		for ($i=0, $pct = count($pidArray); $i < $pct; $i++){
            $dt = substr($entryDate, 0, 10)." 23:59:59"; // 当日の最終時刻でカルテを検索
            $rc = getChartContens($link, $pidArray[$i], $dt, $tags, $printImage, $owner);
			$rec = array_merge($rec, $rc);
		}
	} else {
		// $patientId のカルテを印刷する
		$rec = getChartContens($link, $patientId, $entryDate, $tags, $printImage, $owner);
	}
 	
	$col = 0;						// カラムを左欄にセット
	$lineNum = 0;					// 行番号
	$pageNum = 0;					// ページ数
	$w = $colWidth - ($colMargin * 2);
	$h = $cellHeight; 
	$x = $leftMargin + $colMargin;
	$y = $topMargin + $colMargin;
	$count = count($rec);
	$date = showDayTitle($entryDate);
	for ($i=0; $i < $count; $i++){
		$ary = $rec[$i];
		$label = $ary[0];
		$contents = trim($ary[1]);
        
		$isFooter = (strcmp($label, "FOOTER") == 0) ? 1 : 0;
		// 空の項目は印刷しない
		if (($isFooter == 0) && (strlen($contents) == 0)) continue;
		if (($isFooter == 0) && (strcmp($contents, "　") == 0)) continue; // 倍角の空白の場合
		
		// このレコードが先頭行かどうかを検証
		$isHeader = (strcmp($label, "HEADER") == 0) ? 1 : 0;
		
		if ($lineNum > $lineMax){
			// 行番号が $lineMax に達したら、欄、行、ページを変更
			// 描画先頭位置をページ先頭位置にセット
			$y = ($pageNum * $colHeight) + $topMargin + $colMargin;
			$lineNum = 0; // 行番号を先頭へ戻す
			if ($col == 0){
				$x = $leftMargin2 + $colMargin;	// 左欄だったなら右欄へ移動
				$col = 1;
			} else {
				$pdf->AddPage();				// 改ページ
				$x = $leftMargin + $colMargin;	// 右欄だったなら左欄へ移動し
				$col = 0;
			}
		}
		$lineNum++;	// この位置でインクリメントしないとおかしくなる
		
		if ($isHeader > 0){
			// ヘッダー印刷
			$pdf->SetXY($x, $y);
			$pdf->MultiCell($colWidth, $h, $contents, 0, 'L');
		} else if ($isFooter > 0){
			// 空白業を置く
			$pdf->SetXY($x, $y);
			$pdf->MultiCell($colWidth, $h, "", 0, 'L');
		} else {
			// ラベル印刷
			$pdf->SetXY($x, $y);
			$pdf->Cell($labelWidth, $h, $label, 0, 0, 'L');
			// 内容印刷
			$pdf->SetXY($x + $labelWidth, $y);
			$pdf->MultiCell($w - $labelWidth, $h, $contents, 0, 'L');
			$lineNum += foldCount($contents);
		}
		$y = $pdf->GetY();
		// 最初の罫線だけは太くする
		if ($isHeader > 0)
			$pdf->setLineWidth(0.5);
		else if ($isFooter > 0)
			continue; // footer の場合はその後の経線を描かない
		else
			$pdf->setLineWidth(0.1);
		$pdf->Line($x, $y, $x + $w, $y);
		$lineNum--; // 罫線は行数にカウントしない
	}
     
    if ($printImage * 1 > 0){
        // 添付された画像のサムネイルを画像ギャラリーとして印刷
        $x = $leftMargin + $colMargin;	// 右欄だったなら左欄へ移動し
        $y = $pdf->getY() + 2;
        $cols = 2; // thumb nail を横に並べる個数
        $w = ($colWidth - ($colMargin * 2)) / $cols;
        $h = $w; // イメージの高さが算出できないので巾と同じ高さで改行
        
        $images = count($imageArray);
        for ($i=0; $images > $i; ){
            // 画像のラベル名
            $num = $i + 1;
            $pdf->Text($x, $y, "IMAGE( $num )"); 
            
            // 画像のサムネイル
            // $url = '../NOA_ARCHIVE/tmp/xp.png';
            // $url = '../NOA_ARCHIVE/tmp/20110806180255_0.png';
            $url = $imageArray[$i];
            $url = "..$url"; // 相対パスの必要あり '../' を追加：
            $pdf->Image($url, $x, $y+1, $w);
            
            // 次の画像の位置決め
            $x += $w;
            if (++$i >= $cols){
                $x = $leftMargin + $colMargin;
                $y += $h; // イメージの高さが算出できないので巾と同じ高さで改行
            }
            $pdf->SetXY($x, $y);
        }
    }
   
    if ($slip){ // 伝票ラベル印刷
        $w = 80; // 伝票ラベルの巾
        $lineW = 50; // 罫線の長さ
        $h = 5; 
        // $x = 2;
        // $y = $pdf->GetY();
        $space = 3;
        $pdf->setLineWidth(0.1);
        $pdf->SetFont('kozminproregular', '', 8); // 文字サイズ
        
        for ($i=0; $i < $slipCount; $i++){
            // 内容印刷
            $pdf->SetXY($x, $y);
            $pdf->MultiCell($w, $h, $slip, 0, 'L');
            
            // 罫線
            $y = $pdf->GetY() + $space;
            $pdf->Line($x, $y, $x + $w, $y);
            $y += $space;
            $pdf->SetXY($x, $y);
        }
    }
    
	$pdf->Output();
	
?>
