<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }

    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (preg_match("/\)/", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                }
            }
        }
        return $obj;
    }
    
    function printPatientName($pdf, $x, $y, $w, $h, $patientName, $term){
        // 患者氏名・予定日を印字
        $pdf->SetXY($x, $y);
        $st = ($patientName) ? "$patientName 様" : "";
        $st = "$st ( 分娩予定日：$term )";
        $pdf->MultiCell($w * 9, $h, $st, 0, 'L');
    }
    
    function printRow($pdf, $x, $y, $w, $h, $st){
        // コメント行を印字
        $pdf->SetXY($x, $y);
        $pdf->MultiCell($w * 9, $h, $st, 0, 'L');
    }
    
    function printCalendar($pdf, $x, $y, $w, $h, $array){
        // カレンダーの一行分を印字
        $cols = count($array);
        for ($col=0; $col < $cols; $col++){
            $val = $array[$col];
            
            $pdf->SetXY($x, $y);
            $ary = explode("/", $val);
            if (count($ary) > 1){ // $val は "10/1" 形式 -- 月ラベル表示
                $month = $ary[0];
                $pdf->SetFont('kozminproregular', 'B', 7); // BOLD
                $pdf->SetFillColor(210, 210, 210); // 月の塗りつぶし色を指定
                $val = "$month 月";
                $pdf->MultiCell($w, $h, $val, 0, 'C', 1);
                $pdf->SetFont('kozminproregular', '', 8);
            } else {
                $pdf->MultiCell($w, $h, $val, 0, 'R');
            }
            $x += $w;
        }
    }
    
    function printFacilityName($pdf, $x, $y, $w, $h, $facilityName){
        // 施設名を印字
        $pdf->SetTextColor(150, 150, 150); // 文字色を指定
        $pdf->SetFont('kozminproregular', '', 14);
        $pdf->SetXY($x, $y);
        $pdf->MultiCell($w * 9, $h, $facilityName, 0, 'L');
        $pdf->SetFont('kozminproregular', '', 8);
    }

    function printLogo($pdf, $x, $y, $logoPath){
        // ロゴ画像の URL は相対パスの必要あり
        //$url = '../Users/ohashi/ohashi-clinic.png';
        $w = 0; // ロゴ・イメージの巾
        if (strlen($logoPath) > 0){
            //    $x = $footerLeftMargin;
            //    $y = $this->GetY() + 5;
            $w = 11;
            $pdf->Image($logoPath, $x, $y, $w);
        }
    }
    
    /////////////////////////////
    // print FOLDER with FPDF  //
    /////////////////////////////
    
    $value = $_GET['value']; $value = htmlspecialchars($value);
    $value = decodeSTRING($value);
    
    require_once '../TCPDF/tcpdf.php';
    
    $args = decodeObject($value);
    $buff = $args['rows'];
    $records = explode(";", $buff);
    $patientName = $args['patientName'];
    $term = $args['term'];
    $facilityName = $args['facilityName'];
    $commentMode = ($args['commentMode']) ? TRUE : FALSE;
    $logoPath = $args['logo'];
    
    if ($commentMode){
        // DB を開いて該当レコードを読み込む
        // ### セキュリティーを保つには、以下のファイルを外からアクセスできない
        // ### directory に置き、以下の cfg.php の pass をそこへ変更
        require_once('cfg.php');
        
        $link = mysqli_connect($db['host'], $db['user'], $db['pwd'], $db['dbname']);
        // 接続状況をチェック
        if (mysqli_connect_errno()) {
            echo("Connect failed: ".mysqli_connect_error()." <br>");
            exit();
        }
        $db_select = mysqli_select_db($link, $db['dbname']);
        mysqli_query($link, "set names utf8");

        // コメントを読み込む
        $pid = "REPRODUCTIVE_HISTORY_COMMENT";
        $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$pid' ORDER BY `type`";
        $result=mysqli_query($link, $sql);
        
        $comments = array();
        while ($row=mysqli_fetch_array($result)){
            $week = $row['type'];
            $comment = $row['dataString'];
            $comments[$week] = $comment;
        }
    }
    
    $pdf=new TCPDF('P', 'mm', array(180, 256)); // B5
    
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
    $pdf->Open();
    $pdf->AddPage();
    $pdf->SetFont('kozminproregular', '', 8);
    
    $x=0;
    $y=5;
    $w=9;
    $h=4.5;
    $week = -1;
    $calendarTop = -1;
    
    // 患者氏名・予定日
    printPatientName($pdf, 2, $y, $w, $h, $patientName, $term); // 左側
    if ($commentMode == FALSE)
        printPatientName($pdf, 98, $y, $w, $h, $patientName, $term); // 右側
    $y += 4;
    
    // コメント
    $st = "実際生まれる日は前後２週間ほどの巾をお考えください";
    printRow($pdf, 2, $y, $w, $h, $st); // 左側
    if ($commentMode == FALSE)
        printRow($pdf, 98, $y, $w, $h, $st); // 左側
    $y += 6;

    // calendar
    for ($row=0,$rows=count($records); $row < $rows; $row++){
        $record = $records[$row];
        if (strlen($record) == 0) continue;

        // 曜日のある行のみグレー表示
        if (strpos($record, "火") > 0) // 曜日の表示
            $pdf->SetTextColor(170, 170, 170); // 文字色を指定
        else
            $pdf->SetTextColor(0, 0, 0); // 文字色を指定
        
        $array = explode(",", $record);
        $x = 0;
        
        // 左側
        if ($calendarTop < 0) $calendarTop = 1;
        // カレンダー
        printCalendar($pdf, 0, $y, $w, $h, $array);
        
        // 右側
        if ($commentMode){
            // 右側の妊娠週数ごとのコメント
            if (strpos($record, "週")) $week++;
            if ($calendarTop == 1){
                $comment = "[ 備考 ]";
                $calendarTop = 2;
            } else {
                $comment = $comments[$week];
            }
            $pdf->SetXY(85, $y);
            $pdf->MultiCell($w * 9, $h, $comment, 0, 'L');
        } else {
            printCalendar($pdf, 95, $y, $w, $h, $array);
        }
        $y += 4;
    }
    
    // 下線を引く
    $pdf->SetDrawColor(150, 150, 150); // 線の色を指定
    $y += 1;
    $pdf->Line(0, $y, 0 + $w*20, $y);
    
    // ロゴを印刷
    $x = 2;
    if ($logoPath){
        $y += 1;
        printLogo($pdf, $x, $y, $logoPath);
        if ($commentMode == FALSE)
            printLogo($pdf, $x + 96, $y, $logoPath);
        $x = 20;
    }
    
    // 施設名を印字
    if ($facilityName){
        $y += 1;
        printFacilityName($pdf, $x, $y, $w, $h, $facilityName); // 左側
        if ($commentMode == FALSE)
            printFacilityName($pdf, $x + 96, $y, $w, $h, $facilityName); // 右側
        $y += 4;
    }
    
    $pdf->Output();
    
?>