/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.regex.Pattern;
import nor.core.plugin.Plugin;
import nor.core.proxy.LocalContentsHandlerAdapter;
import nor.core.proxy.RequestHandler;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.http.server.HttpServer;
import nor.http.server.local.ListResource;
import nor.http.server.nserver.HttpNServer;
import nor.http.server.proxyserver.ProxyRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.http.server.tserver.HttpTServer;
import nor.util.log.Logger;

public class ProxyServer
implements Closeable {
    private final HttpServer server;
    private final RequestHandler remoteHandler;
    private final LocalContentsHandlerAdapter localHandler;
    private final Router router;
    private static final Logger LOGGER = Logger.getLogger(ProxyServer.class);

    public ProxyServer(ProxyRequestHandler handler, Router router) {
        this(handler, router, false);
    }

    public ProxyServer(ProxyRequestHandler handler, Router router, boolean useTServer) {
        LOGGER.entering("<init>", handler, router, useTServer);
        assert (handler != null);
        assert (router != null);
        this.router = router;
        this.remoteHandler = new RequestHandler(handler);
        this.localHandler = new LocalContentsHandlerAdapter();
        this.remoteHandler.attach(this.localHandler);
        this.server = useTServer ? new HttpTServer(this.remoteHandler) : new HttpNServer(this.remoteHandler);
        LOGGER.exiting("<init>");
    }

    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, port);
        assert (hostname != null && hostname.length() != 0);
        assert (port > 0);
        this.server.start(hostname, port);
        LOGGER.exiting("start");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.server.close();
        LOGGER.exiting("close");
    }

    public ListResource localResourceRoot() {
        return this.localHandler.getRoot();
    }

    public void attach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        int n;
        LOGGER.entering("attach", plugin);
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            MessageHandler[] messageHandlerArray = hs;
            n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                MessageHandler h = messageHandlerArray[n2];
                this.remoteHandler.attach(h);
                ++n2;
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            RequestFilter[] requestFilterArray = rqs;
            int n3 = rqs.length;
            n = 0;
            while (n < n3) {
                RequestFilter f = requestFilterArray[n];
                this.remoteHandler.attach(f);
                ++n;
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            ResponseFilter[] responseFilterArray = res;
            int n4 = res.length;
            int n5 = 0;
            while (n5 < n4) {
                ResponseFilter f = responseFilterArray[n5];
                this.remoteHandler.attach(f);
                ++n5;
            }
        }
        LOGGER.exiting("attach");
    }

    public void detach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        int n;
        LOGGER.entering("detach", plugin);
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            MessageHandler[] messageHandlerArray = hs;
            n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                MessageHandler h = messageHandlerArray[n2];
                this.remoteHandler.detach(h);
                ++n2;
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            RequestFilter[] requestFilterArray = rqs;
            int n3 = rqs.length;
            n = 0;
            while (n < n3) {
                RequestFilter f = requestFilterArray[n];
                this.remoteHandler.detach(f);
                ++n;
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            ResponseFilter[] responseFilterArray = res;
            int n4 = res.length;
            int n5 = 0;
            while (n5 < n4) {
                ResponseFilter f = responseFilterArray[n5];
                this.remoteHandler.detach(f);
                ++n5;
            }
        }
        LOGGER.exiting("detach");
    }

    public String getPAC(String host, int port, boolean ssh) throws IOException {
        Class<?> c = this.getClass();
        InputStream in = ssh ? c.getResourceAsStream("res/proxy.pac.template") : c.getResourceAsStream("res/no-ssh-proxy.pac.template");
        BufferedReader rin = new BufferedReader(new InputStreamReader(in));
        StringBuilder pac_template = new StringBuilder();
        String buf = rin.readLine();
        while (buf != null) {
            pac_template.append(buf);
            pac_template.append("\n");
            buf = rin.readLine();
        }
        String proxy = String.format("%s:%d", host, port);
        StringBuilder filtering_rule = new StringBuilder();
        String[] stringArray = this.remoteHandler.getHandlingURLPatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pat = stringArray[n2];
            filtering_rule.append("if(url.match(new RegExp(\"");
            filtering_rule.append(pat.replace("\\", "\\\\"));
            filtering_rule.append("\")) !== null){return proxy;}\n");
            ++n2;
        }
        StringBuilder routing_rule = new StringBuilder();
        for (Pattern pat : this.router.keySet()) {
            InetSocketAddress addr = (InetSocketAddress)this.router.get(pat).address();
            routing_rule.append("if(url.match(new RegExp(\"");
            routing_rule.append(pat.pattern());
            routing_rule.append("\")) !== null){return \"PROXY ");
            routing_rule.append(addr.getHostName());
            routing_rule.append(":");
            routing_rule.append(addr.getPort());
            routing_rule.append("\";}\n");
        }
        String ret = pac_template.toString().replace("{PROXY_URL}", proxy).replace("{FILTERING_RULE}", filtering_rule.toString()).replace("{ROUTING_RULE}", routing_rule.toString());
        LOGGER.fine("getPAC", ret, new Object[0]);
        return ret;
    }

    public static void main(String[] args) {
        Router router = new Router();
        ProxyServer app = new ProxyServer(new ProxyRequestHandler("nor", router), router);
        try {
            if (args.length < 2) {
                System.err.println("Usage: <bind address> <listen port> [<external proxy url>]");
                System.exit(1);
            }
            if (args.length >= 3) {
                router.put(".*", new URL(args[2]));
            }
            app.start(args[0], Integer.parseInt(args[1]));
            System.in.read();
            app.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

