/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.http.HeaderName;
import nor.http.HttpHeader;

public class SetCookie
implements Iterable<Entry> {
    private static String SP = ";";
    private static String EQ = "=";
    private static String SECURE = "secure";
    private static String EXPIRES = "expires";
    private static String PATH = "path";
    private static String DOMAIN = "domain";
    private static Pattern ENTRYP_ATTERN = Pattern.compile("\\s*([^=]+)=([^;]+)");
    private final HttpHeader header;
    private final List<Entry> entries = new ArrayList<Entry>();
    private static final Logger LOGGER = Logger.getLogger(SetCookie.class.getName());

    private SetCookie(HttpHeader header) {
        this.header = header;
        String[] stringArray = header.get(HeaderName.SetCookie).split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            this.entries.add(new Entry(e));
            ++n2;
        }
    }

    public void add(Entry e) {
        this.entries.add(e);
        this.update();
    }

    public Entry get(int i) {
        return this.entries.get(i);
    }

    public void clear() {
        LOGGER.entering(SetCookie.class.getName(), "clear");
        this.entries.clear();
        this.header.remove(HeaderName.SetCookie);
        LOGGER.exiting(SetCookie.class.getName(), "clear");
    }

    public void remove(Entry e) {
        this.entries.remove(e);
        this.update();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public int size() {
        return this.entries.size();
    }

    public String toString() {
        LOGGER.entering(SetCookie.class.getName(), "toString");
        StringBuffer buf = new StringBuffer();
        if (this.entries.size() != 0) {
            for (Entry e : this.entries) {
                buf.append(e.toString());
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        String ret = buf.toString();
        LOGGER.exiting(SetCookie.class.getName(), "toString", ret);
        return ret;
    }

    private void update() {
        this.header.set(HeaderName.SetCookie, this.toString());
    }

    public static SetCookie get(HttpHeader header) {
        return new SetCookie(header);
    }

    public class Entry {
        private String key = null;
        private String value = null;
        private String date = null;
        private String path = null;
        private String domain = null;
        private boolean secure = false;
        private String src;

        public Entry(String src) {
            this.src = src;
            this.secure = false;
            String[] stringArray = src.split(SP);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (SECURE.equalsIgnoreCase(e.trim())) {
                    this.secure = true;
                } else {
                    Matcher m = ENTRYP_ATTERN.matcher(e);
                    if (m.find()) {
                        String key = m.group(1);
                        String value = m.group(2);
                        if (EXPIRES.equalsIgnoreCase(key)) {
                            this.date = value;
                        } else if (PATH.equalsIgnoreCase(key)) {
                            this.date = value;
                        } else if (DOMAIN.equalsIgnoreCase(key)) {
                            this.domain = value;
                        } else {
                            this.key = key;
                            this.value = value;
                        }
                    }
                }
                ++n2;
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getData() {
            return this.date;
        }

        public String getPath() {
            return this.path;
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean getSecure() {
            return this.secure;
        }

        public void setKey(String key) {
            this.key = key;
            this.update();
        }

        public void setValue(String value) {
            this.value = value;
            this.update();
        }

        public void setDate(String date) {
            this.date = date;
            this.update();
        }

        public void setPath(String path) {
            this.path = path;
            this.update();
        }

        public void setDomain(String domain) {
            this.domain = domain;
            this.update();
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
            this.update();
        }

        public String toString() {
            return this.src;
        }

        private void update() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.key);
            buf.append(EQ);
            buf.append(this.value);
            if (this.date != null) {
                buf.append(SP);
                buf.append(EXPIRES);
                buf.append(EQ);
                buf.append(this.date);
            }
            if (this.path != null) {
                buf.append(SP);
                buf.append(PATH);
                buf.append(EQ);
                buf.append(this.path);
            }
            if (this.domain != null) {
                buf.append(SP);
                buf.append(DOMAIN);
                buf.append(EQ);
                buf.append(this.domain);
            }
            if (this.secure) {
                buf.append(SP);
                buf.append(SECURE);
            }
            this.src = buf.toString();
        }
    }
}

