/*
 * Decompiled with CFR 0.152.
 */
package nor.http.io;

import java.io.IOException;
import java.io.InputStream;
import nor.util.log.Logger;

public class HeaderInputStream
extends InputStream {
    private final InputStream in;
    private State state = State.SecondCR;
    private static final Logger LOGGER = Logger.getLogger(HeaderInputStream.class);

    public HeaderInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        LOGGER.entering("read", new Object[0]);
        int ret = -1;
        switch (this.state) {
            case Default: {
                ret = this.in.read();
                if (ret != 13) break;
                this.state = State.FirstCR;
                break;
            }
            case FirstCR: {
                ret = this.in.read();
                if (ret == 10) {
                    this.state = State.FirstLF;
                    break;
                }
                this.state = State.Default;
                break;
            }
            case FirstLF: {
                ret = this.in.read();
                if (ret == 13) {
                    this.state = State.SecondCR;
                    break;
                }
                this.state = State.Default;
                break;
            }
            case SecondCR: {
                ret = this.in.read();
                this.state = ret == 10 ? State.SecondLF : State.Default;
            }
        }
        if (ret == -1) {
            this.state = State.SecondLF;
        }
        LOGGER.exiting("read", ret);
        return ret;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        long i = 0L;
        while (i != n) {
            if (this.read() == -1) break;
            ++i;
        }
        return i;
    }

    public void clearState() {
        this.state = State.SecondCR;
    }

    private static enum State {
        Default,
        FirstCR,
        FirstLF,
        SecondCR,
        SecondLF;

    }
}

