/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.local;

import java.nio.channels.SocketChannel;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.local.ListResource;
import nor.util.log.Logger;

public class LocalContentsHandler
implements HttpRequestHandler {
    private final ListResource root = new ListResource("");
    private static final Logger LOGGER = Logger.getLogger(LocalContentsHandler.class);

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        HttpResponse ret = null;
        String path = request.getPath();
        if (path.startsWith("/")) {
            try {
                switch (request.getMethod()) {
                    case GET: {
                        ret = this.root.doGet(path, request);
                        break;
                    }
                    case POST: {
                        ret = this.root.doPost(path, request);
                        break;
                    }
                    case PUT: {
                        ret = this.root.doPut(path, request);
                        break;
                    }
                    case DELETE: {
                        ret = this.root.doDelete(path, request);
                    }
                }
            }
            catch (HttpException e) {
                ret = e.createResponse(request);
            }
        }
        if (ret == null) {
            ret = HttpException.createResponse(request, Status.NotFound);
        }
        LOGGER.exiting("doRequest", ret);
        return ret;
    }

    @Override
    public SocketChannel doConnectRequest(HttpRequest request) throws HttpException {
        throw new HttpException(Status.MethodNotAllowed);
    }

    public ListResource getRoot() {
        LOGGER.entering("getRoot", new Object[0]);
        ListResource ret = this.root;
        LOGGER.exiting("getRoot", ret);
        return ret;
    }
}

