/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.local;

import java.util.ArrayList;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.error.HttpException;
import nor.http.error.MethodNotAllowedException;
import nor.util.log.Logger;

public abstract class Resource {
    private final String name;
    private final Method[] allowed;
    private static final Logger LOGGER = Logger.getLogger(Resource.class);
    private static final String DoDELETE = "doDelete";
    private static final String DoGET = "doGet";
    private static final String DoPOST = "doPost";
    private static final String DoPUT = "doPut";

    protected Resource(String name) {
        LOGGER.entering("<init>", new Object[0]);
        this.name = name;
        Class<?> c = this.getClass();
        ArrayList<Method> allowd = new ArrayList<Method>();
        try {
            java.lang.reflect.Method toDelete = c.getMethod(DoDELETE, String.class, HttpRequest.class);
            if (!toDelete.equals(Resource.class.getMethod(DoDELETE, String.class, HttpRequest.class))) {
                allowd.add(Method.DELETE);
            }
            java.lang.reflect.Method toGet = c.getMethod(DoGET, String.class, HttpRequest.class);
            if (!toGet.equals(Resource.class.getMethod(DoGET, String.class, HttpRequest.class))) {
                allowd.add(Method.GET);
            }
            java.lang.reflect.Method toPost = c.getMethod(DoPOST, String.class, HttpRequest.class);
            if (!toPost.equals(Resource.class.getMethod(DoPOST, String.class, HttpRequest.class))) {
                allowd.add(Method.POST);
            }
            java.lang.reflect.Method toPut = c.getMethod(DoPUT, String.class, HttpRequest.class);
            if (!toPut.equals(Resource.class.getMethod(DoPUT, String.class, HttpRequest.class))) {
                allowd.add(Method.PUT);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.allowed = new Method[allowd.size()];
        allowd.toArray(this.allowed);
        LOGGER.exiting("<init>");
    }

    public final String getName() {
        LOGGER.entering("getName", new Object[0]);
        LOGGER.exiting("getName", (Object)this.name);
        return this.name;
    }

    public HttpResponse doDelete(String path, HttpRequest request) throws HttpException {
        throw new MethodNotAllowedException(this.allowed);
    }

    public HttpResponse doGet(String path, HttpRequest request) throws HttpException {
        throw new MethodNotAllowedException(this.allowed);
    }

    public HttpResponse doPost(String path, HttpRequest request) throws HttpException {
        throw new MethodNotAllowedException(this.allowed);
    }

    public HttpResponse doPut(String path, HttpRequest request) throws HttpException {
        throw new MethodNotAllowedException(this.allowed);
    }
}

