/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import nor.http.server.nserver.Delegator;
import nor.http.server.nserver.NServer;
import nor.network.SelectionEventHandler;
import nor.network.SelectionEventHandlerAdapter;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

class Connection
implements Closeable {
    private boolean closed = false;
    private SelectableChannel delegation;
    private final SelectionWorker selector;
    private final SelectionEventHandler handler;
    private final SocketChannelInputStream in;
    private final SocketChannelOutputStream out;
    private final SelectionKey key;
    private static final Logger LOGGER = Logger.getLogger(Connection.class);
    private static final String AlreadyClosed = "This stream has already closed.";

    public Connection(SocketChannel ch, SelectionWorker selector) throws IOException {
        this.selector = selector;
        this.handler = new ConnectionHandler();
        this.in = new SocketChannelInputStream();
        this.out = new SocketChannelOutputStream();
        this.key = this.selector.register(ch, 0, this.handler);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean waitForReady(int timeout) {
        return true;
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    public String toString() {
        return String.format("%s(key = %s)", this.getClass().getSimpleName(), this.key);
    }

    public void requestDelegation(SelectableChannel ch) throws IOException {
        this.delegation = ch;
    }

    private void addOps(int ops) {
        if (this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() | ops);
        }
    }

    private void removeOps(int ops) {
        if (this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() & ~ops);
        }
    }

    private void wakeup() {
        this.key.selector().wakeup();
    }

    private void onCloseStream() {
        if (this.in.closed() && this.out.closed()) {
            try {
                if (this.delegation != null) {
                    LOGGER.fine("onCloseStream", "Close streams and delegate to {0}.", this.delegation);
                    new Delegator(this.key, this.delegation, this.selector);
                } else {
                    this.key.cancel();
                    this.key.attach(null);
                    this.key.channel().close();
                }
            }
            catch (IOException e) {
                LOGGER.warning("onCloseStream", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "onCloseStream", e);
            }
            this.closed = true;
        }
    }

    private final class ConnectionHandler
    extends SelectionEventHandlerAdapter {
        private ConnectionHandler() {
        }

        @Override
        public void onRead(ReadableByteChannel ch) {
            Connection.this.in.onRead(ch);
        }

        @Override
        public void onWrite(WritableByteChannel ch) {
            Connection.this.out.onWrite(ch);
        }
    }

    private final class SocketChannelInputStream
    extends InputStream {
        private boolean closed = false;
        private IOException error;
        private final ByteBuffer buffer = ByteBuffer.allocate(NServer.BufferSize);

        public SocketChannelInputStream() {
            this.buffer.limit(0);
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (this.available() == 0) {
                this.reload();
                if (this.available() == 0) {
                    return -1;
                }
            }
            return this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int available;
            if (b == null) {
                NullPointerException e = new NullPointerException("b is null");
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                IndexOutOfBoundsException e = new IndexOutOfBoundsException("off < 0 or len < 0 or len > b.length - off");
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (this.closed) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (this.available() == 0) {
                this.reload();
                if (this.available() == 0) {
                    return -1;
                }
            }
            if (len > (available = this.available())) {
                this.buffer.get(b, off, available);
                return available;
            }
            this.buffer.get(b, off, len);
            return len;
        }

        @Override
        public int available() {
            return this.buffer.limit() - this.buffer.position();
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                LOGGER.fine(this.getClass(), "close", "InputStream by {0} is closed.", Connection.this);
                Connection.this.removeOps(1);
                Connection.this.onCloseStream();
            }
        }

        public synchronized void reload() throws IOException {
            if (!this.closed && this.available() == 0) {
                this.error = null;
                Connection.this.addOps(1);
                Connection.this.wakeup();
                try {
                    this.wait(NServer.Timeout);
                }
                catch (InterruptedException e) {
                    LOGGER.catched(Level.FINE, this.getClass(), "reload", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (this.error != null) {
                    Connection.this.close();
                    IOException e = new IOException("An error is occuered", this.error);
                    LOGGER.throwing(this.getClass(), "reload", e);
                    throw e;
                }
            }
        }

        public boolean closed() {
            return this.closed;
        }

        public synchronized void onRead(ReadableByteChannel channel) {
            try {
                this.buffer.clear();
                if (channel.read(this.buffer) == -1) {
                    Connection.this.removeOps(1);
                    this.notify();
                } else if (this.available() != 0) {
                    this.buffer.flip();
                    Connection.this.removeOps(1);
                    this.notify();
                }
            }
            catch (IOException e) {
                LOGGER.fine(this.getClass(), "onRead", "Socket error ({0}) by {1}", e.getMessage(), Connection.this);
                LOGGER.catched(Level.FINE, this.getClass(), "onRead", (Throwable)e);
                Connection.this.removeOps(1);
                this.error = e;
                this.notify();
            }
        }
    }

    private final class SocketChannelOutputStream
    extends OutputStream {
        private boolean closed = false;
        private boolean flushed = true;
        private boolean wrote = false;
        private final ByteBuffer buffer = ByteBuffer.allocate(NServer.BufferSize);

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "write", e);
                throw e;
            }
            if (this.available() == 0) {
                this.flush();
            }
            this.buffer.put((byte)b);
            this.flushed = false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.closed) ** GOTO lbl18
            e = new IOException("This stream has already closed.");
            Connection.access$2().throwing(this.getClass(), "write", e);
            throw e;
lbl-1000:
            // 1 sources

            {
                if (this.available() == 0) {
                    this.flush();
                }
                if (len > (size = this.available())) {
                    this.buffer.put(b, off, size);
                    off += size;
                    len -= size;
                } else {
                    this.buffer.put(b, off, len);
                    off += len;
                    len -= len;
                }
                this.flushed = false;
lbl18:
                // 2 sources

                ** while (len != 0)
            }
lbl19:
            // 1 sources

        }

        @Override
        public synchronized void flush() throws IOException {
            this.flushed = true;
            if (this.closed) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "flush", e);
                throw e;
            }
            if (this.buffer.position() != 0) {
                LOGGER.finer("flush", "Start flush.", new Object[0]);
                this.buffer.flip();
                Connection.this.addOps(4);
                Connection.this.wakeup();
                try {
                    this.wait(NServer.Timeout);
                }
                catch (InterruptedException e) {
                    LOGGER.catched(Level.FINE, this.getClass(), "flush", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                LOGGER.finer("flush", "End flush.", new Object[0]);
                if (!this.wrote) {
                    Connection.this.close();
                    IOException e = new IOException("Do not write to the stream.");
                    LOGGER.throwing(this.getClass(), "flush", e);
                    throw e;
                }
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (!this.flushed) {
                    this.flush();
                }
            }
            catch (Throwable throwable) {
                if (!this.closed) {
                    this.closed = true;
                    LOGGER.fine(this.getClass(), "close", "OutputStream by {0} is closed.", Connection.this);
                    Connection.this.removeOps(4);
                    Connection.this.onCloseStream();
                }
                throw throwable;
            }
            if (!this.closed) {
                this.closed = true;
                LOGGER.fine(this.getClass(), "close", "OutputStream by {0} is closed.", Connection.this);
                Connection.this.removeOps(4);
                Connection.this.onCloseStream();
            }
        }

        public boolean closed() {
            return this.closed;
        }

        public synchronized void onWrite(WritableByteChannel channel) {
            try {
                this.wrote = false;
                channel.write(this.buffer);
                if (this.available() == 0) {
                    Connection.this.removeOps(4);
                    this.buffer.clear();
                    this.wrote = true;
                    this.notify();
                }
            }
            catch (IOException e) {
                LOGGER.fine(this.getClass(), "onWrite", "Socket error ({0}) by {1}", e.getMessage(), Connection.this);
                LOGGER.catched(Level.FINE, this.getClass(), "onWrite", (Throwable)e);
                Connection.this.removeOps(4);
                this.notify();
            }
        }

        private int available() {
            return this.buffer.limit() - this.buffer.position();
        }
    }
}

