/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.ConnectionManager;
import nor.network.SelectionEventHandler;
import nor.network.SelectionEventHandlerAdapter;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

class PortListener
implements Closeable {
    private final ConnectionManager manager;
    private final SelectionWorker selector;
    private final SelectionEventHandler handler;
    private final SelectionKey key;
    private static final Logger LOGGER = Logger.getLogger(PortListener.class);

    public PortListener(String host, int port, ConnectionManager manager, SelectionWorker selector) throws IOException {
        this.manager = manager;
        this.selector = selector;
        this.handler = new ListenWorkerHandler();
        ServerSocketChannel channel = ServerSocketChannel.open();
        InetSocketAddress addr = new InetSocketAddress(host, port);
        channel.socket().bind(addr);
        this.key = this.selector.register(channel, 16, this.handler);
        LOGGER.info("<init>", "Bind socket to {0}", addr);
    }

    @Override
    public void close() {
        SelectableChannel ch = this.key.channel();
        this.key.cancel();
        this.key.attach(null);
        this.key.selector().wakeup();
        try {
            ch.close();
        }
        catch (IOException e) {
            LOGGER.catched(Level.FINE, "close", e);
        }
    }

    private final class ListenWorkerHandler
    extends SelectionEventHandlerAdapter {
        private ListenWorkerHandler() {
        }

        @Override
        public void onAccept(ServerSocketChannel ch) {
            try {
                SocketChannel socketChannel = ch.accept();
                if (socketChannel != null) {
                    LOGGER.finest("onAccept", "Receive an accsptable key from {0}", socketChannel.socket());
                    Connection con = new Connection(socketChannel, PortListener.this.selector);
                    PortListener.this.manager.offer(con);
                } else {
                    LOGGER.finest("onAccept", "Receive an accsptable but null key", new Object[0]);
                }
            }
            catch (IOException e) {
                LOGGER.warning(this.getClass(), "onAccept", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "onAccept", e);
            }
        }
    }
}

