/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;
import nor.util.io.NoExceptionOutputStreamFilter;
import nor.util.log.Logger;

class RequestHandleWorker
implements Runnable,
Closeable {
    private boolean running = true;
    private final Queue<Connection> queue;
    private final HttpRequestHandler handler;
    private final List<ServiceEventListener> listeners = new ArrayList<ServiceEventListener>();
    private static final Logger LOGGER = Logger.getLogger(RequestHandleWorker.class);

    public RequestHandleWorker(Queue<Connection> queue, HttpRequestHandler handler) {
        this.queue = queue;
        this.handler = handler;
    }

    public void addListener(ServiceEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ServiceEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void run() {
        LOGGER.entering("run", new Object[0]);
        while (this.running) {
            Connection con = this.queue.poll();
            if (con != null) {
                LOGGER.finer("run", "Begin to handle the connection; {0}", con);
                try {
                    while (this.running) {
                        BufferedInputStream input = new BufferedInputStream(new NoCloseInputStream(con.getInputStream()));
                        NoExceptionOutputStreamFilter output = new NoExceptionOutputStreamFilter(new BufferedOutputStream(new NoCloseOutputStream(con.getOutputStream())));
                        HttpRequest request = HttpRequest.create(input);
                        if (request == null) {
                            LOGGER.fine("run", "Receive a null request", new Object[0]);
                        } else if (request.getMethod() == Method.CONNECT) {
                            HttpResponse response;
                            LOGGER.fine("run", "Receive a connect request: {0}", request);
                            try {
                                SocketChannel ch = this.handler.doConnectRequest(request);
                                response = request.createResponse(Status.ConnectionEstablished);
                                response.writeTo(output);
                                output.flush();
                                con.requestDelegation(ch);
                                LOGGER.info("run", "{0} > {1} (unknown length)", request.getHeadLine(), response.getHeadLine());
                            }
                            catch (HttpException e) {
                                response = e.createResponse(request);
                                response.writeTo(output);
                                output.flush();
                            }
                        } else {
                            LOGGER.fine("run", "Receive a {0}", request);
                            HttpResponse response = this.handler.doRequest(request);
                            HttpHeader header = response.getHeader();
                            if (header.containsKey(HeaderName.ContentLength)) {
                                LOGGER.info("run", "{0} > {1} ({2} bytes)", request.getHeadLine(), response.getHeadLine(), header.get(HeaderName.ContentLength));
                            } else {
                                LOGGER.info("run", "{0} > {1} (unknown length)", request.getHeadLine(), response.getHeadLine());
                            }
                            LOGGER.fine("run", "Return the {0}", response);
                            response.writeTo(output);
                            response.close();
                            output.flush();
                            if (output.alive() && this.isKeepingAlive(request) && this.isKeepingAlive(response)) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (this.running) {
                        LOGGER.warning("run", e.toString(), new Object[0]);
                        LOGGER.catched(Level.FINE, "run", e);
                    }
                }
                catch (VirtualMachineError e) {
                    LOGGER.warning("run", e.toString(), new Object[0]);
                    LOGGER.catched(Level.FINE, "run", e);
                }
                LOGGER.finer("run", "Finish to handle and closes the connection; {0}", con);
                try {
                    con.close();
                }
                catch (IOException e) {
                    LOGGER.warning("run", e.getMessage(), new Object[0]);
                    LOGGER.catched(Level.FINE, "run", e);
                }
                continue;
            }
            this.running = false;
        }
        for (ServiceEventListener listener : this.listeners) {
            listener.onEnd(this);
        }
        LOGGER.exiting("run");
    }

    @Override
    public void close() {
        this.running = false;
    }

    private boolean isKeepingAlive(HttpMessage msg) {
        return !msg.getHeader().containsValue(HeaderName.Connection, "close");
    }

    public static interface ServiceEventListener {
        public void onEnd(RequestHandleWorker var1);
    }
}

