/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import nor.util.io.SequentialReader;

public class CopyingStreamReader
extends SequentialReader {
    private final StringBuilder _copy = new StringBuilder();

    public CopyingStreamReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        this._copy.append((char)ret);
        return ret;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int ret = this.in.read(cbuf);
        this._copy.append(cbuf, 0, ret);
        return ret;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret = this.in.read(cbuf, off, len);
        this._copy.append(cbuf, off, ret);
        return ret;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int ret = this.in.read(target);
        this._copy.append(target);
        return ret;
    }
}

