/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import nor.util.log.Logger;

public class NoExceptionOutputStreamFilter
extends FilterOutputStream {
    private boolean alive = true;
    private static final Logger LOGGER = Logger.getLogger(NoExceptionOutputStreamFilter.class);

    public NoExceptionOutputStreamFilter(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        if (this.alive) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "flush", e);
                this.alive = false;
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.alive) {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.alive) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.alive) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "write", e);
                this.alive = false;
            }
        }
    }

    public boolean alive() {
        return this.alive;
    }
}

