#include <wchar.h>
#include <assert.h>

#include "utils/nt_std_t.h"
#include "_2ch/model_2ch.h"


nt_thread_tp nt_get_thread_by_seq_no(
		nt_link_tp thread_list, int seq_no)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(seq_no == threadp->seq_no)
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}

nt_thread_tp nt_get_thread_by_dat_name(
		nt_link_tp thread_list, const wchar_t *dat_name)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(0 == wcscmp(dat_name, threadp->file_name))
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}
