/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <wchar.h>

#include "utils/nt_std_t.h"
#include "utils/text.h"
#include "_2ch/parse_2ch.h"

static nt_link_tp parse_number_list_local (const char *source, 
				const char **endpp);

static int comp_int(int a, int b)
{
	if(a == b) return 0;
	else if(a < b) return 1;
	else return -1;
}

nt_link_tp parse_number_list (const char *source, const char **endpp)
{
	nt_link_tp linkp =
		parse_number_list_local(source, endpp);
	if(!linkp)
		return NULL;
	nt_link_n_sort(&linkp, comp_int);
	return linkp;
}

static nt_link_tp parse_number_list_local (const char *source, 
				const char **endpp)
{
	nt_link_tp linkp, top_linkp;
	int i , len, state;
	const char *start;
	int n, prev;

	assert(source);

	if(endpp)
		*endpp = source;
	
	top_linkp = NULL;
	linkp = NULL;
	len = strlen(source);
	state = 0;

	for(i = 0; i < len; i++){
		switch(source[i]){
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			if(state == 0){
				state = 1;
				start = source + i;
			}else if(state == 2){
				state = 3;
				start = source + i;
			}else if(state != 1 && state != 3){
				assert(0);
			}
			break;
		case ' ':
		case ',':
			if(state == 1){
				n = atoi(start);
				linkp = nt_link_add_n_data(top_linkp, n);
				if(!top_linkp)
					top_linkp= linkp;
				if(endpp)
					*endpp = source + i;
			}else if(state == 3){
				n = atoi(start);
				if(prev > n){
					linkp = nt_link_add_n_data(top_linkp, prev);
					if(!top_linkp)
						top_linkp= linkp;
					return top_linkp;
				}
				while(prev <= n){
					linkp = nt_link_add_n_data(top_linkp, prev);
					if(!top_linkp)
						top_linkp = linkp;
					prev++;
				}
				if(endpp)
					*endpp = source + i;
			}else if(state == 2){
				linkp = nt_link_add_n_data(top_linkp, prev);
				if(!top_linkp)
					top_linkp = linkp;
				return top_linkp;
			}else{
				return top_linkp;
			}
			state = 0;
			break;
		case '-':
			if(state == 1){
				prev = atoi(start);
				if(endpp)
					*endpp = source + i;
				state = 2;
				break;
			}
			/* fall through */
		default:
			goto END_FOR;
		}/* end switch */
	}/* end for */
END_FOR:
	if(state == 1){
		n = atoi(start);
		linkp = nt_link_add_n_data(top_linkp, n);
		if(!top_linkp)
			top_linkp = linkp;
		if(endpp)
			*endpp = source + i;
	}else if(state == 3){
		n = atoi(start);
		if(prev > n){
			linkp = nt_link_add_n_data(top_linkp, prev);
			if(!top_linkp)
				top_linkp = linkp;
			return top_linkp;
		}
		while(prev <= n){
			linkp = nt_link_add_n_data(top_linkp, prev);
			if(!top_linkp)
				top_linkp = linkp;
			prev++;
		}
	}
	return top_linkp;
}


