/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _DISP_H_
#define _DISP_H_
#include "ui/disp_win.h"

#define	DISP_STATE_ERROR		(-1)
#define	DISP_STATE_BOARDMENU	1
#define	DISP_STATE_THREADTITLE	2
#define	DISP_STATE_RESLIST		3
#define	DISP_STATE_EDITOR		4 
#define	DISP_STATE_HTML_RESULT	5
#define	DISP_STATE_REFRESH		6


extern int disp_board_menu(nt_window_tp wp, 
		nt_2ch_model_tp modelp);
extern int disp_threadlist(nt_window_tp wp, 
		nt_2ch_model_tp modelp, void *usr_db_handle);
extern int disp_reslist(nt_window_tp wp, 
		nt_2ch_model_tp modelp, void *usr_db_handle);
extern void free_board_menu_ctx(void *ptr);
extern void init_threadlist_ctx(void *ptr);
extern void free_threadlist_ctx(void *ptr);
extern void free_reslist_ctx(void *ptr);
extern BOOL disp_editor(nt_write_data_tp writep);
extern int disp_html_result(nt_write_data_tp writep);

#endif /* _DISP_H_ */

