/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <wchar.h>
#include <assert.h>

#include "utils/nt_std_t.h"
#include "_2ch/model_2ch.h"


nt_thread_tp nt_get_thread_by_seq_no(
		nt_link_tp thread_list, int seq_no)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(seq_no == threadp->seq_no)
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}

nt_thread_tp nt_get_thread_by_dat_name(
		nt_link_tp thread_list, const wchar_t *dat_name)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(0 == wcscmp(dat_name, threadp->file_name))
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}
