/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <string.h>
#include <stdio.h>
#include <assert.h>

#include "error.h"
#include "utils/nt_std_t.h"
#include "utils/nt_pthread.h"

nt_pthread_ctxp nt_pthread_init(
		int num_threads, int queue_size. const wchar_t *error_msg)
{
	nt_pthread_ctxp ctxp;
	
	if(num_threads <= 0 || queue_size <= 0){
		error_msg = NT_ERR_MSG_THREAD_POOL_PARAM;
		return NULL;
	}
	
	ctxp = malloc(sizeof(nt_pthread_ctx));
	if(!ctxp){
		error_msg = NT_ERR_MSG_MEMORY_ALLOCATION;
		return NULL;
	}
	ctxp->pthreads = malloc(sizeof(pthread_t)*num_threads);
	if(!ctxp->pthreads){
		free(ctxp);
		error_msg = NT_ERR_MSG_MEMORY_ALLOCATION;
		return NULL;
	}
	pthread_mutex_init(&ctxp->mutex, NULL);
}
void nt_pthread_free(nt_pthread_ctxp ctxp)
{
	aassert(ctxp);
	if(ctxp->queue){
		nt_queue_free(ctxp->queue, NULL);
	free(ctxp);
}
