/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <wchar.h>
#include <assert.h>

#include "utils/nt_std_t.h"
#include "_2ch/model_2ch.h"

static BOOL address_match(const wchar_t *address, const wchar_t *param);

nt_board_tp nt_get_board_by_name(
		nt_2ch_model_tp modelp, const wchar_t *board_name,
		nt_category_tp *categorypp)
{
	nt_link_tp cate_list, board_list;
	nt_link_tp clinkp, blinkp;
	nt_category_tp catep;
	nt_board_tp boardp;
	
	assert(modelp);
	cate_list = modelp->categorylistp;
	if(!cate_list)
		return NULL;
	
	clinkp = cate_list;
	do{
		catep = (nt_category_tp)clinkp->data;
		board_list = catep->boardlistp;
		blinkp = board_list;
		if(blinkp){
			do{
				boardp = (nt_board_tp)blinkp->data;
				if(0 == wcscmp(boardp->name, board_name)){
					*categorypp = catep;
					return boardp;
				}
				blinkp = blinkp->next;
			}while(blinkp != board_list);
		}
		clinkp = clinkp->next;
	}while(clinkp != cate_list);
	return NULL;
}

nt_board_tp nt_get_board_by_address_match(
		nt_2ch_model_tp modelp, const wchar_t *param)
{
	nt_link_tp cate_list, board_list;
	nt_link_tp clinkp, blinkp;
	nt_category_tp catep;
	nt_board_tp boardp;
	
	assert(modelp);
	cate_list = modelp->categorylistp;
	if(!cate_list)
		return NULL;
	
	clinkp = cate_list;
	do{
		catep = (nt_category_tp)clinkp->data;
		board_list = catep->boardlistp;
		blinkp = board_list;
		if(blinkp){
			do{
				boardp = (nt_board_tp)blinkp->data;
				if(address_match(boardp->address, param))
					return boardp;
				blinkp = blinkp->next;
			}while(blinkp != board_list);
		}
		clinkp = clinkp->next;
	}while(clinkp != cate_list);
	return NULL;
}

static BOOL address_match(const wchar_t *address, const wchar_t *param)
{
	wchar_t *cptr;
	assert(address);
	
	cptr = wcsstr(address, L"http://");
	if(!cptr)
		return FALSE;
	
	cptr = wcsstr(cptr, L"/");
	if(!cptr)
		return FALSE;
	cptr = wcsstr(cptr, param);
	return (cptr == NULL) ? FALSE : TRUE;
}
nt_thread_tp nt_get_thread_by_seq_no(
		nt_link_tp thread_list, int seq_no)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(seq_no == threadp->seq_no)
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}

nt_thread_tp nt_get_thread_by_dat_name(
		nt_link_tp thread_list, const wchar_t *dat_name)
{
	nt_link_tp listp;
	nt_thread_tp threadp;

	assert(thread_list);

	listp = thread_list;
	do{
		threadp = (nt_thread_tp)listp->data;
		if(0 == wcscmp(dat_name, threadp->file_name))
			return threadp;	
		listp = listp->next;
	}while(listp != thread_list);

	return NULL;
}

