/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_PTHREAD_h_
#define _NT_PTHREAD_h_
#include <pthread.h>
#include <semaphore.h>


#define NT_PTHREAD_RESULT_NONE 0
#define NT_PTHREAD_RESULT_UPDATE_BOARD 1
#define NT_PTHREAD_RESULT_UPDATE_FAVORITE 2

typedef struct tag_nt_pthread_handle *nt_pthread_handle;
typedef struct tag_nt_pthread_handle{
	int chk_sum;
}nt_pthread_handle_t;

//typedef struct tag_nt_pthread_result_t *nt_pthread_result_tp;
typedef struct tag_nt_pthread_result_t{
	int code;
	void *data;
}nt_pthread_result_t;

typedef nt_pthread_result_t (*nt_pthread_fn)(void* data);
typedef nt_pthread_result_t (*nt_pthread_result_fn)(nt_pthread_result_t result);

extern BOOL nt_pthread_lib_init(int thread_pool_size, int queue_size,
		const char **error_msg);
extern void nt_pthread_lib_finish();

extern BOOL nt_pthread_put_que(nt_pthread_handle h_pthread);
extern nt_pthread_result_t nt_pthread_get_result_from_que();


extern nt_pthread_handle nt_pthread_alloc(
			nt_pthread_fn func, void *param, 
			nt_pthread_result_fn result_func);

extern int nt_pthread_add_ref(nt_pthread_handle h_pthread);
extern int nt_pthread_release_ref(nt_pthread_handle h_pthread);



#endif /* _NT_PTHREAD_h_ */
