/* Copyright 2014 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <iconv.h>
#include <netinet/in.h>
#include <assert.h>

#include "env.h"
#include "error.h"
#include "nt_string.h"
#include "utils/nt_std_t.h"
#include "net/nt_http.h"
#include "net/nt_socket.h"
#include "net/nt_cookie.h"
#include "utils/file.h"
#include "usr/usr_db_t.h"
#include "utils/nt_mutex.h"
#include "utils/nt_pthread.h"
#include "utils/nt_timer.h"
#include "utils/base64.h"
#include "utils/crypt.h"
#include "usr/favorite_t.h"
#include "_2ch/_2ch.h"
#include "_2ch/maru_2ch.h"
#include "_2ch/search_2ch.h"
#include "ui/disp.h"
#include "ui/disp_win.h"
#include "ui/disp_string.h"
#ifdef NT_CLOUD
#include "cloud/nt_cloud.h"
#endif 

static BOOL DoLoop();
static BOOL do_loop;
static void interrupt_handler(int signal)
{
	do_loop = FALSE;
	fputs("Program recieved interrupt signal.\n", stderr);
}

int server_main()
{
	int result;
	struct sigaction handler;
	
	result = 1;
	do_loop = TRUE;
	
	handler.sa_handler = interrupt_handler;
	if(sigfillset(&handler.sa_mask) < 0)
		return FALSE;
	handler.sa_flags = 0;
	if(sigaction(SIGINT, &handler, 0) < 0)
		return FALSE;
	
	if(DoLoop())
		goto ERROR_TRAP;
	
	result = 0;
ERROR_TRAP:
	return result;
}


static BOOL DoLoop()
{
	while(do_loop){
		sleep(1);
	}
	return TRUE;
}
