<?php
/*
 nce (ntch cloud environment.)
 name: create_table.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-13th
 License: GPLv3
 */
include_once "user.php";
include_once "database.php";
include_once "html_util.php";
include_once "log.php";

print_header("Initialize tables");

if(CREATE_DB_PHP == FALSE){
	echo "Canceled to initialize the db. [CREATE_DB_PHP == FALSE] in preference.php.";
	print_footer();
	exit;
}

if(USE_DB == "mysql"){
	$auto_increment = "auto_increment";
	$on_update_current_timestamp = "ON UPDATE CURRENT_TIMESTAMP";
}else{
	$auto_increment = "";
	$on_update_current_timestamp = "(DATETIME('now','localtime')";
}

$sql_drop_tbl = <<< END0
drop table $nc_ACCOUNTTABLE_NAME;
END0;
$sql_create_tbl = <<< END1
create table $nc_ACCOUNTTABLE_NAME (
user_id int unsigned not null {$auto_increment} primary key,
user_name char(20) ascii not null,
user_pass char(20) ascii not null,
seed char(20) ascii not null,
home_url char(60) ascii not null,
licensed timestamp null
);
END1;

function register_user($user_name, $password, $seed, $home_dir){
	global $db;
	global $auto_increment;
	global $on_update_current_timestamp;
	global $nc_ACCOUNTTABLE_NAME;
	$query = 
		"insert into $nc_ACCOUNTTABLE_NAME (".
		"user_name, user_pass, seed, home_url".
		")".
		"values(".
		"'{$user_name}','{$password}',".
		"'{$seed}','{$home_dir}'".
		");";
	$db->execute($query);
	$table_name = TABLE_PREFIX."tbl{$home_dir}";
	$query = "show tables like '{$table_name}'";
	$checktable = $db->execute($query);
	if($checktable->num_rows == 0){
		$query = "create table {$table_name}".
		" (id int unsigned not null {$auto_increment} primary key, ".
		"record_type tinyint unsigned not null, res_number char(25) ascii not null, ".
		"board_name char(45) ascii not null , dat_name char(25) ascii not null , ".
		"last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP {$on_update_current_timestamp} )";
		$db->execute($query);
	}
}
try{
	$db->open();
	try{
		$db->execute($sql_drop_tbl);
	}catch(Exception $e){
	}
	$db->execute($sql_create_tbl);
	foreach($user_list as $user){
		register_user( $user->user_name, 
			$user->password, $user->seed, 
			$user->home_dir);
	}
	$db->close();
	echo "<h1>Initialization complete.</h1>";
}catch(Exception $e){
	$error = __FILE__."(".__LINE__.") An error occured during  the database initialization.";
	nc_logging($error, $e);
	echo "<br />Please refer to ".LOG_FILE." and collect the error.<br />";
}

print_footer();

?>