/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _CRYPT_H_
#define _CRYPT_H_

typedef struct tag_nt_crypt_handle *nt_crypt_handle;
typedef struct tag_nt_crypt_handle{
	int chk_sum;
}nt_crypt_handle_t;


extern BOOL nt_make_sha1_string(const char *org_name, 
			char *outbuf, size_t outbuf_len);
extern BOOL nt_crypt_lib_init(const char *rfc2898_salt,
		int rfc2898_iteration, const char *aes256pass,
		const char **error_msg);
extern void nt_crypt_lib_finish();
extern nt_crypt_handle nt_crypt_get_handle();
extern int nt_crypt_encrypt(nt_crypt_handle handle,
		const unsigned char *in_buf, size_t in_buf_len,
		unsigned char *out_buf, size_t out_buf_len);
extern int nt_crypt_decrypt(nt_crypt_handle handle,
		const unsigned char *in_buf, size_t in_buf_len,
		unsigned char *out_buf, size_t out_buf_len);
extern int nt_crypt_add_ref(nt_crypt_handle handle);
extern int nt_crypt_release_ref(nt_crypt_handle handle);

#endif /* _CRYPT_H_ */

