/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.Logger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public class SockIOPool {
    private static Logger log = Logger.getLogger(SockIOPool.class.getName());
    private static SockIOPool instance = new SockIOPool();
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    private boolean initialized = false;
    private boolean maintThreadRunning = false;
    private int maxCreate = 1;
    private Map createShift;
    private final int poolMultiplier = 4;
    private int initConn = 3;
    private int minConn = 3;
    private int maxConn = 10;
    private long maxIdle = 180000L;
    private long maintSleep = 5000L;
    private int socketTO = 10000;
    private int socketConnectTO = 0;
    private boolean failover = true;
    private boolean nagle = true;
    private int hashingAlg = 0;
    private String[] servers;
    private Integer[] weights;
    private List buckets;
    private Map hostDead;
    private Map hostDeadDur;
    private Map availPool;
    private Map busyPool;

    protected SockIOPool() {
    }

    public static SockIOPool getInstance() {
        return instance;
    }

    public void setServers(String[] servers) {
        this.servers = servers;
    }

    public String[] getServers() {
        return this.servers;
    }

    public void setWeights(Integer[] weights) {
        this.weights = weights;
    }

    public Integer[] getWeights() {
        return this.weights;
    }

    public void setInitConn(int initConn) {
        this.initConn = initConn;
    }

    public int getInitConn() {
        return this.initConn;
    }

    public void setMinConn(int minConn) {
        this.minConn = minConn;
    }

    public int getMinConn() {
        return this.minConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaintSleep(long maintSleep) {
        this.maintSleep = maintSleep;
    }

    public long getMaintSleep() {
        return this.maintSleep;
    }

    public void setSocketTO(int socketTO) {
        this.socketTO = socketTO;
    }

    public int getSocketTO() {
        return this.socketTO;
    }

    public void setSocketConnectTO(int socketConnectTO) {
        this.socketConnectTO = socketConnectTO;
    }

    public int getSocketConnectTO() {
        return this.socketConnectTO;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public boolean getFailover() {
        return this.failover;
    }

    public void setNagle(boolean nagle) {
        this.nagle = nagle;
    }

    public boolean getNagle() {
        return this.nagle;
    }

    public void setHashingAlg(int alg) {
        this.hashingAlg = alg;
    }

    public int getHashingAlg() {
        return this.hashingAlg;
    }

    public synchronized void initialize() {
        if (this.initialized && this.buckets != null && this.availPool != null && this.busyPool != null) {
            log.error("++++ trying to initialize an already initialized pool");
            return;
        }
        this.buckets = new ArrayList();
        this.availPool = new Hashtable(this.servers.length * this.initConn);
        this.busyPool = new Hashtable(this.servers.length * this.initConn);
        this.hostDeadDur = new Hashtable();
        this.hostDead = new Hashtable();
        this.createShift = new Hashtable();
        this.maxCreate = 4 > this.minConn ? this.minConn : this.minConn / 4;
        log.debug("++++ initializing pool with following settings:");
        log.debug("++++ initial size: " + this.initConn);
        log.debug("++++ min spare   : " + this.minConn);
        log.debug("++++ max spare   : " + this.maxConn);
        if (this.servers == null || this.servers.length <= 0) {
            log.error("++++ trying to initialize with no servers");
            throw new IllegalStateException("++++ trying to initialize with no servers");
        }
        for (int i = 0; i < this.servers.length; ++i) {
            SockIO socket;
            if (this.weights != null && this.weights.length > i) {
                for (int k = 0; k < this.weights[i]; ++k) {
                    this.buckets.add(this.servers[i]);
                    log.debug("++++ added " + this.servers[i] + " to server bucket");
                }
            } else {
                this.buckets.add(this.servers[i]);
                log.debug("++++ added " + this.servers[i] + " to server bucket");
            }
            log.debug("+++ creating initial connections (" + this.initConn + ") for host: " + this.servers[i]);
            for (int j = 0; j < this.initConn && (socket = this.createSocket(this.servers[i])) != null; ++j) {
                this.addSocketToPool(this.availPool, this.servers[i], socket);
                log.debug("++++ created and added socket: " + socket.toString() + " for host " + this.servers[i]);
            }
        }
        this.initialized = true;
        if (this.maintSleep > 0L) {
            this.startMaintThread();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private SockIO createSocket(String host) {
        long expire;
        SockIO socket = null;
        if (this.hostDead.containsKey(host) && this.hostDeadDur.containsKey(host)) {
            Date store = (Date)this.hostDead.get(host);
            expire = (Long)this.hostDeadDur.get(host);
            if (store.getTime() + expire > System.currentTimeMillis()) {
                return null;
            }
        }
        try {
            socket = new SockIO(host, this.socketTO, this.socketConnectTO, this.nagle);
            if (!socket.isConnected()) {
                log.error("++++ failed to get SockIO obj for: " + host + " -- new socket is not connected");
                try {
                    socket.trueClose();
                }
                catch (Exception ex) {
                    log.error("++++ failed to close SockIO obj for server: " + host);
                    log.error(ex.getMessage(), ex);
                    socket = null;
                }
            }
        }
        catch (Exception ex) {
            log.error("++++ failed to get SockIO obj for: " + host);
            log.error(ex.getMessage(), ex);
        }
        if (socket == null) {
            Date now = new Date();
            this.hostDead.put(host, now);
            expire = this.hostDeadDur.containsKey(host) ? (Long)this.hostDeadDur.get(host) * 2L : 1000L;
            this.hostDeadDur.put(host, new Long(expire));
            log.debug("++++ ignoring dead host: " + host + " for " + expire + " ms");
            this.clearHostFromPool(this.availPool, host);
        } else {
            log.debug("++++ created socket (" + socket.toString() + ") for host: " + host);
            this.hostDead.remove(host);
            this.hostDeadDur.remove(host);
        }
        return socket;
    }

    public SockIO getSock(String key) {
        return this.getSock(key, null);
    }

    public SockIO getSock(String key, Integer hashCode) {
        int hv;
        log.debug("cache socket pick " + key + " " + hashCode);
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (this.buckets.size() == 0) {
            return null;
        }
        if (this.buckets.size() == 1) {
            return this.getConnection((String)this.buckets.get(0));
        }
        int tries = 0;
        if (hashCode != null) {
            hv = hashCode;
        } else {
            switch (this.hashingAlg) {
                case 0: {
                    hv = key.hashCode();
                    break;
                }
                case 1: {
                    hv = SockIOPool.origCompatHashingAlg(key);
                    break;
                }
                case 2: {
                    hv = SockIOPool.newCompatHashingAlg(key);
                    break;
                }
                default: {
                    hv = 0;
                }
            }
        }
        int bucketSize = this.buckets.size();
        while (tries++ < bucketSize) {
            int bucket = hv % bucketSize;
            if (bucket < 0) {
                bucket += bucketSize;
            }
            SockIO sock = this.getConnection((String)this.buckets.get(bucket));
            log.debug("cache choose " + this.buckets.get(bucket) + " for " + key);
            if (sock != null) {
                return sock;
            }
            if (!this.failover) {
                return null;
            }
            hv += ("" + hv + tries).hashCode();
        }
        return null;
    }

    private static int origCompatHashingAlg(String key) {
        int hash = 0;
        char[] cArr = key.toCharArray();
        for (int i = 0; i < cArr.length; ++i) {
            hash = hash * 33 + cArr[i];
        }
        return hash;
    }

    private static int newCompatHashingAlg(String key) {
        CRC32 checksum = new CRC32();
        checksum.update(key.getBytes());
        int crc = (int)checksum.getValue();
        return crc >> 16 & Short.MAX_VALUE;
    }

    public synchronized SockIO getConnection(String host) {
        SockIO socket;
        Integer cShift;
        int shift;
        int create;
        Map aSockets;
        if (!this.initialized) {
            log.error("attempting to get SockIO from uninitialized pool!");
            return null;
        }
        if (host == null) {
            return null;
        }
        if (this.availPool != null && !this.availPool.isEmpty() && (aSockets = (Map)this.availPool.get(host)) != null && !aSockets.isEmpty()) {
            Iterator i = aSockets.keySet().iterator();
            while (i.hasNext()) {
                SockIO socket2 = (SockIO)i.next();
                if (socket2.isConnected()) {
                    log.debug("++++ moving socket for host (" + host + ") to busy pool ... socket: " + socket2);
                    i.remove();
                    this.addSocketToPool(this.busyPool, host, socket2);
                    return socket2;
                }
                log.error("++++ socket in avail pool is not connected: " + socket2.toString() + " for host: " + host);
                socket2 = null;
                i.remove();
            }
        }
        if ((create = 1 << (shift = (cShift = (Integer)this.createShift.get(host)) != null ? cShift : 0)) >= this.maxCreate) {
            create = this.maxCreate;
        } else {
            ++shift;
        }
        this.createShift.put(host, new Integer(shift));
        log.debug("++++ creating " + create + " new SockIO objects");
        for (int i = create; i > 0 && (socket = this.createSocket(host)) != null; --i) {
            if (i == 1) {
                this.addSocketToPool(this.busyPool, host, socket);
                return socket;
            }
            this.addSocketToPool(this.availPool, host, socket);
        }
        return null;
    }

    private synchronized void addSocketToPool(Map pool, String host, SockIO socket) {
        Map<SockIO, Long> sockets;
        if (pool.containsKey(host) && (sockets = (Map)pool.get(host)) != null) {
            sockets.put(socket, new Long(System.currentTimeMillis()));
            return;
        }
        sockets = new Hashtable();
        sockets.put(socket, new Long(System.currentTimeMillis()));
        pool.put(host, sockets);
    }

    private synchronized void removeSocketFromPool(Map pool, String host, SockIO socket) {
        Map sockets;
        if (pool.containsKey(host) && (sockets = (Map)pool.get(host)) != null) {
            sockets.remove(socket);
        }
    }

    private synchronized void clearHostFromPool(Map pool, String host) {
        Map sockets;
        if (pool.containsKey(host) && (sockets = (Map)pool.get(host)) != null && sockets.size() > 0) {
            Iterator i = sockets.keySet().iterator();
            while (i.hasNext()) {
                SockIO socket = (SockIO)i.next();
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to close socket: " + ioe.getMessage());
                }
                i.remove();
                socket = null;
            }
        }
    }

    public synchronized void checkIn(SockIO socket, boolean addToAvail) {
        String host = socket.getHost();
        log.debug("++++ calling check-in on socket: " + socket.toString() + " for host: " + host);
        log.debug("++++ removing socket (" + socket.toString() + ") from busy pool for host: " + host);
        this.removeSocketFromPool(this.busyPool, host, socket);
        if (addToAvail && socket.isConnected()) {
            log.debug("++++ returning socket (" + socket.toString() + " to avail pool for host: " + host);
            this.addSocketToPool(this.availPool, host, socket);
        }
    }

    public synchronized void checkIn(SockIO socket) {
        this.checkIn(socket, true);
    }

    private void closePool(Map pool) {
        for (String host : pool.keySet()) {
            Map sockets = (Map)pool.get(host);
            Iterator j = sockets.keySet().iterator();
            while (j.hasNext()) {
                SockIO socket = (SockIO)j.next();
                try {
                    socket.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to trueClose socket: " + socket.toString() + " for host: " + host);
                }
                j.remove();
                socket = null;
            }
        }
    }

    public synchronized void shutDown() {
        log.debug("++++ SockIOPool shutting down...");
        if (this.maintThreadRunning) {
            this.stopMaintThread();
        }
        log.debug("++++ closing all internal pools.");
        this.closePool(this.availPool);
        this.closePool(this.busyPool);
        this.availPool = null;
        this.busyPool = null;
        this.buckets = null;
        this.hostDeadDur = null;
        this.hostDead = null;
        this.initialized = false;
        log.debug("++++ SockIOPool finished shutting down.");
    }

    private synchronized void startMaintThread() {
        if (this.maintThreadRunning) {
            return;
        }
        MaintThread t = MaintThread.getInstance();
        t.setInterval(this.maintSleep);
        t.start();
        this.maintThreadRunning = true;
    }

    private synchronized void stopMaintThread() {
        if (!this.maintThreadRunning) {
            log.error("++++ maint thread not running, so can't stop it");
            return;
        }
        MaintThread t = MaintThread.getInstance();
        t.stopThread();
        this.maintThreadRunning = false;
    }

    private synchronized void selfMaint() {
        log.debug("++++ Starting self maintenance....");
        for (String host : this.availPool.keySet()) {
            Map sockets = (Map)this.availPool.get(host);
            Map bSockets = (Map)this.busyPool.get(host);
            log.debug("++++ Size of avail pool for host (" + host + ") = " + sockets.size());
            log.debug("++++ Size of busy pool for host (" + host + ") = " + bSockets.size());
            if (sockets.size() < this.minConn) {
                SockIO socket;
                int need = this.minConn - sockets.size();
                log.debug("++++ Need to create " + need + " new sockets for pool for host: " + host);
                for (int j = 0; j < need && (socket = this.createSocket(host)) != null; ++j) {
                    this.addSocketToPool(this.availPool, host, socket);
                }
            } else if (sockets.size() > this.maxConn) {
                int diff = sockets.size() - this.maxConn;
                int needToClose = diff <= 4 ? diff : diff / 4;
                log.debug("++++ need to remove " + needToClose + " spare sockets for pool for host: " + host);
                Iterator j = sockets.keySet().iterator();
                while (j.hasNext() && needToClose > 0) {
                    SockIO socket = (SockIO)j.next();
                    long expire = (Long)sockets.get(socket);
                    if (expire + this.maxIdle >= System.currentTimeMillis()) continue;
                    log.debug("+++ removing stale entry from pool as it is past its idle timeout and pool is over max spare");
                    try {
                        socket.trueClose();
                    }
                    catch (IOException ioe) {
                        log.error("failed to close socket");
                        log.error(ioe.getMessage(), ioe);
                    }
                    j.remove();
                    socket = null;
                    --needToClose;
                }
            }
            this.createShift.put(host, new Integer(0));
        }
        log.debug("+++ ending self maintenance.");
    }

    static class ConnectThread
    extends Thread {
        private static Logger log = Logger.getLogger(ConnectThread.class.getName());
        private Socket socket;
        private String host;
        private int port;
        boolean error;

        public ConnectThread(String host, int port) {
            this.host = host;
            this.port = port;
            this.socket = null;
            this.error = false;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.socket = new Socket(this.host, this.port);
            }
            catch (IOException ioe) {
                this.error = true;
            }
            log.debug("socket creation thread leaving for host: " + this.host);
        }

        public boolean isConnected() {
            return this.socket != null && this.socket.isConnected();
        }

        public boolean isError() {
            return this.error;
        }

        public Socket getSocket() {
            return this.socket;
        }
    }

    public static class SockIO {
        private static Logger log = Logger.getLogger(SockIO.class.getName());
        private String host;
        private Socket sock;
        private DataInputStream in;
        private BufferedOutputStream out;

        SockIO(String host, int port, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            Socket socket = this.sock = connectTimeout > 0 ? SockIO.getSocket(host, port, connectTimeout) : new Socket(host, port);
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host + ":" + port;
        }

        SockIO(String host, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
            String[] ip = host.split(":");
            Socket socket = this.sock = connectTimeout > 0 ? SockIO.getSocket(ip[0], Integer.parseInt(ip[1]), connectTimeout) : new Socket(ip[0], Integer.parseInt(ip[1]));
            if (timeout >= 0) {
                this.sock.setSoTimeout(timeout);
            }
            this.sock.setTcpNoDelay(noDelay);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = host;
        }

        private static Socket getSocket(String host, int port, int timeout) throws IOException {
            ConnectThread thread = new ConnectThread(host, port);
            thread.start();
            Object socket = null;
            int sleep = 25;
            for (int timer = 0; timer < timeout; timer += sleep) {
                if (thread.isConnected()) {
                    return thread.getSocket();
                }
                if (thread.isError()) {
                    throw new IOException();
                }
                try {
                    Thread.sleep(sleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            throw new IOException("Could not connect for " + timeout + " milliseconds");
        }

        String getHost() {
            return this.host;
        }

        void trueClose() throws IOException {
            log.debug("++++ Closing socket for real: " + this.toString());
            boolean err = false;
            StringBuffer errMsg = new StringBuffer();
            if (this.in == null || this.out == null || this.sock == null) {
                err = true;
                errMsg.append("++++ socket or its streams already null in trueClose call");
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), ioe);
                    errMsg.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), ioe);
                    errMsg.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {
                    log.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                    log.error(ioe.getMessage(), ioe);
                    errMsg.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    errMsg.append(ioe.getMessage());
                    err = true;
                }
            }
            if (this.sock != null) {
                SockIOPool.getInstance().checkIn(this, false);
            }
            this.in = null;
            this.out = null;
            this.sock = null;
            if (err) {
                throw new IOException(errMsg.toString());
            }
        }

        void close() {
            log.debug("++++ marking socket (" + this.toString() + ") as closed and available to return to avail pool");
            SockIOPool.getInstance().checkIn(this);
        }

        boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
            if (bos == null || bos.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return bos.toString().trim();
        }

        void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] b = new byte[1];
            boolean eol = false;
            while (this.in.read(b, 0, 1) != -1) {
                if (b[0] == 13) {
                    eol = true;
                    continue;
                }
                if (!eol) continue;
                if (b[0] == 10) break;
                eol = false;
            }
        }

        void read(byte[] b) throws IOException {
            int cnt;
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to read from closed socket");
                throw new IOException("++++ attempting to read from closed socket");
            }
            for (int count = 0; count < b.length; count += cnt) {
                cnt = this.in.read(b, count, b.length - count);
            }
        }

        void flush() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.flush();
        }

        void write(byte[] b) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                log.error("++++ attempting to write to closed socket");
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.write(b);
        }

        public int hashCode() {
            return this.sock == null ? 0 : this.sock.hashCode();
        }

        public String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }
    }

    private static class MaintThread
    extends Thread {
        private long interval = 3000L;
        private boolean stopThread = false;
        private static MaintThread thread = null;

        private MaintThread() {
            this.setDaemon(true);
        }

        public static synchronized MaintThread getInstance() {
            if (thread == null) {
                thread = new MaintThread();
            }
            return thread;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void stopThread() {
            this.stopThread = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopThread) {
                try {
                    MaintThread.sleep(this.interval);
                    SockIOPool poolObj = SockIOPool.getInstance();
                    if (!poolObj.isInitialized()) continue;
                    poolObj.selfMaint();
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }
}

