/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.AllFileModeCoreValueCnv;
import okuyama.imdst.util.CoreValueMapSet;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ICoreValueConverter;
import okuyama.imdst.util.MemoryModeCoreValueCnv;
import okuyama.imdst.util.PartialFileModeCoreValueCnv;
import okuyama.imdst.util.StatusUtil;

public class CoreValueMap
extends AbstractMap
implements Cloneable,
Serializable {
    private boolean fileWrite = false;
    private ICoreValueConverter converter = null;
    private AbstractMap mainMap = null;
    private boolean allDataMemory = false;
    private boolean urgentSaveMode = false;
    private AbstractMap urgentSaveMap = null;
    private ICoreValueConverter urgentSaveMapConverter = null;
    private String[] virtualStoreDirs = null;
    private Object syncObj = new Object();

    public CoreValueMap(int size, int upper, int multi, boolean memoryMode, String[] virtualStoreDirs) {
        if (memoryMode) {
            this.mainMap = new ConcurrentHashMap(size, upper, multi);
            this.converter = new MemoryModeCoreValueCnv();
            this.allDataMemory = true;
        } else {
            this.mainMap = new ConcurrentHashMap(size, upper, multi);
            this.converter = new PartialFileModeCoreValueCnv();
        }
        this.virtualStoreDirs = virtualStoreDirs;
    }

    public CoreValueMap(String[] dirs, int numberOfDataSize) {
        this.mainMap = new FileBaseDataMap(dirs, numberOfDataSize);
        this.converter = new AllFileModeCoreValueCnv();
    }

    @Override
    public Object put(Object key, Object value) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        return this.urgentSaveMap.put(this.urgentSaveMapConverter.convertEncodeKey(key), this.urgentSaveMapConverter.convertEncodeValue(value));
    }

    @Override
    public Object get(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.get(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public Object remove(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.remove(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.containsKey(this.converter.convertEncodeKey(key));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return true;
        }
        return this.urgentSaveMap.containsKey(this.urgentSaveMapConverter.convertEncodeKey(key));
    }

    @Override
    public void clear() {
        this.mainMap.clear();
        if (this.isUrgentSaveMode()) {
            this.urgentSaveMap.clear();
        }
    }

    @Override
    public int size() {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.size();
        }
        int retSize = this.mainMap.size();
        return retSize += this.urgentSaveMap.size();
    }

    @Override
    public Set entrySet() {
        if (!this.isUrgentSaveMode()) {
            return new CoreValueMapSet(this.mainMap.entrySet(), this.converter);
        }
        return new CoreValueMapSet(this.mainMap.entrySet(), this.urgentSaveMap.entrySet(), this.converter, this.urgentSaveMapConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUrgentSaveMode() {
        if (this.virtualStoreDirs == null) {
            return false;
        }
        if (this.urgentSaveMode) {
            return true;
        }
        if (!StatusUtil.isUseMemoryLimitOver()) {
            return false;
        }
        if (this.urgentSaveMap != null) {
            return true;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.urgentSaveMap != null) {
                return true;
            }
            this.urgentSaveMapConverter = new AllFileModeCoreValueCnv();
            this.urgentSaveMap = this.allDataMemory ? new FileBaseDataMap(this.virtualStoreDirs, 1000000, 0.1, new Double(1447034.88).intValue() + 1) : new FileBaseDataMap(this.virtualStoreDirs, 1000000, 0.1);
            this.urgentSaveMode = true;
        }
        return true;
    }
}

