/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import okuyama.imdst.util.CoreValueMap;
import okuyama.imdst.util.FileBaseDataList;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.ValueCacheMap;
import org.apache.commons.codec.digest.DigestUtils;

public class KeyManagerValueMap
extends CoreValueMap
implements Cloneable,
Serializable {
    private boolean memoryMode = true;
    private transient FileOutputStream fos = null;
    private transient OutputStreamWriter osw = null;
    private transient BufferedWriter bw = null;
    private transient RandomAccessFile raf = null;
    private transient Object sync = new Object();
    private transient boolean vacuumExecFlg = false;
    private transient List vacuumDiffDataList = null;
    private ConcurrentHashMap dataSizeMap = new ConcurrentHashMap();
    private String lineFile = null;
    private String tmpVacuumeLineFile = null;
    private String[] tmpVacuumeCopyMapDirs = null;
    private int lineCount = 0;
    private int oneDataLength = 8192;
    private int seekOneDataLength = 8193;
    private long lastDataChangeTime = 0L;
    private int nowKeySize = 0;
    private transient boolean readObjectFlg = false;
    private int overSizeDataParallelSize = 2000;
    private Object[] overSizeDataParallelSyncs = new Object[this.overSizeDataParallelSize];
    private ValueCacheMap valueCacheMap = null;

    public KeyManagerValueMap(int size, boolean memoryMode, String[] virtualStoreDirs) {
        super(size, new Double((double)size * 0.9).intValue(), 512, memoryMode, virtualStoreDirs);
        this.memoryMode = memoryMode;
    }

    public KeyManagerValueMap(String[] dirs, int numberOfDataSize) {
        super(dirs, numberOfDataSize);
        this.memoryMode = false;
    }

    public void initNoMemoryModeSetting(String lineFile) {
        try {
            if (this.sync == null) {
                this.sync = new Object();
            }
            this.readObjectFlg = true;
            this.tmpVacuumeLineFile = lineFile + ".vacuumtmp";
            this.tmpVacuumeCopyMapDirs = new String[5];
            this.tmpVacuumeCopyMapDirs[0] = lineFile + ".cpmapdir1/";
            this.tmpVacuumeCopyMapDirs[1] = lineFile + ".cpmapdir2/";
            this.tmpVacuumeCopyMapDirs[2] = lineFile + ".cpmapdir3/";
            this.tmpVacuumeCopyMapDirs[3] = lineFile + ".cpmapdir4/";
            this.tmpVacuumeCopyMapDirs[4] = lineFile + ".cpmapdir5/";
            for (int dirIdx = -19; dirIdx < 20; ++dirIdx) {
                File overDataFileDir = new File(lineFile + "_/" + dirIdx);
                overDataFileDir.mkdirs();
            }
            for (int overSizeParallelIdx = 0; overSizeParallelIdx < this.overSizeDataParallelSize; ++overSizeParallelIdx) {
                this.overSizeDataParallelSyncs[overSizeParallelIdx] = new Object();
            }
            this.fos = new FileOutputStream(new File(lineFile), true);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
            this.bw = new BufferedWriter(this.osw);
            this.raf = new RandomAccessFile(new File(lineFile), "rw");
            FileInputStream fis = new FileInputStream(new File(lineFile));
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            this.lineFile = lineFile;
            int counter = 0;
            while (br.readLine() != null) {
                ++counter;
            }
            this.lineCount = counter;
            br.close();
            isr.close();
            fis.close();
            this.nowKeySize = super.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - init - Error [" + e.getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNoCnv(Object key) {
        Object ret = null;
        if (this.memoryMode) {
            ret = super.get(key);
        } else {
            try {
                boolean i = false;
                long seekPoint = 0L;
                byte[] buf = new byte[this.oneDataLength];
                seekPoint = this.calcSeekDataPoint(key);
                if (seekPoint == -1L) {
                    return null;
                }
                Object object = this.sync;
                synchronized (object) {
                    if (this.vacuumExecFlg && seekPoint != this.calcSeekDataPoint(key)) {
                        return this.get(key);
                    }
                    this.readDataFile(buf, seekPoint, this.oneDataLength);
                }
                ret = new String(buf, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - get - Error [" + e.getMessage() + "]");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object ret;
        block31: {
            ret = null;
            if (this.memoryMode) {
                ret = super.get(key);
            } else {
                try {
                    int i;
                    if (this.vacuumExecFlg) {
                        ret = this.syncGet(key);
                        break block31;
                    }
                    int readRet = 0;
                    long seekPoint = 0L;
                    byte[] buf = new byte[this.oneDataLength];
                    seekPoint = this.calcSeekDataPoint(key);
                    if (seekPoint == -1L) {
                        return null;
                    }
                    Object object = this.sync;
                    synchronized (object) {
                        readRet = this.readDataFile(buf, seekPoint, this.oneDataLength);
                        if (readRet == -1) {
                            return null;
                        }
                    }
                    if (readRet > this.oneDataLength) {
                        object = this.overSizeDataParallelSyncs[(key.toString().hashCode() << 1 >>> 1) % this.overSizeDataParallelSize];
                        synchronized (object) {
                            File overDataFile = new File(this.lineFile + "_/" + key.toString().hashCode() % 20 + "/" + DigestUtils.md5Hex((byte[])key.toString().getBytes()));
                            if (overDataFile.exists()) {
                                FileInputStream fis = null;
                                InputStreamReader isr = null;
                                BufferedReader br = null;
                                try {
                                    fis = new FileInputStream(overDataFile);
                                    isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                    br = new BufferedReader(isr);
                                    StringBuilder retTmpBuf = new StringBuilder(this.oneDataLength);
                                    retTmpBuf.append(new String(buf, 0, this.oneDataLength, "UTF-8"));
                                    retTmpBuf.append(br.readLine());
                                    ret = retTmpBuf.toString();
                                }
                                catch (Exception inE) {
                                    inE.printStackTrace();
                                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - Inner File Read[get] - Error [" + inE.getMessage() + "]");
                                }
                                finally {
                                    try {
                                        if (br != null) {
                                            br.close();
                                        }
                                        if (isr != null) {
                                            isr.close();
                                        }
                                        if (fis != null) {
                                            fis.close();
                                        }
                                    }
                                    catch (Exception inE2) {}
                                }
                            } else {
                                return null;
                            }
                        }
                    }
                    for (i = 0; i < buf.length && buf[i] != 38; ++i) {
                    }
                    ret = new String(buf, 0, i, "UTF-8");
                    buf = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - get - Error [" + e.getMessage() + "]");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncGet(Object key) {
        String ret = null;
        try {
            byte[] buf = new byte[this.oneDataLength];
            long seekPoint = 0L;
            int readRet = 0;
            Object object = this.sync;
            synchronized (object) {
                int i;
                seekPoint = this.calcSeekDataPoint(key);
                if (seekPoint == -1L) {
                    return null;
                }
                readRet = this.readDataFile(buf, seekPoint, this.oneDataLength);
                if (readRet > this.oneDataLength) {
                    Object object2 = this.overSizeDataParallelSyncs[(key.toString().hashCode() << 1 >>> 1) % this.overSizeDataParallelSize];
                    synchronized (object2) {
                        File overDataFile = null;
                        FileInputStream fis = null;
                        InputStreamReader isr = null;
                        BufferedReader br = null;
                        try {
                            overDataFile = new File(this.lineFile + "_/" + key.toString().hashCode() % 20 + "/" + DigestUtils.md5Hex((byte[])key.toString().getBytes()));
                            fis = new FileInputStream(overDataFile);
                            isr = new InputStreamReader((InputStream)fis, "UTF-8");
                            br = new BufferedReader(isr);
                            StringBuilder retTmpBuf = new StringBuilder(this.oneDataLength);
                            retTmpBuf.append(new String(buf, 0, this.oneDataLength, "UTF-8"));
                            retTmpBuf.append(br.readLine());
                            ret = retTmpBuf.toString();
                        }
                        catch (Exception inE) {
                            inE.printStackTrace();
                            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - syncGet - Inner File Read Error [" + inE.getMessage() + "]");
                        }
                        finally {
                            try {
                                if (br != null) {
                                    br.close();
                                }
                                if (isr != null) {
                                    isr.close();
                                }
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception inE2) {}
                        }
                    }
                }
                for (i = 0; i < buf.length && buf[i] != 38; ++i) {
                }
                ret = new String(buf, 0, i, "UTF-8");
                buf = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - syncGet - Error [" + e.getMessage() + "]");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        Object ret;
        block33: {
            ret = null;
            this.totalDataSizeCalc(key, value);
            if (this.memoryMode) {
                ret = super.put(key, value);
            } else {
                StringBuilder writeBuf = new StringBuilder(this.oneDataLength + 2);
                int valueSize = value.toString().length();
                try {
                    if (this.readObjectFlg) {
                        Object[] diffObj;
                        Object object;
                        long seekPoint = 0L;
                        boolean overSizeFlg = false;
                        if (((String)value).length() > this.oneDataLength) {
                            writeBuf.append(((String)value).substring(0, this.oneDataLength));
                            overSizeFlg = true;
                            valueSize = this.oneDataLength;
                        } else {
                            writeBuf.append((String)value);
                        }
                        byte[] appendDatas = new byte[this.oneDataLength - valueSize];
                        for (int i = 0; i < appendDatas.length; ++i) {
                            appendDatas[i] = 38;
                        }
                        writeBuf.append(new String(appendDatas));
                        writeBuf.append("\n");
                        seekPoint = this.calcSeekDataPoint(key);
                        if (seekPoint == -1L) {
                            object = this.sync;
                            synchronized (object) {
                                if (this.vacuumExecFlg) {
                                    diffObj = new Object[]{"1", (String)key, (String)value};
                                    this.vacuumDiffDataList.add(diffObj);
                                }
                                this.bw.write(writeBuf.toString());
                                this.bw.flush();
                                ++this.lineCount;
                                super.put(key, new Integer(this.lineCount));
                                this.nowKeySize = super.size();
                            }
                        }
                        object = this.sync;
                        synchronized (object) {
                            if (this.vacuumExecFlg) {
                                diffObj = new Object[]{"1", key, value};
                                this.vacuumDiffDataList.add(diffObj);
                            }
                            if (this.raf != null) {
                                this.raf.seek(seekPoint);
                                this.raf.write(writeBuf.toString().getBytes(), 0, this.oneDataLength);
                            }
                        }
                        if (!overSizeFlg) break block33;
                        object = this.overSizeDataParallelSyncs[(key.toString().hashCode() << 1 >>> 1) % this.overSizeDataParallelSize];
                        synchronized (object) {
                            File overDataFile = new File(this.lineFile + "_/" + key.toString().hashCode() % 20 + "/" + DigestUtils.md5Hex((byte[])key.toString().getBytes()));
                            BufferedWriter overBw = null;
                            try {
                                overBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(overDataFile, false), "UTF-8"));
                                overBw.write(((String)value).substring(this.oneDataLength, ((String)value).length()));
                                overBw.flush();
                            }
                            catch (Exception inE) {
                                inE.printStackTrace();
                                StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - Inner File Write - Error [" + inE.getMessage() + "]");
                            }
                            finally {
                                try {
                                    if (overBw != null) {
                                        overBw.close();
                                    }
                                }
                                catch (Exception inE2) {}
                            }
                            break block33;
                        }
                    }
                    super.put(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - put - Error [" + e.getMessage() + "]");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Object ret = null;
        Object object = this.sync;
        synchronized (object) {
            this.totalDataSizeCalc(key, null);
            ret = super.remove(key);
            this.nowKeySize = super.size();
            if (this.vacuumExecFlg) {
                Object[] diffObj = new Object[]{"2", (String)key};
                this.vacuumDiffDataList.add(diffObj);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.vacuumExecFlg) {
            Object object = this.sync;
            synchronized (object) {
                return super.containsKey(key);
            }
        }
        return super.containsKey(key);
    }

    private void totalDataSizeCalc(Object key, Object value) {
    }

    public long getDataUseSize(String unique) {
        AtomicLong size = new AtomicLong(0L);
        if (unique == null) {
            unique = "all";
        }
        if (this.dataSizeMap.containsKey(unique)) {
            size = (AtomicLong)this.dataSizeMap.get(unique);
        }
        return size.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vacuumData() {
        boolean ret = false;
        FileOutputStream tmpFos = null;
        OutputStreamWriter tmpOsw = null;
        BufferedWriter tmpBw = null;
        RandomAccessFile raf = null;
        AbstractMap vacuumWorkMap = null;
        boolean userMap = false;
        String dataStr = null;
        Set entrySet = null;
        Iterator entryIte = null;
        String key = null;
        int putCounter = 0;
        Object object = this.sync;
        synchronized (object) {
            if (this.vacuumDiffDataList != null) {
                this.vacuumDiffDataList.clear();
                this.vacuumDiffDataList = null;
            }
            this.vacuumDiffDataList = new FileBaseDataList(this.tmpVacuumeLineFile);
            this.vacuumExecFlg = true;
        }
        if (JavaSystemApi.getUseMemoryPercent() > 40) {
            userMap = true;
            vacuumWorkMap = new FileBaseDataMap(this.tmpVacuumeCopyMapDirs, super.size(), 0.2);
        } else {
            vacuumWorkMap = new HashMap(super.size());
        }
        try {
            tmpFos = new FileOutputStream(new File(this.lineFile + ".tmp"), true);
            tmpOsw = new OutputStreamWriter((OutputStream)tmpFos, "UTF-8");
            tmpBw = new BufferedWriter(tmpOsw);
            raf = new RandomAccessFile(new File(this.lineFile), "r");
            entrySet = super.entrySet();
            for (Object obj : entrySet) {
                key = (String)obj.getKey();
                if (key == null || (dataStr = (String)this.getNoCnv(key)) == null) continue;
                tmpBw.write(dataStr);
                tmpBw.write("\n");
                vacuumWorkMap.put(key, new Integer(++putCounter).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e.getMessage() + "]");
        }
        finally {
            block45: {
                try {
                    if (StatusUtil.getStatus() != 0) break block45;
                    tmpBw.flush();
                    tmpBw.close();
                    tmpOsw.close();
                    tmpFos.close();
                    Object e = this.sync;
                    synchronized (e) {
                        File dataFile;
                        raf.close();
                        if (this.raf != null) {
                            this.raf.close();
                        }
                        if (this.bw != null) {
                            this.bw.close();
                        }
                        if (this.osw != null) {
                            this.osw.close();
                        }
                        if (this.fos != null) {
                            this.fos.close();
                        }
                        if ((dataFile = new File(this.lineFile)).exists()) {
                            dataFile.delete();
                        }
                        dataFile = null;
                        File tmpFile = new File(this.lineFile + ".tmp");
                        tmpFile.renameTo(new File(this.lineFile));
                        super.clear();
                        Integer workMapData = null;
                        Set workEntrySet = vacuumWorkMap.entrySet();
                        Iterator workEntryIte = workEntrySet.iterator();
                        String workKey = null;
                        while (workEntryIte.hasNext()) {
                            Map.Entry obj = workEntryIte.next();
                            workKey = (String)obj.getKey();
                            if (workKey == null) continue;
                            workMapData = new Integer((String)vacuumWorkMap.get(workKey));
                            super.put(workKey, workMapData);
                        }
                        this.nowKeySize = super.size();
                        this.initNoMemoryModeSetting(this.lineFile);
                        int vacuumDiffDataSize = this.vacuumDiffDataList.size();
                        if (vacuumDiffDataSize > 0) {
                            Object[] diffObj = null;
                            for (int i = 0; i < vacuumDiffDataSize; ++i) {
                                diffObj = (Object[])this.vacuumDiffDataList.get(i);
                                if (diffObj[0].equals("1")) {
                                    this.put(diffObj[1], diffObj[2]);
                                    continue;
                                }
                                if (!diffObj[0].equals("2")) continue;
                                this.remove(diffObj[1]);
                            }
                        }
                        this.vacuumDiffDataList.clear();
                        this.vacuumDiffDataList = null;
                        if (userMap) {
                            ((FileBaseDataMap)vacuumWorkMap).finishClear();
                        }
                        vacuumWorkMap = null;
                        this.vacuumExecFlg = false;
                        ret = true;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    try {
                        File tmpFile = new File(this.lineFile + ".tmp");
                        if (tmpFile.exists()) {
                            tmpFile.delete();
                        }
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e3.getMessage() + e3.getMessage() + "]");
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.sync;
            synchronized (object) {
                if (this.raf != null) {
                    this.raf.close();
                }
                if (this.bw != null) {
                    this.bw.close();
                }
                if (this.osw != null) {
                    this.osw.close();
                }
                if (this.fos != null) {
                    this.fos.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMapDataFile() throws Exception {
        try {
            Object object = this.sync;
            synchronized (object) {
                File dataFile;
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
                if (this.bw != null) {
                    this.bw.close();
                    this.bw = null;
                }
                if (this.osw != null) {
                    this.osw.close();
                    this.osw = null;
                }
                if (this.fos != null) {
                    this.fos.close();
                    this.fos = null;
                }
                if ((dataFile = new File(this.lineFile)).exists()) {
                    dataFile.delete();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw e3;
        }
    }

    private int readDataFile(byte[] buf, long seekPoint, int readLength) throws Exception {
        int ret = readLength;
        if (this.raf == null) {
            return -1;
        }
        this.raf.seek(seekPoint);
        this.raf.read(buf, 0, this.oneDataLength);
        if (buf[buf.length - 1] != 38 && buf[buf.length - 2] != 33 && buf[buf.length - 1] != 48) {
            ++ret;
        }
        return ret;
    }

    private long calcSeekDataPoint(Object key) {
        Integer lineInteger = (Integer)super.get(key);
        int line = 0;
        if (lineInteger == null) {
            return -1L;
        }
        line = lineInteger;
        return new Long(this.seekOneDataLength) * new Long(line - 1);
    }

    public int getKeySize() {
        return this.nowKeySize;
    }

    public int getAllDataCount() {
        return this.lineCount;
    }

    public void setKLastDataChangeTime(long time) {
        this.lastDataChangeTime = time;
    }

    public long getKLastDataChangeTime() {
        return this.lastDataChangeTime;
    }
}

