/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import okuyama.imdst.client.OkuyamaClientException;
import okuyama.imdst.util.ImdstDefine;

public class OkuyamaClient {
    protected ArrayList masterNodesList = null;
    protected Socket socket = null;
    protected String nowConnectServerInfo = "";
    protected PrintWriter pw = null;
    protected BufferedReader br = null;
    protected String transactionCode = "0";
    public static final String SEARCH_VALUE_TYPE_AND = "1";
    public static final String SEARCH_VALUE_TYPE_OR = "2";
    protected static final String sepStr = ",";
    protected static final String connectDefaultEncoding = "UTF-8";
    protected static final String blankStr = "(B)";
    protected static final String connectExitStr = "(&imdst9999&)";
    protected static final String tagKeySep = ":";
    protected static final String byteDataKeysSep = ":#:";
    protected int saveSize = ImdstDefine.saveDataMaxSize - 1;
    protected int maxValueSize = ImdstDefine.saveDataMaxSize - 1;
    protected int maxKeySize = new Double(327.59999999999997).intValue();
    protected boolean compressMode = false;
    protected StringBuilder setValueServerReqBuf = new StringBuilder(512);
    protected StringBuilder getValueServerReqBuf = new StringBuilder(128);
    private boolean sendSearchFlg = false;

    public OkuyamaClient() {
        this.dataEncoding("".getBytes());
        this.dataDecoding("".getBytes());
    }

    public void setCompressMode(boolean flg) {
        this.compressMode = flg;
    }

    public void setConnectionInfos(String[] masterNodes) {
        this.masterNodesList = new ArrayList(masterNodes.length);
        for (int i = 0; i < masterNodes.length; ++i) {
            this.masterNodesList.add(masterNodes[i]);
        }
    }

    public void autoConnect() throws OkuyamaClientException {
        ArrayList tmpMasterNodeList = new ArrayList();
        ArrayList workList = (ArrayList)this.masterNodesList.clone();
        Random rnd = new Random();
        for (int idx = 0; idx < workList.size(); ++idx) {
            if (((String)workList.get(idx)).equals(this.nowConnectServerInfo)) continue;
            tmpMasterNodeList.add(workList.get(idx));
        }
        while (tmpMasterNodeList.size() > 0) {
            int ran = rnd.nextInt(tmpMasterNodeList.size());
            try {
                try {
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (this.pw != null) {
                        this.pw.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String nodeStr = (String)tmpMasterNodeList.remove(ran);
                String[] nodeInfo = nodeStr.split(tagKeySep);
                this.socket = new Socket();
                InetSocketAddress inetAddr = new InetSocketAddress(nodeInfo[0], Integer.parseInt(nodeInfo[1]));
                this.socket.connect(inetAddr, 10000);
                this.socket.setSoTimeout(120000);
                this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), connectDefaultEncoding)));
                this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), connectDefaultEncoding));
                this.initClient();
                this.nowConnectServerInfo = nodeStr;
                break;
            }
            catch (Exception e) {
                try {
                    if (this.br != null) {
                        this.br.close();
                        this.br = null;
                    }
                    if (this.pw != null) {
                        this.pw.close();
                        this.pw = null;
                    }
                    if (this.socket != null) {
                        this.socket.close();
                        this.socket = null;
                    }
                }
                catch (Exception e2) {
                    this.socket = null;
                }
                if (tmpMasterNodeList.size() >= 1) continue;
                throw new OkuyamaClientException(e);
            }
        }
    }

    public void connect(String server, int port) throws OkuyamaClientException {
        this.connect(server, port, connectDefaultEncoding, 10000, 120000);
    }

    public void connect(String server, int port, String encoding) throws OkuyamaClientException {
        this.connect(server, port, encoding, 10000, 120000);
    }

    public void connect(String server, int port, String encoding, int openTimeout, int connectionTimeout) throws OkuyamaClientException {
        try {
            this.socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(server, port);
            this.socket.connect(inetAddr, 10000);
            this.socket.setSoTimeout(120000);
            this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), encoding)));
            this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), encoding));
            this.initClient();
            this.nowConnectServerInfo = server + tagKeySep + new Integer(port).toString();
        }
        catch (Exception e) {
            try {
                if (this.br != null) {
                    this.br.close();
                    this.br = null;
                }
                if (this.pw != null) {
                    this.pw.close();
                    this.pw = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (Exception e2) {
                this.socket = null;
            }
            throw new OkuyamaClientException(e);
        }
    }

    public void close() throws OkuyamaClientException {
        try {
            this.transactionCode = "0";
            if (this.pw != null) {
                this.pw.println(connectExitStr);
                this.pw.flush();
                this.pw.close();
                this.pw = null;
            }
            if (this.br != null) {
                this.br.close();
                this.br = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
    }

    public boolean initClient() throws OkuyamaClientException {
        boolean ret;
        block18: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                serverRequestBuf = new StringBuilder();
                serverRequestBuf.append("0");
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("0")) {
                    if (serverRet[1].equals("true")) {
                        this.maxValueSize = this.saveSize = new Integer(serverRet[2]) - 1;
                        ret = true;
                    } else {
                        ret = false;
                    }
                    break block18;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.initClient();
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.initClient();
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.initClient();
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public boolean startTransaction() throws OkuyamaClientException {
        boolean ret;
        block18: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                serverRequestBuf = new StringBuilder();
                serverRequestBuf.append("37");
                serverRequestBuf.append(sepStr);
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("37")) {
                    if (serverRet[1].equals("true")) {
                        this.transactionCode = serverRet[2];
                        ret = true;
                    } else {
                        ret = false;
                    }
                    break block18;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.startTransaction();
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.startTransaction();
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.startTransaction();
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public void endTransaction() {
        this.transactionCode = "0";
    }

    public String[] lockData(String keyStr, int lockingTime, int waitLockTime) throws OkuyamaClientException {
        String[] ret;
        block23: {
            ret = new String[1];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (this.transactionCode == null || this.transactionCode.equals("") || this.transactionCode.equals("0")) {
                    throw new OkuyamaClientException("No Start Transaction!!");
                }
                if (keyStr == null || keyStr.equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                serverRequestBuf = new StringBuilder();
                serverRequestBuf.append("30");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(this.transactionCode);
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new Integer(lockingTime).toString());
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new Integer(waitLockTime).toString());
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("30")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.lockData(keyStr, lockingTime, waitLockTime);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.lockData(keyStr, lockingTime, waitLockTime);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.lockData(keyStr, lockingTime, waitLockTime);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] releaseLockData(String keyStr) throws OkuyamaClientException {
        String[] ret;
        block23: {
            ret = new String[1];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (this.transactionCode == null || this.transactionCode.equals("") || this.transactionCode.equals("0")) {
                    throw new OkuyamaClientException("No Start Transaction!!");
                }
                if (keyStr == null || keyStr.equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                serverRequestBuf = new StringBuilder();
                serverRequestBuf.append("31");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(this.transactionCode);
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("31")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.releaseLockData(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.releaseLockData(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.releaseLockData(keyStr);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    protected String getNowTransactionCode() {
        return this.transactionCode;
    }

    protected void setNowTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    public boolean setValue(String keyStr, String value) throws OkuyamaClientException {
        return this.setValue(keyStr, null, value);
    }

    public boolean setValue(String keyStr, String[] tagStrs, String value) throws OkuyamaClientException {
        boolean ret;
        block27: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            String encodeValue = null;
            this.setValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                int i;
                if (tagStrs != null) {
                    for (i = 0; i < tagStrs.length; ++i) {
                        if (tagStrs[i].getBytes().length <= this.maxValueSize) continue;
                        throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                    }
                }
                if (value != null && value.getBytes().length > this.maxValueSize) {
                    throw new OkuyamaClientException("Save Value Max Size " + this.maxValueSize + " Byte");
                }
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                encodeValue = value == null || value.equals("") ? blankStr : new String(this.dataEncoding(value.getBytes()));
                this.setValueServerReqBuf.append(SEARCH_VALUE_TYPE_AND);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.setValueServerReqBuf.append(sepStr);
                if (tagStrs == null || tagStrs.length < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[0].getBytes())));
                    for (i = 1; i < tagStrs.length; ++i) {
                        this.setValueServerReqBuf.append(tagKeySep);
                        this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[i].getBytes())));
                    }
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(this.transactionCode);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(encodeValue);
                this.pw.println(this.setValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet.length == 3 && serverRet[0].equals(SEARCH_VALUE_TYPE_AND)) {
                    if (serverRet[1].equals("true")) {
                        ret = true;
                    } else if (serverRet[1].equals("error")) {
                        throw new OkuyamaClientException(serverRet[2]);
                    }
                    break block27;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValue(keyStr, tagStrs, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValue(keyStr, tagStrs, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValue(keyStr, tagStrs, value);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public boolean setValueAndCreateIndex(String keyStr, String value) throws OkuyamaClientException {
        return this.setValueAndCreateIndex(keyStr, null, value, null, 3);
    }

    public boolean setValueAndCreateIndex(String keyStr, String value, String indexPrefix) throws OkuyamaClientException {
        return this.setValueAndCreateIndex(keyStr, null, value, indexPrefix, 3);
    }

    public boolean setValueAndCreateIndex(String keyStr, String value, String indexPrefix, int createIndexLen) throws OkuyamaClientException {
        return this.setValueAndCreateIndex(keyStr, null, value, indexPrefix, createIndexLen);
    }

    public boolean setValueAndCreateIndex(String keyStr, String[] tagStrs, String value, String indexPrefix, int createIndexLen) throws OkuyamaClientException {
        boolean ret;
        block29: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            String encodeValue = null;
            this.setValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                int i;
                if (tagStrs != null) {
                    for (i = 0; i < tagStrs.length; ++i) {
                        if (tagStrs[i].getBytes(ImdstDefine.characterDecodeSetBySearch).length <= this.maxValueSize) continue;
                        throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                    }
                }
                if (value != null && value.getBytes(ImdstDefine.characterDecodeSetBySearch).length > this.maxValueSize) {
                    throw new OkuyamaClientException("Save Value Max Size " + this.maxValueSize + " Byte");
                }
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes(ImdstDefine.characterDecodeSetBySearch).length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                encodeValue = value == null || value.equals("") ? blankStr : new String(this.dataEncoding(value.getBytes(ImdstDefine.characterDecodeSetBySearch)), ImdstDefine.characterDecodeSetBySearch);
                this.setValueServerReqBuf.append("42");
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes(ImdstDefine.characterDecodeSetBySearch))));
                this.setValueServerReqBuf.append(sepStr);
                if (tagStrs == null || tagStrs.length < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[0].getBytes(ImdstDefine.characterDecodeSetBySearch))));
                    for (i = 1; i < tagStrs.length; ++i) {
                        this.setValueServerReqBuf.append(tagKeySep);
                        this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[i].getBytes(ImdstDefine.characterDecodeSetBySearch))));
                    }
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(this.transactionCode);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(encodeValue);
                this.setValueServerReqBuf.append(sepStr);
                if (indexPrefix == null || indexPrefix.length() < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(indexPrefix.getBytes(ImdstDefine.characterDecodeSetBySearch))));
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(createIndexLen);
                this.pw.println(this.setValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet.length == 3 && serverRet[0].equals("42")) {
                    if (serverRet[1].equals("true")) {
                        ret = true;
                    } else if (serverRet[1].equals("error")) {
                        throw new OkuyamaClientException(serverRet[2]);
                    }
                    break block29;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueAndCreateIndex(keyStr, tagStrs, value, indexPrefix, createIndexLen);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueAndCreateIndex(keyStr, tagStrs, value, indexPrefix, createIndexLen);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueAndCreateIndex(keyStr, tagStrs, value, indexPrefix, createIndexLen);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] setNewValue(String keyStr, String value) throws OkuyamaClientException {
        return this.setNewValue(keyStr, null, value);
    }

    public String[] setNewValue(String keyStr, String[] tagStrs, String value) throws OkuyamaClientException {
        String[] ret;
        block24: {
            ret = null;
            String serverRetStr = null;
            String[] serverRet = null;
            String encodeValue = null;
            this.setValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                int i;
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (tagStrs != null) {
                    for (i = 0; i < tagStrs.length; ++i) {
                        if (tagStrs[i].getBytes().length <= this.maxValueSize) continue;
                        throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                    }
                }
                if (value != null && value.getBytes().length > this.maxValueSize) {
                    throw new OkuyamaClientException("Save Value Max Size " + this.maxValueSize + " Byte");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                encodeValue = value == null || value.equals("") ? blankStr : new String(this.dataEncoding(value.getBytes()));
                this.setValueServerReqBuf.append("6");
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.setValueServerReqBuf.append(sepStr);
                if (tagStrs == null || tagStrs.length < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[0].getBytes())));
                    for (i = 1; i < tagStrs.length; ++i) {
                        this.setValueServerReqBuf.append(tagKeySep);
                        this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[i].getBytes())));
                    }
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(this.transactionCode);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(encodeValue);
                this.pw.println(this.setValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet != null && serverRet[0].equals("6")) {
                    ret = serverRet[1].equals("true") ? new String[]{"true"} : new String[]{"false", serverRet[2]};
                    break block24;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setNewValue(keyStr, tagStrs, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setNewValue(keyStr, tagStrs, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setNewValue(keyStr, tagStrs, value);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] setValueVersionCheck(String keyStr, String value, String versionNo) throws OkuyamaClientException {
        return this.setValueVersionCheck(keyStr, null, value, versionNo);
    }

    public String[] setValueVersionCheck(String keyStr, String[] tagStrs, String value, String versionNo) throws OkuyamaClientException {
        String[] ret;
        block24: {
            ret = null;
            String serverRetStr = null;
            String[] serverRet = null;
            String encodeValue = null;
            this.setValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                int i;
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (tagStrs != null) {
                    for (i = 0; i < tagStrs.length; ++i) {
                        if (tagStrs[i].getBytes().length <= this.maxValueSize) continue;
                        throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                    }
                }
                if (value != null && value.getBytes().length > this.maxValueSize) {
                    throw new OkuyamaClientException("Save Value Max Size " + this.maxValueSize + " Byte");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                encodeValue = value == null || value.equals("") ? blankStr : new String(this.dataEncoding(value.getBytes()));
                this.setValueServerReqBuf.append("16");
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.setValueServerReqBuf.append(sepStr);
                if (tagStrs == null || tagStrs.length < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[0].getBytes())));
                    for (i = 1; i < tagStrs.length; ++i) {
                        this.setValueServerReqBuf.append(tagKeySep);
                        this.setValueServerReqBuf.append(new String(this.dataEncoding(tagStrs[i].getBytes())));
                    }
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(this.transactionCode);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(encodeValue);
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(versionNo);
                this.pw.println(this.setValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet != null && serverRet[0].equals("16")) {
                    ret = serverRet[1].equals("true") ? new String[]{"true"} : new String[]{"false", serverRet[2]};
                    break block24;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueVersionCheck(keyStr, tagStrs, value, versionNo);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueVersionCheck(keyStr, tagStrs, value, versionNo);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.setValueVersionCheck(keyStr, tagStrs, value, versionNo);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public boolean setByteValue(String keyStr, byte[] values) throws OkuyamaClientException {
        return this.setByteValue(keyStr, null, values);
    }

    public boolean setByteValue(String keyStr, String[] tagStrs, byte[] values) throws OkuyamaClientException {
        boolean ret = false;
        int bufSize = 0;
        int nowCounter = 0;
        byte[] workData = null;
        boolean counter = false;
        boolean tmpKeyIndex = false;
        String tmpKey = null;
        StringBuilder saveKeys = new StringBuilder(8192);
        String sep = "";
        Object tmpKeys = null;
        int keyCount = values.length / this.saveSize;
        int much = values.length % this.saveSize;
        String firstKey = null;
        String endKey = null;
        try {
            int i;
            if (keyStr == null || keyStr.trim().equals("")) {
                throw new OkuyamaClientException("The blank is not admitted on a key");
            }
            if (keyStr.getBytes().length > this.maxKeySize) {
                throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
            }
            if (values == null || values.length == 0) {
                throw new OkuyamaClientException("The blank is not admitted on a value");
            }
            if (tagStrs != null) {
                for (i = 0; i < tagStrs.length; ++i) {
                    if (tagStrs[i].getBytes().length <= this.maxValueSize) continue;
                    throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                }
            }
            if (much > 0) {
                ++keyCount;
            }
            for (i = 0; i < keyCount; ++i) {
                bufSize = keyCount == i + 1 ? values.length - nowCounter : this.saveSize;
                workData = new byte[bufSize];
                for (int workCounter = 0; workCounter < bufSize; ++workCounter) {
                    workData[workCounter] = values[nowCounter];
                    ++nowCounter;
                }
                tmpKey = keyStr.hashCode() + "_" + i;
                if (this.sendByteData(tmpKey, workData)) continue;
                throw new OkuyamaClientException("Byte Data Save Node Error");
            }
            firstKey = keyStr.hashCode() + "_" + 0;
            if (firstKey.equals(endKey = tmpKey)) {
                saveKeys.append(firstKey);
            } else {
                saveKeys.append(firstKey);
                saveKeys.append(byteDataKeysSep);
                saveKeys.append(tmpKey);
            }
            ret = this.setValue(keyStr, tagStrs, saveKeys.toString());
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    private boolean sendByteData(String keyStr, byte[] values) throws OkuyamaClientException {
        boolean ret = false;
        String serverRetStr = null;
        String[] serverRet = null;
        String value = null;
        StringBuilder serverRequestBuf = new StringBuilder(8192);
        Object saveStr = null;
        try {
            value = new String(this.dataEncoding(this.execCompress(values)));
            serverRequestBuf.append(SEARCH_VALUE_TYPE_AND);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(blankStr);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(this.transactionCode);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(value);
            this.pw.println(serverRequestBuf.toString());
            this.pw.flush();
            serverRetStr = this.br.readLine();
            serverRet = serverRetStr.split(sepStr);
            if (serverRet.length == 3 && serverRet[0].equals(SEARCH_VALUE_TYPE_AND)) {
                if (!serverRet[1].equals("true")) {
                    throw new OkuyamaClientException(serverRet[2]);
                }
            } else {
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            ret = true;
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (ConnectException ce) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteData(keyStr, values);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(ce);
                }
            }
            throw new OkuyamaClientException(ce);
        }
        catch (SocketException se) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteData(keyStr, values);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(se);
                }
            }
            throw new OkuyamaClientException(se);
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteData(keyStr, values);
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public boolean sendByteValue(String keyStr, byte[] values) throws OkuyamaClientException {
        boolean ret = false;
        String serverRetStr = null;
        String[] serverRet = null;
        String value = null;
        StringBuilder serverRequestBuf = new StringBuilder(8192);
        Object saveStr = null;
        try {
            if (this.socket == null) {
                throw new OkuyamaClientException("No ServerConnect!!");
            }
            if (keyStr == null || keyStr.trim().equals("")) {
                throw new OkuyamaClientException("The blank is not admitted on a key");
            }
            if (keyStr.getBytes().length > this.maxKeySize) {
                throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
            }
            if (values == null || values.length == 0) {
                throw new OkuyamaClientException("The blank is not admitted on a value");
            }
            if (values.length > this.maxValueSize) {
                throw new OkuyamaClientException("Save Value Max Size " + this.maxValueSize + " Byte");
            }
            value = new String(this.dataEncoding(values));
            serverRequestBuf.append(SEARCH_VALUE_TYPE_AND);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(blankStr);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(this.transactionCode);
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(value);
            this.pw.println(serverRequestBuf.toString());
            this.pw.flush();
            serverRetStr = this.br.readLine();
            serverRet = serverRetStr.split(sepStr);
            if (serverRet.length == 3 && serverRet[0].equals(SEARCH_VALUE_TYPE_AND)) {
                if (!serverRet[1].equals("true")) {
                    throw new OkuyamaClientException(serverRet[2]);
                }
            } else {
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            ret = true;
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (ConnectException ce) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteValue(keyStr, values);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(ce);
                }
            }
            throw new OkuyamaClientException(ce);
        }
        catch (SocketException se) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteValue(keyStr, values);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(se);
                }
            }
            throw new OkuyamaClientException(se);
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.sendByteValue(keyStr, values);
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public String[] getValue(String keyStr) throws OkuyamaClientException {
        return this.getValue(keyStr, null);
    }

    public String[] getValue(String keyStr, String encoding) throws OkuyamaClientException {
        String[] ret;
        block23: {
            ret = new String[2];
            String serverRetStr = null;
            String[] serverRet = null;
            this.getValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                this.getValueServerReqBuf.append(SEARCH_VALUE_TYPE_OR);
                this.getValueServerReqBuf.append(sepStr);
                this.getValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.pw.println(this.getValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals(SEARCH_VALUE_TYPE_OR)) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes(encoding)), encoding));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValue(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValue(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValue(keyStr, encoding);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Map getMultiValue(String[] keyStrList) throws OkuyamaClientException {
        return this.getMultiValue(keyStrList, null);
    }

    public Map getMultiValue(String[] keyStrList, String encoding) throws OkuyamaClientException {
        Map<String, String> ret = new HashMap();
        String serverRetStr = null;
        String[] serverRet = null;
        this.getValueServerReqBuf.delete(0, Integer.MAX_VALUE);
        try {
            if (this.socket == null) {
                throw new OkuyamaClientException("No ServerConnect!!");
            }
            if (keyStrList == null || keyStrList.length == 1) {
                throw new OkuyamaClientException("The blank is not admitted on a key");
            }
            this.getValueServerReqBuf.append("22");
            this.getValueServerReqBuf.append(sepStr);
            String keysSep = "";
            ArrayList<String> sendKeyList = new ArrayList<String>();
            for (int idx = 0; idx < keyStrList.length; ++idx) {
                if (keyStrList[idx] == null || keyStrList[idx].equals("")) continue;
                if (keyStrList[idx].getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte Key=[");
                }
                this.getValueServerReqBuf.append(keysSep);
                this.getValueServerReqBuf.append(new String(this.dataEncoding(keyStrList[idx].getBytes())));
                sendKeyList.add(keyStrList[idx]);
                keysSep = sepStr;
            }
            this.pw.println(this.getValueServerReqBuf.toString());
            this.pw.flush();
            int readIdx = 0;
            while (!(serverRetStr = this.br.readLine()).equals("END")) {
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("22")) {
                    if (serverRet[1].equals("true")) {
                        String[] oneDataRet = new String[]{(String)sendKeyList.get(readIdx), serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes(encoding)), encoding))};
                        ret.put(oneDataRet[0], oneDataRet[1]);
                    } else if (!serverRet[1].equals("false") && serverRet[1].equals("error")) {
                        // empty if block
                    }
                } else {
                    throw new OkuyamaClientException("Execute Violation of validity");
                }
                ++readIdx;
            }
            if (ret.size() == 0) {
                ret = null;
            }
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (ConnectException ce) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getMultiValue(keyStrList, encoding);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(ce);
                }
            }
            throw new OkuyamaClientException(ce);
        }
        catch (SocketException se) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getMultiValue(keyStrList, encoding);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(se);
                }
            }
            throw new OkuyamaClientException(se);
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getMultiValue(keyStrList, encoding);
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            e.printStackTrace();
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public Map getTagValues(String tagStr) throws OkuyamaClientException {
        return this.getTagValues(tagStr, null);
    }

    public Map getTagValues(String tagStr, String encoding) throws OkuyamaClientException {
        Map<String, String> ret = new HashMap();
        String serverRetStr = null;
        String[] serverRet = null;
        this.getValueServerReqBuf.delete(0, Integer.MAX_VALUE);
        try {
            if (this.socket == null) {
                throw new OkuyamaClientException("No ServerConnect!!");
            }
            if (tagStr == null || tagStr.equals("")) {
                throw new OkuyamaClientException("The blank is not admitted on a tag");
            }
            if (tagStr.getBytes().length > this.maxKeySize) {
                throw new OkuyamaClientException("Save Tag Max Size " + this.maxKeySize + " Byte");
            }
            this.getValueServerReqBuf.append("23");
            this.getValueServerReqBuf.append(sepStr);
            this.getValueServerReqBuf.append(new String(this.dataEncoding(tagStr.getBytes())));
            this.pw.println(this.getValueServerReqBuf.toString());
            this.pw.flush();
            int readIdx = 0;
            while (!(serverRetStr = this.br.readLine()).equals("END")) {
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("23")) {
                    if (serverRet[1].equals("true")) {
                        String[] oneDataRet = new String[]{encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes()), encoding), serverRet[3].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[3].getBytes())) : new String(this.dataDecoding(serverRet[3].getBytes()), encoding))};
                        ret.put(oneDataRet[0], oneDataRet[1]);
                    } else if (!serverRet[1].equals("false") && serverRet[1].equals("error")) {
                        // empty if block
                    }
                } else {
                    throw new OkuyamaClientException("Execute Violation of validity");
                }
                ++readIdx;
            }
            if (ret.size() == 0) {
                ret = null;
            }
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (ConnectException ce) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getTagValues(tagStr, encoding);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(ce);
                }
            }
            throw new OkuyamaClientException(ce);
        }
        catch (SocketException se) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getTagValues(tagStr, encoding);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(se);
                }
            }
            throw new OkuyamaClientException(se);
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.getTagValues(tagStr, encoding);
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public String[] getValueVersionCheck(String keyStr) throws OkuyamaClientException {
        return this.getValueVersionCheck(keyStr, null);
    }

    public String[] getValueVersionCheck(String keyStr, String encoding) throws OkuyamaClientException {
        String[] ret;
        block25: {
            ret = new String[3];
            String serverRetStr = null;
            String[] serverRet = null;
            this.getValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                this.getValueServerReqBuf.append("15");
                this.getValueServerReqBuf.append(sepStr);
                this.getValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.pw.println(this.getValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("15")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes()), encoding));
                        if (serverRet.length > 2) {
                            ret[2] = serverRet[3];
                        }
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                        ret[2] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                        if (serverRet.length > 3) {
                            ret[2] = serverRet[3];
                        }
                    }
                    break block25;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueVersionCheck(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueVersionCheck(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueVersionCheck(keyStr, encoding);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] incrValue(String keyStr, long value) throws OkuyamaClientException {
        Object[] ret;
        block23: {
            ret = new Object[2];
            String serverRetStr = null;
            String[] serverRet = null;
            String valueStr = null;
            StringBuilder incrValueServerReqBuf = new StringBuilder();
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                valueStr = new String(this.dataEncoding(new Long(value).toString().getBytes()));
                incrValueServerReqBuf.append("13");
                incrValueServerReqBuf.append(sepStr);
                incrValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                incrValueServerReqBuf.append(sepStr);
                incrValueServerReqBuf.append(this.transactionCode);
                incrValueServerReqBuf.append(sepStr);
                incrValueServerReqBuf.append(valueStr);
                this.pw.println(incrValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet.length == 3 && serverRet[0].equals("13")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = new Boolean(true);
                        ret[1] = new Long(new String(BASE64DecoderStream.decode((byte[])serverRet[2].getBytes())));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = new Boolean(false);
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        throw new OkuyamaClientException(serverRet[2]);
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.incrValue(keyStr, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.incrValue(keyStr, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.incrValue(keyStr, value);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] decrValue(String keyStr, long value) throws OkuyamaClientException {
        Object[] ret;
        block23: {
            ret = new Object[2];
            String serverRetStr = null;
            String[] serverRet = null;
            String valueStr = null;
            StringBuilder decrValueServerReqBuf = new StringBuilder();
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                valueStr = new String(this.dataEncoding(new Long(value).toString().getBytes()));
                decrValueServerReqBuf.append("14");
                decrValueServerReqBuf.append(sepStr);
                decrValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                decrValueServerReqBuf.append(sepStr);
                decrValueServerReqBuf.append(this.transactionCode);
                decrValueServerReqBuf.append(sepStr);
                decrValueServerReqBuf.append(valueStr);
                this.pw.println(decrValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet.length == 3 && serverRet[0].equals("14")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = new Boolean(true);
                        ret[1] = new Long(new String(BASE64DecoderStream.decode((byte[])serverRet[2].getBytes())));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = new Boolean(false);
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        throw new OkuyamaClientException(serverRet[2]);
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.decrValue(keyStr, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.decrValue(keyStr, value);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.decrValue(keyStr, value);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] getValueScript(String keyStr, String scriptStr) throws OkuyamaClientException {
        return this.getValueScript(keyStr, scriptStr, null);
    }

    public String[] getValueScript(String keyStr, String scriptStr, String encoding) throws OkuyamaClientException {
        String[] ret;
        block24: {
            ret = new String[2];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                if (scriptStr == null || scriptStr.trim().equals("")) {
                    scriptStr = blankStr;
                    throw new OkuyamaClientException("The blank is not admitted on a Script");
                }
                serverRequestBuf = new StringBuilder(512);
                serverRequestBuf.append("8");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(scriptStr.getBytes())));
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("8")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes()), encoding));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block24;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScript(keyStr, scriptStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScript(keyStr, scriptStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScript(keyStr, scriptStr, encoding);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] getValueScriptForUpdate(String keyStr, String scriptStr) throws OkuyamaClientException {
        return this.getValueScriptForUpdate(keyStr, scriptStr, null);
    }

    public String[] getValueScriptForUpdate(String keyStr, String scriptStr, String encoding) throws OkuyamaClientException {
        String[] ret;
        block24: {
            ret = new String[2];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                if (scriptStr == null || scriptStr.equals("")) {
                    scriptStr = blankStr;
                    throw new OkuyamaClientException("The blank is not admitted on a Script");
                }
                serverRequestBuf = new StringBuilder(512);
                serverRequestBuf.append("9");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(scriptStr.getBytes())));
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("9")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes()), encoding));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block24;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScriptForUpdate(keyStr, scriptStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScriptForUpdate(keyStr, scriptStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getValueScriptForUpdate(keyStr, scriptStr, encoding);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public String[] removeValue(String keyStr) throws OkuyamaClientException {
        return this.removeValue(keyStr, null);
    }

    public String[] removeValue(String keyStr, String encoding) throws OkuyamaClientException {
        String[] ret;
        block23: {
            ret = new String[2];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                serverRequestBuf = new StringBuilder(128);
                serverRequestBuf.append("5");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(this.transactionCode);
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("5")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2].equals(blankStr) ? "" : (encoding == null ? new String(this.dataDecoding(serverRet[2].getBytes())) : new String(this.dataDecoding(serverRet[2].getBytes()), encoding));
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block23;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeValue(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeValue(keyStr, encoding);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeValue(keyStr, encoding);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public boolean removeTagFromKey(String keyStr, String tagStr) throws OkuyamaClientException {
        boolean ret;
        block19: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (tagStr != null && tagStr.getBytes().length > this.maxValueSize) {
                    throw new OkuyamaClientException("Tag Max Size " + this.maxValueSize + " Byte");
                }
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                serverRequestBuf = new StringBuilder();
                serverRequestBuf.append("40");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(tagStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(this.transactionCode);
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet.length == 2 && serverRet[0].equals("40")) {
                    ret = serverRet[1].equals("true");
                    break block19;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeTagFromKey(keyStr, tagStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeTagFromKey(keyStr, tagStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeTagFromKey(keyStr, tagStr);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public boolean removeSearchIndex(String keyStr) throws OkuyamaClientException {
        return this.removeSearchIndex(keyStr, null, 3);
    }

    public boolean removeSearchIndex(String keyStr, String indexPrefix) throws OkuyamaClientException {
        return this.removeSearchIndex(keyStr, indexPrefix, 3);
    }

    public boolean removeSearchIndex(String keyStr, int indexLength) throws OkuyamaClientException {
        return this.removeSearchIndex(keyStr, null, indexLength);
    }

    public boolean removeSearchIndex(String keyStr, String indexPrefix, int indexLength) throws OkuyamaClientException {
        boolean ret;
        block25: {
            ret = false;
            String serverRetStr = null;
            String[] serverRet = null;
            Object encodeValue = null;
            this.setValueServerReqBuf.delete(0, Integer.MAX_VALUE);
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes(ImdstDefine.characterDecodeSetBySearch).length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + this.maxKeySize + " Byte");
                }
                this.setValueServerReqBuf.append("44");
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(new String(this.dataEncoding(keyStr.getBytes(ImdstDefine.characterDecodeSetBySearch))));
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(this.transactionCode);
                this.setValueServerReqBuf.append(sepStr);
                if (indexPrefix == null || indexPrefix.length() < 1) {
                    this.setValueServerReqBuf.append(blankStr);
                } else {
                    this.setValueServerReqBuf.append(new String(this.dataEncoding(indexPrefix.getBytes(ImdstDefine.characterDecodeSetBySearch))));
                }
                this.setValueServerReqBuf.append(sepStr);
                this.setValueServerReqBuf.append(indexLength);
                this.pw.println(this.setValueServerReqBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("44")) {
                    if (serverRet[1].equals("true")) {
                        ret = true;
                    } else if (serverRet[1].equals("false")) {
                        ret = false;
                    } else if (serverRet[1].equals("error")) {
                        throw new OkuyamaClientException(serverRet[2]);
                    }
                    break block25;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRetStr + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeSearchIndex(keyStr, indexPrefix, indexLength);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeSearchIndex(keyStr, indexPrefix, indexLength);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.removeSearchIndex(keyStr, indexPrefix, indexLength);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] getByteValue(String keyStr) throws OkuyamaClientException {
        Object[] ret = new Object[2];
        Object[] byteTmpRet = null;
        String[] workKeyRet = null;
        String workKeyStr = null;
        Object workKeys = null;
        byte[] workValue = null;
        byte[] tmpValue = new byte[]{};
        byte[] retValue = new byte[]{};
        boolean execFlg = true;
        try {
            workKeyRet = this.getValue(keyStr);
            if (workKeyRet[0].equals("true")) {
                workKeyStr = workKeyRet[1];
                if ((workKeyRet = workKeyStr.split(byteDataKeysSep)).length > 1) {
                    String[] keyWork = workKeyRet[1].split("_");
                    String keyStrPre = keyWork[0];
                    int maxKeyIndexSize = Integer.parseInt(keyWork[1]) + 1;
                    workKeyRet = new String[maxKeyIndexSize];
                    for (int i = 0; i < workKeyRet.length; ++i) {
                        workKeyRet[i] = keyStrPre + "_" + i;
                    }
                }
                for (int idx = 0; idx < workKeyRet.length; ++idx) {
                    byteTmpRet = this.getByteData(workKeyRet[idx]);
                    if (byteTmpRet[0].equals("true")) {
                        int i;
                        workValue = (byte[])byteTmpRet[1];
                        if (execFlg) {
                            tmpValue = new byte[retValue.length + workValue.length];
                            for (i = 0; i < retValue.length; ++i) {
                                tmpValue[i] = retValue[i];
                            }
                            for (i = 0; i < workValue.length; ++i) {
                                tmpValue[retValue.length + i] = workValue[i];
                            }
                            execFlg = false;
                            continue;
                        }
                        retValue = new byte[tmpValue.length + workValue.length];
                        for (i = 0; i < tmpValue.length; ++i) {
                            retValue[i] = tmpValue[i];
                        }
                        for (i = 0; i < workValue.length; ++i) {
                            retValue[tmpValue.length + i] = workValue[i];
                        }
                        execFlg = true;
                        continue;
                    }
                    ret[0] = byteTmpRet[0];
                    ret[1] = byteTmpRet[1];
                    break;
                }
                ret[0] = "true";
                ret[1] = retValue.length >= tmpValue.length ? (Object)retValue : (Object)tmpValue;
            } else {
                ret[0] = workKeyRet[0];
                ret[1] = workKeyRet[1];
            }
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public Object[] getByteValueVer2(String keyStr) throws OkuyamaClientException {
        ArrayList<Byte> byteDataList = null;
        Object[] ret = new Object[2];
        Object[] byteTmpRet = null;
        String[] workKeyRet = null;
        String workKeyStr = null;
        Object workKeys = null;
        byte[] workValue = null;
        byte[] tmpValue = new byte[]{};
        byte[] retValue = new byte[]{};
        boolean execFlg = true;
        try {
            workKeyRet = this.getValue(keyStr);
            if (workKeyRet[0].equals("true")) {
                workKeyStr = workKeyRet[1];
                if ((workKeyRet = workKeyStr.split(byteDataKeysSep)).length > 1) {
                    String[] keyWork = workKeyRet[1].split("_");
                    String keyStrPre = keyWork[0];
                    int maxKeyIndexSize = Integer.parseInt(keyWork[1]) + 1;
                    workKeyRet = new String[maxKeyIndexSize];
                    for (int i = 0; i < workKeyRet.length; ++i) {
                        workKeyRet[i] = keyStrPre + "_" + i;
                    }
                }
                byteDataList = new ArrayList<Byte>(workKeyRet.length * new Double((double)this.maxValueSize * 1.38).intValue());
                for (int idx = 0; idx < workKeyRet.length; ++idx) {
                    byteTmpRet = this.getByteData(workKeyRet[idx]);
                    if (byteTmpRet[0].equals("true")) {
                        int i;
                        workValue = (byte[])byteTmpRet[1];
                        if (execFlg) {
                            for (i = 0; i < workValue.length; ++i) {
                                byteDataList.add(workValue[i]);
                            }
                            execFlg = false;
                            continue;
                        }
                        for (i = 0; i < workValue.length; ++i) {
                            byteDataList.add(workValue[i]);
                        }
                        execFlg = true;
                        continue;
                    }
                    ret[0] = byteTmpRet[0];
                    ret[1] = byteTmpRet[1];
                    break;
                }
                ret[0] = "true";
                byte[] retBytes = new byte[byteDataList.size()];
                int size = byteDataList.size();
                for (int idx = 1; idx < size; ++idx) {
                    retBytes[size - idx] = (Byte)byteDataList.remove(size - idx);
                }
                retBytes[0] = (Byte)byteDataList.remove(0);
                ret[1] = retBytes;
            } else {
                ret[0] = workKeyRet[0];
                ret[1] = workKeyRet[1];
            }
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    protected Object[] getByteData(String keyStr) throws OkuyamaClientException {
        Object[] ret;
        block25: {
            ret = new Object[2];
            byte[] byteRet = null;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                serverRequestBuf = new StringBuilder(128);
                serverRequestBuf.append(SEARCH_VALUE_TYPE_OR);
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals(SEARCH_VALUE_TYPE_OR)) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        if (serverRet[2].equals(blankStr)) {
                            byteRet = new byte[]{};
                            ret[1] = byteRet;
                        } else {
                            ret[1] = this.execDecompres(this.dataDecoding(serverRet[2].getBytes()));
                        }
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block25;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getByteData(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getByteData(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getByteData(keyStr);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] readByteValue(String keyStr) throws OkuyamaClientException {
        Object[] ret;
        block25: {
            ret = new Object[2];
            byte[] byteRet = null;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (keyStr == null || keyStr.trim().equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a key");
                }
                if (keyStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Key Max Size " + keyStr + " Byte");
                }
                serverRequestBuf = new StringBuilder(128);
                serverRequestBuf.append(SEARCH_VALUE_TYPE_OR);
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(keyStr.getBytes())));
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals(SEARCH_VALUE_TYPE_OR)) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        if (serverRet[2].equals(blankStr)) {
                            byteRet = new byte[]{};
                            ret[1] = byteRet;
                        } else {
                            ret[1] = this.dataDecoding(serverRet[2].getBytes());
                        }
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block25;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.readByteValue(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.readByteValue(keyStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.readByteValue(keyStr);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] getTagKeys(String tagStr) throws OkuyamaClientException {
        return this.getTagKeys(tagStr, true);
    }

    public Object[] getTagKeys(String tagStr, boolean noExistsData) throws OkuyamaClientException {
        Object[] ret;
        block26: {
            ret = new Object[2];
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                if (tagStr == null || tagStr.equals("")) {
                    throw new OkuyamaClientException("The blank is not admitted on a tag");
                }
                if (tagStr.getBytes().length > this.maxKeySize) {
                    throw new OkuyamaClientException("Save Tag Max Size " + this.maxKeySize + " Byte");
                }
                serverRequestBuf = new StringBuilder(128);
                serverRequestBuf.append("3");
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new String(this.dataEncoding(tagStr.getBytes())));
                serverRequestBuf.append(sepStr);
                serverRequestBuf.append(new Boolean(noExistsData).toString());
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("4")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        if (serverRet[2].equals(blankStr)) {
                            String[] tags;
                            ret[1] = tags = new String[]{""};
                        } else {
                            String[] tags = null;
                            Object cnvTags = null;
                            tags = serverRet[2].split(tagKeySep);
                            String[] decTags = new String[tags.length];
                            for (int i = 0; i < tags.length; ++i) {
                                decTags[i] = new String(this.dataDecoding(tags[i].getBytes()));
                            }
                            ret[1] = decTags;
                        }
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block26;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRet[0] + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getTagKeys(tagStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getTagKeys(tagStr);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        ret = this.getTagKeys(tagStr);
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }

    public Object[] searchValue(String[] searchCharacterList, String searchType) throws OkuyamaClientException {
        return this.searchValue(searchCharacterList, searchType, null);
    }

    public Object[] searchValue(String[] searchCharacterList, String searchType, int searchIndexLen) throws OkuyamaClientException {
        return this.searchValue(searchCharacterList, searchType, null, searchIndexLen);
    }

    public Object[] searchValue(String[] searchCharacterList, String searchType, String prefix) throws OkuyamaClientException {
        try {
            this.sendSearchValueRequest(searchCharacterList, searchType, prefix, 3);
            return this.readSearchValueResponse(searchCharacterList, searchType, prefix, 3);
        }
        catch (Throwable e) {
            throw new OkuyamaClientException(e);
        }
    }

    public Object[] searchValue(String[] searchCharacterList, String searchType, String prefix, int searchIndexLen) throws OkuyamaClientException {
        try {
            this.sendSearchValueRequest(searchCharacterList, searchType, prefix, searchIndexLen);
            return this.readSearchValueResponse(searchCharacterList, searchType, prefix, searchIndexLen);
        }
        catch (Throwable e) {
            throw new OkuyamaClientException(e);
        }
    }

    protected void sendSearchValueRequest(String[] searchCharacterList, String searchType) throws OkuyamaClientException {
        this.sendSearchValueRequest(searchCharacterList, searchType, null, 3);
    }

    protected void sendSearchValueRequest(String[] searchCharacterList, String searchType, int searchIndexLen) throws OkuyamaClientException {
        this.sendSearchValueRequest(searchCharacterList, searchType, null, searchIndexLen);
    }

    protected void sendSearchValueRequest(String[] searchCharacterList, String searchType, String prefix, int searchIndexLen) throws OkuyamaClientException {
        Object[] ret = new Object[2];
        Object serverRetStr = null;
        Object serverRet = null;
        StringBuilder serverRequestBuf = null;
        try {
            if (this.socket == null) {
                throw new OkuyamaClientException("No ServerConnect!!");
            }
            if (searchCharacterList == null || searchCharacterList.length == 0) {
                throw new OkuyamaClientException("The blank is not admitted on a searchCharacterList");
            }
            for (int idx = 0; idx < searchCharacterList.length; ++idx) {
                if (searchCharacterList[idx].length() <= 128) continue;
                throw new OkuyamaClientException("SearchCharacter MaxSize 128Character");
            }
            if (searchType == null || !searchType.equals(SEARCH_VALUE_TYPE_AND) && !searchType.equals(SEARCH_VALUE_TYPE_OR)) {
                searchType = SEARCH_VALUE_TYPE_OR;
            }
            serverRequestBuf = new StringBuilder(128);
            serverRequestBuf.append("43");
            serverRequestBuf.append(sepStr);
            String sep = "";
            for (int idx = 0; idx < searchCharacterList.length; ++idx) {
                serverRequestBuf.append(sep);
                serverRequestBuf.append(new String(this.dataEncoding(searchCharacterList[idx].getBytes(ImdstDefine.characterDecodeSetBySearch))));
                sep = tagKeySep;
            }
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(searchType);
            serverRequestBuf.append(sepStr);
            if (prefix == null || prefix.length() < 1) {
                serverRequestBuf.append(blankStr);
            } else {
                serverRequestBuf.append(new String(this.dataEncoding(prefix.getBytes(ImdstDefine.characterDecodeSetBySearch))));
            }
            serverRequestBuf.append(sepStr);
            serverRequestBuf.append(searchIndexLen);
            this.pw.println(serverRequestBuf.toString());
            this.pw.flush();
            this.sendSearchFlg = true;
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    this.sendSearchValueRequest(searchCharacterList, searchType, prefix, searchIndexLen);
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            throw new OkuyamaClientException(e);
        }
    }

    protected Object[] readSearchValueResponse(String[] searchCharacterList, String searchType, String prefix) throws OkuyamaClientException {
        return this.readSearchValueResponse(searchCharacterList, searchType, prefix, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] readSearchValueResponse(String[] searchCharacterList, String searchType, String prefix, int searchIndexLen) throws OkuyamaClientException {
        Object[] ret;
        block27: {
            ret = new Object[2];
            String serverRetStr = null;
            String[] serverRet = null;
            Object serverRequestBuf = null;
            try {
                if (!this.sendSearchFlg) {
                    throw new OkuyamaClientException("Not Request Send");
                }
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(sepStr);
                if (serverRet[0].equals("43")) {
                    if (serverRet[1].equals("true")) {
                        ret[0] = serverRet[1];
                        String[] keys = null;
                        keys = serverRet[2].split(tagKeySep);
                        String[] decKeys = new String[keys.length];
                        for (int i = 0; i < keys.length; ++i) {
                            decKeys[i] = new String(this.dataDecoding(keys[i].getBytes(ImdstDefine.characterDecodeSetBySearch)));
                        }
                        ret[1] = decKeys;
                    } else if (serverRet[1].equals("false")) {
                        ret[0] = serverRet[1];
                        ret[1] = null;
                    } else if (serverRet[1].equals("error")) {
                        ret[0] = serverRet[1];
                        ret[1] = serverRet[2];
                    }
                    break block27;
                }
                throw new OkuyamaClientException("Execute Violation of validity [" + serverRet[0] + "]");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        this.sendSearchFlg = false;
                        this.searchValue(searchCharacterList, searchType, prefix);
                        ret = this.readSearchValueResponse(searchCharacterList, searchType, prefix, searchIndexLen);
                        break block27;
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        this.sendSearchFlg = false;
                        this.searchValue(searchCharacterList, searchType, prefix);
                        ret = this.readSearchValueResponse(searchCharacterList, searchType, prefix, searchIndexLen);
                        break block27;
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Throwable e) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.autoConnect();
                        this.sendSearchFlg = false;
                        this.searchValue(searchCharacterList, searchType, prefix);
                        ret = this.readSearchValueResponse(searchCharacterList, searchType, prefix, searchIndexLen);
                        break block27;
                    }
                    catch (Exception ee) {
                        throw new OkuyamaClientException(e);
                    }
                }
                throw new OkuyamaClientException(e);
            }
            finally {
                this.sendSearchFlg = false;
            }
        }
        return ret;
    }

    protected byte[] dataEncoding(byte[] datas) {
        return BASE64EncoderStream.encode((byte[])datas);
    }

    protected byte[] dataDecoding(byte[] datas) {
        return BASE64DecoderStream.decode((byte[])datas);
    }

    protected byte[] execCompress(byte[] bytes) throws Exception {
        int i;
        int compressedDataLength;
        if (!this.compressMode) {
            return bytes;
        }
        Deflater compresser = new Deflater();
        compresser.setInput(bytes);
        compresser.finish();
        int bufSize = 2048;
        byte[] output = new byte[bufSize];
        byte[] workByte1 = new byte[]{};
        byte[] workByte2 = new byte[]{};
        boolean flg = false;
        boolean use = true;
        while ((compressedDataLength = compresser.deflate(output)) == bufSize) {
            if (!flg) {
                workByte1 = new byte[workByte2.length + bufSize];
                for (i = 0; i < workByte2.length; ++i) {
                    workByte1[i] = workByte2[i];
                }
                for (i = 0; i < bufSize; ++i) {
                    workByte1[workByte2.length + i] = output[i];
                }
                flg = true;
                continue;
            }
            workByte2 = new byte[workByte1.length + bufSize];
            for (i = 0; i < workByte1.length; ++i) {
                workByte2[i] = workByte1[i];
            }
            for (i = 0; i < bufSize; ++i) {
                workByte2[workByte1.length + i] = output[i];
            }
            flg = false;
        }
        if (workByte1.length == workByte2.length) {
            workByte1 = new byte[compressedDataLength];
            for (i = 0; i < compressedDataLength; ++i) {
                workByte1[i] = output[i];
            }
        } else if (workByte1.length > workByte2.length) {
            workByte2 = new byte[workByte1.length + compressedDataLength];
            for (i = 0; i < workByte1.length; ++i) {
                workByte2[i] = workByte1[i];
            }
            for (i = 0; i < compressedDataLength; ++i) {
                workByte2[workByte1.length + i] = output[i];
            }
        } else if (workByte1.length < workByte2.length) {
            workByte1 = new byte[workByte2.length + compressedDataLength];
            for (i = 0; i < workByte2.length; ++i) {
                workByte1[i] = workByte2[i];
            }
            for (i = 0; i < compressedDataLength; ++i) {
                workByte1[workByte2.length + i] = output[i];
            }
        }
        if (workByte1.length > workByte2.length) {
            return workByte1;
        }
        if (workByte1.length < workByte2.length) {
            return workByte2;
        }
        return null;
    }

    protected byte[] execDecompres(byte[] bytes) throws Exception {
        int i;
        int resultLength;
        if (!this.compressMode) {
            return bytes;
        }
        int bufSize = 2048;
        Inflater decompresser = new Inflater();
        decompresser.setInput(bytes, 0, bytes.length);
        byte[] result = new byte[bufSize];
        byte[] workByte1 = new byte[]{};
        byte[] workByte2 = new byte[]{};
        boolean flg = false;
        while ((resultLength = decompresser.inflate(result)) == bufSize) {
            if (!flg) {
                workByte1 = new byte[workByte2.length + bufSize];
                for (i = 0; i < workByte2.length; ++i) {
                    workByte1[i] = workByte2[i];
                }
                for (i = 0; i < bufSize; ++i) {
                    workByte1[workByte2.length + i] = result[i];
                }
                flg = true;
                continue;
            }
            workByte2 = new byte[workByte1.length + bufSize];
            for (i = 0; i < workByte1.length; ++i) {
                workByte2[i] = workByte1[i];
            }
            for (i = 0; i < bufSize; ++i) {
                workByte2[workByte1.length + i] = result[i];
            }
            flg = false;
        }
        if (workByte1.length == workByte2.length) {
            workByte1 = new byte[resultLength];
            for (i = 0; i < resultLength; ++i) {
                workByte1[i] = result[i];
            }
        } else if (workByte1.length > workByte2.length) {
            workByte2 = new byte[workByte1.length + resultLength];
            for (i = 0; i < workByte1.length; ++i) {
                workByte2[i] = workByte1[i];
            }
            for (i = 0; i < resultLength; ++i) {
                workByte2[workByte1.length + i] = result[i];
            }
        } else if (workByte1.length < workByte2.length) {
            workByte1 = new byte[workByte2.length + resultLength];
            for (i = 0; i < workByte2.length; ++i) {
                workByte1[i] = workByte2[i];
            }
            for (i = 0; i < resultLength; ++i) {
                workByte1[workByte2.length + i] = result[i];
            }
        }
        decompresser.end();
        if (workByte1.length > workByte2.length) {
            return workByte1;
        }
        if (workByte1.length < workByte2.length) {
            return workByte2;
        }
        return null;
    }
}

