/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.job;

import java.net.ServerSocket;
import java.net.Socket;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.StatusUtil;

public class HttpGatewayServerJob
extends AbstractJob
implements IJob {
    private int portNo = 80;
    ServerSocket serverSocket = null;
    private static ILogger logger = LoggerFactory.createLogger(HttpGatewayServerJob.class);

    @Override
    public void initJob(String initValue) {
        logger.debug("HttpGatewayServerJob - initJob - start");
        this.portNo = Integer.parseInt(initValue);
        logger.debug("HttpGatewayServerJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        String ret;
        block6: {
            logger.debug("HttpGatewayServerJob - executeJob - start");
            ret = SUCCESS;
            Object[] helperParams = null;
            String[] okuyamaMasterInfos = null;
            try {
                okuyamaMasterInfos = optionParam.split(",");
                this.serverSocket = new ServerSocket(this.portNo);
                super.setJobShareParam(super.getJobName() + "_ServeSocket", this.serverSocket);
                Socket socket = null;
                int paramSize = 6;
                if (!DataDispatcher.isStandby()) break block6;
                while (StatusUtil.getStatus() != 1 && StatusUtil.getStatus() != 2) {
                    try {
                        helperParams = new Object[paramSize];
                        socket = this.serverSocket.accept();
                        helperParams[0] = socket;
                        helperParams[1] = okuyamaMasterInfos;
                        super.executeHelper("HttpGatewayServerHelper", helperParams);
                    }
                    catch (Exception e) {
                        if (StatusUtil.getStatus() == 2) {
                            logger.info("HttpGatewayServerJob - executeJob - ServerEnd");
                            break;
                        }
                        logger.error(e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("HttpGatewayServerJob - executeJob - Error", e);
                throw new BatchException(e);
            }
        }
        return ret;
    }
}

