/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;

public class ImdstKeyValueClient
extends OkuyamaClient {
    @Override
    public void connect(String server, int port) throws OkuyamaClientException {
        this.connect(server, port, "UTF-8", 30000, 360000);
    }

    public void setSaveMaxDataSize(int size) {
        this.saveSize = size;
        this.maxValueSize = size;
    }

    public void changeByteSaveSize(int size) {
        this.saveSize = size;
    }

    public void nextConnect() throws OkuyamaClientException {
        ArrayList tmpMasterNodeList = new ArrayList();
        tmpMasterNodeList = (ArrayList)this.masterNodesList.clone();
        while (tmpMasterNodeList.size() > 0) {
            try {
                try {
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (this.pw != null) {
                        this.pw.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String nodeStr = (String)tmpMasterNodeList.remove(0);
                String[] nodeInfo = nodeStr.split(":");
                this.socket = new Socket();
                InetSocketAddress inetAddr = new InetSocketAddress(nodeInfo[0], Integer.parseInt(nodeInfo[1]));
                this.socket.connect(inetAddr, 10000);
                this.socket.setSoTimeout(120000);
                this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8")));
                this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.initClient();
                this.nowConnectServerInfo = nodeStr;
                break;
            }
            catch (Exception e) {
                try {
                    if (this.br != null) {
                        this.br.close();
                        this.br = null;
                    }
                    if (this.pw != null) {
                        this.pw.close();
                        this.pw = null;
                    }
                    if (this.socket != null) {
                        this.socket.close();
                        this.socket = null;
                    }
                }
                catch (Exception e2) {
                    this.socket = null;
                }
                if (tmpMasterNodeList.size() >= 1) continue;
                throw new OkuyamaClientException(e);
            }
        }
    }

    @Override
    public String getNowTransactionCode() {
        return super.getNowTransactionCode();
    }

    @Override
    public void setNowTransactionCode(String transactionCode) {
        super.setNowTransactionCode(transactionCode);
    }

    public boolean arrivalMasterNode() throws OkuyamaClientException {
        boolean ret = false;
        String serverRetStr = null;
        String[] serverRet = null;
        StringBuilder serverRequestBuf = null;
        try {
            if (this.socket == null) {
                throw new OkuyamaClientException("No ServerConnect!!");
            }
            serverRequestBuf = new StringBuilder();
            serverRequestBuf.append("12");
            serverRequestBuf.append(",");
            this.pw.println(serverRequestBuf.toString());
            this.pw.flush();
            serverRetStr = this.br.readLine();
            serverRet = serverRetStr.split(",");
            ret = serverRet[0].equals("12") ? serverRet[1].equals("true") : false;
        }
        catch (OkuyamaClientException ice) {
            throw ice;
        }
        catch (ConnectException ce) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.arrivalMasterNode();
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(ce);
                }
            }
            throw new OkuyamaClientException(ce);
        }
        catch (SocketException se) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.arrivalMasterNode();
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(se);
                }
            }
            throw new OkuyamaClientException(se);
        }
        catch (Throwable e) {
            if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                try {
                    this.autoConnect();
                    ret = this.arrivalMasterNode();
                }
                catch (Exception ee) {
                    throw new OkuyamaClientException(e);
                }
            }
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public String getDataNodeStatus(String nodeInfo) throws OkuyamaClientException {
        String ret;
        block13: {
            ret = null;
            String serverRetStr = null;
            String[] serverRet = null;
            StringBuilder serverRequestBuf = null;
            try {
                if (this.socket == null) {
                    throw new OkuyamaClientException("No ServerConnect!!");
                }
                serverRequestBuf = new StringBuilder(128);
                serverRequestBuf.append("10");
                serverRequestBuf.append(",");
                serverRequestBuf.append(nodeInfo);
                this.pw.println(serverRequestBuf.toString());
                this.pw.flush();
                serverRetStr = this.br.readLine();
                serverRet = serverRetStr.split(",");
                if (serverRet[0].equals("10")) {
                    ret = serverRet[1].equals("true") ? (serverRet.length >= 3 ? serverRet[2] : "") : "";
                    break block13;
                }
                throw new OkuyamaClientException("Execute Violation of validity");
            }
            catch (OkuyamaClientException ice) {
                throw ice;
            }
            catch (ConnectException ce) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.nextConnect();
                        ret = this.getDataNodeStatus(nodeInfo);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(ce);
                    }
                }
                throw new OkuyamaClientException(ce);
            }
            catch (SocketException se) {
                if (this.masterNodesList != null && this.masterNodesList.size() > 1) {
                    try {
                        this.nextConnect();
                        ret = this.getDataNodeStatus(nodeInfo);
                    }
                    catch (Exception e) {
                        throw new OkuyamaClientException(se);
                    }
                }
                throw new OkuyamaClientException(se);
            }
            catch (Exception e) {
                throw new OkuyamaClientException(e);
            }
        }
        return ret;
    }
}

