/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.KeyNodeConnector;

public class ConnectionPoolHelper
extends AbstractMasterManagerHelper {
    private int connectCycle = 1000;
    private ArrayList nodeList = null;
    private static ILogger logger = LoggerFactory.createLogger(ConnectionPoolHelper.class);

    @Override
    public void initHelper(String initValue) {
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("ConnectionPoolHelper - executeHelper - start");
        String ret = SUCCESS;
        String serverStopMarkerFileName = null;
        File serverStopMarkerFile = null;
        boolean serverRunning = true;
        int counter = 0;
        int maxConnCnt = new Integer(super.getPropertiesValue("KeyNodeConnectionPoolMax"));
        int maxNodeConnCnt = new Integer(super.getPropertiesValue("OneKeyNodeConnectionPoolMax"));
        try {
            while (serverRunning) {
                int i;
                this.nodeList = new ArrayList();
                HashMap allNodeInfo = DataDispatcher.getAllDataNodeInfo();
                ArrayList mainNodeList = (ArrayList)allNodeInfo.get("main");
                ArrayList subNodeList = (ArrayList)allNodeInfo.get("sub");
                ArrayList transactionManagerList = DataDispatcher.getTransactionManagerInfo();
                if (mainNodeList != null) {
                    for (i = 0; i < mainNodeList.size(); ++i) {
                        this.nodeList.add(mainNodeList.get(i));
                    }
                }
                if (subNodeList != null) {
                    for (i = 0; i < subNodeList.size(); ++i) {
                        this.nodeList.add(subNodeList.get(i));
                    }
                }
                if (transactionManagerList != null) {
                    for (i = 0; i < transactionManagerList.size(); ++i) {
                        this.nodeList.add(transactionManagerList.get(i));
                    }
                }
                if (StatusUtil.getStatus() == 1) {
                    serverRunning = false;
                    logger.info("ConnectionPoolHelper - Status Error");
                }
                if (StatusUtil.getStatus() == 2) {
                    serverRunning = false;
                    logger.info("ConnectionPoolHelper - End Status");
                }
                if ((serverStopMarkerFile = new File(new File(serverStopMarkerFileName = super.getPropertiesValue("ServerStopFile")).getAbsolutePath())).exists()) {
                    serverRunning = false;
                    logger.info("ConnectionPoolHelper - Server End File Exists");
                    StatusUtil.setStatus(2);
                }
                counter = super.getNowConnectionPoolCount();
                for (i = 0; i < maxNodeConnCnt && counter < maxConnCnt; ++i) {
                    for (int j = 0; j < this.nodeList.size(); ++j) {
                        String nodeInfo = (String)this.nodeList.get(j);
                        KeyNodeConnector keyNodeConnector = this.createNodeConnection(nodeInfo);
                        if (keyNodeConnector != null) {
                            super.setActiveConnection(nodeInfo, keyNodeConnector);
                        }
                        if (++counter >= maxConnCnt) break;
                    }
                    if (counter >= maxConnCnt) break;
                }
                Thread.sleep(this.connectCycle);
            }
        }
        catch (Exception e) {
            logger.error("ConnectionPoolHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        logger.debug("ConnectionPoolHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private KeyNodeConnector createNodeConnection(String nodeInfo) {
        KeyNodeConnector keyNodeConnector = null;
        String[] nodeInfos = nodeInfo.split(":");
        try {
            keyNodeConnector = new KeyNodeConnector(nodeInfos[0], Integer.parseInt(nodeInfos[1]), nodeInfo);
            keyNodeConnector.connect();
        }
        catch (Exception e) {
            logger.info("Connection Pool Error = [" + nodeInfo + "]");
            keyNodeConnector = null;
        }
        return keyNodeConnector;
    }
}

