/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.job;

import java.net.ServerSocket;
import java.util.Date;
import okuyama.base.JavaMain;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;

public class ServerManagedJob
extends AbstractJob
implements IJob {
    private int checkCycle = 2000;
    private int memoryLimitSize = 90;
    private static ILogger logger = LoggerFactory.createLogger(ServerManagedJob.class);

    @Override
    public void initJob(String initValue) {
        logger.debug("ServerManagedJob - initJob - start");
        if (initValue != null && !initValue.equals("")) {
            this.memoryLimitSize = Integer.parseInt(initValue);
        }
        logger.debug("ServerManagedJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("ServerManagedJob - executeJob - start");
        String ret = SUCCESS;
        Object serverStopMarkerFile = null;
        boolean serverRunning = true;
        Object[] shareKeys = null;
        ServerSocket serverSocket = null;
        boolean firstOver = true;
        long gcExecuteTime = System.currentTimeMillis();
        long executeGcInterval = 60000L;
        long memoryLimitOverCount = 0L;
        long maxMemoryLimitOverCount = 5L;
        boolean gcOff = true;
        try {
            super.executeHelper("ServerControllerHelper", null, true);
            super.executeHelper("ServerTimerHelper", null, true);
            while (serverRunning && StatusUtil.getStatus() == 0) {
                StringBuilder memBuf = new StringBuilder();
                memBuf.append("JVM MaxMemory Size =[" + JavaSystemApi.getRuntimeMaxMem("M") + "];");
                memBuf.append("JVM TotalMemory Size =[" + JavaSystemApi.getRuntimeTotalMem("M") + "]; ");
                memBuf.append("JVM FreeMemory Size =[" + JavaSystemApi.getRuntimeFreeMem("M") + "]; ");
                memBuf.append("JVM Use Memory Percent=[" + JavaSystemApi.getUseMemoryPercent() + "]");
                StatusUtil.setNowMemoryStatus(memBuf.toString());
                if (optionParam != null && optionParam.equals("true")) {
                    logger.debug("JVM MaxMemory Size =[" + JavaSystemApi.getRuntimeMaxMem("M") + "]");
                    logger.debug("JVM TotalMemory Size =[" + JavaSystemApi.getRuntimeTotalMem("M") + "]");
                    logger.debug("JVM FreeMemory Size =[" + JavaSystemApi.getRuntimeFreeMem("M") + "]");
                    logger.debug("JVM Use Memory Percent=[" + JavaSystemApi.getUseMemoryPercent() + "]");
                }
                if (!gcOff && JavaSystemApi.getUseMemoryPercentCache() > this.memoryLimitSize) {
                    if (++memoryLimitOverCount < maxMemoryLimitOverCount || System.currentTimeMillis() - gcExecuteTime > executeGcInterval) {
                        System.out.println(new Date().toString() + " FullGC - Execute - Start");
                        JavaSystemApi.manualGc();
                        System.out.println(new Date().toString() + " FullGC - Execute - End");
                        gcExecuteTime = System.currentTimeMillis();
                    } else if (memoryLimitOverCount == maxMemoryLimitOverCount) {
                        System.out.println(new Date().toString() + " JVM Limit MemorySize Over");
                        StatusUtil.useMemoryLimitOver();
                        gcOff = true;
                    }
                } else {
                    memoryLimitOverCount = 0L;
                }
                if (!gcOff) {
                    JavaSystemApi.autoGc();
                }
                Thread.sleep(this.checkCycle);
            }
            shareKeys = super.getJobShareParamKeys();
            if (shareKeys != null) {
                for (int i = 0; i < shareKeys.length; ++i) {
                    if (!(shareKeys[i] instanceof String) || ((String)shareKeys[i]).indexOf("ServeSocket") == -1) continue;
                    try {
                        serverSocket = (ServerSocket)super.getJobShareParam((String)shareKeys[i]);
                        serverSocket.close();
                        serverSocket = null;
                        continue;
                    }
                    catch (Exception e2) {
                        logger.error("ServerManagedJob - executeJob - ServerSocket Colse Error!! Error Socket = " + (String)shareKeys[i], e2);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("ServerManagedJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        finally {
            if (StatusUtil.getStatus() == 1 || StatusUtil.getStatus() == 2) {
                logger.error("ServerManagedJob - executeJob - Error End Message=[" + StatusUtil.getStatusMessage() + "]");
                JavaMain.shutdownMainProccess();
            }
        }
        logger.debug("ServerManagedJob - executeJob - end");
        return ret;
    }
}

