/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.AllFileModeCoreValueCnv;
import okuyama.imdst.util.CoreValueMapSet;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ICoreValueConverter;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.MemoryModeCoreValueCnv;
import okuyama.imdst.util.PartialConcurrentHashMap;
import okuyama.imdst.util.PartialFileModeCoreValueCnv;
import okuyama.imdst.util.PartialSerializeMap;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.serializemap.SerializeMap;

public class CoreValueMap
extends AbstractMap
implements Cloneable,
Serializable {
    private boolean fileWrite = false;
    private ICoreValueConverter converter = null;
    private AbstractMap mainMap = null;
    private boolean allDataMemory = false;
    private boolean urgentSaveMode = false;
    private AbstractMap urgentSaveMap = null;
    private ICoreValueConverter urgentSaveMapConverter = null;
    private String[] virtualStoreDirs = null;
    private Object syncObj = new Object();

    public CoreValueMap(int size, int upper, int multi, boolean memoryMode, String[] virtualStoreDirs) {
        if (memoryMode) {
            if (!ImdstDefine.useSerializeMap) {
                this.mainMap = new PartialConcurrentHashMap(size, upper, multi, virtualStoreDirs);
            } else {
                if (size > 19999999) {
                    multi = 2000000;
                } else if (size > 9999999) {
                    multi = 1000000;
                } else if (size > 5999999) {
                    multi = 600000;
                } else if (size > 2999999) {
                    multi = 400000;
                } else if (size > 999999) {
                    multi = 200000;
                } else if (size > 599999) {
                    multi = 100000;
                } else {
                    size = 200000;
                    upper = 190000;
                    multi = 50000;
                }
                this.mainMap = new PartialSerializeMap(size, upper, multi, virtualStoreDirs);
            }
            this.converter = new MemoryModeCoreValueCnv();
            this.allDataMemory = true;
        } else {
            if (!ImdstDefine.useSerializeMap) {
                this.mainMap = new ConcurrentHashMap(size, upper, multi);
            } else {
                if (size > 19999999) {
                    multi = 2000000;
                } else if (size > 9999999) {
                    multi = 1000000;
                } else if (size > 5999999) {
                    multi = 600000;
                } else if (size > 2999999) {
                    multi = 400000;
                } else if (size > 999999) {
                    multi = 200000;
                } else if (size > 599999) {
                    multi = 100000;
                } else {
                    size = 200000;
                    upper = 190000;
                    multi = 50000;
                }
                this.mainMap = new SerializeMap(size, upper, multi, ImdstDefine.serializerClassName);
            }
            this.converter = new PartialFileModeCoreValueCnv();
        }
        this.virtualStoreDirs = virtualStoreDirs;
    }

    public CoreValueMap(String[] dirs, int numberOfDataSize) {
        this.mainMap = new FileBaseDataMap(dirs, numberOfDataSize, 0.2, 15);
        this.converter = new AllFileModeCoreValueCnv();
    }

    @Override
    public Object put(Object key, Object value) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        return this.urgentSaveMap.put(this.urgentSaveMapConverter.convertEncodeKey(key), this.urgentSaveMapConverter.convertEncodeValue(value));
    }

    @Override
    public Object get(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.get(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public Object remove(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.remove(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.containsKey(this.converter.convertEncodeKey(key));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return true;
        }
        return this.urgentSaveMap.containsKey(this.urgentSaveMapConverter.convertEncodeKey(key));
    }

    @Override
    public void clear() {
        this.mainMap.clear();
        if (this.isUrgentSaveMode()) {
            this.urgentSaveMap.clear();
        }
    }

    @Override
    public int size() {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.size();
        }
        int retSize = this.mainMap.size();
        return retSize += this.urgentSaveMap.size();
    }

    @Override
    public Set entrySet() {
        if (!this.isUrgentSaveMode()) {
            return new CoreValueMapSet(this.mainMap.entrySet(), this.converter);
        }
        return new CoreValueMapSet(this.mainMap.entrySet(), this.urgentSaveMap.entrySet(), this.converter, this.urgentSaveMapConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUrgentSaveMode() {
        if (this.virtualStoreDirs == null) {
            return false;
        }
        if (this.urgentSaveMode) {
            return true;
        }
        if (!StatusUtil.isUseMemoryLimitOver()) {
            return false;
        }
        if (this.urgentSaveMap != null) {
            return true;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.urgentSaveMap != null) {
                return true;
            }
            this.urgentSaveMapConverter = new AllFileModeCoreValueCnv();
            this.urgentSaveMap = this.allDataMemory ? new FileBaseDataMap(this.virtualStoreDirs, 100000, 0.05, new Double((double)ImdstDefine.saveDataMaxSize * 1.38).intValue() + 1, 512, 126976) : new FileBaseDataMap(this.virtualStoreDirs, 100000, 0.05);
            this.urgentSaveMode = true;
        }
        return true;
    }
}

