/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.KeyNodeConnector;

public class KeyNodeOptimizationConsistentHashHelper
extends AbstractMasterManagerHelper {
    private int checkCycle = 60000;
    private KeyNodeConnector mainKeyNodeConnector = null;
    private KeyNodeConnector subKeyNodeConnector = null;
    private KeyNodeConnector thirdKeyNodeConnector = null;
    private int nextData = 1;
    private static ILogger logger = LoggerFactory.createLogger(KeyNodeOptimizationConsistentHashHelper.class);

    @Override
    public void initHelper(String initValue) {
        if (initValue != null) {
            try {
                this.checkCycle = Integer.parseInt(initValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("KeyNodeOptimizationConsistentHashHelper - executeHelper - start");
        String ret = SUCCESS;
        Object serverStopMarkerFileName = null;
        Object serverStopMarkerFile = null;
        boolean serverRunning = true;
        HashMap moveTargetData = null;
        boolean sendError = false;
        String addMainDataNodeInfo = null;
        HashMap mainMoveTargetMap = null;
        String[] toMainDataNodeDt = null;
        Set mainSet = null;
        Iterator mainIterator = null;
        KeyNodeConnector toMainKeyNodeConnector = null;
        String toMainSendRet = null;
        String mainDataNodeStr = null;
        String[] mainDataNodeDetail = null;
        String mainRangStr = null;
        String mainTargetDataStr = null;
        ArrayList<String> mainRemoveTargetDatas = null;
        String addSubDataNodeInfo = null;
        HashMap subMoveTargetMap = null;
        String[] toSubDataNodeDt = null;
        Set subSet = null;
        Iterator subIterator = null;
        KeyNodeConnector toSubKeyNodeConnector = null;
        String toSubSendRet = null;
        String subDataNodeStr = null;
        String[] subDataNodeDetail = null;
        String subRangStr = null;
        String subTargetDataStr = null;
        ArrayList<String> subRemoveTargetDatas = null;
        String addThirdDataNodeInfo = null;
        HashMap thirdMoveTargetMap = null;
        String[] toThirdDataNodeDt = null;
        Set thirdSet = null;
        Iterator thirdIterator = null;
        KeyNodeConnector toThirdKeyNodeConnector = null;
        String toThirdSendRet = null;
        String thirdDataNodeStr = null;
        String[] thirdDataNodeDetail = null;
        String thirdRangStr = null;
        String thirdTargetDataStr = null;
        ArrayList<String> thirdRemoveTargetDatas = null;
        Object optimizeTargetKeys = null;
        String myInfo = null;
        String[] myInfoDt = null;
        myInfo = StatusUtil.getMyNodeInfo();
        if (myInfo == null || myInfo.trim().equals("")) {
            myInfo = "127.0.0.1:8888";
        }
        myInfoDt = myInfo.split(":");
        block10: while (true) {
            try {
                while (serverRunning) {
                    Thread.sleep(this.checkCycle);
                    if (!StatusUtil.isMainMasterNode()) continue;
                    moveTargetData = super.getConsistentHashMoveData();
                    Thread.sleep(this.checkCycle);
                    StringBuilder sendRequestBuf = new StringBuilder();
                    sendRequestBuf.append("28");
                    sendRequestBuf.append(",");
                    sendRequestBuf.append("true");
                    if (moveTargetData == null) continue;
                    logger.info("Step - 1");
                    while (true) {
                        super.setNowNodeDataOptimization(true);
                        try {
                            sendError = false;
                            toMainKeyNodeConnector = null;
                            toMainSendRet = null;
                            mainSet = null;
                            mainIterator = null;
                            mainDataNodeStr = null;
                            mainDataNodeDetail = null;
                            mainRangStr = null;
                            mainTargetDataStr = null;
                            mainRemoveTargetDatas = new ArrayList<String>();
                            toSubKeyNodeConnector = null;
                            toSubSendRet = null;
                            subSet = null;
                            subIterator = null;
                            subDataNodeStr = null;
                            subDataNodeDetail = null;
                            subRangStr = null;
                            subTargetDataStr = null;
                            subRemoveTargetDatas = new ArrayList<String>();
                            toThirdKeyNodeConnector = null;
                            toThirdSendRet = null;
                            thirdSet = null;
                            thirdIterator = null;
                            thirdDataNodeStr = null;
                            thirdDataNodeDetail = null;
                            thirdRangStr = null;
                            thirdTargetDataStr = null;
                            thirdRemoveTargetDatas = new ArrayList<String>();
                            addMainDataNodeInfo = (String)moveTargetData.get("tomain");
                            toMainDataNodeDt = addMainDataNodeInfo.split(":");
                            mainMoveTargetMap = (HashMap)moveTargetData.get("main");
                            addSubDataNodeInfo = (String)moveTargetData.get("tosub");
                            subMoveTargetMap = (HashMap)moveTargetData.get("sub");
                            addThirdDataNodeInfo = (String)moveTargetData.get("tothird");
                            thirdMoveTargetMap = (HashMap)moveTargetData.get("third");
                            logger.info("Step - 2");
                            if (addSubDataNodeInfo != null && addThirdDataNodeInfo != null) {
                                logger.info("Step - 3");
                                StatusUtil.waitNodeUseStatus(addMainDataNodeInfo, addSubDataNodeInfo, addThirdDataNodeInfo);
                                StatusUtil.addNodeUse(addMainDataNodeInfo);
                                StatusUtil.addNodeUse(addSubDataNodeInfo);
                                StatusUtil.addNodeUse(addThirdDataNodeInfo);
                            } else if (addSubDataNodeInfo != null) {
                                logger.info("Step - 4");
                                StatusUtil.waitNodeUseStatus(addMainDataNodeInfo, addSubDataNodeInfo, null);
                                StatusUtil.addNodeUse(addMainDataNodeInfo);
                                StatusUtil.addNodeUse(addSubDataNodeInfo);
                            } else {
                                logger.info("Step - 5");
                                StatusUtil.waitNodeUseStatus(addMainDataNodeInfo, null, null);
                                StatusUtil.addNodeUse(addMainDataNodeInfo);
                            }
                            if (super.isNodeArrival(addMainDataNodeInfo)) {
                                logger.info("Step - 6");
                                try {
                                    logger.info("Step - 7");
                                    toMainKeyNodeConnector = new KeyNodeConnector(toMainDataNodeDt[0], Integer.parseInt(toMainDataNodeDt[1]), toMainDataNodeDt[0] + ":" + Integer.parseInt(toMainDataNodeDt[1]));
                                    toMainKeyNodeConnector.connect();
                                    toMainKeyNodeConnector.setSoTimeout(21600000);
                                    mainSet = mainMoveTargetMap.keySet();
                                    mainIterator = mainSet.iterator();
                                    toMainKeyNodeConnector.println(sendRequestBuf.toString());
                                    toMainKeyNodeConnector.flush();
                                    logger.info("Step - 8");
                                }
                                catch (Exception e) {
                                    logger.info("Step Error - 9");
                                    super.setDeadNode(addMainDataNodeInfo, 37, e);
                                    toMainKeyNodeConnector.close();
                                    toMainKeyNodeConnector = null;
                                }
                            }
                            logger.info("Step - 10");
                            if (addSubDataNodeInfo != null) {
                                logger.info("Step - 11");
                                if (super.isNodeArrival(addSubDataNodeInfo)) {
                                    logger.info("Step - 12");
                                    try {
                                        toSubDataNodeDt = addSubDataNodeInfo.split(":");
                                        toSubKeyNodeConnector = new KeyNodeConnector(toSubDataNodeDt[0], Integer.parseInt(toSubDataNodeDt[1]), toSubDataNodeDt[0] + ":" + Integer.parseInt(toSubDataNodeDt[1]));
                                        toSubKeyNodeConnector.connect();
                                        toSubKeyNodeConnector.setSoTimeout(21600000);
                                        subSet = subMoveTargetMap.keySet();
                                        subIterator = subSet.iterator();
                                        toSubKeyNodeConnector.println(sendRequestBuf.toString());
                                        toSubKeyNodeConnector.flush();
                                        logger.info("Step - 13");
                                    }
                                    catch (Exception e) {
                                        logger.info("Step Error - 14");
                                        super.setDeadNode(addSubDataNodeInfo, 38, e);
                                        toSubKeyNodeConnector.close();
                                        toSubKeyNodeConnector = null;
                                    }
                                }
                            }
                            logger.info("Step - 15");
                            if (addThirdDataNodeInfo != null) {
                                logger.info("Step - 16");
                                if (super.isNodeArrival(addThirdDataNodeInfo)) {
                                    logger.info("Step - 17");
                                    try {
                                        toThirdDataNodeDt = addThirdDataNodeInfo.split(":");
                                        toThirdKeyNodeConnector = new KeyNodeConnector(toThirdDataNodeDt[0], Integer.parseInt(toThirdDataNodeDt[1]), toThirdDataNodeDt[0] + ":" + Integer.parseInt(toThirdDataNodeDt[1]));
                                        toThirdKeyNodeConnector.connect();
                                        toThirdKeyNodeConnector.setSoTimeout(21600000);
                                        thirdSet = thirdMoveTargetMap.keySet();
                                        thirdIterator = thirdSet.iterator();
                                        toThirdKeyNodeConnector.println(sendRequestBuf.toString());
                                        toThirdKeyNodeConnector.flush();
                                        logger.info("Step - 18");
                                    }
                                    catch (Exception e) {
                                        logger.info("Step Error - 19");
                                        super.setDeadNode(addThirdDataNodeInfo, 39, e);
                                        toThirdKeyNodeConnector.close();
                                        toThirdKeyNodeConnector = null;
                                    }
                                }
                            }
                            logger.info("Step - 20");
                            if (mainIterator == null) {
                                logger.info("Step - 21");
                                logger.error("KeyNodeOptimizationConsistentHashHelper - [mainIterator == null] MainDataNode Down!! Please Check [" + addMainDataNodeInfo + "]");
                                if (toMainKeyNodeConnector != null) {
                                    toMainKeyNodeConnector.close();
                                }
                                if (toSubKeyNodeConnector != null) {
                                    toSubKeyNodeConnector.close();
                                }
                                if (toThirdKeyNodeConnector != null) {
                                    toThirdKeyNodeConnector.close();
                                }
                                Thread.sleep(5000L);
                                continue;
                            }
                            logger.info("Step - 22");
                            while (mainIterator.hasNext()) {
                                logger.info("Step - 23");
                                mainDataNodeStr = (String)mainIterator.next();
                                mainDataNodeDetail = mainDataNodeStr.split(":");
                                mainRangStr = (String)mainMoveTargetMap.get(mainDataNodeStr);
                                if (subIterator != null) {
                                    logger.info("Step - 24");
                                    subDataNodeStr = (String)subIterator.next();
                                    subDataNodeDetail = subDataNodeStr.split(":");
                                    subRangStr = (String)subMoveTargetMap.get(subDataNodeStr);
                                }
                                logger.info("Step - 25");
                                if (thirdIterator != null) {
                                    logger.info("Step - 26");
                                    thirdDataNodeStr = (String)thirdIterator.next();
                                    thirdDataNodeDetail = thirdDataNodeStr.split(":");
                                    thirdRangStr = (String)thirdMoveTargetMap.get(thirdDataNodeStr);
                                }
                                logger.info("Step - 27");
                                if (subIterator != null && thirdIterator != null) {
                                    logger.info("Step - 28");
                                    StatusUtil.waitNodeUseStatus(mainDataNodeStr, subDataNodeStr, thirdDataNodeStr);
                                    StatusUtil.addNodeUse(mainDataNodeStr);
                                    StatusUtil.addNodeUse(subDataNodeStr);
                                    StatusUtil.addNodeUse(thirdDataNodeStr);
                                } else if (addSubDataNodeInfo != null) {
                                    logger.info("Step - 29");
                                    StatusUtil.waitNodeUseStatus(mainDataNodeStr, subDataNodeStr, null);
                                    StatusUtil.addNodeUse(mainDataNodeStr);
                                    StatusUtil.addNodeUse(subDataNodeStr);
                                } else {
                                    logger.info("Step - 30");
                                    StatusUtil.waitNodeUseStatus(mainDataNodeStr, null, null);
                                    StatusUtil.addNodeUse(mainDataNodeStr);
                                }
                                logger.info("Step - 31");
                                this.getTargetData(1, mainDataNodeDetail[0], Integer.parseInt(mainDataNodeDetail[1]), mainRangStr);
                                mainRemoveTargetDatas.add(new String(mainDataNodeDetail[0] + "#" + mainDataNodeDetail[1] + "#" + mainRangStr));
                                logger.info("Step - 32");
                                if (subIterator != null) {
                                    logger.info("Step - 33");
                                    this.getTargetData(2, subDataNodeDetail[0], Integer.parseInt(subDataNodeDetail[1]), subRangStr);
                                    subRemoveTargetDatas.add(new String(subDataNodeDetail[0] + "#" + subDataNodeDetail[1] + "#" + subRangStr));
                                }
                                if (thirdIterator != null) {
                                    logger.info("Step - 34");
                                    this.getTargetData(3, thirdDataNodeDetail[0], Integer.parseInt(thirdDataNodeDetail[1]), thirdRangStr);
                                    thirdRemoveTargetDatas.add(new String(thirdDataNodeDetail[0] + "#" + thirdDataNodeDetail[1] + "#" + thirdRangStr));
                                }
                                while ((mainTargetDataStr = this.nextData(1, mainDataNodeStr)) != null) {
                                    logger.info("Step - 35");
                                    if (toMainKeyNodeConnector == null) continue;
                                    logger.info("Step - mainDataNodeStr[" + mainDataNodeStr + "] 36");
                                    toMainKeyNodeConnector.println(mainTargetDataStr);
                                    toMainKeyNodeConnector.flush();
                                    toMainSendRet = toMainKeyNodeConnector.readLine();
                                    logger.info("Step - mainDataNodeStr[" + mainDataNodeStr + "] 37");
                                    if (toMainSendRet != null && toMainSendRet.equals("next")) continue;
                                    logger.info("Step - mainDataNodeStr[" + mainDataNodeStr + "] 38");
                                    super.setDeadNode(addMainDataNodeInfo, 42, new Exception(addMainDataNodeInfo + "=SendError"));
                                    sendError = true;
                                    break;
                                }
                                logger.info("Step - 39");
                                if (toSubKeyNodeConnector != null) {
                                    logger.info("Step - 40");
                                    while ((subTargetDataStr = this.nextData(2, subDataNodeStr)) != null) {
                                        logger.info("Step - subDataNodeStr[" + subDataNodeStr + "] 41");
                                        toSubKeyNodeConnector.println(subTargetDataStr);
                                        toSubKeyNodeConnector.flush();
                                        toSubSendRet = toSubKeyNodeConnector.readLine();
                                        logger.info("Step - subDataNodeStr[" + subDataNodeStr + "] 42");
                                        if (toSubSendRet != null && toSubSendRet.equals("next")) continue;
                                        logger.info("Step - subDataNodeStr[" + subDataNodeStr + "] 43");
                                        super.setDeadNode(addSubDataNodeInfo, 43, new Exception(addSubDataNodeInfo + "=SendError"));
                                        sendError = true;
                                        break;
                                    }
                                }
                                logger.info("Step - 44");
                                if (toThirdKeyNodeConnector != null) {
                                    logger.info("Step - 45");
                                    while ((thirdTargetDataStr = this.nextData(3, thirdDataNodeStr)) != null) {
                                        logger.info("Step - thirdDataNodeStr[" + thirdDataNodeStr + "] 46");
                                        toThirdKeyNodeConnector.println(thirdTargetDataStr);
                                        toThirdKeyNodeConnector.flush();
                                        toThirdSendRet = toThirdKeyNodeConnector.readLine();
                                        logger.info("Step - thirdDataNodeStr[" + thirdDataNodeStr + "] 47");
                                        if (toThirdSendRet != null && toThirdSendRet.equals("next")) continue;
                                        logger.info("Step - thirdDataNodeStr[" + thirdDataNodeStr + "] 48");
                                        super.setDeadNode(addThirdDataNodeInfo, 44, new Exception(addThirdDataNodeInfo + "=SendError"));
                                        sendError = true;
                                        break;
                                    }
                                }
                                logger.info("Step - 49");
                                this.closeConnect(1);
                                super.execNodeUseEnd(mainDataNodeStr);
                                if (subIterator != null) {
                                    logger.info("Step - 50");
                                    super.execNodeUseEnd(subDataNodeStr);
                                    this.closeConnect(2);
                                }
                                if (thirdIterator != null) {
                                    logger.info("Step - 51");
                                    super.execNodeUseEnd(thirdDataNodeStr);
                                    this.closeConnect(3);
                                }
                                logger.info("Step - 52");
                                if (!sendError) continue;
                            }
                            logger.info("Step - 53");
                            super.execNodeUseEnd(addMainDataNodeInfo);
                            toMainKeyNodeConnector.println("-1");
                            toMainKeyNodeConnector.flush();
                            toMainKeyNodeConnector.println("(&imdst9999&)");
                            toMainKeyNodeConnector.flush();
                            toMainKeyNodeConnector.close();
                            toMainKeyNodeConnector.close();
                            logger.info("Step - 54");
                            if (subIterator != null) {
                                logger.info("Step - 55");
                                super.execNodeUseEnd(addSubDataNodeInfo);
                                toSubKeyNodeConnector.println("-1");
                                toSubKeyNodeConnector.flush();
                                toSubKeyNodeConnector.println("(&imdst9999&)");
                                toSubKeyNodeConnector.flush();
                                toSubKeyNodeConnector.close();
                            }
                            logger.info("Step - 56");
                            if (thirdIterator != null) {
                                logger.info("Step - 57");
                                super.execNodeUseEnd(addThirdDataNodeInfo);
                                toThirdKeyNodeConnector.println("-1");
                                toThirdKeyNodeConnector.flush();
                                toThirdKeyNodeConnector.println("(&imdst9999&)");
                                toThirdKeyNodeConnector.flush();
                                toThirdKeyNodeConnector.close();
                            }
                            logger.info("Step - 58");
                            if (!sendError) {
                                logger.info("Step - 59");
                                for (int mainIdx = 0; mainIdx < mainRemoveTargetDatas.size(); ++mainIdx) {
                                    logger.info("Step - 60");
                                    String mainRemoveHostDtStr = (String)mainRemoveTargetDatas.get(mainIdx);
                                    String[] mainRemoveHostDt = mainRemoveHostDtStr.split("#");
                                    if (this.removeTargetData(mainRemoveHostDt[0], Integer.parseInt(mainRemoveHostDt[1]), mainRemoveHostDt[2])) continue;
                                    logger.info("Step - 61");
                                    logger.error("KeyNodeOptimizationConsistentHashHelper - removeTargetData - Error target=[" + mainRemoveHostDt[0] + ":" + mainRemoveHostDt[1] + " Range[" + mainRemoveHostDt[2] + "]");
                                }
                                logger.info("Step - 62");
                                if (subIterator != null) {
                                    logger.info("Step - 63");
                                    for (int subIdx = 0; subIdx < subRemoveTargetDatas.size(); ++subIdx) {
                                        logger.info("Step - 64");
                                        String subRemoveHostDtStr = (String)subRemoveTargetDatas.get(subIdx);
                                        String[] subRemoveHostDt = subRemoveHostDtStr.split("#");
                                        if (this.removeTargetData(subRemoveHostDt[0], Integer.parseInt(subRemoveHostDt[1]), subRemoveHostDt[2])) continue;
                                        logger.info("Step - 65");
                                        logger.error("KeyNodeOptimizationConsistentHashHelper - removeTargetData - Error target=[" + subRemoveHostDt[0] + ":" + subRemoveHostDt[1] + " Range[" + subRemoveHostDt[2] + "]");
                                    }
                                }
                                logger.info("Step - 66");
                                if (thirdIterator != null) {
                                    logger.info("Step - 67");
                                    for (int thirdIdx = 0; thirdIdx < thirdRemoveTargetDatas.size(); ++thirdIdx) {
                                        logger.info("Step - 68");
                                        String thirdRemoveHostDtStr = (String)thirdRemoveTargetDatas.get(thirdIdx);
                                        String[] thirdRemoveHostDt = thirdRemoveHostDtStr.split("#");
                                        if (this.removeTargetData(thirdRemoveHostDt[0], Integer.parseInt(thirdRemoveHostDt[1]), thirdRemoveHostDt[2])) continue;
                                        logger.info("Step - 69");
                                        logger.error("KeyNodeOptimizationConsistentHashHelper - removeTargetData - Error target=[" + thirdRemoveHostDt[0] + ":" + thirdRemoveHostDt[1] + " Range[" + thirdRemoveHostDt[2] + "]");
                                    }
                                }
                                logger.info("Step - 70");
                                super.removeConsistentHashMoveData();
                                logger.info("Step - 71");
                                super.setNowNodeDataOptimization(false);
                                logger.info("Step - 72");
                            }
                            logger.info("Step - 73");
                            continue block10;
                        }
                        catch (Exception e) {
                            super.setNowNodeDataOptimization(false);
                            logger.error("Data shift Error =[" + e.toString() + "]");
                            e.printStackTrace();
                            logger.error("Data shift Error Detail =[" + moveTargetData + "]");
                            continue;
                        }
                        break;
                    }
                }
                break;
            }
            catch (Exception e) {
                logger.error("KeyNodeOptimizationConsistentHashHelper - executeHelper - error", e);
                break;
            }
        }
        logger.debug("KeyNodeOptimizationConsistentHashHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private void getTargetData(int target, String nodeName, int nodePort, String rangStr) throws BatchException {
        StringBuilder buf = null;
        KeyNodeConnector keyNodeConnector = null;
        logger.info("getTargetData - target[" + target + "] nodeName[" + nodeName + "] nodePort[" + nodePort + "] rangStr[" + rangStr + "] - Start");
        try {
            if (!super.isNodeArrival(nodeName + ":" + nodePort)) {
                return;
            }
            keyNodeConnector = new KeyNodeConnector(nodeName, nodePort, nodeName + ":" + nodePort);
            keyNodeConnector.connect();
            keyNodeConnector.setSoTimeout(21600000);
            buf = new StringBuilder();
            buf.append("27");
            buf.append(",");
            buf.append("true");
            buf.append(",");
            buf.append(rangStr);
            keyNodeConnector.println(buf.toString());
            keyNodeConnector.flush();
            if (target == 1) {
                this.mainKeyNodeConnector = keyNodeConnector;
            } else if (target == 2) {
                this.subKeyNodeConnector = keyNodeConnector;
            } else if (target == 3) {
                this.thirdKeyNodeConnector = keyNodeConnector;
            }
            logger.info("getTargetData - target[" + target + "] nodeName[" + nodeName + "] nodePort[" + nodePort + "] rangStr[" + rangStr + "] - End");
        }
        catch (SocketException se) {
            logger.info("getTargetData - Error - SocketException");
            super.setDeadNode(nodeName + ":" + nodePort, 39, se);
        }
        catch (IOException ie) {
            logger.info("getTargetData - Error - IOException");
            super.setDeadNode(nodeName + ":" + nodePort, 40, ie);
        }
        catch (Exception e) {
            logger.info("getTargetData - Error - Exception");
            throw new BatchException(e);
        }
    }

    private String nextData(int target, String nodeInfo) throws BatchException {
        String ret = null;
        String line = null;
        KeyNodeConnector keyNodeConnector = null;
        try {
            if (target == 1) {
                keyNodeConnector = this.mainKeyNodeConnector;
            } else if (target == 2) {
                keyNodeConnector = this.subKeyNodeConnector;
            } else if (target == 3) {
                keyNodeConnector = this.thirdKeyNodeConnector;
            }
            if (keyNodeConnector == null) {
                return null;
            }
            while ((line = keyNodeConnector.readLine()) != null) {
                if (line.length() <= 0) continue;
                if (line.length() != 2 || !line.equals("-1")) {
                    ret = line;
                }
                break;
            }
        }
        catch (SocketException se) {
            super.setDeadNode(nodeInfo, 43, se);
        }
        catch (IOException ie) {
            super.setDeadNode(nodeInfo, 44, ie);
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTargetData(String nodeName, int nodePort, String rangStr) throws BatchException {
        StringBuilder buf = null;
        KeyNodeConnector keyNodeConnector = null;
        String removeRet = null;
        boolean ret = false;
        try {
            keyNodeConnector = new KeyNodeConnector(nodeName, nodePort, nodeName + ":" + nodePort);
            keyNodeConnector.connect();
            keyNodeConnector.setSoTimeout(21600000);
            buf = new StringBuilder();
            buf.append("29");
            buf.append(",");
            buf.append("true");
            buf.append(",");
            buf.append(rangStr);
            keyNodeConnector.println(buf.toString());
            keyNodeConnector.flush();
            removeRet = keyNodeConnector.readLine();
            if (removeRet != null && removeRet.equals("-1")) {
                ret = true;
            }
        }
        catch (Exception e) {
            logger.error("KeyNodeOptimizationConsistentHashHelper - removeTargetData - Error " + e);
        }
        finally {
            try {
                if (keyNodeConnector != null) {
                    keyNodeConnector.println("(&imdst9999&)");
                    keyNodeConnector.flush();
                    keyNodeConnector.close();
                    keyNodeConnector = null;
                }
            }
            catch (Exception ee) {}
        }
        return ret;
    }

    private void closeConnect(int target) {
        KeyNodeConnector keyNodeConnector = null;
        try {
            if (target == 1) {
                keyNodeConnector = this.mainKeyNodeConnector;
            } else if (target == 2) {
                keyNodeConnector = this.subKeyNodeConnector;
            } else if (target == 3) {
                keyNodeConnector = this.thirdKeyNodeConnector;
            }
            if (keyNodeConnector != null) {
                keyNodeConnector.println("(&imdst9999&)");
                keyNodeConnector.flush();
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            if (target == 1) {
                this.mainKeyNodeConnector = keyNodeConnector;
            } else if (target == 2) {
                this.subKeyNodeConnector = keyNodeConnector;
            } else if (target == 3) {
                this.thirdKeyNodeConnector = keyNodeConnector;
            }
        }
        catch (Exception e2) {
            logger.error(e2);
        }
    }
}

