/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class OutputCommitter
extends org.apache.hadoop.mapreduce.OutputCommitter {
    public abstract void setupJob(org.apache.hadoop.mapred.JobContext var1) throws IOException;

    @Deprecated
    public void cleanupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
    }

    public void commitJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        this.cleanupJob(jobContext);
    }

    public void abortJob(org.apache.hadoop.mapred.JobContext jobContext, int status) throws IOException {
        this.cleanupJob(jobContext);
    }

    public abstract void setupTask(org.apache.hadoop.mapred.TaskAttemptContext var1) throws IOException;

    public abstract boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext var1) throws IOException;

    public abstract void commitTask(org.apache.hadoop.mapred.TaskAttemptContext var1) throws IOException;

    public abstract void abortTask(org.apache.hadoop.mapred.TaskAttemptContext var1) throws IOException;

    @Override
    public final void setupJob(JobContext jobContext) throws IOException {
        this.setupJob((org.apache.hadoop.mapred.JobContext)jobContext);
    }

    @Override
    @Deprecated
    public final void cleanupJob(JobContext context) throws IOException {
        this.cleanupJob((org.apache.hadoop.mapred.JobContext)context);
    }

    @Override
    public final void commitJob(JobContext context) throws IOException {
        this.commitJob((org.apache.hadoop.mapred.JobContext)context);
    }

    @Override
    public final void abortJob(JobContext context, JobStatus.State runState) throws IOException {
        int state = JobStatus.getOldNewJobRunState(runState);
        if (state != JobStatus.FAILED && state != JobStatus.KILLED) {
            throw new IOException("Invalid job run state : " + runState.name());
        }
        this.abortJob((org.apache.hadoop.mapred.JobContext)context, state);
    }

    @Override
    public final void setupTask(TaskAttemptContext taskContext) throws IOException {
        this.setupTask((org.apache.hadoop.mapred.TaskAttemptContext)taskContext);
    }

    @Override
    public final boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
        return this.needsTaskCommit((org.apache.hadoop.mapred.TaskAttemptContext)taskContext);
    }

    @Override
    public final void commitTask(TaskAttemptContext taskContext) throws IOException {
        this.commitTask((org.apache.hadoop.mapred.TaskAttemptContext)taskContext);
    }

    @Override
    public final void abortTask(TaskAttemptContext taskContext) throws IOException {
        this.abortTask((org.apache.hadoop.mapred.TaskAttemptContext)taskContext);
    }
}

