/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.NodeHealthCheckerService;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskMemoryManagerThread;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import org.apache.hadoop.mapred.TaskTrackerJobACLsManager;
import org.apache.hadoop.mapred.TaskTrackerMetricsInst;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.UserLogCleaner;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.server.tasktracker.Localizer;
import org.apache.hadoop.mapreduce.server.tasktracker.TTConfig;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.mapreduce.util.MRAsyncDiskService;
import org.apache.hadoop.mapreduce.util.MemoryCalculatorPlugin;
import org.apache.hadoop.mapreduce.util.ProcfsBasedProcessTree;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskTracker
implements MRConstants,
TaskUmbilicalProtocol,
Runnable,
TTConfig {
    @Deprecated
    static final String MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY = "mapred.tasktracker.vmem.reserved";
    @Deprecated
    static final String MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY = "mapred.tasktracker.pmem.reserved";
    static final long WAIT_FOR_DONE = 3000L;
    private int httpPort;
    public static final Log LOG;
    public static final String MR_CLIENTTRACE_FORMAT = "src: %s, dest: %s, maps: %s, op: %s, reduceID: %s, duration: %s";
    public static final Log ClientTraceLog;
    volatile boolean running = true;
    private LocalDirAllocator localDirAllocator;
    String taskTrackerName;
    String localHostname;
    InetSocketAddress jobTrackAddr;
    InetSocketAddress taskReportAddress;
    Server taskReportServer = null;
    InterTrackerProtocol jobClient;
    private TrackerDistributedCacheManager distributedCacheManager;
    short heartbeatResponseId = (short)-1;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    TaskTrackerStatus status = null;
    Path systemDirectory = null;
    FileSystem systemFS = null;
    private final HttpServer server;
    volatile boolean shuttingDown = false;
    Map<TaskAttemptID, TaskInProgress> tasks = new HashMap<TaskAttemptID, TaskInProgress>();
    Map<TaskAttemptID, TaskInProgress> runningTasks = null;
    Map<JobID, RunningJob> runningJobs = new TreeMap<JobID, RunningJob>();
    private final JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    volatile int mapTotal = 0;
    volatile int reduceTotal = 0;
    boolean justStarted = true;
    boolean justInited = true;
    Set<TaskAttemptID> shouldReset = new HashSet<TaskAttemptID>();
    Map<String, DF> localDirsDf = new HashMap<String, DF>();
    long minSpaceStart = 0L;
    boolean acceptNewTasks = true;
    long minSpaceKill = 0L;
    static Random r;
    public static final String SUBDIR = "taskTracker";
    static final String DISTCACHEDIR = "distcache";
    static final String JOBCACHE = "jobcache";
    static final String OUTPUT = "output";
    private static final String JARSDIR = "jars";
    static final String LOCAL_SPLIT_FILE = "split.dta";
    static final String LOCAL_SPLIT_META_FILE = "split.info";
    static final String JOBFILE = "job.xml";
    static final String JOB_TOKEN_FILE = "jobToken";
    static final String JOB_LOCAL_DIR = "mapreduce.job.local.dir";
    private JobConf fConf;
    private FileSystem localFs;
    private Localizer localizer;
    private int maxMapSlots;
    private int maxReduceSlots;
    private int failures;
    private UserGroupInformation mrOwner;
    private String supergroup;
    private volatile boolean oobHeartbeatOnTaskCompletion;
    private IntWritable finishedCount = new IntWritable(0);
    private MapEventsFetcherThread mapEventsFetcher;
    int workerThreads;
    CleanupQueue directoryCleanupThread;
    private volatile JvmManager jvmManager;
    UserLogCleaner taskLogCleanupThread;
    private TaskMemoryManagerThread taskMemoryManager;
    private boolean taskMemoryManagerEnabled = true;
    private long totalVirtualMemoryOnTT = -1L;
    private long totalPhysicalMemoryOnTT = -1L;
    private long mapSlotMemorySizeOnTT = -1L;
    private long reduceSlotSizeMemoryOnTT = -1L;
    private long totalMemoryAllottedForTasks = -1L;
    private long reservedPhysicalMemoryOnTT = -1L;
    private ResourceCalculatorPlugin resourceCalculatorPlugin = null;
    private TaskTrackerJobACLsManager jobACLsManager;
    private volatile int heartbeatInterval = 3000;
    private int probe_sample_size = 500;
    private IndexCache indexCache;
    private MRAsyncDiskService asyncDiskService;
    private TaskController taskController;
    private NodeHealthCheckerService healthChecker;
    private List<TaskAttemptID> commitResponses = Collections.synchronizedList(new ArrayList());
    private ShuffleServerMetrics shuffleServerMetrics;
    private TaskTrackerInstrumentation myInstrumentation = null;
    private BlockingQueue<TaskTrackerAction> tasksToCleanup = new LinkedBlockingQueue<TaskTrackerAction>();
    private Thread taskCleanupThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskTrackerAction action;
                        if ((action = (TaskTrackerAction)TaskTracker.this.tasksToCleanup.take()) instanceof KillJobAction) {
                            TaskTracker.this.purgeJob((KillJobAction)action);
                            continue;
                        }
                        if (action instanceof KillTaskAction) {
                            TaskTracker.this.processKillTaskAction((KillTaskAction)action);
                            continue;
                        }
                        LOG.error((Object)("Non-delete action given to cleanup thread: " + action));
                    }
                }
                catch (Throwable except) {
                    LOG.warn((Object)StringUtils.stringifyException((Throwable)except));
                    continue;
                }
                break;
            }
        }
    }, "taskCleanup");
    private Object waitingOn = new Object();
    private static LocalDirAllocator lDirAlloc;
    private long previousUpdate = 0L;
    private TaskLauncher mapLauncher;
    private TaskLauncher reduceLauncher;

    MRAsyncDiskService getAsyncDiskService() {
        return this.asyncDiskService;
    }

    void setAsyncDiskService(MRAsyncDiskService asyncDiskService) {
        this.asyncDiskService = asyncDiskService;
    }

    public TaskTrackerInstrumentation getTaskTrackerInstrumentation() {
        return this.myInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processKillTaskAction(KillTaskAction killAction) throws IOException {
        TaskInProgress tip;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            tip = this.tasks.get(killAction.getTaskID());
        }
        LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskID()));
        this.purgeTask(tip, false);
    }

    public TaskController getTaskController() {
        return this.taskController;
    }

    void setTaskController(TaskController t) {
        this.taskController = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningJob addTaskToJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rJob = null;
            if (!this.runningJobs.containsKey(jobId)) {
                rJob = new RunningJob(jobId);
                rJob.localized = false;
                rJob.tasks = new HashSet<TaskInProgress>();
                this.runningJobs.put(jobId, rJob);
            } else {
                rJob = this.runningJobs.get(jobId);
            }
            RunningJob runningJob = rJob;
            synchronized (runningJob) {
                rJob.tasks.add(tip);
            }
            this.runningJobs.notify();
            return rJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskFromJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob == null) {
                LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
            } else {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.tasks.remove(tip);
                }
            }
        }
    }

    JobTokenSecretManager getJobTokenSecretManager() {
        return this.jobTokenSecretManager;
    }

    RunningJob getRunningJob(JobID jobId) {
        return this.runningJobs.get(jobId);
    }

    Localizer getLocalizer() {
        return this.localizer;
    }

    void setLocalizer(Localizer l) {
        this.localizer = l;
    }

    public static String getUserDir(String user) {
        return "taskTracker/" + user;
    }

    public static String getPrivateDistributedCacheDir(String user) {
        return TaskTracker.getUserDir(user) + "/" + DISTCACHEDIR;
    }

    public static String getPublicDistributedCacheDir() {
        return "taskTracker/distcache";
    }

    public static String getJobCacheSubdir(String user) {
        return TaskTracker.getUserDir(user) + "/" + JOBCACHE;
    }

    public static String getLocalJobDir(String user, String jobid) {
        return TaskTracker.getJobCacheSubdir(user) + "/" + jobid;
    }

    static String getLocalJobConfFile(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JOBFILE;
    }

    static String getLocalJobTokenFile(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JOB_TOKEN_FILE;
    }

    static String getTaskConfFile(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid, isCleanupAttempt) + "/" + JOBFILE;
    }

    static String getJobJarsDir(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JARSDIR;
    }

    static String getJobJarFile(String user, String jobid) {
        return TaskTracker.getJobJarsDir(user, jobid) + "/" + "job.jar";
    }

    static String getJobWorkDir(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + "work";
    }

    static String getLocalSplitMetaFile(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid) + "/" + LOCAL_SPLIT_META_FILE;
    }

    static String getLocalSplitFile(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid) + "/" + LOCAL_SPLIT_FILE;
    }

    static String getIntermediateOutputDir(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid) + "/" + OUTPUT;
    }

    static String getLocalTaskDir(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid, false);
    }

    public static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = TaskTracker.getLocalJobDir(user, jobid) + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + TASK_CLEANUP_SUFFIX;
        }
        return taskDir;
    }

    static String getTaskWorkDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String dir = TaskTracker.getLocalTaskDir(user, jobid, taskid, isCleanupAttempt);
        return dir + "/" + "work";
    }

    String getPid(TaskAttemptID tid) {
        TaskInProgress tip = this.tasks.get(tid);
        if (tip != null) {
            return this.jvmManager.getPid(tip.getTaskRunner());
        }
        return null;
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(TaskUmbilicalProtocol.class.getName())) {
            return 19L;
        }
        throw new IOException("Unknown protocol for task tracker: " + protocol);
    }

    synchronized void initialize() throws IOException, InterruptedException {
        String keytabFilename = this.fConf.get("mapreduce.tasktracker.keytab.file");
        UserGroupInformation.setConfiguration((Configuration)this.fConf);
        if (keytabFilename != null) {
            String desiredUser = this.fConf.get("mapreduce.tasktracker.user.name", System.getProperty("user.name"));
            UserGroupInformation.loginUserFromKeytab((String)desiredUser, (String)keytabFilename);
            this.mrOwner = UserGroupInformation.getLoginUser();
        } else {
            this.mrOwner = UserGroupInformation.getCurrentUser();
        }
        this.supergroup = this.fConf.get("mapreduce.cluster.permissions.supergroup", "supergroup");
        LOG.info((Object)("Starting tasktracker with owner as " + this.mrOwner.getShortUserName() + " and supergroup as " + this.supergroup));
        this.localFs = FileSystem.getLocal((Configuration)this.fConf);
        if (this.fConf.get("mapreduce.tasktracker.host.name") != null) {
            this.localHostname = this.fConf.get("mapreduce.tasktracker.host.name");
        }
        if (this.localHostname == null) {
            this.localHostname = DNS.getDefaultHost((String)this.fConf.get("mapreduce.tasktracker.dns.interface", "default"), (String)this.fConf.get("mapreduce.tasktracker.dns.nameserver", "default"));
        }
        TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
        this.setAsyncDiskService(new MRAsyncDiskService(this.fConf));
        this.getAsyncDiskService().cleanupAllVolumes();
        this.tasks.clear();
        this.runningTasks = new LinkedHashMap<TaskAttemptID, TaskInProgress>();
        this.runningJobs = new TreeMap<JobID, RunningJob>();
        this.mapTotal = 0;
        this.reduceTotal = 0;
        this.acceptNewTasks = true;
        this.status = null;
        this.minSpaceStart = this.fConf.getLong("mapreduce.tasktracker.local.dir.minspacestart", 0L);
        this.minSpaceKill = this.fConf.getLong("mapreduce.tasktracker.local.dir.minspacekill", 0L);
        this.probe_sample_size = this.fConf.getInt("mapreduce.tasktracker.events.batchsize", 500);
        Class<? extends TaskTrackerInstrumentation> metricsInst = TaskTracker.getInstrumentationClass(this.fConf);
        try {
            Constructor<? extends TaskTrackerInstrumentation> c = metricsInst.getConstructor(TaskTracker.class);
            this.myInstrumentation = c.newInstance(this);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize taskTracker metrics", (Throwable)e);
            this.myInstrumentation = new TaskTrackerMetricsInst(this);
        }
        InetSocketAddress socAddr = NetUtils.createSocketAddr((String)this.fConf.get("mapreduce.tasktracker.report.address", "127.0.0.1:0"));
        String bindAddress = socAddr.getHostName();
        int tmpPort = socAddr.getPort();
        this.jvmManager = new JvmManager(this);
        if (this.fConf.getBoolean("hadoop.security.authorization", false)) {
            PolicyProvider policyProvider = (PolicyProvider)ReflectionUtils.newInstance((Class)this.fConf.getClass("hadoop.security.authorization.policyprovider", MapReducePolicyProvider.class, PolicyProvider.class), (Configuration)this.fConf);
            ServiceAuthorizationManager.refresh((Configuration)this.fConf, (PolicyProvider)policyProvider);
        }
        int max = this.maxMapSlots > this.maxReduceSlots ? this.maxMapSlots : this.maxReduceSlots;
        this.taskReportServer = RPC.getServer(this.getClass(), (Object)this, (String)bindAddress, (int)tmpPort, (int)(2 * max), (boolean)false, (Configuration)this.fConf, (SecretManager)this.jobTokenSecretManager);
        this.taskReportServer.start();
        this.taskReportAddress = this.taskReportServer.getListenerAddress();
        this.fConf.set("mapreduce.tasktracker.report.address", this.taskReportAddress.getHostName() + ":" + this.taskReportAddress.getPort());
        LOG.info((Object)("TaskTracker up at: " + this.taskReportAddress));
        this.taskTrackerName = "tracker_" + this.localHostname + ":" + this.taskReportAddress;
        LOG.info((Object)("Starting tracker " + this.taskTrackerName));
        Class taskControllerClass = this.fConf.getClass("mapreduce.tasktracker.taskcontroller", DefaultTaskController.class, TaskController.class);
        this.taskController = (TaskController)ReflectionUtils.newInstance((Class)taskControllerClass, (Configuration)this.fConf);
        this.taskController.setup();
        this.distributedCacheManager = new TrackerDistributedCacheManager(this.fConf, this.taskController, this.asyncDiskService);
        this.distributedCacheManager.startCleanupThread();
        this.jobClient = (InterTrackerProtocol)this.mrOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                return RPC.waitForProxy(InterTrackerProtocol.class, (long)30L, (InetSocketAddress)TaskTracker.this.jobTrackAddr, (Configuration)TaskTracker.this.fConf);
            }
        });
        this.justInited = true;
        this.running = true;
        this.mapEventsFetcher = new MapEventsFetcherThread();
        this.mapEventsFetcher.setDaemon(true);
        this.mapEventsFetcher.setName("Map-events fetcher for all reduce tasks on " + this.taskTrackerName);
        this.mapEventsFetcher.start();
        Class clazz = this.fConf.getClass("mapreduce.tasktracker.resourcecalculatorplugin", null, ResourceCalculatorPlugin.class);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(clazz, this.fConf);
        LOG.info((Object)(" Using ResourceCalculatorPlugin : " + (Object)((Object)this.resourceCalculatorPlugin)));
        this.initializeMemoryManagement();
        this.setIndexCache(new IndexCache(this.fConf));
        this.taskLogCleanupThread.clearOldUserLogs(this.fConf);
        this.mapLauncher = new TaskLauncher(TaskType.MAP, this.maxMapSlots);
        this.reduceLauncher = new TaskLauncher(TaskType.REDUCE, this.maxReduceSlots);
        this.mapLauncher.start();
        this.reduceLauncher.start();
        this.setLocalizer(new Localizer(this.localFs, this.fConf.getLocalDirs(), this.taskController));
        if (this.shouldStartHealthMonitor(this.fConf)) {
            this.startHealthMonitor(this.fConf);
        }
        this.oobHeartbeatOnTaskCompletion = this.fConf.getBoolean("mapreduce.tasktracker.outofband.heartbeat", false);
    }

    UserGroupInformation getMROwner() {
        return this.mrOwner;
    }

    String getSuperGroup() {
        return this.supergroup;
    }

    boolean isJobLevelAuthorizationEnabled() {
        return this.fConf.getBoolean("mapreduce.cluster.job-authorization-enabled", false);
    }

    public static Class<? extends TaskTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapreduce.tasktracker.instrumentation", TaskTrackerMetricsInst.class, TaskTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends TaskTrackerInstrumentation> t) {
        conf.setClass("mapreduce.tasktracker.instrumentation", t, TaskTrackerInstrumentation.class);
    }

    @Deprecated
    public void cleanupStorage() throws IOException {
        this.fConf.deleteLocalFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunningJob localizeJob(TaskInProgress tip) throws IOException, InterruptedException {
        Task t = tip.getTask();
        JobID jobId = t.getJobID();
        RunningJob rjob = this.addTaskToJob(jobId, tip);
        this.getLocalizer().initializeUserDirs(t.getUser());
        RunningJob runningJob = rjob;
        synchronized (runningJob) {
            if (!rjob.localized) {
                JobConf localJobConf = this.localizeJobFiles(t, rjob);
                this.initializeJobLogDir(jobId);
                TaskController.JobInitializationContext context = new TaskController.JobInitializationContext();
                context.jobid = jobId;
                context.user = t.getUser();
                context.workDir = new File(localJobConf.get(JOB_LOCAL_DIR));
                this.taskController.initializeJob(context);
                rjob.jobConf = localJobConf;
                rjob.keepJobFiles = localJobConf.getKeepTaskFilesPattern() != null || localJobConf.getKeepFailedTaskFiles();
                rjob.localized = true;
            }
        }
        return rjob;
    }

    private FileSystem getFS(final Path filePath, JobID jobId, final Configuration conf) throws IOException, InterruptedException {
        RunningJob rJob = this.runningJobs.get(jobId);
        FileSystem userFs = (FileSystem)rJob.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return filePath.getFileSystem(conf);
            }
        });
        return userFs;
    }

    JobConf localizeJobFiles(Task t, RunningJob rjob) throws IOException, InterruptedException {
        JobID jobId = t.getJobID();
        String userName = t.getUser();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.fConf);
        this.getLocalizer().initializeJobDirs(userName, jobId);
        String localJobTokenFile = this.localizeJobTokenFile(t.getUser(), jobId);
        rjob.ugi = UserGroupInformation.createRemoteUser((String)t.getUser());
        TokenStorage ts = TokenCache.loadTokens(localJobTokenFile, this.fConf);
        Token<JobTokenIdentifier> jt = TokenCache.getJobToken(ts);
        if (jt != null) {
            this.getJobTokenSecretManager().addTokenForJob(jobId.toString(), jt);
        }
        for (Token token : ts.getAllTokens()) {
            rjob.ugi.addToken(token);
        }
        Path localJobFile = this.localizeJobConfFile(new Path(t.getJobFile()), userName, jobId);
        JobConf localJobConf = new JobConf(localJobFile);
        localJobConf.setUser(userName);
        localJobConf.set("mapreduce.job.jobTokenFile", localJobTokenFile.toString());
        Path workDir = lDirAlloc.getLocalPathForWrite(TaskTracker.getJobWorkDir(userName, jobId.toString()), (Configuration)this.fConf);
        if (!localFs.mkdirs(workDir)) {
            throw new IOException("Mkdirs failed to create " + workDir.toString());
        }
        System.setProperty(JOB_LOCAL_DIR, workDir.toUri().getPath());
        localJobConf.set(JOB_LOCAL_DIR, workDir.toUri().getPath());
        this.localizeJobJarFile(userName, jobId, (FileSystem)localFs, localJobConf);
        return localJobConf;
    }

    void initializeJobLogDir(JobID jobId) {
        this.taskLogCleanupThread.unmarkJobFromLogDeletion(jobId);
        this.localizer.initializeJobLogDir(jobId);
    }

    private Path localizeJobConfFile(Path jobFile, String user, JobID jobId) throws IOException, InterruptedException {
        JobConf conf = new JobConf(this.getJobConf());
        FileSystem userFs = this.getFS(jobFile, jobId, conf);
        FileStatus status = null;
        long jobFileSize = -1L;
        try {
            status = userFs.getFileStatus(jobFile);
            jobFileSize = status.getLen();
        }
        catch (FileNotFoundException fe) {
            jobFileSize = -1L;
        }
        Path localJobFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobConfFile(user, jobId.toString()), jobFileSize, (Configuration)this.fConf);
        userFs.copyToLocalFile(jobFile, localJobFile);
        return localJobFile;
    }

    private void localizeJobJarFile(String user, JobID jobId, FileSystem localFs, JobConf localJobConf) throws IOException, InterruptedException {
        String jarFile = localJobConf.getJar();
        FileStatus status = null;
        long jarFileSize = -1L;
        if (jarFile != null) {
            Path jarFilePath = new Path(jarFile);
            FileSystem fs = this.getFS(jarFilePath, jobId, localJobConf);
            try {
                status = fs.getFileStatus(jarFilePath);
                jarFileSize = status.getLen();
            }
            catch (FileNotFoundException fe) {
                jarFileSize = -1L;
            }
            Path localJarFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getJobJarFile(user, jobId.toString()), 5L * jarFileSize, (Configuration)this.fConf);
            fs.copyToLocalFile(jarFilePath, localJarFile);
            localJobConf.setJar(localJarFile.toString());
            RunJar.unJar((File)new File(localJarFile.toString()), (File)new File(localJarFile.getParent().toString()), (Pattern)localJobConf.getJarUnpackPattern());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTaskForJob(TaskInProgress tip, JobConf jobConf) throws IOException {
        TaskInProgress taskInProgress = tip;
        synchronized (taskInProgress) {
            tip.setJobConf(jobConf);
            tip.launchTask();
        }
    }

    public synchronized void shutdown() throws IOException {
        this.shuttingDown = true;
        this.close();
        if (this.server != null) {
            try {
                LOG.info((Object)"Shutting down StatusHttpServer");
                this.server.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down TaskTracker", (Throwable)e);
            }
        }
    }

    public synchronized void close() throws IOException {
        TreeMap<TaskAttemptID, TaskInProgress> tasksToClose = new TreeMap<TaskAttemptID, TaskInProgress>();
        tasksToClose.putAll(this.tasks);
        for (TaskInProgress tip : tasksToClose.values()) {
            tip.jobHasFinished(false);
        }
        this.running = false;
        if (this.asyncDiskService != null) {
            this.asyncDiskService.cleanupAllVolumes();
            this.asyncDiskService.shutdown();
            try {
                if (!this.asyncDiskService.awaitTermination(10000L)) {
                    this.asyncDiskService.shutdownNow();
                    this.asyncDiskService = null;
                }
            }
            catch (InterruptedException e) {
                this.asyncDiskService.shutdownNow();
                this.asyncDiskService = null;
            }
        }
        this.mapEventsFetcher.interrupt();
        this.mapLauncher.interrupt();
        this.reduceLauncher.interrupt();
        this.distributedCacheManager.stopCleanupThread();
        this.jvmManager.stop();
        RPC.stopProxy((Object)this.jobClient);
        boolean done = false;
        while (!done) {
            try {
                this.mapEventsFetcher.join();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.taskReportServer != null) {
            this.taskReportServer.stop();
            this.taskReportServer = null;
        }
        if (this.healthChecker != null) {
            this.healthChecker.stop();
            this.healthChecker = null;
        }
    }

    TaskTracker() {
        this.server = null;
    }

    void setConf(JobConf conf) {
        this.fConf = conf;
    }

    public TaskTracker(JobConf conf) throws IOException, InterruptedException {
        this.fConf = conf;
        this.maxMapSlots = conf.getInt("mapreduce.tasktracker.map.tasks.maximum", 2);
        this.maxReduceSlots = conf.getInt("mapreduce.tasktracker.reduce.tasks.maximum", 2);
        this.jobTrackAddr = JobTracker.getAddress(conf);
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)conf.get("mapreduce.tasktracker.http.address", "0.0.0.0:50060"));
        String httpBindAddress = infoSocAddr.getHostName();
        int httpPort = infoSocAddr.getPort();
        this.server = new HttpServer("task", httpBindAddress, httpPort, httpPort == 0, (Configuration)conf);
        this.workerThreads = conf.getInt("mapreduce.tasktracker.http.threads", 40);
        this.shuffleServerMetrics = new ShuffleServerMetrics(conf);
        this.server.setThreads(1, this.workerThreads);
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        this.localDirAllocator = new LocalDirAllocator("mapreduce.cluster.local.dir");
        this.server.setAttribute("task.tracker", (Object)this);
        this.server.setAttribute("local.file.system", (Object)local);
        this.server.setAttribute("conf", (Object)conf);
        this.server.setAttribute("log", (Object)LOG);
        this.server.setAttribute("localDirAllocator", (Object)this.localDirAllocator);
        this.server.setAttribute("shuffleServerMetrics", (Object)this.shuffleServerMetrics);
        this.server.addInternalServlet("mapOutput", "/mapOutput", MapOutputServlet.class);
        this.server.addServlet("taskLog", "/tasklog", TaskLogServlet.class);
        this.server.start();
        this.httpPort = this.server.getPort();
        this.checkJettyPort(httpPort);
        this.setTaskLogCleanupThread(new UserLogCleaner(this.fConf));
        this.jobACLsManager = new TaskTrackerJobACLsManager(this);
        this.initialize();
    }

    private void checkJettyPort(int port) throws IOException {
        if (port < 0) {
            this.shuttingDown = true;
            throw new IOException("Jetty problem. Jetty didn't bind to a valid port");
        }
    }

    private void startCleanupThreads() throws IOException {
        this.taskCleanupThread.setDaemon(true);
        this.taskCleanupThread.start();
        this.directoryCleanupThread = new CleanupQueue();
        this.taskLogCleanupThread.setDaemon(true);
        this.taskLogCleanupThread.start();
    }

    void setCleanupThread(CleanupQueue c) {
        this.directoryCleanupThread = c;
    }

    CleanupQueue getCleanupThread() {
        return this.directoryCleanupThread;
    }

    UserLogCleaner getTaskLogCleanupThread() {
        return this.taskLogCleanupThread;
    }

    void setTaskLogCleanupThread(UserLogCleaner t) {
        this.taskLogCleanupThread = t;
    }

    void setIndexCache(IndexCache cache) {
        this.indexCache = cache;
    }

    public InterTrackerProtocol getJobClient() {
        return this.jobClient;
    }

    public synchronized InetSocketAddress getTaskTrackerReportAddress() {
        return this.taskReportAddress;
    }

    private List<TaskCompletionEvent> queryJobTracker(IntWritable fromEventId, JobID jobId, InterTrackerProtocol jobClient) throws IOException {
        TaskCompletionEvent[] t = jobClient.getTaskCompletionEvents(jobId, fromEventId.get(), this.probe_sample_size);
        ArrayList<TaskCompletionEvent> recentMapEvents = new ArrayList<TaskCompletionEvent>();
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].isMapTask()) continue;
            recentMapEvents.add(t[i]);
        }
        fromEventId.set(fromEventId.get() + t.length);
        return recentMapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State offerService() throws Exception {
        long lastHeartbeat = 0L;
        while (this.running && !this.shuttingDown) {
            String msg;
            try {
                long now = System.currentTimeMillis();
                long waitTime = (long)this.heartbeatInterval - (now - lastHeartbeat);
                if (waitTime > 0L) {
                    IntWritable intWritable = this.finishedCount;
                    synchronized (intWritable) {
                        if (this.finishedCount.get() == 0) {
                            this.finishedCount.wait(waitTime);
                        }
                        this.finishedCount.set(0);
                    }
                }
                if (this.justInited) {
                    String jobTrackerBV = this.jobClient.getBuildVersion();
                    if (!VersionInfo.getBuildVersion().equals(jobTrackerBV)) {
                        String msg2 = "Shutting down. Incompatible buildVersion.\nJobTracker's: " + jobTrackerBV + "\nTaskTracker's: " + VersionInfo.getBuildVersion();
                        LOG.error((Object)msg2);
                        try {
                            this.jobClient.reportTaskTrackerError(this.taskTrackerName, null, msg2);
                        }
                        catch (Exception e) {
                            LOG.info((Object)("Problem reporting to jobtracker: " + e));
                        }
                        return State.DENIED;
                    }
                    String dir = this.jobClient.getSystemDir();
                    if (dir == null) {
                        throw new IOException("Failed to get system directory");
                    }
                    this.systemDirectory = new Path(dir);
                    this.systemFS = this.systemDirectory.getFileSystem((Configuration)this.fConf);
                }
                HeartbeatResponse heartbeatResponse = this.transmitHeartBeat(now);
                lastHeartbeat = System.currentTimeMillis();
                TaskTrackerAction[] actions = heartbeatResponse.getActions();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got heartbeatResponse from JobTracker with responseId: " + heartbeatResponse.getResponseId() + " and " + (actions != null ? actions.length : 0) + " actions"));
                }
                if (this.reinitTaskTracker(actions)) {
                    return State.STALE;
                }
                this.heartbeatInterval = heartbeatResponse.getHeartbeatInterval();
                this.justStarted = false;
                this.justInited = false;
                if (actions != null) {
                    for (TaskTrackerAction action : actions) {
                        if (action instanceof LaunchTaskAction) {
                            this.addToTaskQueue((LaunchTaskAction)action);
                            continue;
                        }
                        if (action instanceof CommitTaskAction) {
                            CommitTaskAction commitAction = (CommitTaskAction)action;
                            if (this.commitResponses.contains(commitAction.getTaskID())) continue;
                            LOG.info((Object)("Received commit task action for " + commitAction.getTaskID()));
                            this.commitResponses.add(commitAction.getTaskID());
                            continue;
                        }
                        this.tasksToCleanup.put(action);
                    }
                }
                this.markUnresponsiveTasks();
                this.killOverflowingTasks();
                if (!this.acceptNewTasks && this.isIdle()) {
                    this.acceptNewTasks = true;
                }
                this.checkJettyPort(this.server.getPort());
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted. Closing down.");
                return State.INTERRUPTED;
            }
            catch (DiskChecker.DiskErrorException de) {
                msg = "Exiting task tracker for disk error:\n" + StringUtils.stringifyException((Throwable)de);
                LOG.error((Object)msg);
                TaskTracker taskTracker = this;
                synchronized (taskTracker) {
                    this.jobClient.reportTaskTrackerError(this.taskTrackerName, "DiskErrorException", msg);
                }
                return State.STALE;
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (!DisallowedTaskTrackerException.class.getName().equals(reClass)) continue;
                LOG.info((Object)"Tasktracker disallowed by JobTracker.");
                return State.DENIED;
            }
            catch (Exception except) {
                msg = "Caught exception: " + StringUtils.stringifyException((Throwable)except);
                LOG.error((Object)msg);
            }
        }
        return State.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse transmitHeartBeat(long now) throws IOException {
        long localMinSpaceStart;
        boolean askForNewTask;
        boolean sendCounters;
        if (now > this.previousUpdate + 60000L) {
            sendCounters = true;
            this.previousUpdate = now;
        } else {
            sendCounters = false;
        }
        if (this.status == null) {
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.status = new TaskTrackerStatus(this.taskTrackerName, this.localHostname, this.httpPort, this.cloneAndResetRunningTaskStatuses(sendCounters), this.failures, this.maxMapSlots, this.maxReduceSlots);
            }
        } else {
            LOG.info((Object)("Resending 'status' to '" + this.jobTrackAddr.getHostName() + "' with reponseId '" + this.heartbeatResponseId));
        }
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            askForNewTask = (this.status.countOccupiedMapSlots() < this.maxMapSlots || this.status.countOccupiedReduceSlots() < this.maxReduceSlots) && this.acceptNewTasks;
            localMinSpaceStart = this.minSpaceStart;
        }
        if (askForNewTask) {
            TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
            askForNewTask = this.enoughFreeSpace(localMinSpaceStart);
            long freeDiskSpace = this.getFreeSpace();
            long totVmem = this.getTotalVirtualMemoryOnTT();
            long totPmem = this.getTotalPhysicalMemoryOnTT();
            long availableVmem = this.getAvailableVirtualMemoryOnTT();
            long availablePmem = this.getAvailablePhysicalMemoryOnTT();
            long cumuCpuTime = this.getCumulativeCpuTimeOnTT();
            long cpuFreq = this.getCpuFrequencyOnTT();
            int numCpu = this.getNumProcessorsOnTT();
            float cpuUsage = this.getCpuUsageOnTT();
            this.status.getResourceStatus().setAvailableSpace(freeDiskSpace);
            this.status.getResourceStatus().setTotalVirtualMemory(totVmem);
            this.status.getResourceStatus().setTotalPhysicalMemory(totPmem);
            this.status.getResourceStatus().setMapSlotMemorySizeOnTT(this.mapSlotMemorySizeOnTT);
            this.status.getResourceStatus().setReduceSlotMemorySizeOnTT(this.reduceSlotSizeMemoryOnTT);
            this.status.getResourceStatus().setAvailableVirtualMemory(availableVmem);
            this.status.getResourceStatus().setAvailablePhysicalMemory(availablePmem);
            this.status.getResourceStatus().setCumulativeCpuTime(cumuCpuTime);
            this.status.getResourceStatus().setCpuFrequency(cpuFreq);
            this.status.getResourceStatus().setNumProcessors(numCpu);
            this.status.getResourceStatus().setCpuUsage(cpuUsage);
        }
        TaskTrackerStatus.TaskTrackerHealthStatus healthStatus = this.status.getHealthStatus();
        TaskTracker taskTracker2 = this;
        synchronized (taskTracker2) {
            if (this.healthChecker != null) {
                this.healthChecker.setHealthStatus(healthStatus);
            } else {
                healthStatus.setNodeHealthy(true);
                healthStatus.setLastReported(0L);
                healthStatus.setHealthReport("");
            }
        }
        HeartbeatResponse heartbeatResponse = this.jobClient.heartbeat(this.status, this.justStarted, this.justInited, askForNewTask, this.heartbeatResponseId);
        this.heartbeatResponseId = heartbeatResponse.getResponseId();
        TaskTracker taskTracker3 = this;
        synchronized (taskTracker3) {
            for (TaskStatus taskStatus : this.status.getTaskReports()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.inTaskCleanupPhase()) continue;
                if (taskStatus.getIsMap()) {
                    --this.mapTotal;
                } else {
                    --this.reduceTotal;
                }
                try {
                    this.myInstrumentation.completeTask(taskStatus.getTaskID());
                }
                catch (MetricsException me) {
                    LOG.warn((Object)("Caught: " + StringUtils.stringifyException((Throwable)me)));
                }
                this.runningTasks.remove(taskStatus.getTaskID());
            }
            for (TaskInProgress tip : this.runningTasks.values()) {
                tip.getStatus().clearStatus();
            }
        }
        this.status = null;
        return heartbeatResponse;
    }

    long getTotalVirtualMemoryOnTT() {
        return this.totalVirtualMemoryOnTT;
    }

    long getTotalPhysicalMemoryOnTT() {
        return this.totalPhysicalMemoryOnTT;
    }

    long getAvailableVirtualMemoryOnTT() {
        long availableVirtualMemoryOnTT = -1L;
        if (this.resourceCalculatorPlugin != null) {
            availableVirtualMemoryOnTT = this.resourceCalculatorPlugin.getAvailableVirtualMemorySize();
        }
        return availableVirtualMemoryOnTT;
    }

    long getAvailablePhysicalMemoryOnTT() {
        long availablePhysicalMemoryOnTT = -1L;
        if (this.resourceCalculatorPlugin != null) {
            availablePhysicalMemoryOnTT = this.resourceCalculatorPlugin.getAvailablePhysicalMemorySize();
        }
        return availablePhysicalMemoryOnTT;
    }

    long getCumulativeCpuTimeOnTT() {
        long cumulativeCpuTime = -1L;
        if (this.resourceCalculatorPlugin != null) {
            cumulativeCpuTime = this.resourceCalculatorPlugin.getCumulativeCpuTime();
        }
        return cumulativeCpuTime;
    }

    int getNumProcessorsOnTT() {
        int numProcessors = -1;
        if (this.resourceCalculatorPlugin != null) {
            numProcessors = this.resourceCalculatorPlugin.getNumProcessors();
        }
        return numProcessors;
    }

    long getCpuFrequencyOnTT() {
        long cpuFrequency = -1L;
        if (this.resourceCalculatorPlugin != null) {
            cpuFrequency = this.resourceCalculatorPlugin.getCpuFrequency();
        }
        return cpuFrequency;
    }

    float getCpuUsageOnTT() {
        float cpuUsage = -1.0f;
        if (this.resourceCalculatorPlugin != null) {
            cpuUsage = this.resourceCalculatorPlugin.getCpuUsage();
        }
        return cpuUsage;
    }

    long getTotalMemoryAllottedForTasksOnTT() {
        return this.totalMemoryAllottedForTasks;
    }

    long getReservedPhysicalMemoryOnTT() {
        return this.reservedPhysicalMemoryOnTT;
    }

    private boolean reinitTaskTracker(TaskTrackerAction[] actions) {
        if (actions != null) {
            for (TaskTrackerAction action : actions) {
                if (action.getActionId() != TaskTrackerAction.ActionType.REINIT_TRACKER) continue;
                LOG.info((Object)"Recieved RenitTrackerAction from JobTracker");
                return true;
            }
        }
        return false;
    }

    private synchronized void markUnresponsiveTasks() throws IOException {
        long now = System.currentTimeMillis();
        for (TaskInProgress tip : this.runningTasks.values()) {
            long timeSinceLastReport;
            long jobTaskTimeout;
            if (tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING && !tip.isCleaningup() || (jobTaskTimeout = tip.getTaskTimeout()) == 0L || (timeSinceLastReport = now - tip.getLastProgressReport()) <= jobTaskTimeout || tip.wasKilled) continue;
            String msg = "Task " + tip.getTask().getTaskID() + " failed to report status for " + timeSinceLastReport / 1000L + " seconds. Killing!";
            LOG.info((Object)(tip.getTask().getTaskID() + ": " + msg));
            ReflectionUtils.logThreadInfo((Log)LOG, (String)"lost task", (long)30L);
            tip.reportDiagnosticInfo(msg);
            this.myInstrumentation.timedoutTask(tip.getTask().getTaskID());
            this.dumpTaskStack(tip);
            this.purgeTask(tip, true);
        }
    }

    private static CleanupQueue.PathDeletionContext[] buildPathDeletionContexts(FileSystem fs, Path[] paths) {
        int i = 0;
        CleanupQueue.PathDeletionContext[] contexts = new CleanupQueue.PathDeletionContext[paths.length];
        for (Path p : paths) {
            contexts[i++] = new CleanupQueue.PathDeletionContext(fs, p.toUri().getPath());
        }
        return contexts;
    }

    static CleanupQueue.PathDeletionContext[] buildTaskControllerJobPathDeletionContexts(FileSystem fs, Path[] paths, JobID id, String user, TaskController taskController) throws IOException {
        int i = 0;
        CleanupQueue.PathDeletionContext[] contexts = new TaskController.TaskControllerPathDeletionContext[paths.length];
        for (Path p : paths) {
            contexts[i++] = new TaskController.TaskControllerJobPathDeletionContext(fs, p, id, user, taskController);
        }
        return contexts;
    }

    static CleanupQueue.PathDeletionContext[] buildTaskControllerTaskPathDeletionContexts(FileSystem fs, Path[] paths, Task task, boolean isWorkDir, TaskController taskController) throws IOException {
        int i = 0;
        CleanupQueue.PathDeletionContext[] contexts = new TaskController.TaskControllerPathDeletionContext[paths.length];
        for (Path p : paths) {
            contexts[i++] = new TaskController.TaskControllerTaskPathDeletionContext(fs, p, task, isWorkDir, taskController);
        }
        return contexts;
    }

    private void dumpTaskStack(TaskInProgress tip) {
        TaskRunner runner = tip.getTaskRunner();
        if (null == runner) {
            return;
        }
        JvmManager jvmMgr = runner.getJvmManager();
        jvmMgr.dumpStack(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void purgeJob(KillJobAction action) throws IOException {
        JobID jobId = action.getJobID();
        LOG.info((Object)("Received 'KillJobAction' for job: " + jobId));
        RunningJob rjob = null;
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob == null) {
            LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
        } else {
            map = rjob;
            synchronized (map) {
                for (TaskInProgress tip : rjob.tasks) {
                    tip.jobHasFinished(false);
                    Task t = tip.getTask();
                    if (!t.isMapTask()) continue;
                    this.indexCache.removeMap(tip.getTask().getTaskID().toString());
                }
                if (!rjob.keepJobFiles) {
                    this.removeJobFiles(rjob.jobConf.getUser(), rjob.getJobID());
                }
                long now = System.currentTimeMillis();
                this.taskLogCleanupThread.markJobLogsForDeletion(now, rjob.jobConf, rjob.jobid);
                rjob.tasks.clear();
            }
        }
        map = this.runningJobs;
        synchronized (map) {
            this.runningJobs.remove(jobId);
        }
        this.getJobTokenSecretManager().removeTokenForJob(jobId.toString());
    }

    void removeJobFiles(String user, JobID jobId) throws IOException {
        CleanupQueue.PathDeletionContext[] contexts = TaskTracker.buildTaskControllerJobPathDeletionContexts(this.localFs, this.getLocalFiles(this.fConf, ""), jobId, user, this.taskController);
        this.directoryCleanupThread.addToQueue(contexts);
    }

    private void purgeTask(TaskInProgress tip, boolean wasFailure) throws IOException {
        if (tip != null) {
            LOG.info((Object)("About to purge task: " + tip.getTask().getTaskID()));
            this.removeTaskFromJob(tip.getTask().getJobID(), tip);
            tip.jobHasFinished(wasFailure);
            if (tip.getTask().isMapTask()) {
                this.indexCache.removeMap(tip.getTask().getTaskID().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOverflowingTasks() throws IOException {
        long localMinSpaceKill;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            localMinSpaceKill = this.minSpaceKill;
        }
        if (!this.enoughFreeSpace(localMinSpaceKill)) {
            this.acceptNewTasks = false;
            taskTracker = this;
            synchronized (taskTracker) {
                TaskInProgress killMe = this.findTaskToKill(null);
                if (killMe != null) {
                    String msg = "Tasktracker running out of space. Killing task.";
                    LOG.info((Object)(killMe.getTask().getTaskID() + ": " + msg));
                    killMe.reportDiagnosticInfo(msg);
                    this.purgeTask(killMe, false);
                }
            }
        }
    }

    synchronized TaskInProgress findTaskToKill(List<TaskAttemptID> tasksToExclude) {
        TaskInProgress killMe = null;
        for (TaskInProgress tip : this.runningTasks.values()) {
            if (tasksToExclude != null && tasksToExclude.contains(tip.getTask().getTaskID()) || tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING || tip.wasKilled) continue;
            if (killMe == null) {
                killMe = tip;
                continue;
            }
            if (!tip.getTask().isMapTask()) {
                if (!killMe.getTask().isMapTask() && !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
                killMe = tip;
                continue;
            }
            if (!killMe.getTask().isMapTask() || !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
            killMe = tip;
        }
        return killMe;
    }

    private boolean enoughFreeSpace(long minSpace) throws IOException {
        if (minSpace == 0L) {
            return true;
        }
        return minSpace < this.getFreeSpace();
    }

    private long getFreeSpace() throws IOException {
        long biggestSeenSoFar = 0L;
        String[] localDirs = this.fConf.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            DF df = null;
            if (this.localDirsDf.containsKey(localDirs[i])) {
                df = this.localDirsDf.get(localDirs[i]);
            } else {
                df = new DF(new File(localDirs[i]), (Configuration)this.fConf);
                this.localDirsDf.put(localDirs[i], df);
            }
            long availOnThisVol = df.getAvailable();
            if (availOnThisVol <= biggestSeenSoFar) continue;
            biggestSeenSoFar = availOnThisVol;
        }
        return biggestSeenSoFar;
    }

    public JvmManager getJvmManagerInstance() {
        return this.jvmManager;
    }

    void setJvmManagerInstance(JvmManager jvmManager) {
        this.jvmManager = jvmManager;
    }

    private void addToTaskQueue(LaunchTaskAction action) {
        if (action.getTask().isMapTask()) {
            this.mapLauncher.addToTaskQueue(action);
        } else {
            this.reduceLauncher.addToTaskQueue(action);
        }
    }

    int getFreeSlots(boolean isMap) {
        if (isMap) {
            return this.mapLauncher.numFreeSlots.get();
        }
        return this.reduceLauncher.numFreeSlots.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInProgress registerTask(LaunchTaskAction action, TaskLauncher launcher) {
        Task t = action.getTask();
        LOG.info((Object)("LaunchTaskAction (registerTask): " + t.getTaskID() + " task's state:" + (Object)((Object)t.getState())));
        TaskInProgress tip = new TaskInProgress(t, this.fConf, launcher);
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            this.tasks.put(t.getTaskID(), tip);
            this.runningTasks.put(t.getTaskID(), tip);
            boolean isMap = t.isMapTask();
            if (isMap) {
                ++this.mapTotal;
            } else {
                ++this.reduceTotal;
            }
        }
        return tip;
    }

    void startNewTask(TaskInProgress tip) {
        block4: {
            try {
                RunningJob rjob = this.localizeJob(tip);
                this.launchTaskForJob(tip, new JobConf(rjob.jobConf));
            }
            catch (Throwable e) {
                String msg = "Error initializing " + tip.getTask().getTaskID() + ":\n" + StringUtils.stringifyException((Throwable)e);
                LOG.warn((Object)msg);
                tip.reportDiagnosticInfo(msg);
                try {
                    tip.kill(true);
                    tip.cleanup(true);
                }
                catch (IOException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskID() + ":\n" + StringUtils.stringifyException((Throwable)ie2)));
                }
                if (!(e instanceof Error)) break block4;
                throw (Error)e;
            }
        }
    }

    void addToMemoryManager(TaskAttemptID attemptId, boolean isMap, JobConf conf) {
        if (!this.isTaskMemoryManagerEnabled()) {
            return;
        }
        long physicalMemoryLimit = conf.getLong(isMap ? "mapreduce.map.memory.physical.mb" : "mapreduce.reduce.memory.physical.mb", -1L);
        if (physicalMemoryLimit > 0L) {
            physicalMemoryLimit *= 0x100000L;
        }
        long virtualMemoryLimit = isMap ? conf.getMemoryForMapTask() * 1024L * 1024L : conf.getMemoryForReduceTask() * 1024L * 1024L;
        this.taskMemoryManager.addTask(attemptId, virtualMemoryLimit, physicalMemoryLimit);
    }

    void removeFromMemoryManager(TaskAttemptID attemptId) {
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager.removeTask(attemptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTTAboutTaskCompletion() {
        if (this.oobHeartbeatOnTaskCompletion) {
            IntWritable intWritable = this.finishedCount;
            synchronized (intWritable) {
                int value = this.finishedCount.get();
                this.finishedCount.set(value + 1);
                this.finishedCount.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.startCleanupThreads();
            boolean denied = false;
            while (true) {
                if (!this.running || this.shuttingDown || denied) {
                    if (!denied) return;
                    this.shutdown();
                    return;
                }
                boolean staleState = false;
                try {
                    while (this.running && !staleState && !this.shuttingDown && !denied) {
                        try {
                            State osState = this.offerService();
                            if (osState == State.STALE) {
                                staleState = true;
                                continue;
                            }
                            if (osState != State.DENIED) continue;
                            denied = true;
                        }
                        catch (Exception ex) {
                            if (this.shuttingDown) continue;
                            LOG.info((Object)("Lost connection to JobTracker [" + this.jobTrackAddr + "].  Retrying..."), (Throwable)ex);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
                finally {
                    this.close();
                }
                if (this.shuttingDown) {
                    return;
                }
                LOG.warn((Object)"Reinitializing local state");
                this.initialize();
            }
        }
        catch (IOException iex) {
            LOG.error((Object)("Got fatal exception while reinitializing TaskTracker: " + StringUtils.stringifyException((Throwable)iex)));
            return;
        }
        catch (InterruptedException i) {
            LOG.error((Object)("Got interrupted while reinitializing TaskTracker: " + i.getMessage()));
            return;
        }
    }

    @Override
    public synchronized JvmTask getTask(JvmContext context) throws IOException {
        JVMId jvmId = context.jvmId;
        this.jvmManager.setPidToJvm(jvmId, context.pid);
        LOG.debug((Object)("JVM with ID : " + jvmId + " asked for a task"));
        if (!this.jvmManager.isJvmKnown(jvmId)) {
            LOG.info((Object)("Killing unknown JVM " + jvmId));
            return new JvmTask(null, true);
        }
        RunningJob rjob = this.runningJobs.get(jvmId.getJobId());
        if (rjob == null) {
            LOG.info((Object)("Killing JVM " + jvmId + " since job " + jvmId.getJobId() + " is dead"));
            this.jvmManager.killJvm(jvmId);
            return new JvmTask(null, true);
        }
        TaskInProgress tip = this.jvmManager.getTaskForJvm(jvmId);
        if (tip == null) {
            return new JvmTask(null, false);
        }
        if (this.tasks.get(tip.getTask().getTaskID()) != null) {
            LOG.info((Object)("JVM with ID: " + jvmId + " given task: " + tip.getTask().getTaskID()));
            return new JvmTask(tip.getTask(), false);
        }
        LOG.info((Object)("Killing JVM with ID: " + jvmId + " since scheduled task: " + tip.getTask().getTaskID() + " is " + (Object)((Object)tip.taskStatus.getRunState())));
        return new JvmTask(null, true);
    }

    @Override
    public synchronized boolean statusUpdate(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportProgress(taskStatus);
            return true;
        }
        LOG.warn((Object)("Progress from unknown child task: " + taskid));
        return false;
    }

    @Override
    public synchronized void reportDiagnosticInfo(TaskAttemptID taskid, String info) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportNextRecordRange(range);
        } else {
            LOG.warn((Object)("reportNextRecordRange from unknown child task: " + taskid + ". " + "Ignored."));
        }
    }

    @Override
    public synchronized boolean ping(TaskAttemptID taskid) throws IOException {
        return this.tasks.get(taskid) != null;
    }

    @Override
    public synchronized void commitPending(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException {
        LOG.info((Object)("Task " + taskid + " is in commit-pending," + "" + " task state:" + (Object)((Object)taskStatus.getRunState())));
        this.statusUpdate(taskid, taskStatus);
        this.reportTaskFinished(taskid, true);
    }

    @Override
    public synchronized boolean canCommit(TaskAttemptID taskid) {
        return this.commitResponses.contains(taskid);
    }

    @Override
    public synchronized void done(TaskAttemptID taskid) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        this.commitResponses.remove(taskid);
        if (tip != null) {
            tip.reportDone();
        } else {
            LOG.warn((Object)("Unknown child task done: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void shuffleError(TaskAttemptID taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to Shuffle Failure: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("Shuffle Error: " + message);
        this.purgeTask(tip, true);
    }

    @Override
    public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("FSError: " + message);
        this.purgeTask(tip, true);
    }

    @Override
    public synchronized void fatalError(TaskAttemptID taskId, String msg) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - exited : " + msg));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("Error: " + msg);
        this.purgeTask(tip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
        TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
        Set<TaskAttemptID> set = this.shouldReset;
        synchronized (set) {
            if (this.shouldReset.remove(id)) {
                return new MapTaskCompletionEventsUpdate(mapEvents, true);
            }
        }
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob != null) {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    if (f != null) {
                        mapEvents = f.getMapEvents(fromEventId, maxLocs);
                    }
                }
            }
        }
        return new MapTaskCompletionEventsUpdate(mapEvents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTaskFinished(TaskAttemptID taskid, boolean commitPending) {
        TaskInProgress tip;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            tip = this.tasks.get(taskid);
        }
        if (tip != null) {
            tip.reportTaskFinished(commitPending);
        } else {
            LOG.warn((Object)("Unknown child task finished: " + taskid + ". Ignored."));
        }
    }

    public synchronized void mapOutputLost(TaskAttemptID taskid, String errorMsg) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.mapOutputLost(errorMsg);
        } else {
            LOG.warn((Object)("Unknown child with bad map output: " + taskid + ". Ignored."));
        }
    }

    String getName() {
        return this.taskTrackerName;
    }

    private synchronized List<TaskStatus> cloneAndResetRunningTaskStatuses(boolean sendCounters) {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            TaskStatus status = tip.getStatus();
            status.setIncludeCounters(sendCounters);
            if (status.getRunState() != TaskStatus.State.RUNNING) {
                status.setIncludeCounters(true);
            }
            result.add((TaskStatus)status.clone());
            status.clearStatus();
        }
        return result;
    }

    synchronized List<TaskStatus> getRunningTaskStatuses() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            result.add(tip.getStatus());
        }
        return result;
    }

    synchronized List<TaskStatus> getNonRunningTasks() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<TaskAttemptID, TaskInProgress> task : this.tasks.entrySet()) {
            if (this.runningTasks.containsKey(task.getKey())) continue;
            result.add(task.getValue().getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<TaskStatus> getTasksFromRunningJobs() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<JobID, RunningJob> item : this.runningJobs.entrySet()) {
            RunningJob rjob;
            RunningJob runningJob = rjob = item.getValue();
            synchronized (runningJob) {
                for (TaskInProgress tip : rjob.tasks) {
                    result.add(tip.getStatus());
                }
            }
        }
        return result;
    }

    JobConf getJobConf() {
        return this.fConf;
    }

    private static void checkLocalDirs(String[] localDirs) throws DiskChecker.DiskErrorException {
        boolean writable = false;
        if (localDirs != null) {
            for (int i = 0; i < localDirs.length; ++i) {
                try {
                    DiskChecker.checkDir((File)new File(localDirs[i]));
                    writable = true;
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    LOG.warn((Object)("Task Tracker local " + e.getMessage()));
                }
            }
        }
        if (!writable) {
            throw new DiskChecker.DiskErrorException("all local directories are not writable");
        }
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty() && this.tasksToCleanup.isEmpty();
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(TaskTracker.class, (String[])argv, (Log)LOG);
        if (argv.length != 0) {
            System.out.println("usage: TaskTracker");
            System.exit(-1);
        }
        try {
            JobConf conf = new JobConf();
            ReflectionUtils.setContentionTracing((boolean)conf.getBoolean("mapreduce.tasktracker.contention.tracking", false));
            new TaskTracker(conf).run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can not start task tracker because " + StringUtils.stringifyException((Throwable)e)));
            System.exit(-1);
        }
    }

    Path[] getLocalFiles(JobConf conf, String subdir) throws IOException {
        String[] localDirs = conf.getLocalDirs();
        Path[] paths = new Path[localDirs.length];
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        boolean subdirNeeded = subdir != null && subdir.length() > 0;
        for (int i = 0; i < localDirs.length; ++i) {
            paths[i] = subdirNeeded ? new Path(localDirs[i], subdir) : new Path(localDirs[i]);
            paths[i] = paths[i].makeQualified((FileSystem)localFs);
        }
        return paths;
    }

    FileSystem getLocalFileSystem() {
        return this.localFs;
    }

    void setLocalFileSystem(FileSystem fs) {
        this.localFs = fs;
    }

    int getMaxCurrentMapTasks() {
        return this.maxMapSlots;
    }

    int getMaxCurrentReduceTasks() {
        return this.maxReduceSlots;
    }

    synchronized void setMaxMapSlots(int mapSlots) {
        this.maxMapSlots = mapSlots;
    }

    synchronized void setMaxReduceSlots(int reduceSlots) {
        this.maxReduceSlots = reduceSlots;
    }

    public boolean isTaskMemoryManagerEnabled() {
        return this.taskMemoryManagerEnabled;
    }

    public TaskMemoryManagerThread getTaskMemoryManager() {
        return this.taskMemoryManager;
    }

    private long normalizeMemoryConfigValue(long val) {
        if (val < 0L) {
            val = -1L;
        }
        return val;
    }

    private void initializeMemoryManagement() {
        Class clazz;
        MemoryCalculatorPlugin memoryCalculatorPlugin;
        if (this.fConf.get(MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY) != null) {
            LOG.warn((Object)JobConf.deprecatedString(MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY));
        }
        if (this.fConf.get(MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY) != null) {
            LOG.warn((Object)JobConf.deprecatedString(MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY));
        }
        if (this.fConf.get("mapred.task.default.maxvmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString("mapred.task.default.maxvmem"));
        }
        if (this.fConf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString("mapred.task.limit.maxvmem"));
        }
        MemoryCalculatorPlugin memoryCalculatorPlugin2 = memoryCalculatorPlugin = (clazz = this.fConf.getClass("mapreduce.tasktracker.memorycalculatorplugin", null, MemoryCalculatorPlugin.class)) == null ? null : MemoryCalculatorPlugin.getMemoryCalculatorPlugin(clazz, this.fConf);
        if (memoryCalculatorPlugin != null || this.resourceCalculatorPlugin != null) {
            long l = this.totalVirtualMemoryOnTT = memoryCalculatorPlugin == null ? this.resourceCalculatorPlugin.getVirtualMemorySize() : memoryCalculatorPlugin.getVirtualMemorySize();
            if (this.totalVirtualMemoryOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalVmem could not be calculated. Setting it to -1");
                this.totalVirtualMemoryOnTT = -1L;
            }
            long l2 = this.totalPhysicalMemoryOnTT = memoryCalculatorPlugin == null ? this.resourceCalculatorPlugin.getPhysicalMemorySize() : memoryCalculatorPlugin.getPhysicalMemorySize();
            if (this.totalPhysicalMemoryOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalPmem could not be calculated. Setting it to -1");
                this.totalPhysicalMemoryOnTT = -1L;
            }
        }
        this.mapSlotMemorySizeOnTT = this.fConf.getLong("mapreduce.cluster.mapmemory.mb", -1L);
        this.reduceSlotSizeMemoryOnTT = this.fConf.getLong("mapreduce.cluster.reducememory.mb", -1L);
        this.totalMemoryAllottedForTasks = (long)this.maxMapSlots * this.mapSlotMemorySizeOnTT + (long)this.maxReduceSlots * this.reduceSlotSizeMemoryOnTT;
        if (this.totalMemoryAllottedForTasks < 0L) {
            long memoryAllotedForSlot = JobConf.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.default.maxvmem", -1L));
            long limitVmPerTask = JobConf.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.limit.maxvmem", -1L));
            if (memoryAllotedForSlot == -1L) {
                this.totalMemoryAllottedForTasks = -1L;
            } else if (memoryAllotedForSlot > limitVmPerTask) {
                LOG.info((Object)"DefaultMaxVmPerTask is mis-configured. It shouldn't be greater than task limits");
                this.totalMemoryAllottedForTasks = -1L;
            } else {
                this.totalMemoryAllottedForTasks = (long)(this.maxMapSlots + this.maxReduceSlots) * (memoryAllotedForSlot / 0x100000L);
            }
        }
        if (this.totalMemoryAllottedForTasks > this.totalPhysicalMemoryOnTT) {
            LOG.info((Object)"totalMemoryAllottedForTasks > totalPhysicalMemoryOnTT. Thrashing might happen.");
        } else if (this.totalMemoryAllottedForTasks > this.totalVirtualMemoryOnTT) {
            LOG.info((Object)"totalMemoryAllottedForTasks > totalVirtualMemoryOnTT. Thrashing might happen.");
        }
        this.reservedPhysicalMemoryOnTT = this.fConf.getLong("mapreduce.tasktracker.reserved.physicalmemory.mb", -1L);
        this.reservedPhysicalMemoryOnTT = this.reservedPhysicalMemoryOnTT == -1L ? -1L : this.reservedPhysicalMemoryOnTT * 1024L * 1024L;
        this.setTaskMemoryManagerEnabledFlag();
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager = new TaskMemoryManagerThread(this);
            this.taskMemoryManager.setDaemon(true);
            this.taskMemoryManager.start();
        }
    }

    void setTaskMemoryManagerEnabledFlag() {
        if (!ProcfsBasedProcessTree.isAvailable()) {
            LOG.info((Object)"ProcessTree implementation is missing on this system. TaskMemoryManager is disabled.");
            this.taskMemoryManagerEnabled = false;
            return;
        }
        if (this.reservedPhysicalMemoryOnTT == -1L && this.totalMemoryAllottedForTasks == -1L) {
            this.taskMemoryManagerEnabled = false;
            LOG.warn((Object)"TaskTracker's totalMemoryAllottedForTasks is -1 and reserved physical memory is not configured. TaskMemoryManager is disabled.");
            return;
        }
        this.taskMemoryManagerEnabled = true;
    }

    synchronized void cleanUpOverMemoryTask(TaskAttemptID tid, boolean wasFailure, String diagnosticMsg) {
        TaskInProgress tip = this.runningTasks.get(tid);
        if (tip != null) {
            tip.reportDiagnosticInfo(diagnosticMsg);
            try {
                this.purgeTask(tip, wasFailure);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Couldn't purge the task of " + tid + ". Error : " + ioe));
            }
        }
    }

    private boolean shouldStartHealthMonitor(Configuration conf) {
        return NodeHealthCheckerService.shouldRun(conf);
    }

    private void startHealthMonitor(Configuration conf) {
        this.healthChecker = new NodeHealthCheckerService(conf);
        this.healthChecker.start();
    }

    TrackerDistributedCacheManager getTrackerDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    private String localizeJobTokenFile(String user, JobID jobId) throws IOException {
        Path skPath = new Path(this.systemDirectory, jobId.toString() + "/" + JOB_TOKEN_FILE);
        FileStatus status = null;
        long jobTokenSize = -1L;
        status = this.systemFS.getFileStatus(skPath);
        jobTokenSize = status.getLen();
        Path localJobTokenFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobTokenFile(user, jobId.toString()), jobTokenSize, (Configuration)this.fConf);
        String localJobTokenFileStr = localJobTokenFile.toUri().getPath();
        LOG.debug((Object)("localizingJobTokenFile from sd=" + skPath.toUri().getPath() + " to " + localJobTokenFileStr));
        this.systemFS.copyToLocalFile(skPath, localJobTokenFile);
        return localJobTokenFileStr;
    }

    TaskTrackerJobACLsManager getJobACLsManager() {
        return this.jobACLsManager;
    }

    static {
        ConfigUtil.loadResources();
        LOG = LogFactory.getLog(TaskTracker.class);
        ClientTraceLog = LogFactory.getLog((String)(TaskTracker.class.getName() + ".clienttrace"));
        r = new Random();
        lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class MapOutputServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final int MAX_BYTES_TO_READ = 65536;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            long start = System.currentTimeMillis();
            String mapIds = request.getParameter("map");
            String reduceId = request.getParameter("reduce");
            String jobId = request.getParameter("job");
            LOG.debug((Object)("Shuffle started for maps (mapIds=" + mapIds + ") to reduce " + reduceId));
            if (jobId == null) {
                throw new IOException("job parameter is required");
            }
            if (mapIds == null || reduceId == null) {
                throw new IOException("map and reduce parameters are required");
            }
            ServletContext context = this.getServletContext();
            int reduce = Integer.parseInt(reduceId);
            DataOutputStream outStream = null;
            ShuffleServerMetrics shuffleMetrics = (ShuffleServerMetrics)context.getAttribute("shuffleServerMetrics");
            TaskTracker tracker = (TaskTracker)context.getAttribute("task.tracker");
            this.verifyRequest(request, response, tracker, jobId);
            int numMaps = 0;
            try {
                shuffleMetrics.serverHandlerBusy();
                outStream = new DataOutputStream((OutputStream)response.getOutputStream());
                response.setBufferSize(65536);
                JobConf conf = (JobConf)((Object)context.getAttribute("conf"));
                LocalDirAllocator lDirAlloc = (LocalDirAllocator)context.getAttribute("localDirAllocator");
                FileSystem rfs = ((LocalFileSystem)context.getAttribute("local.file.system")).getRaw();
                StringTokenizer itr = new StringTokenizer(mapIds, ",");
                while (itr.hasMoreTokens()) {
                    String mapId = itr.nextToken();
                    ++numMaps;
                    this.sendMapFile(jobId, mapId, reduce, conf, outStream, tracker, lDirAlloc, shuffleMetrics, rfs);
                }
            }
            catch (IOException ie) {
                Log log = (Log)context.getAttribute("log");
                String errorMsg = "getMapOutputs(" + mapIds + "," + reduceId + ") failed";
                log.warn((Object)errorMsg, (Throwable)ie);
                response.sendError(410, errorMsg);
                shuffleMetrics.failedOutput();
                throw ie;
            }
            finally {
                shuffleMetrics.serverHandlerFree();
            }
            outStream.close();
            shuffleMetrics.successOutput();
            long timeElapsed = System.currentTimeMillis() - start;
            LOG.info((Object)("Shuffled " + numMaps + "maps (mapIds=" + mapIds + ") to reduce " + reduceId + " in " + timeElapsed + "s"));
            if (ClientTraceLog.isInfoEnabled()) {
                ClientTraceLog.info((Object)String.format(TaskTracker.MR_CLIENTTRACE_FORMAT, request.getLocalAddr() + ":" + request.getLocalPort(), request.getRemoteAddr() + ":" + request.getRemotePort(), numMaps, "MAPRED_SHUFFLE", reduceId, timeElapsed));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMapFile(String jobId, String mapId, int reduce, Configuration conf, DataOutputStream outStream, TaskTracker tracker, LocalDirAllocator lDirAlloc, ShuffleServerMetrics shuffleMetrics, FileSystem localfs) throws IOException {
            LOG.debug((Object)("sendMapFile called for " + mapId + " to reduce " + reduce));
            boolean isInputException = false;
            FSDataInputStream mapOutputIn = null;
            byte[] buffer = new byte[65536];
            long totalRead = 0L;
            String userName = null;
            Map<JobID, RunningJob> map = tracker.runningJobs;
            synchronized (map) {
                RunningJob rjob = tracker.runningJobs.get(JobID.forName(jobId));
                if (rjob == null) {
                    throw new IOException("Unknown job " + jobId + "!!");
                }
                userName = rjob.jobConf.getUser();
            }
            Path indexFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(userName, jobId, mapId) + "/file.out.index", conf);
            Path mapOutputFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getIntermediateOutputDir(userName, jobId, mapId) + "/file.out", conf);
            IndexRecord info = tracker.indexCache.getIndexInformation(mapId, reduce, indexFileName);
            try {
                mapOutputIn = localfs.open(mapOutputFileName);
                mapOutputIn.seek(info.startOffset);
                ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
                header.write(outStream);
                isInputException = true;
                long rem = info.partLength;
                if (rem == 0L) {
                    throw new IOException("Illegal partLength of 0 for mapId " + mapId + " to reduce " + reduce);
                }
                int len = mapOutputIn.read(buffer, 0, (int)Math.min(rem, 65536L));
                long now = 0L;
                while (len >= 0) {
                    rem -= (long)len;
                    try {
                        shuffleMetrics.outputBytes(len);
                        if (len > 0) {
                            outStream.write(buffer, 0, len);
                        } else {
                            LOG.info((Object)("Skipped zero-length read of map " + mapId + " to reduce " + reduce));
                        }
                    }
                    catch (IOException ie) {
                        isInputException = false;
                        throw ie;
                    }
                    totalRead += (long)len;
                    if (rem == 0L) break;
                    len = mapOutputIn.read(buffer, 0, (int)Math.min(rem, 65536L));
                }
                try {
                    outStream.flush();
                }
                catch (IOException ie) {
                    isInputException = false;
                    throw ie;
                }
            }
            catch (IOException ie) {
                String errorMsg = "error on sending map " + mapId + " to reduce " + reduce;
                if (isInputException) {
                    tracker.mapOutputLost(TaskAttemptID.forName(mapId), errorMsg + StringUtils.stringifyException((Throwable)ie));
                }
                throw new IOException(errorMsg, ie);
            }
            finally {
                if (mapOutputIn != null) {
                    try {
                        mapOutputIn.close();
                    }
                    catch (IOException ioe) {
                        LOG.info((Object)"problem closing map output file", (Throwable)ioe);
                    }
                }
            }
            LOG.info((Object)("Sent out " + totalRead + " bytes to reduce " + reduce + " from map: " + mapId + " given " + info.partLength + "/" + info.rawLength));
        }

        private void verifyRequest(HttpServletRequest request, HttpServletResponse response, TaskTracker tracker, String jobId) throws IOException {
            SecretKey tokenSecret = tracker.getJobTokenSecretManager().retrieveTokenSecret(jobId);
            String enc_str = SecureShuffleUtils.buildMsgFrom(request);
            String urlHashStr = request.getHeader("UrlHash");
            if (urlHashStr == null) {
                response.sendError(401);
                throw new IOException("fetcher cannot be authenticated");
            }
            int len = urlHashStr.length();
            LOG.debug((Object)("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1)));
            try {
                SecureShuffleUtils.verifyReply(urlHashStr, enc_str, tokenSecret);
            }
            catch (IOException ioe) {
                response.sendError(401);
                throw ioe;
            }
            String reply = SecureShuffleUtils.generateHash(urlHashStr.getBytes(), tokenSecret);
            response.addHeader("ReplyHash", reply);
            len = reply.length();
            LOG.debug((Object)("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1)));
        }
    }

    static class RunningJob {
        private JobID jobid;
        private JobConf jobConf;
        volatile Set<TaskInProgress> tasks;
        boolean localized;
        boolean keepJobFiles;
        UserGroupInformation ugi;
        FetchStatus f;

        RunningJob(JobID jobid) {
            this.jobid = jobid;
            this.localized = false;
            this.tasks = new HashSet<TaskInProgress>();
            this.keepJobFiles = false;
        }

        JobID getJobID() {
            return this.jobid;
        }

        UserGroupInformation getUGI() {
            return this.ugi;
        }

        void setFetchStatus(FetchStatus f) {
            this.f = f;
        }

        FetchStatus getFetchStatus() {
            return this.f;
        }

        JobConf getJobConf() {
            return this.jobConf;
        }
    }

    class TaskInProgress {
        Task task;
        long lastProgressReport;
        StringBuffer diagnosticInfo = new StringBuffer();
        private TaskRunner runner;
        volatile boolean done = false;
        volatile boolean wasKilled = false;
        private JobConf defaultJobConf;
        private JobConf localJobConf;
        private boolean keepFailedTaskFiles;
        private boolean alwaysKeepTaskFiles;
        private TaskStatus taskStatus;
        private long taskTimeout;
        private String debugCommand;
        private volatile boolean slotTaken = false;
        private TaskLauncher launcher;

        public TaskInProgress(Task task, JobConf conf) {
            this(task, conf, null);
        }

        public TaskInProgress(Task task, JobConf conf, TaskLauncher launcher) {
            this.task = task;
            this.launcher = launcher;
            this.lastProgressReport = System.currentTimeMillis();
            this.defaultJobConf = conf;
            this.localJobConf = null;
            this.taskStatus = TaskStatus.createTaskStatus(task.isMapTask(), task.getTaskID(), 0.0f, task.getNumSlotsRequired(), task.getState(), this.diagnosticInfo.toString(), "initializing", TaskTracker.this.getName(), task.isTaskCleanupTask() ? TaskStatus.Phase.CLEANUP : (task.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE), task.getCounters());
            this.taskTimeout = 600000L;
        }

        void localizeTask(Task task) throws IOException {
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)TaskTracker.this.fConf);
            TaskTracker.this.getLocalizer().initializeAttemptDirs(task.getUser(), task.getJobID().toString(), task.getTaskID().toString(), task.isTaskCleanupTask());
            Path cwd = lDirAlloc.getLocalPathForWrite(TaskTracker.getTaskWorkDir(task.getUser(), task.getJobID().toString(), task.getTaskID().toString(), task.isTaskCleanupTask()), (Configuration)this.defaultJobConf);
            if (!localFs.mkdirs(cwd)) {
                throw new IOException("Mkdirs failed to create " + cwd.toString());
            }
            this.localJobConf.set("mapreduce.cluster.local.dir", TaskTracker.this.fConf.get("mapreduce.cluster.local.dir"));
            if (TaskTracker.this.fConf.get("mapreduce.tasktracker.host.name") != null) {
                this.localJobConf.set("mapreduce.tasktracker.host.name", TaskTracker.this.fConf.get("mapreduce.tasktracker.host.name"));
            }
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            task.localizeConfiguration(this.localJobConf);
            List staticResolutions = NetUtils.getAllStaticResolutions();
            if (staticResolutions != null && staticResolutions.size() > 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < staticResolutions.size(); ++i) {
                    String[] hostToResolved = (String[])staticResolutions.get(i);
                    str.append(hostToResolved[0] + "=" + hostToResolved[1]);
                    if (i == staticResolutions.size() - 1) continue;
                    str.append(',');
                }
                this.localJobConf.set("mapreduce.tasktracker.net.static.resolutions", str.toString());
            }
            this.debugCommand = task.isMapTask() ? this.localJobConf.getMapDebugScript() : this.localJobConf.getReduceDebugScript();
            String keepPattern = this.localJobConf.getKeepTaskFilesPattern();
            this.alwaysKeepTaskFiles = keepPattern != null ? Pattern.matches(keepPattern, task.getTaskID().toString()) : false;
            if (this.debugCommand != null || this.localJobConf.getProfileEnabled() || this.alwaysKeepTaskFiles || this.keepFailedTaskFiles) {
                this.localJobConf.setNumTasksToExecutePerJvm(1);
            }
            task.setConf(this.localJobConf);
        }

        public Task getTask() {
            return this.task;
        }

        TaskRunner getTaskRunner() {
            return this.runner;
        }

        void setTaskRunner(TaskRunner rnr) {
            this.runner = rnr;
        }

        public synchronized void setJobConf(JobConf lconf) {
            this.localJobConf = lconf;
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            this.taskTimeout = this.localJobConf.getLong("mapreduce.task.timeout", 600000L);
        }

        public synchronized JobConf getJobConf() {
            return this.localJobConf;
        }

        public synchronized TaskStatus getStatus() {
            this.taskStatus.setDiagnosticInfo(this.diagnosticInfo.toString());
            if (this.diagnosticInfo.length() > 0) {
                this.diagnosticInfo = new StringBuffer();
            }
            return this.taskStatus;
        }

        public synchronized void launchTask() throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.localizeTask(this.task);
                if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                    this.taskStatus.setRunState(TaskStatus.State.RUNNING);
                }
                this.setTaskRunner(this.task.createRunner(TaskTracker.this, this));
                this.runner.start();
                this.taskStatus.setStartTime(System.currentTimeMillis());
            } else {
                LOG.info((Object)("Not launching task: " + this.task.getTaskID() + " since it's state is " + (Object)((Object)this.taskStatus.getRunState())));
            }
        }

        boolean isCleaningup() {
            return this.taskStatus.inTaskCleanupPhase();
        }

        boolean canBeLaunched() {
            return this.getRunState() == TaskStatus.State.UNASSIGNED || this.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.getRunState() == TaskStatus.State.KILLED_UNCLEAN;
        }

        public synchronized void reportProgress(TaskStatus taskStatus) {
            LOG.info((Object)(this.task.getTaskID() + " " + taskStatus.getProgress() + "% " + taskStatus.getStateString()));
            if (this.done || this.taskStatus.getRunState() != TaskStatus.State.RUNNING && this.taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING && !this.isCleaningup() || (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) && taskStatus.getRunState() == TaskStatus.State.RUNNING) {
                LOG.info((Object)(this.task.getTaskID() + " Ignoring status-update since " + (this.done ? "task is 'done'" : "runState: " + (Object)((Object)this.taskStatus.getRunState()))));
                return;
            }
            this.taskStatus.statusUpdate(taskStatus);
            this.lastProgressReport = System.currentTimeMillis();
        }

        public long getLastProgressReport() {
            return this.lastProgressReport;
        }

        public TaskStatus.State getRunState() {
            return this.taskStatus.getRunState();
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public synchronized void reportDiagnosticInfo(String info) {
            this.diagnosticInfo.append(info);
        }

        public synchronized void reportNextRecordRange(SortedRanges.Range range) {
            this.taskStatus.setNextRecordRange(range);
        }

        public synchronized void reportDone() {
            if (this.isCleaningup()) {
                if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            } else {
                this.taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
            }
            this.taskStatus.setProgress(1.0f);
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            this.done = true;
            TaskTracker.this.jvmManager.taskFinished(this.runner);
            this.runner.signalDone();
            LOG.info((Object)("Task " + this.task.getTaskID() + " is done."));
            LOG.info((Object)("reported output size for " + this.task.getTaskID() + "  was " + this.taskStatus.getOutputSize()));
        }

        public boolean wasKilled() {
            return this.wasKilled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reportTaskFinished(boolean commitPending) {
            if (!commitPending) {
                try {
                    this.taskFinished();
                }
                finally {
                    this.releaseSlot();
                }
            }
            TaskTracker.this.notifyTTAboutTaskCompletion();
        }

        private void setTaskFailState(boolean wasFailure) {
            if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            } else if (this.task.isMapOrReduce() && this.taskStatus.getPhase() != TaskStatus.Phase.CLEANUP) {
                if (wasFailure) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED_UNCLEAN);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED_UNCLEAN);
                }
            } else if (wasFailure) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished() {
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            boolean needCleanup = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.done || !this.wasKilled) {
                    TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
                }
                if (!this.done) {
                    if (!this.wasKilled) {
                        TaskTracker.this.failures += 1;
                        this.setTaskFailState(true);
                        if (this.debugCommand != null) {
                            try {
                                this.runDebugScript();
                            }
                            catch (Exception e) {
                                String msg = "Debug-script could not be run successfully : " + StringUtils.stringifyException((Throwable)e);
                                LOG.warn((Object)msg);
                                this.reportDiagnosticInfo(msg);
                            }
                        }
                    }
                    this.taskStatus.setProgress(0.0f);
                }
                this.taskStatus.setFinishTime(System.currentTimeMillis());
                needCleanup = this.taskStatus.getRunState() == TaskStatus.State.FAILED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED;
            }
            if (needCleanup) {
                TaskTracker.this.removeTaskFromJob(this.task.getJobID(), this);
            }
            this.cleanup(needCleanup);
        }

        private void runDebugScript() throws IOException {
            String taskStdout = "";
            String taskStderr = "";
            String taskSyslog = "";
            String jobConf = this.task.getJobFile();
            try {
                taskStdout = FileUtil.makeShellPath((File)TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), this.task.isTaskCleanupTask(), TaskLog.LogName.STDOUT));
                taskStderr = FileUtil.makeShellPath((File)TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), this.task.isTaskCleanupTask(), TaskLog.LogName.STDERR));
                taskSyslog = FileUtil.makeShellPath((File)TaskLog.getRealTaskLogFileLocation(this.task.getTaskID(), this.task.isTaskCleanupTask(), TaskLog.LogName.SYSLOG));
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception finding task's stdout/err/syslog files", (Throwable)e);
            }
            File workDir = new File(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir(this.task.getUser(), this.task.getJobID().toString(), this.task.getTaskID().toString(), this.task.isTaskCleanupTask()) + "/" + "work", (Configuration)this.localJobConf).toString());
            File stdout = TaskLog.getTaskLogFile(this.task.getTaskID(), this.task.isTaskCleanupTask(), TaskLog.LogName.DEBUGOUT);
            String program = "";
            String executable = Submitter.getExecutable(this.localJobConf);
            if (executable != null) {
                try {
                    program = new URI(executable).getFragment();
                }
                catch (URISyntaxException ur) {
                    LOG.warn((Object)"Problem in the URI fragment for pipes executable");
                }
            }
            String[] debug = this.debugCommand.split(" ");
            ArrayList<String> vargs = new ArrayList<String>();
            for (String component : debug) {
                vargs.add(component);
            }
            vargs.add(taskStdout);
            vargs.add(taskStderr);
            vargs.add(taskSyslog);
            vargs.add(jobConf);
            vargs.add(program);
            TaskController.DebugScriptContext context = new TaskController.DebugScriptContext();
            context.args = vargs;
            context.stdout = stdout;
            context.workDir = workDir;
            context.task = this.task;
            TaskTracker.this.getTaskController().runDebugScript(context);
            int num = this.localJobConf.getInt("mapreduce.task.debugout.lines", -1);
            this.addDiagnostics(FileUtil.makeShellPath((File)stdout), num, "DEBUG OUT");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDiagnostics(String file, int num, String tag) {
            RandomAccessFile rafile = null;
            try {
                int n;
                rafile = new RandomAccessFile(file, "r");
                int no_lines = 0;
                String line = null;
                StringBuffer tail = new StringBuffer();
                tail.append("\n-------------------- " + tag + "---------------------\n");
                String[] lines = null;
                if (num > 0) {
                    lines = new String[num];
                }
                while ((line = rafile.readLine()) != null) {
                    ++no_lines;
                    if (num > 0) {
                        if (no_lines <= num) {
                            lines[no_lines - 1] = line;
                            continue;
                        }
                        for (int i = 0; i < num - 1; ++i) {
                            lines[i] = lines[i + 1];
                        }
                        lines[num - 1] = line;
                        continue;
                    }
                    if (num != -1) continue;
                    tail.append(line);
                    tail.append("\n");
                }
                int n2 = n = no_lines > num ? num : no_lines;
                if (num > 0) {
                    for (int i = 0; i < n; ++i) {
                        tail.append(lines[i]);
                        tail.append("\n");
                    }
                }
                if (n != 0) {
                    this.reportDiagnosticInfo(tail.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                LOG.warn((Object)("File " + file + " not found"));
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error reading file " + file));
            }
            finally {
                try {
                    if (rafile != null) {
                        rafile.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + file));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobHasFinished(boolean wasFailure) throws IOException {
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.getRunState() == TaskStatus.State.RUNNING || this.getRunState() == TaskStatus.State.UNASSIGNED || this.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                    this.kill(wasFailure);
                }
            }
            this.cleanup(true);
        }

        public synchronized void kill(boolean wasFailure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.RUNNING || this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                this.wasKilled = true;
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                }
                if (this.runner != null) {
                    this.runner.kill();
                }
                this.setTaskFailState(wasFailure);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            }
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
            this.releaseSlot();
            TaskTracker.this.notifyTTAboutTaskCompletion();
        }

        private synchronized void releaseSlot() {
            if (this.slotTaken) {
                if (this.launcher != null) {
                    this.launcher.addFreeSlots(this.task.getNumSlotsRequired());
                }
                this.slotTaken = false;
            } else if (this.launcher != null) {
                this.launcher.notifySlots();
            }
        }

        private synchronized void mapOutputLost(String failure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.SUCCEEDED) {
                LOG.info((Object)("Reporting output lost:" + this.task.getTaskID()));
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
                this.taskStatus.setProgress(0.0f);
                this.reportDiagnosticInfo("Map output lost, rescheduling: " + failure);
                TaskTracker.this.runningTasks.put(this.task.getTaskID(), this);
                ++TaskTracker.this.mapTotal;
            } else {
                LOG.warn((Object)("Output already reported lost:" + this.task.getTaskID()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup(boolean needCleanup) {
            TaskAttemptID taskId = this.task.getTaskID();
            LOG.debug((Object)("Cleaning up " + taskId));
            Object object = TaskTracker.this;
            synchronized (object) {
                if (needCleanup && TaskTracker.this.tasks.get(taskId) == this) {
                    TaskTracker.this.tasks.remove(taskId);
                }
                TaskInProgress taskInProgress = this;
                synchronized (taskInProgress) {
                    if (this.alwaysKeepTaskFiles || this.taskStatus.getRunState() == TaskStatus.State.FAILED && this.keepFailedTaskFiles) {
                        return;
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (this.localJobConf == null) {
                    return;
                }
                try {
                    this.removeTaskFiles(needCleanup, taskId);
                }
                catch (Throwable ie) {
                    LOG.info((Object)("Error cleaning up task runner: " + StringUtils.stringifyException((Throwable)ie)));
                }
            }
        }

        void removeTaskFiles(boolean needCleanup, TaskAttemptID taskId) throws IOException {
            if (needCleanup) {
                if (this.runner != null) {
                    this.runner.close();
                }
                if (this.localJobConf.getNumTasksToExecutePerJvm() == 1) {
                    CleanupQueue.PathDeletionContext[] contexts = TaskTracker.buildTaskControllerTaskPathDeletionContexts(TaskTracker.this.localFs, TaskTracker.this.getLocalFiles(TaskTracker.this.fConf, ""), this.task, false, TaskTracker.this.taskController);
                    TaskTracker.this.directoryCleanupThread.addToQueue(contexts);
                } else {
                    String localTaskDir = TaskTracker.getLocalTaskDir(this.task.getUser(), this.task.getJobID().toString(), taskId.toString(), this.task.isTaskCleanupTask());
                    CleanupQueue.PathDeletionContext[] contexts = TaskTracker.buildPathDeletionContexts(TaskTracker.this.localFs, TaskTracker.this.getLocalFiles(this.defaultJobConf, localTaskDir + "/" + TaskTracker.JOBFILE));
                    TaskTracker.this.directoryCleanupThread.addToQueue(contexts);
                }
            } else if (this.localJobConf.getNumTasksToExecutePerJvm() == 1) {
                CleanupQueue.PathDeletionContext[] contexts = TaskTracker.buildTaskControllerTaskPathDeletionContexts(TaskTracker.this.localFs, TaskTracker.this.getLocalFiles(TaskTracker.this.fConf, ""), this.task, true, TaskTracker.this.taskController);
                TaskTracker.this.directoryCleanupThread.addToQueue(contexts);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof TaskInProgress && this.task.getTaskID().equals(((TaskInProgress)obj).getTask().getTaskID());
        }

        public int hashCode() {
            return this.task.getTaskID().hashCode();
        }
    }

    class TaskLauncher
    extends Thread {
        private IntWritable numFreeSlots;
        private final int maxSlots;
        private List<TaskInProgress> tasksToLaunch;

        public TaskLauncher(TaskType taskType, int numSlots) {
            this.maxSlots = numSlots;
            this.numFreeSlots = new IntWritable(numSlots);
            this.tasksToLaunch = new LinkedList<TaskInProgress>();
            this.setDaemon(true);
            this.setName("TaskLauncher for " + (Object)((Object)taskType) + " tasks");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToTaskQueue(LaunchTaskAction action) {
            List<TaskInProgress> list = this.tasksToLaunch;
            synchronized (list) {
                TaskInProgress tip = TaskTracker.this.registerTask(action, this);
                this.tasksToLaunch.add(tip);
                this.tasksToLaunch.notifyAll();
            }
        }

        public void cleanTaskQueue() {
            this.tasksToLaunch.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFreeSlots(int numSlots) {
            IntWritable intWritable = this.numFreeSlots;
            synchronized (intWritable) {
                this.numFreeSlots.set(this.numFreeSlots.get() + numSlots);
                assert (this.numFreeSlots.get() <= this.maxSlots);
                LOG.info((Object)("addFreeSlot : current free slots : " + this.numFreeSlots.get()));
                this.numFreeSlots.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifySlots() {
            IntWritable intWritable = this.numFreeSlots;
            synchronized (intWritable) {
                this.numFreeSlots.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumWaitingTasksToLaunch() {
            List<TaskInProgress> list = this.tasksToLaunch;
            synchronized (list) {
                return this.tasksToLaunch.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Task task;
                    TaskInProgress tip;
                    Object object = this.tasksToLaunch;
                    synchronized (object) {
                        while (this.tasksToLaunch.isEmpty()) {
                            this.tasksToLaunch.wait();
                        }
                        tip = this.tasksToLaunch.remove(0);
                        task = tip.getTask();
                        LOG.info((Object)("Trying to launch : " + tip.getTask().getTaskID() + " which needs " + task.getNumSlotsRequired() + " slots"));
                    }
                    object = this.numFreeSlots;
                    synchronized (object) {
                        boolean canLaunch = true;
                        while (this.numFreeSlots.get() < task.getNumSlotsRequired()) {
                            if (!tip.canBeLaunched()) {
                                LOG.info((Object)("Not blocking slots for " + task.getTaskID() + " as it got killed externally. Task's state is " + (Object)((Object)tip.getRunState())));
                                canLaunch = false;
                                break;
                            }
                            LOG.info((Object)("TaskLauncher : Waiting for " + task.getNumSlotsRequired() + " to launch " + task.getTaskID() + ", currently we have " + this.numFreeSlots.get() + " free slots"));
                            this.numFreeSlots.wait();
                        }
                        if (!canLaunch) {
                            continue;
                        }
                        LOG.info((Object)("In TaskLauncher, current free slots : " + this.numFreeSlots.get() + " and trying to launch " + tip.getTask().getTaskID() + " which needs " + task.getNumSlotsRequired() + " slots"));
                        this.numFreeSlots.set(this.numFreeSlots.get() - task.getNumSlotsRequired());
                        assert (this.numFreeSlots.get() >= 0);
                    }
                    object = tip;
                    synchronized (object) {
                        if (!tip.canBeLaunched()) {
                            LOG.info((Object)("Not launching task " + task.getTaskID() + " as it got" + " killed externally. Task's state is " + (Object)((Object)tip.getRunState())));
                            this.addFreeSlots(task.getNumSlotsRequired());
                            continue;
                        }
                        tip.slotTaken = true;
                    }
                    TaskTracker.this.startNewTask(tip);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable th) {
                    LOG.error((Object)("TaskLauncher error " + StringUtils.stringifyException((Throwable)th)));
                }
            }
        }
    }

    private class FetchStatus {
        private IntWritable fromEventId = new IntWritable(0);
        private List<TaskCompletionEvent> allMapEvents;
        private JobID jobId;
        private long lastFetchTime;
        private boolean fetchAgain;

        public FetchStatus(JobID jobId, int numMaps) {
            this.jobId = jobId;
            this.allMapEvents = new ArrayList<TaskCompletionEvent>(numMaps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.fromEventId.set(0);
                    this.allMapEvents.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskCompletionEvent[] getMapEvents(int fromId, int max) {
            TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
            boolean notifyFetcher = false;
            Object object = this.allMapEvents;
            synchronized (object) {
                if (this.allMapEvents.size() > fromId) {
                    int actualMax = Math.min(max, this.allMapEvents.size() - fromId);
                    List<TaskCompletionEvent> eventSublist = this.allMapEvents.subList(fromId, actualMax + fromId);
                    mapEvents = eventSublist.toArray(mapEvents);
                } else {
                    notifyFetcher = true;
                }
            }
            if (notifyFetcher) {
                object = TaskTracker.this.waitingOn;
                synchronized (object) {
                    TaskTracker.this.waitingOn.notify();
                }
            }
            return mapEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchMapCompletionEvents(long currTime) throws IOException {
            if (!this.fetchAgain && currTime - this.lastFetchTime < (long)TaskTracker.this.heartbeatInterval) {
                return false;
            }
            int currFromEventId = 0;
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                currFromEventId = this.fromEventId.get();
                List recentMapEvents = TaskTracker.this.queryJobTracker(this.fromEventId, this.jobId, TaskTracker.this.jobClient);
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.allMapEvents.addAll(recentMapEvents);
                }
                this.lastFetchTime = currTime;
                if (this.fromEventId.get() - currFromEventId >= TaskTracker.this.probe_sample_size) {
                    this.fetchAgain = true;
                    return true;
                }
            }
            this.fetchAgain = false;
            return false;
        }
    }

    private class MapEventsFetcherThread
    extends Thread {
        private MapEventsFetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FetchStatus> reducesInShuffle() {
            ArrayList<FetchStatus> fList = new ArrayList<FetchStatus>();
            for (Map.Entry<JobID, RunningJob> item : TaskTracker.this.runningJobs.entrySet()) {
                RunningJob rjob = item.getValue();
                JobID jobId = item.getKey();
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    for (TaskInProgress tip : rjob.tasks) {
                        Task task = tip.getTask();
                        if (task.isMapTask() || ((ReduceTask)task).getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                        if (rjob.getFetchStatus() == null) {
                            f = new FetchStatus(jobId, ((ReduceTask)task).getNumMaps());
                            rjob.setFetchStatus(f);
                        }
                        f = rjob.getFetchStatus();
                        fList.add(f);
                        break;
                    }
                }
            }
            return fList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)("Starting thread: " + this.getName()));
            while (TaskTracker.this.running) {
                try {
                    List<FetchStatus> fList = null;
                    Map<JobID, RunningJob> map = TaskTracker.this.runningJobs;
                    synchronized (map) {
                        while ((fList = this.reducesInShuffle()).size() == 0) {
                            try {
                                TaskTracker.this.runningJobs.wait();
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)("Shutting down: " + this.getName()));
                                return;
                            }
                        }
                    }
                    boolean fetchAgain = false;
                    for (FetchStatus f : fList) {
                        long currentTime = System.currentTimeMillis();
                        try {
                            if (f.fetchMapCompletionEvents(currentTime)) {
                                fetchAgain = true;
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Ignoring exception that fetch for map completion events threw for " + f.jobId + " threw: " + StringUtils.stringifyException((Throwable)e)));
                        }
                        if (TaskTracker.this.running) continue;
                        break;
                    }
                    Object object = TaskTracker.this.waitingOn;
                    synchronized (object) {
                        try {
                            if (!fetchAgain) {
                                TaskTracker.this.waitingOn.wait(TaskTracker.this.heartbeatInterval);
                            }
                        }
                        catch (InterruptedException ie) {
                            LOG.info((Object)("Shutting down: " + this.getName()));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Ignoring exception " + e.getMessage()));
                }
            }
        }
    }

    private class ShuffleServerMetrics
    implements Updater {
        private MetricsRecord shuffleMetricsRecord = null;
        private int serverHandlerBusy = 0;
        private long outputBytes = 0L;
        private int failedOutputs = 0;
        private int successOutputs = 0;

        ShuffleServerMetrics(JobConf conf) {
            MetricsContext context = MetricsUtil.getContext((String)"mapred");
            this.shuffleMetricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"shuffleOutput");
            this.shuffleMetricsRecord.setTag("sessionId", conf.getSessionId());
            context.registerUpdater((Updater)this);
        }

        synchronized void serverHandlerBusy() {
            ++this.serverHandlerBusy;
        }

        synchronized void serverHandlerFree() {
            --this.serverHandlerBusy;
        }

        synchronized void outputBytes(long bytes) {
            this.outputBytes += bytes;
        }

        synchronized void failedOutput() {
            ++this.failedOutputs;
        }

        synchronized void successOutput() {
            ++this.successOutputs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            ShuffleServerMetrics shuffleServerMetrics = this;
            synchronized (shuffleServerMetrics) {
                if (TaskTracker.this.workerThreads != 0) {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 100.0f * ((float)this.serverHandlerBusy / (float)TaskTracker.this.workerThreads));
                } else {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 0);
                }
                this.shuffleMetricsRecord.incrMetric("shuffle_output_bytes", this.outputBytes);
                this.shuffleMetricsRecord.incrMetric("shuffle_failed_outputs", this.failedOutputs);
                this.shuffleMetricsRecord.incrMetric("shuffle_success_outputs", this.successOutputs);
                this.outputBytes = 0L;
                this.failedOutputs = 0;
                this.successOutputs = 0;
            }
            this.shuffleMetricsRecord.update();
        }
    }

    static enum State {
        NORMAL,
        STALE,
        INTERRUPTED,
        DENIED;

    }
}

