/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserToGroupMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MRAdmin
extends Configured
implements Tool {
    public MRAdmin() {
    }

    public MRAdmin(Configuration conf) {
        super(conf);
    }

    private static void printHelp(String cmd) {
        String summary = "hadoop mradmin is the command to execute Map-Reduce administrative commands.\nThe full syntax is: \n\nhadoop mradmin [-refreshServiceAcl] [-refreshQueues] [-refreshNodes] [-refreshUserToGroupsMappings] [-help [cmd]]\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tJobtracker will reload the authorization policy file.\n";
        String refreshQueues = "-refreshQueues: Reload the queues' acls, states and scheduler specific properties.\n\t\tJobTracker will reload the mapred-queues configuration file.\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshNodes = "-refreshNodes: Refresh the hosts information at the jobtracker.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("refreshQueues".equals(cmd)) {
            System.out.println(refreshQueues);
        } else if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(refreshServiceAcl);
            System.out.println(refreshQueues);
            System.out.println(refreshNodes);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        }
    }

    private static void printUsage(String cmd) {
        if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshServiceAcl]");
        } else if ("-refreshQueues".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshQueues]");
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshNodes]");
        } else {
            System.err.println("Usage: java MRAdmin");
            System.err.println("           [-refreshServiceAcl]");
            System.err.println("           [-refreshQueues]");
            System.err.println("           [-refreshUserToGroupsMappings]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        }
    }

    private static UserGroupInformation getUGI(Configuration conf) throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    private int refreshAuthorizationPolicy() throws IOException {
        Configuration conf = this.getConf();
        RefreshAuthorizationPolicyProtocol refreshProtocol = (RefreshAuthorizationPolicyProtocol)RPC.getProxy(RefreshAuthorizationPolicyProtocol.class, (long)1L, (InetSocketAddress)JobTracker.getAddress(conf), (UserGroupInformation)MRAdmin.getUGI(conf), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, RefreshAuthorizationPolicyProtocol.class));
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        RefreshUserToGroupMappingsProtocol refreshProtocol = (RefreshUserToGroupMappingsProtocol)RPC.getProxy(RefreshUserToGroupMappingsProtocol.class, (long)1L, (InetSocketAddress)JobTracker.getAddress(conf), (UserGroupInformation)MRAdmin.getUGI(conf), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, RefreshUserToGroupMappingsProtocol.class));
        refreshProtocol.refreshUserToGroupsMappings(conf);
        return 0;
    }

    private int refreshQueues() throws IOException {
        Configuration conf = this.getConf();
        AdminOperationsProtocol adminOperationsProtocol = (AdminOperationsProtocol)RPC.getProxy(AdminOperationsProtocol.class, (long)3L, (InetSocketAddress)JobTracker.getAddress(conf), (UserGroupInformation)MRAdmin.getUGI(conf), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, AdminOperationsProtocol.class));
        adminOperationsProtocol.refreshQueues();
        return 0;
    }

    private int refreshNodes() throws IOException {
        Configuration conf = this.getConf();
        AdminOperationsProtocol adminOperationsProtocol = (AdminOperationsProtocol)RPC.getProxy(AdminOperationsProtocol.class, (long)3L, (InetSocketAddress)JobTracker.getAddress(conf), (UserGroupInformation)MRAdmin.getUGI(conf), (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, AdminOperationsProtocol.class));
        adminOperationsProtocol.refreshNodes();
        return 0;
    }

    public int run(String[] args) throws Exception {
        String cmd;
        if (args.length < 1) {
            MRAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if (("-refreshServiceAcl".equals(cmd = args[i++]) || "-refreshQueues".equals(cmd) || "-refreshNodes".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd)) && args.length != 1) {
            MRAdmin.printUsage(cmd);
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshAuthorizationPolicy();
            } else if ("-refreshQueues".equals(cmd)) {
                exitCode = this.refreshQueues();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-help".equals(cmd)) {
                if (i < args.length) {
                    MRAdmin.printUsage(args[i]);
                } else {
                    MRAdmin.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                MRAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            MRAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new MRAdmin(), (String[])args);
        System.exit(result);
    }
}

