/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobHistory {
    final Log LOG = LogFactory.getLog(JobHistory.class);
    private long jobHistoryBlockSize;
    private final Map<org.apache.hadoop.mapreduce.JobID, MetaInfo> fileMap = Collections.synchronizedMap(new HashMap());
    private ThreadPoolExecutor executor = null;
    static final FsPermission HISTORY_DIR_PERMISSION = FsPermission.createImmutable((short)488);
    public static final FsPermission HISTORY_FILE_PERMISSION = FsPermission.createImmutable((short)480);
    private JobTracker jobTracker;
    static final long DEFAULT_HISTORY_MAX_AGE = 604800000L;
    private FileSystem logDirFs;
    private FileSystem doneDirFs;
    private Path logDir = null;
    private Path done = null;
    public static final String OLD_SUFFIX = ".old";
    public static final String HISTORY_VERSION = "1.0";
    private HistoryCleaner historyCleanerThread = null;
    private Map<org.apache.hadoop.mapreduce.JobID, MovedFileInfo> jobHistoryFileMap = Collections.synchronizedMap(new LinkedHashMap());

    public void init(JobTracker jt, JobConf conf, String hostname, long jobTrackerStartTime) throws IOException {
        String logDirLoc = conf.get("mapreduce.jobtracker.jobhistory.location", "file:///" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath() + File.separator + "history");
        this.LOG.info((Object)("History log directory is " + logDirLoc));
        this.logDir = new Path(logDirLoc);
        this.logDirFs = this.logDir.getFileSystem((Configuration)conf);
        if (!this.logDirFs.exists(this.logDir) && !this.logDirFs.mkdirs(this.logDir, new FsPermission(HISTORY_DIR_PERMISSION))) {
            throw new IOException("Mkdirs failed to create " + this.logDir.toString());
        }
        conf.set("mapreduce.jobtracker.jobhistory.location", logDirLoc);
        this.jobHistoryBlockSize = conf.getLong("mapreduce.jobtracker.jobhistory.block.size", 0x300000L);
        this.jobTracker = jt;
    }

    public void initDone(JobConf conf, FileSystem fs) throws IOException {
        String doneLocation = conf.get("mapreduce.jobtracker.jobhistory.completed.location");
        if (doneLocation != null) {
            this.done = fs.makeQualified(new Path(doneLocation));
            this.doneDirFs = fs;
        } else {
            this.done = this.logDirFs.makeQualified(new Path(this.logDir, "done"));
            this.doneDirFs = this.logDirFs;
        }
        if (!this.doneDirFs.exists(this.done)) {
            this.LOG.info((Object)("Creating DONE folder at " + this.done));
            if (!this.doneDirFs.mkdirs(this.done, new FsPermission(HISTORY_DIR_PERMISSION))) {
                throw new IOException("Mkdirs failed to create " + this.done.toString());
            }
        }
        this.LOG.info((Object)("Inited the done directory to " + this.done.toString()));
        this.moveOldFiles();
        this.startFileMoverThreads();
        long maxAgeOfHistoryFiles = conf.getLong("mapreduce.jobtracker.jobhistory.maxage", 604800000L);
        this.historyCleanerThread = new HistoryCleaner(maxAgeOfHistoryFiles);
        this.historyCleanerThread.start();
    }

    public void markCompleted(org.apache.hadoop.mapreduce.JobID id) throws IOException {
        this.moveToDone(id);
    }

    public void shutDown() {
        this.LOG.info((Object)"Interrupting History Cleaner");
        this.historyCleanerThread.interrupt();
        try {
            this.historyCleanerThread.join();
        }
        catch (InterruptedException e) {
            this.LOG.info((Object)"Error with shutting down history thread");
        }
    }

    public Path getJobHistoryLocation() {
        return this.logDir;
    }

    public Path getCompletedJobHistoryLocation() {
        return this.done;
    }

    public static Path getJobHistoryFile(Path dir, org.apache.hadoop.mapreduce.JobID jobId, String user) {
        return new Path(dir, jobId.toString() + "_" + user);
    }

    public static org.apache.hadoop.mapreduce.JobID getJobIDFromHistoryFilePath(Path jobHistoryFilePath) {
        String[] jobDetails = jobHistoryFilePath.getName().split("_");
        String jobId = jobDetails[0] + "_" + jobDetails[1] + "_" + jobDetails[2];
        return org.apache.hadoop.mapreduce.JobID.forName(jobId);
    }

    public static String getUserFromHistoryFilePath(Path jobHistoryFilePath) {
        String[] jobDetails = jobHistoryFilePath.getName().split("_");
        return jobDetails[3];
    }

    public String getHistoryFilePath(org.apache.hadoop.mapreduce.JobID jobId) {
        MovedFileInfo info = this.jobHistoryFileMap.get(jobId);
        if (info == null) {
            return null;
        }
        return info.historyFile;
    }

    public void setupEventWriter(org.apache.hadoop.mapreduce.JobID jobId, JobConf jobConf) throws IOException {
        Path logFile = JobHistory.getJobHistoryFile(this.logDir, jobId, this.getUserName(jobConf));
        if (this.logDir == null) {
            this.LOG.info((Object)"Log Directory is null, returning");
            throw new IOException("Missing Log Directory for History");
        }
        int defaultBufferSize = this.logDirFs.getConf().getInt("io.file.buffer.size", 4096);
        this.LOG.info((Object)("SetupWriter, creating file " + logFile));
        FSDataOutputStream out = this.logDirFs.create(logFile, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, this.logDirFs.getDefaultReplication(), this.jobHistoryBlockSize, null);
        EventWriter writer = new EventWriter(out);
        Path logDirConfPath = JobHistory.getConfFile(this.logDir, jobId);
        this.LOG.info((Object)("LogDirConfPath is " + logDirConfPath));
        FSDataOutputStream jobFileOut = null;
        try {
            if (logDirConfPath != null) {
                defaultBufferSize = this.logDirFs.getConf().getInt("io.file.buffer.size", 4096);
                if (!this.logDirFs.exists(logDirConfPath)) {
                    jobFileOut = this.logDirFs.create(logDirConfPath, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, this.logDirFs.getDefaultReplication(), this.logDirFs.getDefaultBlockSize(), null);
                    jobConf.writeXml((OutputStream)jobFileOut);
                    jobFileOut.close();
                }
            }
        }
        catch (IOException e) {
            this.LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException((Throwable)e)));
        }
        MetaInfo fi = new MetaInfo(logFile, logDirConfPath, writer);
        this.fileMap.put(jobId, fi);
    }

    public void closeWriter(org.apache.hadoop.mapreduce.JobID id) {
        try {
            MetaInfo mi = this.fileMap.get(id);
            if (mi != null) {
                mi.closeWriter();
            }
        }
        catch (IOException e) {
            this.LOG.info((Object)("Error closing writer for JobID: " + id));
        }
    }

    public void logEvent(HistoryEvent event, org.apache.hadoop.mapreduce.JobID id) {
        try {
            MetaInfo mi = this.fileMap.get(id);
            if (mi != null) {
                mi.writeEvent(event);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error Logging event, " + e.getMessage()));
        }
    }

    private void moveToDoneNow(Path fromPath, Path toPath) throws IOException {
        if (this.logDirFs.exists(fromPath)) {
            this.LOG.info((Object)("Moving " + fromPath.toString() + " to " + toPath.toString()));
            this.doneDirFs.moveFromLocalFile(fromPath, toPath);
            this.doneDirFs.setPermission(toPath, new FsPermission(HISTORY_FILE_PERMISSION));
        }
    }

    private void startFileMoverThreads() {
        this.executor = new ThreadPoolExecutor(1, 3, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>());
    }

    public static Path getConfFile(Path logDir, org.apache.hadoop.mapreduce.JobID jobId) {
        Path jobFilePath = null;
        if (logDir != null) {
            jobFilePath = new Path(logDir + File.separator + jobId.toString() + "_conf.xml");
        }
        return jobFilePath;
    }

    private void moveOldFiles() throws IOException {
        FileStatus[] files = this.logDirFs.listStatus(this.logDir);
        String jtIdentifier = this.jobTracker.getTrackerIdentifier();
        String fileSuffix = "." + jtIdentifier + OLD_SUFFIX;
        for (FileStatus fileStatus : files) {
            Path fromPath = fileStatus.getPath();
            if (fromPath.equals((Object)this.done)) continue;
            this.LOG.info((Object)("Moving log file from last run: " + fromPath));
            Path toPath = new Path(this.done, fromPath.getName() + fileSuffix);
            try {
                this.moveToDoneNow(fromPath, toPath);
            }
            catch (ChecksumException e) {
                this.LOG.warn((Object)("Unable to move " + fromPath + ", deleting it"));
                try {
                    boolean b = this.logDirFs.delete(fromPath, false);
                    this.LOG.debug((Object)("Deletion of corrupt file " + fromPath + " returned " + b));
                }
                catch (IOException ioe) {
                    this.LOG.warn((Object)("Unable to delete " + fromPath + "Exception: " + ioe.getMessage()));
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)("Error moving file " + fromPath + " to done folder." + "Ignoring."));
            }
        }
    }

    private void moveToDone(final org.apache.hadoop.mapreduce.JobID id) {
        final ArrayList<Path> paths = new ArrayList<Path>();
        MetaInfo metaInfo = this.fileMap.get(id);
        if (metaInfo == null) {
            this.LOG.info((Object)("No file for job-history with " + id + " found in cache!"));
            return;
        }
        final Path historyFile = metaInfo.getHistoryFile();
        if (historyFile == null) {
            this.LOG.info((Object)("No file for job-history with " + id + " found in cache!"));
        } else {
            paths.add(historyFile);
        }
        Path confPath = metaInfo.getConfFile();
        if (confPath == null) {
            this.LOG.info((Object)("No file for jobconf with " + id + " found in cache!"));
        } else {
            paths.add(confPath);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Path path : paths) {
                        JobHistory.this.moveToDoneNow(path, new Path(JobHistory.this.done, path.getName()));
                    }
                }
                catch (Throwable e) {
                    JobHistory.this.LOG.error((Object)"Unable to move history file to DONE folder.", e);
                }
                String historyFileDonePath = null;
                if (historyFile != null) {
                    historyFileDonePath = new Path(JobHistory.this.done, historyFile.getName()).toString();
                }
                JobHistory.this.jobHistoryFileMap.put(id, new MovedFileInfo(historyFileDonePath, System.currentTimeMillis()));
                JobHistory.this.jobTracker.retireJob(JobID.downgrade(id), historyFileDonePath);
                JobHistory.this.fileMap.remove(id);
            }
        });
    }

    private String getUserName(JobConf jobConf) {
        String user = jobConf.getUser();
        if (user == null) {
            user = "";
        }
        return user;
    }

    class HistoryCleaner
    extends Thread {
        static final long ONE_DAY_IN_MS = 86400000L;
        private long cleanupFrequency;
        private long maxAgeOfHistoryFiles;

        public HistoryCleaner(long maxAge) {
            this.setName("Thread for cleaning up History files");
            this.setDaemon(true);
            this.maxAgeOfHistoryFiles = maxAge;
            this.cleanupFrequency = Math.min(86400000L, this.maxAgeOfHistoryFiles);
            JobHistory.this.LOG.info((Object)("Job History Cleaner Thread started. MaxAge is " + maxAge + " ms(" + (float)maxAge / 8.64E7f + " days)," + " Cleanup Frequency is " + this.cleanupFrequency + " ms (" + (float)this.cleanupFrequency / 8.64E7f + " days)"));
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.doCleanup();
                        Thread.sleep(this.cleanupFrequency);
                    }
                }
                catch (InterruptedException e) {
                    JobHistory.this.LOG.info((Object)"History Cleaner thread exiting");
                    return;
                }
                catch (Throwable t) {
                    JobHistory.this.LOG.warn((Object)"History cleaner thread threw an exception", t);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCleanup() {
            long now = System.currentTimeMillis();
            try {
                FileStatus[] historyFiles = JobHistory.this.doneDirFs.listStatus(JobHistory.this.done);
                if (historyFiles != null) {
                    for (FileStatus f : historyFiles) {
                        if (now - f.getModificationTime() <= this.maxAgeOfHistoryFiles) continue;
                        JobHistory.this.doneDirFs.delete(f.getPath(), true);
                        JobHistory.this.LOG.info((Object)("Deleting old history file : " + f.getPath()));
                    }
                }
                Map map = JobHistory.this.jobHistoryFileMap;
                synchronized (map) {
                    MovedFileInfo info;
                    Iterator it = JobHistory.this.jobHistoryFileMap.entrySet().iterator();
                    while (it.hasNext() && now - (info = (MovedFileInfo)it.next().getValue()).timestamp > this.maxAgeOfHistoryFiles) {
                        it.remove();
                    }
                }
            }
            catch (IOException ie) {
                JobHistory.this.LOG.info((Object)("Error cleaning up history directory" + StringUtils.stringifyException((Throwable)ie)));
            }
        }
    }

    private static class MetaInfo {
        private Path historyFile;
        private Path confFile;
        private EventWriter writer;

        MetaInfo(Path historyFile, Path conf, EventWriter writer) {
            this.historyFile = historyFile;
            this.confFile = conf;
            this.writer = writer;
        }

        Path getHistoryFile() {
            return this.historyFile;
        }

        Path getConfFile() {
            return this.confFile;
        }

        synchronized void closeWriter() throws IOException {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }

        synchronized void writeEvent(HistoryEvent event) throws IOException {
            if (this.writer != null) {
                this.writer.write(event);
            }
        }
    }

    private static class MovedFileInfo {
        private final String historyFile;
        private final long timestamp;

        public MovedFileInfo(String historyFile, long timestamp) {
            this.historyFile = historyFile;
            this.timestamp = timestamp;
        }
    }
}

